/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.listener;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.render.layers.LayerEquippables;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.CheckPlayerBattlePacket;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MouseOverPlayer {
    private static final int tickInterval = 10;
    private int tick = 0;
    private UUID lastPlayer;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.type == TickEvent.Type.PLAYER && event.player instanceof LocalPlayer) {
            if (LayerEquippables.getPokemon() != null) {
                LayerEquippables.getPokemon().getAnimationVariables().tick();
            }
            if (event.player == Minecraft.m_91087_().f_91074_) {
                PixelmonOverlayScreen.onPlayerTick();
                ++this.tick;
                if (this.tick >= 10) {
                    this.tick = 0;
                    Player player = this.getLookAtPlayer();
                    if (player != null) {
                        if (!player.m_20148_().equals(this.lastPlayer)) {
                            this.sendCheckBattlePacket(player);
                            this.lastPlayer = player.m_20148_();
                        }
                    } else {
                        if (this.lastPlayer != null) {
                            PixelmonOverlayScreen.hideSpectateMessage(this.lastPlayer);
                        }
                        this.lastPlayer = null;
                    }
                }
            }
        }
    }

    private void sendCheckBattlePacket(Player player) {
        CheckPlayerBattlePacket message = new CheckPlayerBattlePacket(player);
        NetworkHelper.sendToServer(message);
    }

    private Player getLookAtPlayer() {
        Minecraft mc = Minecraft.m_91087_();
        Player pointedEntity = null;
        float partialTick = 1.0f;
        double range = PixelmonConfigProxy.getGraphics().getSpectatorRangeBlocks();
        Vec3 Vec32 = mc.m_91288_().m_20299_(partialTick);
        Vec3 Vec31 = mc.m_91288_().m_20252_(partialTick);
        Vec3 Vec322 = Vec32.m_82520_(Vec31.f_82479_ * range, Vec31.f_82480_ * range, Vec31.f_82481_ * range);
        double d1 = range;
        Vec32 = mc.m_91288_().m_20299_(partialTick);
        float f1 = 1.0f;
        List list = mc.f_91073_.m_45976_(Player.class, mc.m_91288_().m_20191_().m_82363_(Vec31.f_82479_ * range, Vec31.f_82480_ * range, Vec31.f_82481_ * range).m_82363_((double)f1, (double)f1, (double)f1));
        double d2 = d1;
        for (Player entity : list) {
            double d3;
            if (entity == Minecraft.m_91087_().f_91074_ || !entity.m_6087_()) continue;
            float f2 = entity.m_6143_();
            AABB axisalignedbb = entity.m_20191_().m_82363_((double)f2, (double)f2, (double)f2);
            Optional movingobjectposition = axisalignedbb.m_82371_(Vec32, Vec322);
            if (axisalignedbb.m_82390_(Vec32)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (!movingobjectposition.isPresent() || !((d3 = Vec32.m_82554_((Vec3)movingobjectposition.get())) < d2) && d2 != 0.0) continue;
            if (entity == mc.m_91288_().m_6688_() && !entity.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity;
                continue;
            }
            pointedEntity = entity;
            d2 = d3;
        }
        return pointedEntity;
    }
}

