/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.listener;

import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.items.EscapeRopeItem;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pixelmon", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class EscapeRopeClient {
    private static float rotation = 0.0f;
    private static float rotationDelta = 10.0f;
    private static float height = 1.0f;
    private static CameraType pov = CameraType.FIRST_PERSON;
    private static long lastTime = -1L;
    private static float lastYaw = -1.0f;
    private static float lastPitch = -1.0f;
    private static Vec3 lastPosition = null;
    private static float shadowRadius = -1.0f;

    @SubscribeEvent
    public static void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && event.getEntity().m_20148_().equals(mc.f_91074_.m_20148_())) {
            event.getPoseStack().m_85836_();
            if (EscapeRopeItem.EscapeRopeTask.clientFlag()) {
                if (shadowRadius == -1.0f) {
                    shadowRadius = event.getRenderer().f_114477_;
                }
                boolean reverse = EscapeRopeItem.EscapeRopeTask.clientReverseFlag();
                long time = System.currentTimeMillis();
                if (lastTime == -1L) {
                    lastTime = time;
                }
                if (mc.f_91066_.m_92176_() != CameraType.THIRD_PERSON_FRONT) {
                    mc.f_91066_.m_92157_(CameraType.THIRD_PERSON_FRONT);
                }
                double timeDelta = (double)(time - lastTime) * 0.1;
                if (!mc.m_91104_()) {
                    if (reverse) {
                        rotationDelta = (float)((double)rotationDelta / (1.0 + 0.007 * (double)event.getPartialTick()));
                        height = (float)((double)height / (1.0 + 0.0105 * (double)event.getPartialTick() * timeDelta));
                        rotation = (float)((double)rotation - (double)(rotationDelta * event.getPartialTick()) * timeDelta);
                        if (height <= 1.0f) {
                            EscapeRopeItem.EscapeRopeTask.unsetClientReverseFlag();
                            EscapeRopeClient.resetValues();
                            return;
                        }
                    } else {
                        rotationDelta = (float)((double)rotationDelta * (1.0 + 0.007 * (double)event.getPartialTick()));
                        height = (float)((double)height * (1.0 + 0.0125 * (double)event.getPartialTick() * timeDelta));
                        rotation = (float)((double)rotation + (double)(rotationDelta * event.getPartialTick()) * timeDelta);
                    }
                    event.getRenderer().f_114477_ = shadowRadius * (8.0f - Math.max(0.0f, Math.min(8.0f, height - 2.0f))) * 0.125f;
                }
                event.getPoseStack().m_252880_(0.0f, height - 1.0f, 0.0f);
                event.getPoseStack().m_252781_(QuaternionHelper.fromOld(0.0f, rotation, 0.0f, true));
                lastTime = time;
            } else {
                EscapeRopeClient.resetValues();
            }
        } else if (shadowRadius != -1.0f) {
            event.getRenderer().f_114477_ = shadowRadius;
        }
    }

    @SubscribeEvent
    public static void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && event.getEntity().m_20148_().equals(mc.f_91074_.m_20148_())) {
            event.getPoseStack().m_85849_();
        }
    }

    @SubscribeEvent
    public static void onTryMove(MovementInputUpdateEvent event) {
        if (EscapeRopeItem.EscapeRopeTask.clientFlag()) {
            event.getInput().f_108568_ = false;
            event.getInput().f_108569_ = false;
            event.getInput().f_108570_ = false;
            event.getInput().f_108571_ = false;
            event.getInput().f_108573_ = false;
            event.getInput().f_108572_ = false;
            event.getInput().f_108567_ = 0.0f;
            event.getInput().f_108566_ = 0.0f;
        }
    }

    @SubscribeEvent
    public static void onTryPress(InputEvent.MouseButton.Pre event) {
        if (EscapeRopeItem.EscapeRopeTask.clientFlag() && event.getAction() == 1) {
            event.setCanceled(true);
        }
    }

    public static void setPOV(boolean enabled, boolean reset) {
        Minecraft mc = Minecraft.m_91087_();
        if (enabled) {
            if (pov == null) {
                pov = mc.f_91066_.m_92176_();
            }
            if (mc.f_91066_.m_92176_() != CameraType.THIRD_PERSON_FRONT) {
                mc.f_91066_.m_92157_(CameraType.THIRD_PERSON_FRONT);
            }
            mc.f_91066_.f_92062_ = true;
            if (Minecraft.m_91087_().m_293199_().m_294516_()) {
                Minecraft.m_91087_().m_293199_().m_293034_();
            }
        } else {
            if (pov != null) {
                mc.f_91066_.m_92157_(pov);
                pov = null;
            }
            if (reset) {
                mc.f_91066_.f_92062_ = false;
                mc.execute(EscapeRopeClient::resetValues);
            }
        }
    }

    public static void updatePOV() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.m_92176_() != CameraType.THIRD_PERSON_FRONT) {
            mc.f_91066_.m_92157_(CameraType.THIRD_PERSON_FRONT);
        }
    }

    private static void resetValues() {
        rotation = 0.0f;
        height = 1.0f;
        lastTime = -1L;
        rotationDelta = 9.0f;
    }
}

