/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.keybindings;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.ArrayHelper;
import com.pixelmonmod.pixelmon.client.keybindings.TargetKeyBinding;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class WikiKey
extends KeyMapping {
    public static final String PIXELMON_WIKI = "https://pixelmonmod.com/wiki/index.php?title=";
    private static final String MINECRAFT_WIKI_START = "http://minecraft";
    private static final String MINECRAFT_WIKI_END = ".gamepedia.com/";
    private static final String[] TRANSLATED_MINECRAFT_WIKI = new String[]{"de", "el", "es", "fr", "hu", "it", "ja", "ko", "nl", "pl", "pt", "ru", "zh"};

    public WikiKey() {
        super("key.wiki", 75, "key.categories.pixelmon");
    }

    @SubscribeEvent
    public void keyDown(InputEvent.Key event) {
        if (this.m_90859_()) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            try {
                HitResult objectMouseOver = TargetKeyBinding.getTarget(false);
                ItemStack itemStack = mc.f_91074_.f_36095_.m_142621_();
                ResourceLocation id = null;
                String name = null;
                if (!itemStack.m_41619_()) {
                    Item item = itemStack.m_41720_();
                    id = ForgeRegistries.ITEMS.getKey((Object)item);
                    name = item == PixelmonItems.pixelmon_sprite.m_5456_() ? I18n.m_118938_((String)"item.pixelmon_sprite", (Object[])new Object[0]) : item.m_7626_(itemStack).getString();
                } else if (objectMouseOver.m_6662_() == HitResult.Type.BLOCK) {
                    Block block = mc.f_91073_.m_8055_(((BlockHitResult)objectMouseOver).m_82425_()).m_60734_();
                    id = ForgeRegistries.BLOCKS.getKey((Object)block);
                    name = block.m_49954_().getString();
                }
                if (id != null && name != null) {
                    name = name.trim().replace(":", "%3A").replace(" ", "_").replace("\u00e9", "e");
                    String resourceDomain = id.m_135827_();
                    Object baseURL = null;
                    if (resourceDomain.equalsIgnoreCase("pixelmon")) {
                        baseURL = PIXELMON_WIKI;
                    } else if (resourceDomain.equalsIgnoreCase("minecraft")) {
                        baseURL = MINECRAFT_WIKI_START;
                        String langCode = mc.m_91102_().m_264236_();
                        if (!(langCode = langCode.substring(0, 2)).equals("en") && ArrayHelper.contains(TRANSLATED_MINECRAFT_WIKI, langCode)) {
                            if (langCode.equals("pt")) {
                                langCode = "br";
                            }
                            baseURL = (String)baseURL + "-" + langCode;
                        }
                        baseURL = (String)baseURL + MINECRAFT_WIKI_END;
                    }
                    if (baseURL != null) {
                        Util.m_137581_().m_137648_(new URI((String)baseURL + name));
                    }
                }
            }
            catch (RuntimeException | URISyntaxException exception) {
                // empty catch block
            }
        }
    }
}

