/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.zygarde;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PowerConstruct;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.RoundButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.zygarde.ZygardeCubePacket;
import com.pixelmonmod.pixelmon.items.ZygardeCubeItem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class ZygardeCubeScreen
extends Screen {
    InteractionHand hand;
    StoragePosition position;
    Pokemon zygarde;
    ItemStack cube;
    Mode mode = Mode.SELECT;
    List<RoundButton> buttons = Lists.newArrayList();
    List<String> lines = Lists.newArrayList();
    private int centerW;
    private int centerH;

    public ZygardeCubeScreen(InteractionHand hand, int partyPos) {
        super((Component)Component.m_237119_());
        ItemStack stack;
        this.f_96541_ = Minecraft.m_91087_();
        this.hand = hand;
        this.position = new StoragePosition(-1, partyPos);
        Pokemon pokemon = ClientStorageManager.party.get(this.position);
        if (pokemon.getSpecies().is(PixelmonSpecies.ZYGARDE)) {
            this.zygarde = pokemon;
        }
        if ((stack = this.f_96541_.f_91074_.m_21120_(hand)).m_41720_() instanceof ZygardeCubeItem) {
            this.cube = stack;
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.centerW = this.f_96543_ / 2;
        this.centerH = this.f_96544_ / 2;
        this.buttons.clear();
        this.lines.clear();
        if (this.cube == null || this.zygarde == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        if (this.mode == Mode.SELECT) {
            if (!(this.zygarde.getAbility() instanceof PowerConstruct) && ZygardeCubeItem.getCoreTypes(this.cube).size() == 0) {
                this.lines.add(I18n.m_118938_((String)"pixelmon.gui.zygarde_cube.nomoves", (Object[])new Object[0]));
                this.buttons.add(new RoundButton(0, 0, I18n.m_118938_((String)"gui.button.okay", (Object[])new Object[0]), 150, 20).setId(-1));
            } else if (this.zygarde.getAbility() instanceof PowerConstruct) {
                this.lines.add(I18n.m_118938_((String)"pixelmon.gui.zygarde_cube.select", (Object[])new Object[0]));
                if (this.zygarde.getAbility() instanceof PowerConstruct) {
                    this.buttons.add(new RoundButton(0, 0, I18n.m_118938_((String)"pixelmon.gui.zygarde_cube.toggleforme", (Object[])new Object[0]), 150, 20).setId(0));
                }
                if (ZygardeCubeItem.getCoreTypes(this.cube).size() > 0) {
                    this.buttons.add(new RoundButton(0, 0, I18n.m_118938_((String)"pixelmon.gui.zygarde_cube.teachmove", (Object[])new Object[0]), 150, 20).setId(1));
                }
            } else {
                this.mode = Mode.LEARN_MOVE;
            }
        }
        if (this.mode == Mode.LEARN_MOVE) {
            this.lines.add(I18n.m_118938_((String)"pixelmon.gui.zygarde_cube.learnmove", (Object[])new Object[0]));
            for (ZygardeCubeItem.CoreType type : ZygardeCubeItem.getCoreTypes(this.cube)) {
                ImmutableAttack base = type.getMove();
                this.buttons.add(new RoundButton(0, 0, base.getLocalizedName(), 150, 20).setId(type.ordinal()));
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (!this.lines.isEmpty()) {
            ScreenHelper.drawDialogueBox(graphics, (Screen)this, "", this.lines, 0.0f);
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            RoundButton button = this.buttons.get(i);
            button.drawButton(graphics, this.centerW - 70, this.f_96544_ / 4 + 20 + 30 * (i + 1), mouseX, mouseY, 0.0f);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            RoundButton button = this.buttons.get(i);
            if (!button.isMouseOver(this.centerW - 70, this.f_96544_ / 4 + 20 + 30 * (i + 1), mouseX, mouseY)) continue;
            if (this.mode == Mode.SELECT) {
                if (button.getId() == 0) {
                    NetworkHelper.sendToServer(new ZygardeCubePacket(this.position, this.f_96541_.f_91074_.m_150109_().m_36030_(this.cube)));
                    this.f_96541_.m_91152_(null);
                    continue;
                }
                if (button.getId() == 1) {
                    this.mode = Mode.LEARN_MOVE;
                    this.m_7856_();
                    continue;
                }
                if (button.getId() != -1) continue;
                this.f_96541_.m_91152_(null);
                continue;
            }
            if (this.mode != Mode.LEARN_MOVE) continue;
            NetworkHelper.sendToServer(new ZygardeCubePacket(this.position, this.f_96541_.f_91074_.m_150109_().m_36030_(this.cube), button.getId()));
            this.f_96541_.m_91152_(null);
        }
        return false;
    }

    static enum Mode {
        SELECT,
        LEARN_MOVE,
        TOGGLE_FORM;

    }
}

