/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class TabCompleteTranslateableTextField<T extends ITranslatable>
extends EditBox {
    private Collection<T> completions = Collections.emptyList();
    private List<T> cache = Lists.newArrayList();
    private boolean isCompleting = false;
    private int index = 0;
    private int id;
    private T value;

    public TabCompleteTranslateableTextField(int componentId, Font fontrendererObj, int x, int y, int par5Width, int par6Height) {
        super(fontrendererObj, x, y, par5Width, par6Height, (Component)Component.m_237119_());
        this.id = componentId;
    }

    public TabCompleteTranslateableTextField<T> setCompletions(Collection<T> completions) {
        this.completions = completions;
        return this;
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (!this.m_93696_()) {
            return super.m_7933_(key, scanCode, modifiers);
        }
        if (key == 258) {
            if (this.isCompleting) {
                this.m_94180_(0);
                this.m_94180_(this.m_94184_(-1) - this.m_94207_());
                if (this.index >= this.cache.size()) {
                    this.index = 0;
                }
            } else {
                int i = this.m_94184_(-1);
                String s = super.m_94155_().substring(0, this.m_94207_());
                this.index = 0;
                this.createCompletionsFor(s);
                if (this.cache.isEmpty()) {
                    return true;
                }
                this.isCompleting = true;
                this.m_94180_(i - this.m_94207_());
            }
            ITranslatable t = (ITranslatable)this.cache.get(this.index++);
            this.m_94144_(t.getLocalizedName());
            this.value = t;
            return true;
        }
        this.isCompleting = false;
        return super.m_7933_(key, scanCode, modifiers);
    }

    public String m_94155_() {
        return this.value.getLocalizedName();
    }

    public T getTranslatableValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.m_94144_(this.value.getTranslatedName().getString());
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (!this.m_93696_()) {
            return super.m_5534_(typedChar, keyCode);
        }
        if (keyCode == 258) {
            if (this.isCompleting) {
                this.m_94180_(0);
                this.m_94180_(this.m_94184_(-1) - this.m_94207_());
                if (this.index >= this.cache.size()) {
                    this.index = 0;
                }
            } else {
                int i = this.m_94184_(-1);
                String s = super.m_94155_().substring(0, this.m_94207_());
                this.index = 0;
                this.createCompletionsFor(s);
                if (this.cache.isEmpty()) {
                    return true;
                }
                this.isCompleting = true;
                this.m_94180_(i - this.m_94207_());
            }
            ITranslatable t = (ITranslatable)this.cache.get(this.index++);
            this.m_94144_(t.getLocalizedName());
            this.value = t;
            return true;
        }
        this.isCompleting = false;
        return super.m_5534_(typedChar, keyCode);
    }

    protected void createCompletionsFor(String leftOfCursor) {
        this.cache.clear();
        if (leftOfCursor.isEmpty()) {
            this.cache.addAll(this.completions);
            return;
        }
        for (ITranslatable completion : this.completions) {
            if (!completion.getLocalizedName().regionMatches(true, 0, leftOfCursor, 0, leftOfCursor.length())) continue;
            this.cache.add(completion);
        }
    }
}

