/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public abstract class SlotBase
extends AbstractWidget {
    protected static Color COLOUR_BAR_ONE = new Color(0, 0, 0);
    protected static Color COLOUR_BAR_TWO = new Color(128, 128, 128);
    protected static Color COLOUR_BAR_THREE = new Color(192, 192, 192);
    protected static final int DEFAULT_SLOT_HEIGHT = 10;
    public final int width;
    public final int height;
    public final int top;
    public final int bottom;
    public final int right;
    public final int left;
    public int amountScrolled;
    public int selectedElement = -1;
    protected int slotHeight;
    protected float initialClickY = -2.0f;
    protected float scrollMultiplier;
    protected long lastClicked = 0L;
    protected boolean opaque;

    public SlotBase(int top, int left, int width, int height, boolean opaque) {
        super(top, left, width, height, (Component)Component.m_237119_());
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = this.top + this.height;
        this.slotHeight = 10;
        this.left = left;
        this.right = this.width + this.left;
        this.opaque = opaque;
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight;
    }

    protected abstract void drawSlot(GuiGraphics var1, int var2, int var3, int var4, int var5);

    protected abstract float[] get1Color();

    protected Color getSelectionColor() {
        return Color.BLACK;
    }

    protected int[] get255Color() {
        float[] color1 = this.get1Color();
        return new int[]{(int)(color1[0] * 255.0f), (int)(color1[1] * 255.0f), (int)(color1[2] * 255.0f)};
    }

    public int getCurrentSlot(int par1, int par2) {
        if (this.m_5953_(par1, par2)) {
            int var3 = this.left;
            int var4 = this.left + this.width;
            int var5 = par2 - this.top + this.amountScrolled - 4;
            int var6 = var5 / this.slotHeight;
            return par1 >= var3 && par1 <= var4 && var6 >= 0 && var5 >= 0 && var6 < this.getSize() ? var6 : -1;
        }
        return -1;
    }

    public boolean isMouseOver(int element, int par1, int par2) {
        return this.getCurrentSlot(par1, par2) == element;
    }

    public boolean isElementVisible(int i) {
        return this.getElementPosition(i) == 0;
    }

    public int getTopIndex() {
        return Math.max(0, this.amountScrolled / this.slotHeight);
    }

    public int getBottomIndex() {
        return Math.min(this.getTopIndex() + this.height / this.slotHeight - 1, this.getSize() - 1);
    }

    public int getElementPosition(int i) {
        int ti = this.getTopIndex();
        int bi = this.getBottomIndex();
        if (ti > i) {
            return -1;
        }
        if (bi < i) {
            return 1;
        }
        return 0;
    }

    public void scrollTo(int i) {
        int prevAmountScrolled;
        int pos = this.getElementPosition(i);
        while (pos > 0) {
            prevAmountScrolled = this.amountScrolled;
            this.amountScrolled += this.slotHeight;
            this.bindAmountScrolled();
            pos = this.getElementPosition(i);
            if (prevAmountScrolled != this.amountScrolled) continue;
            break;
        }
        while (pos < 0) {
            prevAmountScrolled = this.amountScrolled;
            this.amountScrolled -= this.slotHeight;
            this.bindAmountScrolled();
            pos = this.getElementPosition(i);
            if (prevAmountScrolled != this.amountScrolled) continue;
            break;
        }
    }

    public void bindAmountScrolled() {
        int var1 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (var1 < 0) {
            var1 = 0;
        }
        if (this.amountScrolled < 0) {
            this.amountScrolled = 0;
        }
        if (this.amountScrolled > var1) {
            this.amountScrolled = var1;
        }
    }

    public boolean m_5953_(double x, double y) {
        return x > (double)this.left && x < (double)this.right && y > (double)this.top && y < (double)this.bottom;
    }

    boolean inBoundsScroll(double x, double y) {
        return x > (double)this.left && x < (double)(this.right + 6) && y > (double)this.top && y < (double)this.bottom;
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.inBoundsScroll(mouseX, mouseY)) {
            if (deltaY != 0.0) {
                if (deltaY > 0.0) {
                    deltaY = -1.0;
                } else if (deltaY < 0.0) {
                    deltaY = 1.0;
                }
                this.amountScrolled = (int)((double)this.amountScrolled + deltaY * (double)this.slotHeight);
            }
            this.initialClickY = -1.0f;
            this.bindAmountScrolled();
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return false;
        }
        if (mouseX >= (double)this.top && mouseY <= (double)this.bottom) {
            this.amountScrolled = (int)((double)this.amountScrolled - dragY);
            this.bindAmountScrolled();
        }
        return true;
    }

    public boolean m_6375_(double mousePosX, double mousePosY, int button) {
        if (button != 0 || !this.m_5953_(mousePosX, mousePosY)) {
            return false;
        }
        int length = this.getSize();
        int posScrollBar = this.left + this.width;
        int posScrollBar2 = posScrollBar + 6;
        boolean flag = true;
        if (mousePosY >= (double)this.top && mousePosY <= (double)this.bottom) {
            double scrollPosX = this.right;
            double scrollPosY = mousePosY - (double)this.top + (double)this.amountScrolled - 4.0;
            int index = (int)(scrollPosY / (double)this.slotHeight);
            if (this.m_5953_(mousePosX, mousePosY) && index >= 0 && scrollPosY >= 0.0 && index < length) {
                boolean var12 = index == this.selectedElement && System.currentTimeMillis() - this.lastClicked < 250L;
                this.elementClicked(index, var12);
                this.selectedElement = index;
                this.lastClicked = System.currentTimeMillis();
            } else if (mousePosX >= (double)this.left && mousePosX <= scrollPosX && scrollPosY < 0.0) {
                flag = false;
            }
            if (mousePosX >= (double)posScrollBar && mousePosX <= (double)posScrollBar2) {
                int middleOfSelect;
                this.scrollMultiplier = -1.0f;
                int topLeftOfSelect = this.getContentHeight() - (this.bottom - this.top - 4);
                if (topLeftOfSelect < 1) {
                    topLeftOfSelect = 1;
                }
                if ((middleOfSelect = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                    middleOfSelect = 32;
                }
                if (middleOfSelect > this.bottom - this.top - 8) {
                    middleOfSelect = this.bottom - this.top - 8;
                }
                this.amountScrolled = (int)((double)this.amountScrolled + (mousePosY - (double)middleOfSelect));
                this.bindAmountScrolled();
            }
            this.initialClickY = flag ? (float)mousePosY : -2.0f;
        } else {
            this.initialClickY = -2.0f;
        }
        return flag;
    }

    public void m_87963_(GuiGraphics graphics, int mousePosX, int mousePosY, float partialTicks) {
        int middleOfSelect;
        int topLeftOfSelect;
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        int length = this.getSize();
        int posScrollBar = this.left + this.width;
        int posScrollBar2 = posScrollBar + 6;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableBlend();
        int scrollPosX = this.left;
        int scrollPosY = this.top + 2 - this.amountScrolled;
        this.drawBackground(graphics);
        for (int index = 0; index < length; ++index) {
            topLeftOfSelect = scrollPosY + index * this.slotHeight;
            middleOfSelect = topLeftOfSelect + this.slotHeight / 4;
            if (topLeftOfSelect + 6 > this.bottom || middleOfSelect < this.top) continue;
            if (this.isHighlighted(index, mousePosX, mousePosY)) {
                this.drawSelection(graphics, middleOfSelect, topLeftOfSelect);
            }
            this.drawSlot(graphics, index, scrollPosX, topLeftOfSelect, middleOfSelect);
        }
        RenderSystem.disableDepthTest();
        int var20 = 4;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int[] color = this.get255Color();
        if (color != null) {
            VertexConsumer buffer = graphics.m_280091_().m_6299_(PixelmonRendering.gui());
            buffer.m_5483_((double)this.left, (double)(this.top + var20), 0.0).m_6122_(color[0], color[1], color[2], 0).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)this.right, (double)(this.top + var20), 0.0).m_6122_(color[0], color[1], color[2], 0).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)this.right, (double)this.top, 0.0).m_6122_(color[0], color[1], color[2], 255).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_5483_((double)this.left, (double)this.top, 0.0).m_6122_(color[0], color[1], color[2], 255).m_7421_(0.0f, 0.0f).m_5752_();
            buffer = graphics.m_280091_().m_6299_(PixelmonRendering.gui());
            buffer.m_5483_((double)this.left, (double)this.bottom + 2.0, 0.0).m_6122_(color[0], color[1], color[2], 255).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)this.right, (double)this.bottom + 2.0, 0.0).m_6122_(color[0], color[1], color[2], 255).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)this.right, (double)(this.bottom + 2 - var20), 0.0).m_6122_(color[0], color[1], color[2], 0).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_5483_((double)this.left, (double)(this.bottom + 2 - var20), 0.0).m_6122_(color[0], color[1], color[2], 0).m_7421_(0.0f, 0.0f).m_5752_();
        }
        if ((topLeftOfSelect = this.getContentHeight() - (this.bottom - this.top - 4)) > 0) {
            int leftish;
            middleOfSelect = (this.bottom - this.top) * (this.bottom - this.top) / Math.max(this.getContentHeight(), 1);
            if (middleOfSelect < 32) {
                middleOfSelect = 32;
            }
            if (middleOfSelect > this.bottom - this.top - 8) {
                middleOfSelect = this.bottom - this.top - 8;
            }
            if ((leftish = this.amountScrolled * (this.bottom - this.top - middleOfSelect) / topLeftOfSelect + this.top) < this.top) {
                leftish = this.top;
            }
            ScreenHelper.drawQuad(graphics, posScrollBar, (float)this.bottom + 2.0f, 0.0f, posScrollBar2, (float)this.bottom + 2.0f, 0.0f, posScrollBar2, (float)this.top + 2.0f, 0.0f, posScrollBar, (float)this.top + 2.0f, 0.0f, COLOUR_BAR_ONE);
            ScreenHelper.drawQuad(graphics, posScrollBar, leftish + middleOfSelect + 2, 0.0f, posScrollBar2, leftish + middleOfSelect + 2, 0.0f, posScrollBar2, (float)leftish + 2.0f, 0.0f, posScrollBar, (float)leftish + 2.0f, 0.0f, COLOUR_BAR_TWO);
            ScreenHelper.drawQuad(graphics, posScrollBar, leftish + middleOfSelect - 1 + 2, 0.0f, posScrollBar2 - 1, leftish + middleOfSelect - 1 + 2, 0.0f, posScrollBar2 - 1, (float)leftish + 2.0f, 0.0f, posScrollBar, (float)leftish + 2.0f, 0.0f, COLOUR_BAR_THREE);
        }
        RenderSystem.disableBlend();
        matrix.m_85849_();
    }

    public void mouseScrolled(int mousePosX, int mousePosY, double delta) {
        if (this.inBoundsScroll(mousePosX, mousePosY)) {
            if (delta != 0.0) {
                if (delta > 0.0) {
                    delta = -1.0;
                } else if (delta < 0.0) {
                    delta = 1.0;
                }
                this.amountScrolled = (int)((double)this.amountScrolled + delta * (double)this.slotHeight);
            }
            this.initialClickY = -1.0f;
            this.bindAmountScrolled();
        }
        int length = this.getSize();
        int posScrollBar = this.left + this.width;
        int posScrollBar2 = posScrollBar + 6;
        if (mousePosX >= posScrollBar && mousePosX <= posScrollBar2) {
            int middleOfSelect;
            this.scrollMultiplier = -1.0f;
            int topLeftOfSelect = this.getContentHeight() - (this.bottom - this.top - 4);
            if (topLeftOfSelect < 1) {
                topLeftOfSelect = 1;
            }
            if ((middleOfSelect = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                middleOfSelect = 32;
            }
            if (middleOfSelect > this.bottom - this.top - 8) {
                middleOfSelect = this.bottom - this.top - 8;
            }
            this.scrollMultiplier /= (float)(this.bottom - this.top - middleOfSelect) / (float)topLeftOfSelect;
        } else {
            this.scrollMultiplier = 1.0f;
        }
    }

    boolean hasScrollBar() {
        return this.getContentHeight() - (this.bottom - this.top - 4) > 0;
    }

    protected void drawBackground(GuiGraphics graphics) {
    }

    boolean isHighlighted(int index, float mouseX, float mouseY) {
        return this.isSelected(index) || this.isMouseOver(index, (int)mouseX, (int)mouseY);
    }

    void drawSelection(GuiGraphics graphics, int middleOfSelect, int topLeftOfSelect) {
        Color selectionColor;
        int leftish = this.left;
        int rightish = this.left + this.width;
        float[] color = this.get1Color();
        if (this.opaque && (selectionColor = this.getSelectionColor()) != null) {
            ScreenHelper.drawQuad(graphics, leftish + 1, topLeftOfSelect + this.slotHeight + 1, 0.0f, rightish - 1, topLeftOfSelect + this.slotHeight + 1, 0.0f, rightish - 1, topLeftOfSelect - 1, 0.0f, leftish + 1, topLeftOfSelect - 1, 0.0f, selectionColor);
        }
    }

    public int getMouseOverIndex(int mouseX, int mouseY) {
        for (int i = this.getTopIndex(); i <= this.getBottomIndex(); ++i) {
            if (!this.isMouseOver(i, mouseX, mouseY)) continue;
            return i;
        }
        return -1;
    }

    public int getCenterX() {
        return this.left + this.width / 2;
    }
}

