/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;

public class SWSHButton {
    private final String text;
    private final Consumer<Integer> onClick;
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    private final double h;
    private boolean visible = true;
    private boolean enabled = true;

    public SWSHButton(double x, double y, double z, double w, double h, String text, Consumer<Integer> onClick) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        this.h = h;
        this.text = text;
        this.onClick = onClick;
    }

    public void draw(GuiGraphics graphics, double mouseX, double mouseY, float partialTicks) {
        if (this.visible) {
            boolean hover = this.isWithin(mouseX, mouseY);
            ScreenHelper.drawRectWithSemicircleEnds(graphics, this.x, this.y, this.z, this.w, this.h, 20, this.isInteractable() ? (hover ? Color.BLACK : Color.WHITE) : Color.WHITE);
            ScreenHelper.drawScaledCenteredString(graphics, this.text, (float)(this.x + this.w / 2.0), (float)(this.y + this.h * 0.255), this.isInteractable() ? (hover ? Color.WHITE.getRGB() : Color.BLACK.getRGB()) : Color.GRAY.getRGB(), (float)this.h * 1.2f);
        }
    }

    public boolean isWithin(double x, double y) {
        double r = this.h / 2.0;
        return x >= this.x - r && y >= this.y && x <= this.x + this.w + r && y <= this.y + this.h;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (this.isInteractable() && this.isWithin(mouseX, mouseY)) {
            this.onClick.accept(button);
            SoundHelper.playButtonPressSound();
        }
    }

    public boolean isInteractable() {
        return this.enabled && this.visible;
    }

    public SWSHButton setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public SWSHButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

