/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import net.minecraft.client.gui.GuiGraphics;

public class RoundButton {
    private int leftOffset;
    private int topOffset;
    private String text;
    private int id;
    private int width = 100;
    private int height = 20;

    public RoundButton(int leftOffset, int topOffset, String text) {
        this.leftOffset = leftOffset;
        this.topOffset = topOffset;
        this.setText(text);
    }

    public RoundButton(int leftOffset, int topOffset, String text, int width, int height) {
        this(leftOffset, topOffset, text);
        this.width = width;
        this.height = height;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getId() {
        return this.id;
    }

    public RoundButton setId(int id) {
        this.id = id;
        return this;
    }

    public void drawButton(GuiGraphics graphics, int leftX, int topY, double mouseX, double mouseY, float zLevel) {
        this.drawButton(graphics, leftX, topY, mouseX, mouseY, zLevel, false);
    }

    public void drawButton(GuiGraphics graphics, int leftX, int topY, double mouseX, double mouseY, float zLevel, boolean forceOutline) {
        int left = leftX + this.leftOffset;
        int top = topY + this.topOffset;
        ScreenHelper.drawImageQuad(Resources.roundedButton, graphics, left, top, this.width, this.height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        if (forceOutline) {
            int outside = 5;
            ScreenHelper.drawImageQuad(Resources.roundedButtonOver, graphics, left - outside, top - outside, this.width + outside * 2, this.height + outside * 2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        } else if (this.isMouseOver(leftX, topY, mouseX, mouseY)) {
            ScreenHelper.drawImageQuad(Resources.roundedButtonOver, graphics, left, top, this.width, this.height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, zLevel);
        }
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_252880_(0.0f, 0.0f, 190.0f);
        ScreenHelper.drawCenteredString(graphics, this.text, (float)left + (float)this.width / 2.0f, (float)(top + 6), 0xFFFFFF);
        matrix.m_85849_();
    }

    public boolean isMouseOver(int leftX, int topY, double mouseX, double mouseY) {
        int left = leftX + this.leftOffset;
        int top = topY + this.topOffset;
        return mouseX > (double)left && mouseX < (double)(left + this.width) && mouseY > (double)top && mouseY < (double)(top + this.height);
    }
}

