/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class PokemonUI {
    private final Minecraft mc = Minecraft.m_91087_();
    private final Font fontRenderer;
    private int leftOffset;
    private int topOffset;

    public PokemonUI(int leftOffset, int topOffset) {
        this.fontRenderer = this.mc.f_91062_;
        this.leftOffset = leftOffset;
        this.topOffset = topOffset;
    }

    public void drawPokemon(GuiGraphics graphics, Pokemon pokemon, int leftX, int topY, int mouseX, int mouseY, float zLevel) {
        this.drawPokemon(graphics, pokemon, leftX, topY, mouseX, mouseY, zLevel, false);
    }

    public void drawPokemon(GuiGraphics graphics, Pokemon pokemon, int leftX, int topY, int mouseX, int mouseY, float zLevel, boolean highlight) {
        boolean offset = false;
        if (pokemon != null) {
            float color = highlight ? 0.5f : 1.0f;
            ScreenHelper.drawImageQuad(Resources.textbox, graphics, leftX, topY - 10, 123.0f, 34.0f, 0.0f, 0.0f, 1.0f, 1.0f, color, color, color, 1.0f, 1.0f);
            String displayName = pokemon.getDisplayName();
            graphics.m_280488_(this.fontRenderer, displayName, leftX + 28, topY, 0xFFFFFF);
            if (!pokemon.isEgg()) {
                String levelString = I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
                Objects.requireNonNull(this.fontRenderer);
                graphics.m_280488_(this.fontRenderer, levelString, leftX + 29, topY + 1 + 9, 0xFFFFFF);
                if (pokemon.isFainted()) {
                    String string = I18n.m_118938_((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
                    int n = leftX + 30 + this.fontRenderer.m_92895_(levelString);
                    Objects.requireNonNull(this.fontRenderer);
                    graphics.m_280488_(this.fontRenderer, string, n, topY + 1 + 9, 0xFFFFFF);
                } else {
                    String string = I18n.m_118938_((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth();
                    int n = leftX + 31 + this.fontRenderer.m_92895_(levelString);
                    Objects.requireNonNull(this.fontRenderer);
                    graphics.m_280488_(this.fontRenderer, string, n, topY + 1 + 9, 0xFFFFFF);
                }
            }
            if (pokemon.getGender() == Gender.MALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.male, graphics, this.fontRenderer.m_92895_(displayName) + leftX + 29, topY, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            } else if (pokemon.getGender() == Gender.FEMALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.female, graphics, this.fontRenderer.m_92895_(displayName) + leftX + 29, topY, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), graphics, leftX - 3, topY - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.fainted : Resources.normal;
            ScreenHelper.drawImageQuad(rl, graphics, leftX - 3, topY - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), graphics, leftX + 1, topY - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    public boolean isMouseOver(int leftX, int topY, double mouseX, double mouseY) {
        int left = leftX + this.leftOffset;
        int top = topY + this.topOffset - 5;
        return mouseX > (double)left && mouseX < (double)(left + 110) && mouseY > (double)top && mouseY < (double)(top + 25);
    }
}

