/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerMovesScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerStatsScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class PokeCheckerButton
extends IndexedButton {
    private Screen parent;
    private PokemonStorage storage;
    private StoragePosition position;
    private Pokemon pokemon;
    private MiniButton summary = new MiniButton(0, I18n.m_118938_((String)"gui.screenpokechecker.summary", (Object[])new Object[0]), 10, 15);
    private MiniButton moves = new MiniButton(1, I18n.m_118938_((String)"gui.screenpokechecker.moves", (Object[])new Object[0]), 10, 34);
    private MiniButton stats = new MiniButton(2, I18n.m_118938_((String)"gui.screenpokechecker.stats", (Object[])new Object[0]), 10, 53);

    public PokeCheckerButton(Screen parent) {
        super(-1, 0, 0, 67, 75, (Component)Component.m_237119_(), button -> {});
        this.parent = parent;
        this.f_93623_ = false;
    }

    public void setPokemon(PokemonStorage storage, StoragePosition position, Pokemon pokemon, double mouseX, double mouseY) {
        this.storage = storage;
        this.position = position;
        this.pokemon = pokemon;
        this.f_93623_ = this.storage != null && this.position != null && this.pokemon != null;
        this.f_93620_ = (int)(mouseX - 73.0);
        this.f_93621_ = (int)(mouseY - 10.0);
        if (this.f_93621_ + this.f_93619_ > this.parent.f_96544_) {
            this.f_93621_ = this.parent.f_96544_ - this.f_93619_;
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93623_ && super.m_5953_(mouseX, mouseY);
    }

    private boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
    }

    public boolean m_6375_(double par1, double par2, int par3) {
        InventoryMenu inventory = this.parent.getMinecraft().f_91074_.f_36095_;
        ItemStack currentItem = inventory.m_142621_();
        if (!currentItem.m_41619_()) {
            return true;
        }
        if (this.summary.hovered) {
            SoundHelper.playButtonPressSound();
            Minecraft.m_91087_().m_91152_((Screen)new PokeCheckerScreen(this.storage, this.position, this.parent));
        } else if (this.moves.hovered) {
            SoundHelper.playButtonPressSound();
            Minecraft.m_91087_().m_91152_((Screen)new PokeCheckerMovesScreen(this.storage, this.position, this.parent));
        } else if (this.stats.hovered) {
            SoundHelper.playButtonPressSound();
            Minecraft.m_91087_().m_91152_((Screen)new PokeCheckerStatsScreen(this.storage, this.position, this.parent));
        }
        return true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93623_) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            this.f_93622_ = this.isHovered(mouseX, mouseY);
            graphics.m_280218_(Resources.pokecheckerPopup, this.f_93620_, this.f_93621_, 0, 0, this.f_93618_, this.f_93619_);
            this.summary.render(graphics, mouseX, mouseY, partialTicks);
            this.moves.render(graphics, mouseX, mouseY, partialTicks);
            this.stats.render(graphics, mouseX, mouseY, partialTicks);
            ScreenHelper.drawCenteredString(graphics, Minecraft.m_91087_().f_91062_, this.pokemon.getDisplayName(), (float)this.f_93620_ + (float)this.f_93618_ / 2.0f, (float)(this.f_93621_ + 2), 0xFFFFFF, true);
            this.summary.drawText(graphics);
            this.moves.drawText(graphics);
            this.stats.drawText(graphics);
            graphics.m_280168_().m_85849_();
        }
    }

    private class MiniButton {
        private static final int HOVER_WIDTH = 47;
        private static final int HOVER_HEIGHT = 13;
        public final int id;
        private int offsetX;
        private int offsetY;
        private String text;
        private int tempX;
        private int tempY;
        public boolean hovered;

        private MiniButton(int id, String text, int offsetX, int offsetY) {
            this.id = id;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.text = text;
        }

        public boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.tempX && mouseY >= this.tempY && mouseX < this.tempX + 47 && mouseY < this.tempY + 13;
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.tempX = PokeCheckerButton.this.f_93620_ + this.offsetX;
            this.tempY = PokeCheckerButton.this.f_93621_ + this.offsetY;
            this.hovered = this.isHovered(mouseX, mouseY);
            if (this.hovered) {
                graphics.m_280218_(Resources.pokecheckerPopup, this.tempX, this.tempY, 1, 76, 47, 13);
            }
        }

        public void drawText(GuiGraphics graphics) {
            ScreenHelper.drawCenteredString(graphics, Minecraft.m_91087_().f_91062_, this.text, (float)this.tempX + 23.5f, (float)this.tempY + 6.5f - 4.0f, this.hovered ? 0xFFFFA0 : 0xFFFFFF, true);
        }
    }
}

