/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownManager;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownSlot;
import com.pixelmonmod.pixelmon.client.gui.widgets.TextAlignment;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;

public class DropDown<T> {
    List<T> options;
    int selectedIndex = -1;
    T selectedOption;
    Consumer<T> onSelected;
    Consumer<Integer> onSelectedIndex;
    Function<T, String> getOptionString;
    private DropDownSlot slot;
    boolean active;
    private boolean lastSelected;
    private int top;
    private Rectangle rect;
    private Rectangle iconRect;
    TextAlignment align = TextAlignment.Left;
    private DropDownManager manager;
    private static final int ICON_LENGTH = 11;
    public static final int OPTION_HEIGHT = 10;
    private boolean visible = true;
    private int inactiveHeight = 10;

    public DropDown(List<T> options, int selected, int left, int top, int width, int height) {
        this(options, left, top, width, height, (double)width);
        this.setOptions(options, selected);
    }

    public DropDown(List<T> options, int selected, int left, int top, int width, int height, int dropDownWidth) {
        this(options, left, top, width, height, (double)dropDownWidth);
        this.setOptions(options, selected);
    }

    public DropDown(List<T> options, T selected, int left, int top, int width, int height) {
        this(options, left, top, width, height, (double)width);
        this.setOptions(options, selected);
    }

    public DropDown(List<T> options, T selected, int left, int top, int width, int height, int dropDownWidth) {
        this(options, left, top, width, height, (double)dropDownWidth);
        this.setOptions(options, selected);
    }

    private DropDown(List<T> options, int left, int top, int width, int height, double dropDownWidth) {
        height = Math.min(height, 10 * options.size() + 4);
        this.top = top;
        this.slot = new DropDownSlot(this, top - 3, left, width, height, (int)dropDownWidth);
        int rectTop = top + 1;
        this.rect = new Rectangle(left, rectTop, width, 10);
        this.iconRect = new Rectangle(left + width, rectTop, 11, 11);
    }

    void setManager(DropDownManager manager) {
        this.manager = manager;
    }

    public void setOptions(List<T> options, T selected) {
        this.options = options;
        this.setSelected(selected);
    }

    private void setOptions(List<T> options, int selected) {
        this.options = options;
        this.setSelected(selected);
    }

    public void setSelected(T selected) {
        this.selectedOption = selected;
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.options.get(i).equals(selected)) continue;
            this.selectedIndex = i;
            this.slot.scrollTo(i);
            break;
        }
    }

    public void setSelected(int selected) {
        this.selectedIndex = selected;
        this.slot.scrollTo(selected);
        this.selectedOption = this.selectedIndex >= 0 && this.selectedIndex < this.options.size() ? this.options.get(selected) : null;
    }

    public DropDown<T> setInactiveTop(int top) {
        int rectTop;
        this.top = top;
        this.rect.y = rectTop = top + 1;
        this.iconRect.y = rectTop;
        return this;
    }

    public DropDown<T> setInactiveHeight(int height) {
        this.inactiveHeight = height;
        return this;
    }

    public DropDown<T> setTextAlign(TextAlignment align) {
        this.align = align;
        return this;
    }

    public DropDown<T> setGetOptionString(Function<T, String> getOptionString) {
        this.getOptionString = getOptionString;
        return this;
    }

    public DropDown<T> setOnSelected(Consumer<T> onSelected) {
        this.onSelected = onSelected;
        return this;
    }

    public DropDown<T> setOnSelectedIndex(Consumer<Integer> onSelectedIndex) {
        this.onSelectedIndex = onSelectedIndex;
        return this;
    }

    public DropDown<T> setOrdered() {
        this.options.sort((o1, o2) -> this.toOptionString(o1).compareTo(this.toOptionString(o2)));
        if (this.selectedIndex >= 0) {
            for (int i = 0; i < this.options.size(); ++i) {
                if (this.options.get(i) != this.selectedOption) continue;
                this.setSelected(i);
                break;
            }
        }
        return this;
    }

    public T getSelected() {
        return this.selectedOption;
    }

    void mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return;
        }
        if (!this.active) {
            this.active = true;
            return;
        }
        for (int index = 0; index < this.slot.getSize(); ++index) {
            if (!this.slot.isMouseOver(index, (int)mouseX, (int)mouseY)) continue;
            this.elementClicked(index);
        }
        this.slot.m_6375_(mouseX, mouseY, button);
        this.active = false;
    }

    void mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.visible) {
            return;
        }
        this.slot.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    void mouseScrolled(double mouseX, double mouseY, double delta) {
        if (!this.visible) {
            return;
        }
        this.slot.mouseScrolled((int)mouseX, (int)mouseY, delta);
    }

    void elementClicked(int index) {
        if (!this.visible) {
            return;
        }
        if (this.active) {
            this.lastSelected = true;
            this.selectedIndex = index;
            this.selectedOption = this.options.get(index);
            if (this.onSelected != null) {
                this.onSelected.accept(this.selectedOption);
            }
            if (this.onSelectedIndex != null) {
                this.onSelectedIndex.accept(index);
            }
        }
    }

    String toOptionString(T option) {
        return this.getOptionString == null ? option.toString() : this.getOptionString.apply(option);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, DropDown active) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        float gray = this.active ? 0.6f : 1.0f;
        ScreenHelper.drawImageQuad(Resources.dropDownIcon, graphics, this.slot.left + this.slot.width, this.top, 11.0f, 11.0f, 0.0f, 0.0f, 1.0f, 1.0f, gray, gray, gray, 1.0f, 0.0f);
        matrix.m_85849_();
        boolean lastMouse = this.manager.getLastMouse();
        boolean bl = this.lastSelected = this.lastSelected && lastMouse;
        if (this.active) {
            this.slot.m_88315_(graphics, mouseX, mouseY, partialTicks);
        } else {
            int slotTop = this.top + 1;
            this.slot.drawBackgroundRect(graphics, this.top, slotTop + this.inactiveHeight, -1644826);
            if (this.isMouseOver(mouseX, mouseY) && active != null) {
                this.slot.drawSelection(graphics, this.inactiveHeight, this.top);
            }
            this.slot.drawOptionString(graphics, this.selectedOption, slotTop);
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        if (!this.visible) {
            return false;
        }
        if (this.iconRect.contains(mouseX, mouseY)) {
            return true;
        }
        if (this.active) {
            return this.slot.hasScrollBar() ? this.slot.inBoundsScroll(mouseX, mouseY) : this.slot.m_5953_(mouseX, mouseY);
        }
        return this.rect.contains(mouseX, mouseY);
    }

    public boolean getLastSelected() {
        return this.lastSelected;
    }

    public int getTop() {
        return this.top;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }
}

