/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.TextAlignment;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class DescriptiveText {
    private String text;
    private String description;
    private int x;
    private int y;
    private TextAlignment align;
    private Rectangle boundingBox;

    public DescriptiveText(String text, String description, int x, int y, TextAlignment align) {
        this.text = text;
        this.description = description;
        this.x = x;
        this.y = y;
        this.align = align;
        int width = Minecraft.m_91087_().f_91062_.m_92895_(text);
        int height = 10;
        int boxX = x;
        int boxY = y;
        switch (align) {
            case Left: {
                boxX = x;
                break;
            }
            case Center: {
                boxX = x - width / 2;
                break;
            }
            case Right: {
                boxX = x - width;
            }
        }
        this.boundingBox = new Rectangle(boxX, boxY, width, height);
    }

    public void draw(GuiGraphics graphics) {
        switch (this.align) {
            case Left: {
                graphics.m_280488_(Minecraft.m_91087_().f_91062_, this.text, this.x, this.y, 0);
                break;
            }
            case Center: {
                ScreenHelper.drawCenteredString(graphics, this.text, (float)this.x, (float)this.y, 0);
                break;
            }
            case Right: {
                ScreenHelper.drawStringRightAligned(graphics, this.text, this.x, this.y, 0, false);
            }
        }
    }

    public boolean isHovering(int cursorX, int cursorY) {
        return this.boundingBox.contains(cursorX, cursorY);
    }

    public String getDescription() {
        return this.description;
    }
}

