/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.ChatVisiblity;

public class ChatExtensionScreen
extends Screen {
    private int bPosX = 0;
    private int bPosY = 0;
    private int yOffset;
    public static boolean chatOpen = false;
    public boolean updateHeight = false;
    private int lastHeight = -1;
    private int sentHistoryCursor = -1;
    protected EditBox inputField;
    private String chatText;
    private final Minecraft minecraft = Minecraft.m_91087_();
    private Screen screen;
    private CommandSuggestions commandSuggestionHelper;
    private boolean justOpened = false;

    public ChatExtensionScreen(Screen screen, int yOffset) {
        super((Component)Component.m_237119_());
        this.screen = screen;
        this.yOffset = yOffset;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (!this.justOpened || Character.toLowerCase(typedChar) != Character.toLowerCase((char)Minecraft.m_91087_().f_91066_.f_92098_.getKey().m_84873_())) {
            this.justOpened = false;
            return super.m_5534_(typedChar, keyCode);
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        if (button == Minecraft.m_91087_().f_91066_.f_92098_.getKey().m_84873_() && !this.isChatOpen()) {
            this.chatOpened("");
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == Minecraft.m_91087_().f_91066_.f_92098_.getKey().m_84873_() && !this.isChatOpen()) {
            this.chatOpened("");
            return true;
        }
        if (keyCode == 47 && !this.isChatOpen()) {
            this.chatOpened("");
            return true;
        }
        if (this.commandSuggestionHelper.m_93888_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.chatClosed();
            return true;
        }
        if (keyCode != 257 && keyCode != 335) {
            if (keyCode == 265) {
                this.getSentHistory(-1);
                return true;
            }
            if (keyCode == 264) {
                this.getSentHistory(1);
                return true;
            }
            if (keyCode == 266) {
                this.minecraft.f_91065_.m_93076_().m_205360_(this.minecraft.f_91065_.m_93076_().m_93816_() - 1);
                return true;
            }
            if (keyCode == 267) {
                this.minecraft.f_91065_.m_93076_().m_205360_(-this.minecraft.f_91065_.m_93076_().m_93816_() + 1);
                return true;
            }
            return false;
        }
        String s = this.inputField.m_94155_().trim();
        if (!s.isEmpty()) {
            this.sendMessage(s);
        }
        this.chatClosed();
        return true;
    }

    public void m_7856_() {
        this.bPosX = 2;
        this.bPosY = this.screen.f_96544_ - this.yOffset;
        this.sentHistoryCursor = this.minecraft.f_91065_.m_93076_().m_93797_().size();
        this.inputField = new EditBox(this.screen.getMinecraft().f_91062_, this.bPosX + 2, this.bPosY + 2, this.screen.f_96543_ - 4, 12, (Component)Component.m_237115_((String)"chat.editBox")){

            protected MutableComponent m_5646_() {
                return super.m_5646_().m_7220_(ChatExtensionScreen.this.commandSuggestionHelper.m_272218_());
            }
        };
        this.inputField.m_94199_(256);
        this.inputField.m_94182_(false);
        this.inputField.m_93692_(true);
        this.inputField.m_94144_(this.inputField.m_94155_());
        this.inputField.m_94151_(this::onEdited);
        this.inputField.m_94190_(false);
        this.inputField.m_94194_(false);
        this.commandSuggestionHelper = new CommandSuggestions(this.minecraft, this.screen, this.inputField, this.minecraft.f_91062_, false, false, 1, 10, true, -805306368);
        this.commandSuggestionHelper.m_93881_();
    }

    private void onEdited(String p_212997_1_) {
        String s = this.inputField.m_94155_();
        this.commandSuggestionHelper.m_93922_(!s.equals(""));
        this.commandSuggestionHelper.m_93881_();
    }

    public void m_7379_() {
        this.minecraft.f_91065_.m_93076_().m_93810_();
        chatOpen = false;
    }

    public void tick(int height) {
        if (this.inputField != null) {
            // empty if block
        }
        if (this.updateHeight) {
            if (this.lastHeight != height) {
                this.yOffset = height > 900 ? 140 : 125;
                this.m_7856_();
            }
            this.lastHeight = height;
        }
    }

    public boolean isChatOpen() {
        return chatOpen;
    }

    public void drawScreen(GuiGraphics graphics, int par1, int par2, float par3) {
        if (chatOpen) {
            graphics.m_280509_(2, this.screen.f_96544_ - this.yOffset, this.screen.f_96543_ - 122, this.screen.f_96544_ - this.yOffset + 12, Integer.MIN_VALUE);
            this.inputField.m_87963_(graphics, par1, par2, par3);
        }
        if (this.minecraft == null || this.minecraft.f_91065_ == null) {
            return;
        }
        ChatComponent guiNewChat = this.minecraft.f_91065_.m_93076_();
        int j = this.getLineCount();
        int k = 0;
        int l = guiNewChat.m_93816_();
        double f = (Double)this.minecraft.f_91066_.m_232098_().m_231551_() * (double)0.9f + (double)0.1f;
        int updateCounter = this.minecraft.f_91065_.m_93079_();
        PoseStack matrix = graphics.m_280168_();
        if (l > 0) {
            int l1;
            int k1;
            int j1;
            float f1 = (float)this.getChatScale();
            int i1 = Mth.m_14167_((float)((float)this.getChatWidth() / f1));
            matrix.m_85836_();
            if (chatOpen) {
                matrix.m_252880_(2.0f, (float)(this.bPosY - 3), 0.0f);
            } else {
                matrix.m_252880_(2.0f, (float)(this.bPosY + 10), 0.0f);
            }
            matrix.m_85841_(f1, f1, 1.0f);
            for (j1 = 0; j1 + guiNewChat.f_93763_ < guiNewChat.f_93761_.size() && j1 < j; ++j1) {
                GuiMessage.Line chatline = (GuiMessage.Line)guiNewChat.f_93761_.get(j1 + guiNewChat.f_93763_);
                if (chatline == null || (k1 = updateCounter - chatline.f_240350_()) >= 200 && !chatOpen) continue;
                double d0 = (double)k1 / 200.0;
                d0 = 1.0 - d0;
                if ((d0 *= 10.0) < 0.0) {
                    d0 = 0.0;
                }
                if (d0 > 1.0) {
                    d0 = 1.0;
                }
                d0 *= d0;
                l1 = (int)(255.0 * d0);
                if (chatOpen) {
                    l1 = 255;
                }
                l1 = (int)((double)l1 * f);
                ++k;
                if (l1 <= 3) continue;
                int b0 = 0;
                int i2 = -j1 * 9;
                graphics.m_280509_(b0, i2 - 9, b0 + i1 + 4, i2, l1 / 2 << 24);
                FormattedCharSequence s = chatline.f_240339_();
                if (!((Boolean)this.minecraft.f_91066_.m_231814_().m_231551_()).booleanValue()) {
                    // empty if block
                }
                RenderSystem.enableBlend();
                graphics.m_280649_(Minecraft.m_91087_().f_91062_, s, b0, i2 - 8, 0xFFFFFF + (l1 << 24), true);
                RenderSystem.disableBlend();
            }
            if (chatOpen) {
                Objects.requireNonNull(this.minecraft.f_91062_);
                j1 = 9;
                matrix.m_252880_(-3.0f, 0.0f, 0.0f);
                int j2 = l * j1 + l;
                k1 = k * j1 + k;
                int k2 = guiNewChat.f_93763_ * k1 / l;
                int l2 = k1 * k1 / j2;
                if (j2 != k1) {
                    l1 = k2 > 0 ? 170 : 96;
                    int i3 = guiNewChat.f_93764_ ? 0xCC3333 : 0x3333AA;
                    graphics.m_280509_(0, -k2, 2, -k2 - l2, i3 + (l1 << 24));
                    graphics.m_280509_(2, -k2, 1, -k2 - l2, 0xCCCCCC + (l1 << 24));
                }
            }
            matrix.m_85849_();
        }
    }

    private void chatOpened(String start) {
        if (this.minecraft.f_91066_.f_92119_.m_231551_() == ChatVisiblity.HIDDEN || this.inputField == null) {
            return;
        }
        if (start != null) {
            this.inputField.m_94144_(start);
        } else {
            this.inputField.m_94144_("");
        }
        chatOpen = true;
        this.inputField.m_94194_(true);
        this.inputField.m_93692_(true);
        this.m_7522_((GuiEventListener)this.inputField);
        this.justOpened = true;
    }

    private void chatClosed() {
        chatOpen = false;
        this.inputField.m_94194_(false);
        this.inputField.m_93692_(false);
        this.m_7522_(null);
        this.inputField.m_94144_("");
    }

    public void sendMessage(String text) {
        if (text.isEmpty()) {
            return;
        }
        this.minecraft.f_91065_.m_93076_().m_93783_(text);
        if (text.startsWith("/")) {
            this.minecraft.f_91074_.f_108617_.m_246623_(text.substring(1));
        } else {
            this.minecraft.f_91074_.f_108617_.m_246175_(text);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.isChatOpen()) {
            this.minecraft.f_91065_.m_93076_().m_205360_((int)delta);
            return true;
        }
        return false;
    }

    private void getSentHistory(int par1) {
        int j = this.sentHistoryCursor + par1;
        int k = this.minecraft.f_91065_.m_93076_().m_93797_().size();
        if (j < 0) {
            j = 0;
        }
        if (j > k) {
            j = k;
        }
        if (j != this.sentHistoryCursor) {
            try {
                if (j == k) {
                    this.sentHistoryCursor = k;
                    this.inputField.m_94144_(this.chatText);
                } else {
                    if (this.sentHistoryCursor == k) {
                        this.chatText = this.inputField.m_94155_();
                    }
                    this.inputField.m_94144_((String)this.minecraft.f_91065_.m_93076_().m_93797_().get(j));
                    this.sentHistoryCursor = j;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void mouseClickedUnderMenus(int par1, int par2, int par3) {
        this.inputField.m_6375_((double)par1, (double)par2, par3);
    }

    private int getChatWidth() {
        return ChatExtensionScreen.calculateChatboxWidth((Double)this.minecraft.f_91066_.m_232113_().m_231551_());
    }

    private int getChatHeight() {
        return ChatExtensionScreen.calculateChatboxHeight((Double)this.minecraft.f_91066_.m_232117_().m_231551_());
    }

    private double getChatScale() {
        return (Double)this.minecraft.f_91066_.m_232110_().m_231551_();
    }

    private static int calculateChatboxWidth(double p_146233_0_) {
        int short1 = 320;
        int b0 = 40;
        return Mth.m_14107_((double)(p_146233_0_ * (double)(short1 - b0) + (double)b0));
    }

    private static int calculateChatboxHeight(double p_146243_0_) {
        int short1 = 180;
        int b0 = 20;
        return Mth.m_14107_((double)(p_146243_0_ * (double)(short1 - b0) + (double)b0));
    }

    private int getLineCount() {
        return this.getChatHeight() / 9;
    }
}

