/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.trainerCard;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard.RequestTrainerCardPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard.TrainerCardColorPacket;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardColor;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardUser;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrainerCardScreen
extends Screen {
    public Player player;
    public Pokemon[] party = new Pokemon[6];
    public EnumTrainerCardColor color = EnumTrainerCardColor.WHITE;
    public EnumTrainerCardUser user;
    public String money = "0";
    public int caughtCount = 0;
    private static final int SPRITE_HEIGHT = 40;
    private static final int SPRITE_WIDTH = 40;
    private static final int POKEBALL_HEIGHT = 43;
    private static final int POKEBALL_WIDTH = 44;

    public TrainerCardScreen() {
        super((Component)Component.m_237119_());
        this.player = Minecraft.m_91087_().f_91074_;
        this.party = ClientStorageManager.party.getAll();
        this.color = ClientData.color;
        this.user = EnumTrainerCardUser.getFromPlayer(this.player);
        this.money = NumberFormat.getInstance().format(ClientData.playerMoney);
        this.caughtCount = ClientStorageManager.pokedex.countCaught();
    }

    public TrainerCardScreen(Player player) {
        super((Component)Component.m_237119_());
        this.player = player;
        this.user = EnumTrainerCardUser.getFromPlayer(this.player);
        NetworkHelper.sendToServer(new RequestTrainerCardPacket(player.m_20148_()));
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        if (this.player.equals((Object)this.f_96541_.f_91074_)) {
            this.m_169413_();
            int i = 0;
            for (EnumTrainerCardColor color : EnumTrainerCardColor.values()) {
                if (color == EnumTrainerCardColor.GOLD && this.user == EnumTrainerCardUser.REGULAR) {
                    return;
                }
                this.m_142416_((GuiEventListener)new ThemedButton(i, color, this.f_96543_ / 2 - 158 + 13 * i++, 205, this::actionPerformed));
            }
        }
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        int xOffset = this.f_96543_ / 2 - 165;
        int yOffset = 30;
        matrix.m_280163_(this.color.resource, xOffset, yOffset, 0.0f, 0.0f, 335, 195, 335, 195);
        if (this.user.resource != null) {
            matrix.m_280163_(this.user.resource, xOffset + 62, yOffset - 5, 0.0f, 0.0f, 200, 60, 200, 60);
        }
        int firstRowHeight = 67;
        int secondRowHeight = 103;
        this.drawPokemon(matrix, this.party[0], xOffset, yOffset, 12, 65, 15, firstRowHeight);
        this.drawPokemon(matrix, this.party[1], xOffset, yOffset, 58, 65, 61, firstRowHeight);
        this.drawPokemon(matrix, this.party[2], xOffset, yOffset, 105, 65, 108, firstRowHeight);
        this.drawPokemon(matrix, this.party[3], xOffset, yOffset, 12, 101, 15, secondRowHeight);
        this.drawPokemon(matrix, this.party[4], xOffset, yOffset, 58, 101, 61, secondRowHeight);
        this.drawPokemon(matrix, this.party[5], xOffset, yOffset, 105, 101, 108, secondRowHeight);
        matrix.m_280163_(Resources.pokedexItemIcon, xOffset + 169, yOffset + 108, 0.0f, 0.0f, 14, 14, 14, 14);
        matrix.m_280056_(this.f_96547_, this.caughtCount + "/" + Pokedex.pokedexSize, xOffset + 188, yOffset + 112, 1, false);
        matrix.m_280056_(this.f_96547_, "UUID: " + this.player.m_20148_().toString(), xOffset + 46, yOffset + 153, 1, false);
        matrix.m_280056_(this.f_96547_, this.player.m_7755_().getString(), xOffset + 10, yOffset + 55, 1, false);
        matrix.m_280163_(Resources.pokedollar, xOffset + 169, yOffset + 84, 0.0f, 0.0f, 6, 9, 6, 9);
        matrix.m_280056_(this.f_96547_, this.money, xOffset + 177, yOffset + 84, 1, false);
        if (this.player == null) {
            matrix.m_280168_().m_85836_();
            matrix.m_280168_().m_85841_(2.5f, 2.5f, 0.0f);
            matrix.m_280218_(Resources.pokedollar, (this.f_96543_ - 290) / 4, this.f_96544_ / 2 + 15, 227, 242, 10, 14);
            matrix.m_280168_().m_85849_();
        } else {
            ScreenHelper.drawEntity(matrix, (LivingEntity)this.player, this.f_96543_ / 2 + 123, 151, 45.0f, 360.0f, 0.0f);
        }
        super.m_88315_(matrix, mouseX, mouseY, partialTicks);
    }

    private void drawPokemon(GuiGraphics matrix, Pokemon pokemon, int xOffset, int yOffset, int ballX, int ballY, int pokeX, int pokeY) {
        if (pokemon != null) {
            matrix.m_280163_(pokemon.getBall().getGUISprite(), xOffset + ballX, yOffset + ballY, 0.0f, 0.0f, 44, 43, 44, 43);
            matrix.m_280163_(pokemon.getSprite(), xOffset + pokeX, yOffset + pokeY - 3, 0.0f, 0.0f, 40, 40, 40, 40);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    protected void actionPerformed(Button button) {
        if (button instanceof ThemedButton) {
            ClientData.color = this.color = ((ThemedButton)button).color;
            NetworkHelper.sendToServer(new TrainerCardColorPacket(this.color));
        }
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (keyCode == ClientProxy.trainerCardKeyBind.getKey().m_84873_()) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public void m_7861_() {
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public static class ThemedButton
    extends IndexedButton {
        private static final ResourceLocation BUTTON = ResourceLocationHelper.of(Resources.prefix + "gui/trainercards/button.png");
        private EnumTrainerCardColor color;

        public ThemedButton(int buttonId, EnumTrainerCardColor color, int x, int y, Button.OnPress action) {
            super(buttonId, x, y, 10, 10, "", action);
            this.color = color;
        }

        public void m_87963_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
            ScreenHelper.drawImage(BUTTON, matrix, (float)this.f_93620_, (float)this.f_93621_, (float)this.f_93618_, (float)this.f_93619_, this.color.red, this.color.green, this.color.blue, 1.0f, 1.0f);
        }
    }
}

