/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.statueEditor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelData;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.EnumStatuePacketMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.StatueUpdatePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Quaternionf;

public class StatueEditorScreen
extends DropDownScreen {
    public static UUID statueId;
    private StatueEntity statue;
    private float rotationX = 0.0f;
    private float rotationY = 0.0f;
    private float savedX = 0.0f;
    private float savedY = 0.0f;
    private float scale = 0.0f;
    private float savedRotationX = 180.0f;
    private float savedRotationY = 0.0f;
    private boolean paused = false;
    private boolean showAxies = false;
    private Button modelGuiButton;
    private IndexedButton animateButton;
    private IndexedButton axisButton;
    private EditBox tbName;
    private EditBox tbLabel;
    private EditBox tbFrame;
    int controlWidth = 145;
    int controlLeft;
    int controlHeight;
    int controlTop;
    ModelData[] lastModel;
    private DropDown<Stats> formDropDown;
    int lastFrame;

    public StatueEditorScreen(int entityid) {
        super((Component)Component.m_237119_());
        StatueEntity statue;
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(entityid);
        if (entity instanceof StatueEntity && Objects.equals((statue = (StatueEntity)entity).m_20148_(), statueId)) {
            this.statue = statue;
        }
    }

    @Override
    public void m_7856_() {
        if (this.statue == null) {
            ScreenHelper.closeScreen();
            return;
        }
        Species species = this.statue.getSpecies();
        if (species == null) {
            ScreenHelper.closeScreen();
            return;
        }
        super.m_7856_();
        PixelmonOverlayScreen.isVisible = false;
        Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        Minecraft.m_91087_().f_91066_.f_92062_ = true;
        if (Minecraft.m_91087_().m_293199_().m_294516_()) {
            Minecraft.m_91087_().m_293199_().m_293034_();
        }
        this.controlLeft = 10;
        this.controlTop = 10;
        this.controlHeight = this.f_96544_ - 20;
        int buttonHeight = 20;
        int textFieldHeight = 10;
        this.tbName = new TabCompleteTextField(6, this.f_96541_.f_91062_, this.controlLeft + 45, this.controlTop + 3, this.controlWidth - 55, textFieldHeight).setCompletions(PixelmonSpecies.getFormattedEnglishNameSet());
        this.tbName.m_94144_(this.statue.getSpecies().getLocalizedName());
        this.tbName.m_94151_(this::setSpecies);
        this.m_142416_((GuiEventListener)this.tbName);
        this.tbLabel = new EditBox(this.f_96541_.f_91062_, this.controlLeft + 45, this.controlTop + 18, this.controlWidth - 55, textFieldHeight, (Component)Component.m_237119_());
        this.tbLabel.m_94144_(this.statue.getLabel());
        this.tbLabel.m_94151_(this::setLabel);
        this.lastModel = this.statue.getModel();
        this.m_142416_((GuiEventListener)this.tbLabel);
        this.tbFrame = null;
        if (this.statue.getFrameCount() > 0) {
            int animTop = this.controlTop + 33;
            List<AnimationType> anims = this.statue.getAllAnimations();
            ArrayList<String> animStrings = new ArrayList<String>();
            for (AnimationType anim : anims) {
                animStrings.add(anim.toString().toLowerCase(Locale.ROOT));
            }
            this.addDropDown(new DropDown<String>(animStrings, this.statue.getAnimation().toString().toLowerCase(Locale.ROOT), this.controlLeft + 45, animTop + Math.max(-16, (anims.size() - 1) * -10), 80, 100).setGetOptionString(animation -> I18n.m_118938_((String)("gui.model." + animation), (Object[])new Object[0])).setOnSelected(this::selectAnimation).setInactiveTop(this.controlTop + 33));
            this.tbFrame = new EditBox(this.f_96541_.f_91062_, this.controlLeft + 45, this.controlTop + 48, 40, textFieldHeight, (Component)Component.m_237119_());
            this.tbFrame.m_94144_("" + this.statue.getAnimationFrame());
            this.tbFrame.m_94151_(this::setFrame);
            this.lastFrame = this.statue.getAnimationFrame();
            this.m_142416_((GuiEventListener)this.tbFrame);
        }
        ArrayList forms = Lists.newArrayList(this.statue.getSpecies().getForms(true));
        int width = Math.min(150, Math.max(80, forms.stream().mapToInt(f -> this.f_96541_.f_91062_.m_92895_(f.getLocalizedName())).max().orElse(0)));
        this.formDropDown = this.addDropDown(new DropDown<Stats>(forms, this.statue.getStats(), this.controlLeft + 45, this.controlTop + 63, width, 150).setGetOptionString(stats -> {
            if (stats.getLocalizedName().isEmpty()) {
                return "Default";
            }
            return stats.getLocalizedName();
        }).setOnSelected(form -> {
            NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetForm, statueId, form.getName()));
            if (this.statue.getIsFlying()) {
                this.changeFlying(false);
            }
        }).setInactiveTop(this.controlTop + 63));
        ArrayList palettes = Lists.newArrayList((Object[])this.statue.getGenderProperties().getPalettes());
        PaletteProperties currentPalette = this.statue.getPalette();
        this.addDropDown(new DropDown<PaletteProperties>(palettes, currentPalette, this.controlLeft + 45, this.controlTop + 78, 80, 120).setGetOptionString(PaletteProperties::getName).setOnSelected(texture -> NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetPalette, statueId, texture.getName()))).setInactiveTop(this.controlTop + 78));
        ArrayList textures = Lists.newArrayList((Object[])EnumStatueTextureType.values());
        EnumStatueTextureType current = this.statue.getTextureType();
        this.addDropDown(new DropDown<EnumStatueTextureType>(textures, current, this.controlLeft + 45, this.controlTop + 93, 80, 120).setGetOptionString(ITranslatable::getLocalizedName).setOnSelected(texture -> NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetTextureType, statueId, texture.toString()))).setInactiveTop(this.controlTop + 93));
        this.addDropDown(new DropDown<EnumGrowth>(EnumGrowth.orderedList, this.statue.getGrowth(), this.controlLeft + 45, this.controlTop + 108, 80, 150).setGetOptionString(ITranslatable::getLocalizedName).setOnSelected(growth -> Pixelmon.network.send((Object)new StatueUpdatePacket(EnumStatuePacketMode.SetGrowth, statueId, growth.toString()), PacketDistributor.SERVER.noArg())).setInactiveTop(this.controlTop + 108));
        this.addDropDown(new DropDown<EnumBoundingBoxMode>(Lists.newArrayList((Object[])EnumBoundingBoxMode.values()), this.statue.getBoundingMode(), this.controlLeft + 45, this.controlTop + 123, 80, 150).setGetOptionString(val -> val.name().toUpperCase()).setOnSelected(mode -> Pixelmon.network.send((Object)new StatueUpdatePacket(EnumStatuePacketMode.SetBoundingBoxMode, statueId, mode.name()), PacketDistributor.SERVER.noArg())).setInactiveTop(this.controlTop + 123));
        this.addDropDown(new DropDown<String>(Lists.newArrayList((Object[])new String[]{"enabled", "disabled"}), this.statue.canMove() ? "enabled" : "disabled", this.controlLeft + 45, this.controlTop + 138, 80, 150).setGetOptionString(String::toUpperCase).setOnSelected(mode -> Pixelmon.network.send((Object)new StatueUpdatePacket(EnumStatuePacketMode.SetCanMove, statueId, mode.equalsIgnoreCase("enabled")), PacketDistributor.SERVER.noArg())).setInactiveTop(this.controlTop + 138));
        this.m_142416_((GuiEventListener)new IndexedButton(69, this.controlLeft + 45, this.controlTop + 153, 80, 20, I18n.m_118938_((String)this.statue.getGender().getTranslationKey(), (Object[])new Object[0]), this::actionPerformed));
        this.animateButton = new IndexedButton(2, this.controlLeft + 5, this.f_96544_ - 60, 60, buttonHeight, I18n.m_118938_((String)"gui.animate.text", (Object[])new Object[0]), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.animateButton);
        this.axisButton = new IndexedButton(12, this.controlLeft + this.controlWidth - 60 - 6, this.f_96544_ - 60, 60, buttonHeight, I18n.m_118938_((String)"gui.axis_on.text", (Object[])new Object[0]), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.axisButton);
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.controlLeft + 5, this.f_96544_ - 35, this.controlWidth - 10, buttonHeight, I18n.m_118938_((String)"gui.save.text", (Object[])new Object[0]), this::actionPerformed));
    }

    public void setSpecies(String s) {
        Optional<Species> species = PixelmonSpecies.fromNameOrDex(s);
        if (!species.isPresent() || species.get().is(PixelmonSpecies.MISSINGNO)) {
            return;
        }
        if (this.statue.getSpecies() == species.get()) {
            return;
        }
        NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetName, statueId, species.get().getName()));
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        return this.m_7222_() != null && this.m_7222_().m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public void setLabel(String s) {
        this.statue.setLabel(s);
    }

    private void setFrame(String s) {
        int frame;
        int n = frame = s.isEmpty() ? 0 : NumberHelper.parseInt(s).orElseGet(() -> {
            this.tbFrame.m_94144_("");
            return 0;
        });
        if (frame < 0) {
            frame = 0;
            this.tbFrame.m_94144_("");
        } else if (frame >= this.statue.getFrameCount()) {
            frame = this.statue.getFrameCount() - 1;
            this.tbFrame.m_94144_(String.valueOf(frame));
        }
        if (frame != this.lastFrame) {
            this.statue.setAnimationFrame(frame);
            NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetAnimationFrame, statueId, frame));
            this.lastFrame = frame;
        }
    }

    private void selectAnimation(String nextAnim) {
        this.statue.setAnimation(AnimationType.getTypeFor(nextAnim));
        NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetAnimation, statueId, nextAnim));
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean unicode = Minecraft.m_91087_().m_91390_();
        Minecraft.m_91087_().m_91336_(true);
        if (super.m_6375_(mouseX, mouseY, button)) {
            Minecraft.m_91087_().m_91336_(unicode);
            return true;
        }
        this.mouseClickedUnderMenus(mouseX, mouseY, button);
        Minecraft.m_91087_().m_91336_(unicode);
        return true;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            this.scale = (float)((double)this.scale + deltaY * 10.0);
            if (this.scale < 0.0f) {
                this.scale = 0.0f;
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, deltaX, deltaY);
    }

    public void m_7379_() {
        Species e;
        if (!this.tbName.m_94155_().equalsIgnoreCase(this.statue.getSpecies().getName()) && (e = PixelmonSpecies.fromName(this.tbName.m_94155_()).getValueUnsafe()) != null && e != this.statue.getSpecies()) {
            NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetName, statueId, e.getName()));
        }
        if (!this.tbLabel.m_94155_().equalsIgnoreCase(this.statue.getLabel())) {
            NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetLabel, statueId, this.tbLabel.m_94155_()));
        }
        CursorHelper.resetCursor();
        ScreenHelper.closeScreen();
        PixelmonOverlayScreen.isVisible = true;
        Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
        Minecraft.m_91087_().f_91066_.f_92062_ = false;
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        this.tbName.m_6375_(x, y, mouseButton);
        this.tbLabel.m_6375_(x, y, mouseButton);
        if (this.tbFrame != null) {
            this.tbFrame.m_6375_(x, y, mouseButton);
        }
        return super.mouseClickedUnderMenus(x, y, mouseButton);
    }

    protected void actionPerformed(Button guiButton) {
        int id = ((IndexedButton)guiButton).id;
        if (id == 1) {
            this.m_7379_();
        } else if (id == 2) {
            boolean shouldAnimate;
            boolean bl = shouldAnimate = !this.statue.isAnimated();
            if (!shouldAnimate) {
                this.animateButton.m_93666_((Component)Component.m_237115_((String)"gui.animate.text"));
            } else {
                this.animateButton.m_93666_((Component)Component.m_237115_((String)"gui.pause.text"));
            }
            NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetShouldAnimate, statueId, shouldAnimate));
        } else if (id == 10) {
            this.changeFlying(!this.statue.getIsFlying());
        } else if (id == 11) {
            this.paused = !this.paused;
        } else if (id == 12) {
            boolean bl = this.showAxies = !this.showAxies;
            if (!this.showAxies) {
                this.axisButton.m_93666_((Component)Component.m_237115_((String)"gui.axis_on.text"));
            } else {
                this.axisButton.m_93666_((Component)Component.m_237115_((String)"gui.axis_off.text"));
            }
        } else if (id == 69) {
            if (this.statue.getGender() == Gender.NONE) {
                return;
            }
            if (this.statue.getGender() == Gender.MALE) {
                this.statue.setGender(Gender.FEMALE);
            } else {
                this.statue.setGender(Gender.MALE);
            }
            NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetGender, statueId, this.statue.getGender().ordinal()));
            guiButton.m_93666_((Component)(this.statue.getGender() == Gender.MALE ? Component.m_237115_((String)"gui.trainereditor.male") : Component.m_237115_((String)"gui.trainereditor.female")));
        }
    }

    private void changeFlying(boolean isFlying) {
        String extra;
        this.statue.setIsFlying(isFlying);
        NetworkHelper.sendToServer(new StatueUpdatePacket(EnumStatuePacketMode.SetModelStanding, statueId, isFlying));
        String string = extra = isFlying ? "flying" : "standing";
        if (this.modelGuiButton != null) {
            this.modelGuiButton.m_93666_((Component)Component.m_237115_((String)("gui.model." + extra)));
        }
    }

    @Override
    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        if (!this.m_5953_(mouseX, mouseY)) {
            CursorHelper.setCursor(CursorHelper.CROSS_CURSOR);
        } else {
            CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        }
        super.m_88315_(matrix, mouseX, mouseY, partialTicks);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX > 0.0 && mouseX <= (double)this.controlWidth;
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawGradientRect(matrix, this.controlLeft, this.controlTop, 0.0f, this.controlLeft + this.controlWidth, this.controlTop + this.controlHeight, -1713512995, -1713512995);
        if (this.statue.getModel() != this.lastModel) {
            int i = this.f_96541_.m_91268_().m_85445_();
            int j = this.f_96541_.m_91268_().m_85446_();
            this.m_6575_(this.f_96541_, i, j);
            this.lastModel = this.statue.getModel();
        }
        Object text = I18n.m_118938_((String)"gui.trainereditor", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 3), 0, false, true);
        text = I18n.m_118938_((String)"gui.label.text", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 18), 0, false, true);
        if (this.tbFrame != null) {
            text = I18n.m_118938_((String)"gui.model.animation", (Object[])new Object[0]);
            ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 33), 0, false, true);
            text = I18n.m_118938_((String)"gui.model.frame", (Object[])new Object[0]);
            ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 48), 0, false, true);
            text = "/" + (this.statue.getFrameCount() - 1);
            ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 90, (float)(this.controlTop + 48), 0, false, true);
        }
        if (this.formDropDown.getVisible()) {
            text = I18n.m_118938_((String)"gui.trainereditor.form", (Object[])new Object[0]);
            ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 63), 0, false, true);
        }
        text = I18n.m_118938_((String)"gui.model.palette", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 78), 0, false, true);
        text = I18n.m_118938_((String)"gui.texture.text", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 93), 0, false, true);
        text = I18n.m_118938_((String)"gui.trainereditor.growth", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 108), 0, false, true);
        text = I18n.m_118938_((String)"gui.texture.bounding_box_mode", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 123), 0, false, true);
        text = I18n.m_118938_((String)"gui.texture.can_move", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 138), 0, false, true);
        text = I18n.m_118938_((String)"gui.trainereditor.gender", (Object[])new Object[0]);
        ScreenHelper.drawString(matrix, (String)text, this.controlLeft + 5, (float)(this.controlTop + 153), 0, false, true);
        StatueEntity ep = this.statue;
        if (ep != null && ep.getModel() != null) {
            this.drawEntityToScreen(matrix, (this.f_96543_ + this.controlWidth) / 2 - 10, this.f_96544_ / 2 + 20, 200, 200, ep, partialTicks, !this.paused);
        }
    }

    public void drawEntityToScreen(GuiGraphics matrix, int x, int y, int w, int l, StatueEntity e, float pt, boolean spin) {
        matrix.m_280168_().m_85836_();
        matrix.m_280168_().m_252880_((float)x + this.savedX, (float)y + this.savedY, 100.0f);
        float eheight = (float)l / e.m_20206_() / 4.0f;
        float ewidth = (float)l / e.m_20205_() / 4.0f;
        float scalar = eheight > ewidth ? eheight : ewidth;
        matrix.m_280168_().m_85841_(scalar + Math.max(0.0f, this.scale), scalar + Math.max(0.0f, this.scale), scalar + Math.max(0.0f, this.scale));
        matrix.m_280168_().m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.m_280168_().m_252781_(QuaternionHelper.fromEuler(this.savedRotationY + this.rotationY, 1.0f, 0.0f, 0.0f));
        matrix.m_280168_().m_252781_(QuaternionHelper.fromEuler(this.savedRotationX + this.rotationX, 0.0f, 1.0f, 0.0f));
        Entity view = Minecraft.m_91087_().m_91288_();
        if (view == null) {
            view = Minecraft.m_91087_().f_91074_;
        }
        float tx = (float)(view.f_19854_ + (view.m_20185_() - view.f_19854_) * (double)pt);
        float tz = (float)(view.f_19856_ + (view.m_20189_() - view.f_19856_) * (double)pt);
        float angle = (float)(Math.atan2(e.m_20189_() - (double)tz, e.m_20185_() - (double)tx) * 180.0 / Math.PI) + 90.0f;
        matrix.m_280168_().m_252781_(QuaternionHelper.fromEuler(-angle + 45.0f, 0.0f, 1.0f, 0.0f));
        PixelmonRendering.renderEntity(matrix, e, true, pt);
        if (this.showAxies) {
            this.drawAxis(matrix, 0.1f, 0.1f, Color.RED, QuaternionHelper.fromEuler(0.0f, 0.0f, 0.0f, 0.0f));
            this.drawAxis(matrix, 0.1f, 0.1f, Color.BLUE, QuaternionHelper.fromEuler(90.0f, 0.0f, 1.0f, 0.0f));
            this.drawAxis(matrix, 0.1f, 0.1f, Color.GREEN, QuaternionHelper.fromEuler(90.0f, 0.0f, 0.0f, 1.0f));
        }
        matrix.m_280168_().m_85849_();
    }

    private void drawAxis(GuiGraphics matrix, float scale, float height, Color color, Quaternionf axis) {
        matrix.m_280168_().m_85836_();
        matrix.m_280168_().m_85841_(scale, scale, scale);
        matrix.m_280168_().m_252781_(axis);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        for (int i = 0; i < 5; ++i) {
            ScreenHelper.drawQuad(matrix, -this.f_96543_, 0.0f, 0.0f, this.f_96543_, 0.0f, 0.0f, this.f_96543_, height, 0.0f, -this.f_96543_, height, 0.0f, color);
            matrix.m_280168_().m_85836_();
            matrix.m_280168_().m_252781_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
            ScreenHelper.drawQuad(matrix, -this.f_96543_, 0.0f, 0.0f, this.f_96543_, 0.0f, 0.0f, this.f_96543_, height, 0.0f, -this.f_96543_, height, 0.0f, color);
            matrix.m_280168_().m_85849_();
        }
        matrix.m_280168_().m_85849_();
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (mouseX < 0.0 || mouseX > (double)this.f_96543_ || mouseY < 0.0 || mouseY > (double)this.f_96544_) {
            return true;
        }
        if (this.m_5953_(mouseX, mouseY)) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        if (button == 0) {
            this.savedRotationX = (float)((double)this.savedRotationX - dragX);
            this.savedRotationY = (float)((double)this.savedRotationY + dragY);
            return true;
        }
        if (button == 1) {
            this.savedX = (float)((double)this.savedX + dragX);
            this.savedY = (float)((double)this.savedY + dragY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.savedRotationX += this.rotationX;
            this.savedRotationY += this.rotationY;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    public void m_280273_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawGradientRect(graphics, 0, 0, 0.0f, this.f_96543_, this.f_96544_, -1725816286, -1725816286);
    }
}

