/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.starter;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.ShadowDelete;
import com.pixelmonmod.pixelmon.client.gui.starter.MoveDirection;
import com.pixelmonmod.pixelmon.client.gui.starter.ShadowSize;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class Shadow {
    ShadowSize shadowType;
    MoveDirection moveDirection;
    ShadowDelete parent;
    float position;
    float yPos;
    float moveSpeed;

    public Shadow(ShadowSize shadowType, ShadowDelete parent) {
        this.shadowType = shadowType;
        this.parent = parent;
        Random r = RandomHelper.getRandom();
        this.moveDirection = r.nextFloat() < 0.5f ? MoveDirection.LEFT : MoveDirection.RIGHT;
        this.position = this.moveDirection == MoveDirection.LEFT ? 1.0f : 0.0f;
        this.moveSpeed = r.nextFloat() * shadowType.moveSpeedModifier * 0.01f + 0.001f;
        this.yPos = r.nextFloat();
    }

    public Shadow(ShadowSize shadowType, ShadowDelete parent, float startPos) {
        this(shadowType, parent);
        this.position = startPos;
    }

    public void update() {
        if (this.moveDirection == MoveDirection.LEFT) {
            this.position -= this.moveSpeed;
            if (this.position <= 0.0f) {
                this.parent.removeShadow(this);
            }
        } else {
            this.position += this.moveSpeed;
            if (this.position >= 1.0f) {
                this.parent.removeShadow(this);
            }
        }
    }

    public void draw(GuiGraphics matrix, Minecraft mc, int screenWidth, int screenHeight) {
        float totWidth = screenWidth + this.shadowType.width * 2;
        float x = totWidth * this.position - (float)this.shadowType.width;
        float totHeight = screenHeight - 50;
        float y = this.yPos * totHeight - (float)this.shadowType.height + 50.0f;
        RenderSystem.enableBlend();
        ScreenHelper.drawImageQuad(Resources.shadow, matrix, (int)x, (int)y, this.shadowType.width, this.shadowType.height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
    }
}

