/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.starter;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ObjectHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.ShadowDelete;
import com.pixelmonmod.pixelmon.client.gui.starter.Shadow;
import com.pixelmonmod.pixelmon.client.gui.starter.ShadowSize;
import com.pixelmonmod.pixelmon.client.gui.starter.StarterButton;
import com.pixelmonmod.pixelmon.client.gui.starter.StarterScreenPhase;
import com.pixelmonmod.pixelmon.client.gui.widgets.ImageButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.SWSHButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ChooseStarterPacket;
import com.pixelmonmod.pixelmon.config.starter.Starter;
import com.pixelmonmod.pixelmon.config.starter.StarterList;
import com.pixelmonmod.pixelmon.config.starter.StarterOption;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class ChooseStarterScreen
extends Screen
implements ShadowDelete {
    private StarterScreenPhase currentScreen = StarterScreenPhase.Copyright;
    private int clickedIndex = -1;
    protected final boolean[] options;
    private int page;
    private int pages;
    private final List<StarterButton> starterButtons = Lists.newArrayList();
    private final List<ImageButton> pageButtons = Lists.newArrayList();
    private final List<SWSHButton> buttons = Lists.newArrayList();
    private final List<Shadow> shadowList = Lists.newArrayList();
    private int ticksToChange = 100;

    public ChooseStarterScreen() {
        this(new boolean[StarterList.getOptions().size()], 0);
    }

    public ChooseStarterScreen(boolean[] options, int page) {
        super((Component)Component.m_237119_());
        Random r = RandomHelper.getRandom();
        while (this.shadowList.size() < 5) {
            float f = r.nextFloat();
            ShadowSize shadowType = f < 0.2f ? ShadowSize.Large : (f < 0.5f ? ShadowSize.Medium : ShadowSize.Large);
            this.shadowList.add(new Shadow(shadowType, this, r.nextFloat()));
        }
        this.options = options;
        this.page = page;
    }

    public void m_7856_() {
        super.m_7856_();
        if (!ServerStorageDisplay.showStarterScreen) {
            return;
        }
        if (this.currentScreen == StarterScreenPhase.Choose) {
            this.initButtons();
        }
    }

    private void initButtons() {
        this.buttons.clear();
        this.pageButtons.clear();
        this.starterButtons.clear();
        int index = 0;
        for (Starter starter : StarterList.getStarters()) {
            starter.resetDisplay();
            StarterButton button2 = new StarterButton(index, this.f_96543_ / 2 - 96 + 25 * (starter.getX() - 4), this.f_96544_ / 2 - 64 + starter.getY() * 16, starter.getScale(), this, this::actionPerformed);
            if (index == this.clickedIndex) {
                button2.clicked = true;
            }
            button2.f_93624_ = starter.getPage() == this.page;
            button2.f_93623_ = button2.f_93624_;
            this.starterButtons.add(button2);
            ++index;
            this.pages = Math.max(this.pages, starter.getPage() + 1);
        }
        this.buttons.add(new SWSHButton((float)this.f_96543_ / 2.0f - 90.0f, (float)this.f_96544_ * 2.0f / 3.0f + 22.0f, 1.0, 180.0, 16.0, I18n.m_118938_((String)"gui.starter.begin", (Object[])new Object[0]), button -> {
            if (this.isSelected()) {
                NetworkHelper.sendToServer(new ChooseStarterPacket(this.clickedIndex, this.options));
                ServerStorageDisplay.showStarterScreen = false;
                try {
                    this.f_96541_.f_91074_.m_6915_();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }).setVisible(this.isSelected()));
        ImageButton lhs = new ImageButton(0, (int)((float)this.f_96543_ * 0.02f) - 5, (int)((float)this.f_96544_ / 2.0f - 32.0f) - 3, 10, 36, Resources.starterLeft, 1.0f, 1.0f, 1.0f, button -> {
            if (this.page - 1 < 0) {
                if (StarterList.shouldLoop()) {
                    this.page = this.pages - 1;
                }
            } else {
                --this.page;
            }
        });
        lhs.f_93623_ = this.pages != 1 && (StarterList.shouldLoop() || this.page < this.pages - 1);
        lhs.f_93624_ = lhs.f_93623_;
        this.pageButtons.add(lhs);
        ImageButton rhs = new ImageButton(0, (int)((float)this.f_96543_ - (float)this.f_96543_ * 0.02f) - 5, (int)((float)this.f_96544_ / 2.0f - 32.0f) - 3, 10, 36, Resources.starterRight, 1.0f, 1.0f, 1.0f, button -> {
            if (this.page + 1 >= this.pages) {
                if (StarterList.shouldLoop()) {
                    this.page = 0;
                }
            } else {
                ++this.page;
            }
        });
        rhs.f_93623_ = this.pages != 1 && (StarterList.shouldLoop() || this.page > 0);
        rhs.f_93624_ = rhs.f_93623_;
        this.pageButtons.add(rhs);
        int optionIndex = 0;
        for (StarterOption option : StarterList.getOptions()) {
            String labelKey = option.getLabel(this.options[optionIndex]);
            int finalOptionIndex = optionIndex;
            this.buttons.add(new SWSHButton((float)this.f_96543_ / 2.0f - 100.0f + (float)(25 * (option.getX() - 4)) - (float)(option.getWidth() * 25) / 4.0f, (float)this.f_96544_ / 2.0f - 64.0f + (float)(option.getY() * 16), 1.0, option.getWidth() * 25, 14.0, I18n.m_118936_((String)labelKey) ? I18n.m_118938_((String)labelKey, (Object[])new Object[0]) : labelKey, button -> {
                this.options[finalOptionIndex] = !this.options[finalOptionIndex];
                this.initButtons();
            }).setVisible(!this.isSelected()));
            ++optionIndex;
        }
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_5534_(char i, int i1) {
        return false;
    }

    public void actionPerformed(Button button) {
        if (button instanceof StarterButton && ((StarterButton)button).starterIndex != -1) {
            StarterButton starterButton = (StarterButton)button;
            for (StarterButton buttonL : this.starterButtons) {
                if (buttonL == button || buttonL == null) continue;
                buttonL.clicked = false;
            }
            starterButton.clicked = !starterButton.clicked;
            this.clickedIndex = starterButton.clicked ? starterButton.starterIndex : -1;
        }
    }

    public void m_88315_(GuiGraphics graphics, int par1, int par2, float par3) {
        if (this.f_96541_ != null) {
            ObjectHelper.ifNotNull(this.f_96541_.m_91097_().m_118506_(Resources.starterLeft), t -> t.setBlurMipmap(true, true));
            ObjectHelper.ifNotNull(this.f_96541_.m_91097_().m_118506_(Resources.starterRight), t -> t.setBlurMipmap(true, true));
        }
        Color color = StarterList.getColor(this.page);
        ScreenHelper.drawImageQuad(Resources.starterBackground, graphics, 0.0f, 0.0f, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 1.0f, 1.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f, 0.0f);
        for (Shadow aShadowList : this.shadowList) {
            aShadowList.draw(graphics, this.f_96541_, this.f_96543_, this.f_96544_);
        }
        RenderSystem.enableBlend();
        ScreenHelper.drawImageQuad(Resources.starterBorders, graphics, 0.0f, 0.0f, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        if (this.currentScreen == StarterScreenPhase.Copyright) {
            graphics.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.starter.trademark1", (Object[])new Object[0]), this.f_96543_ / 2, this.f_96544_ / 2 - 30, 0xFFFFFF);
            graphics.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.starter.trademark2", (Object[])new Object[0]), this.f_96543_ / 2, this.f_96544_ / 2 - 17, 0xFFFFFF);
            graphics.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.starter.trademark3", (Object[])new Object[0]), this.f_96543_ / 2, this.f_96544_ / 2 + 5, 0xFFFFFF);
        } else if (this.currentScreen == StarterScreenPhase.Choose) {
            if (this.buttons.isEmpty()) {
                this.m_7856_();
                if (this.buttons.isEmpty()) {
                    this.f_96541_.f_91074_.m_6915_();
                }
            }
            graphics.m_280137_(this.f_96541_.f_91062_, I18n.m_118936_((String)StarterList.getText()[0]) ? I18n.m_118938_((String)StarterList.getText()[0], (Object[])new Object[0]) : StarterList.getText()[0], this.f_96543_ / 2, this.f_96544_ / 2 - 92, 0xFFFFFF);
            graphics.m_280137_(this.f_96541_.f_91062_, I18n.m_118936_((String)StarterList.getText()[1]) ? I18n.m_118938_((String)StarterList.getText()[1], (Object[])new Object[0]) : StarterList.getText()[1], this.f_96543_ / 2, this.f_96544_ / 2 - 80, 0xFFFFFF);
            boolean hovering = false;
            PoseStack matrix = graphics.m_280168_();
            if (!this.isSelected()) {
                for (StarterButton starterButton : this.starterButtons) {
                    if (!starterButton.m_5953_(par1, par2)) continue;
                    hovering = true;
                    Species species = StarterList.getStarters().get(starterButton.starterIndex).getDisplay(this.options).getSpecies();
                    String name = ChatFormatting.BOLD + species.getLocalizedName();
                    matrix.m_85841_(0.9f, 0.9f, 0.9f);
                    ScreenHelper.drawCenteredSplitString(graphics, I18n.m_118938_((String)("pixelmon." + species.getName().toLowerCase(Locale.ROOT) + ".description"), (Object[])new Object[0]), (float)this.f_96543_ / 1.8f, this.f_96544_ - 35, 300, 0xFFFFFF, false);
                    matrix.m_85841_(1.1111112f, 1.1111112f, 1.1111112f);
                    ScreenHelper.drawCenteredString(graphics, name, (float)this.f_96543_ / 2.0f, (float)(this.f_96544_ * 2) / 3.0f, 0xFFFFFF);
                }
            } else {
                for (StarterButton starterButton : this.starterButtons) {
                    if (starterButton == null || !starterButton.clicked) continue;
                    Species species = StarterList.getStarters().get(starterButton.starterIndex).getDisplay(this.options).getSpecies();
                    String name = ChatFormatting.BOLD + species.getLocalizedName();
                    ScreenHelper.drawCenteredString(graphics, name, (float)this.f_96543_ / 2.0f, (float)(this.f_96544_ * 2) / 3.0f, 0xFFFFFF);
                }
            }
            for (StarterButton starterButton : this.starterButtons) {
                starterButton.m_88315_(graphics, par1, par2, par3);
            }
            for (ImageButton imageButton : this.pageButtons) {
                if (!imageButton.f_93624_) continue;
                matrix.m_85836_();
                if (imageButton.m_5953_(par1, par2)) {
                    long tick = System.currentTimeMillis();
                    float dx = tick % 2000L - 1000L;
                    if (dx < 0.0f) {
                        dx = Math.abs(dx);
                    }
                    matrix.m_252880_((dx -= 500.0f) * 0.004f, 0.0f, 0.0f);
                }
                imageButton.m_88315_(graphics, par1, par2, par3);
                matrix.m_85849_();
            }
            if (!hovering) {
                for (SWSHButton sWSHButton : this.buttons) {
                    sWSHButton.draw(graphics, par1, par2, par3);
                }
            }
        }
    }

    public void m_86600_() {
        if (this.currentScreen == StarterScreenPhase.Copyright) {
            --this.ticksToChange;
            if (this.ticksToChange <= 0) {
                this.currentScreen = StarterScreenPhase.Choose;
                this.m_7856_();
            }
        }
        for (int i = 0; i < this.shadowList.size(); ++i) {
            this.shadowList.get(i).update();
        }
        if (RandomHelper.getRandom().nextFloat() < 0.008f) {
            float f = RandomHelper.getRandom().nextFloat();
            ShadowSize shadowType = f < 0.2f ? ShadowSize.Large : (f < 0.5f ? ShadowSize.Medium : ShadowSize.Large);
            this.shadowList.add(new Shadow(shadowType, this));
        }
    }

    public boolean m_6375_(double x, double y, int b) {
        boolean reload = false;
        if (this.currentScreen == StarterScreenPhase.Copyright) {
            this.currentScreen = StarterScreenPhase.Choose;
            this.m_7856_();
        } else {
            for (StarterButton starterButton : this.starterButtons) {
                if (!starterButton.f_93623_ || !starterButton.m_6375_(x, y, b)) continue;
                reload = true;
                break;
            }
            if (!reload) {
                for (SWSHButton sWSHButton : this.buttons) {
                    if (!sWSHButton.isInteractable() || !sWSHButton.isWithin(x, y)) continue;
                    sWSHButton.onClick(x, y, b);
                    reload = true;
                    break;
                }
            }
            if (!reload) {
                for (ImageButton imageButton : this.pageButtons) {
                    if (!imageButton.f_93623_ || !imageButton.m_6375_(x, y, b)) continue;
                    reload = true;
                    break;
                }
            }
        }
        if (!reload) {
            for (StarterButton starterButton : this.starterButtons) {
                starterButton.clicked = false;
                this.clickedIndex = -1;
            }
        }
        this.initButtons();
        return super.m_6375_(x, y, b);
    }

    @Override
    public void removeShadow(Shadow shadow) {
        this.shadowList.remove(shadow);
    }

    private boolean isSelected() {
        return this.clickedIndex != -1;
    }
}

