/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.spawner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.machines.PokemonRarity;
import com.pixelmonmod.pixelmon.blocks.tileentity.PixelmonSpawnerTileEntity;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.spawner.PokemonListScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.CheckboxButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.ImageButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.comm.PixelmonSpawnerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.UpdateSpawnerPacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class PixelmonSpawnerScreen
extends Screen {
    protected PokemonListScreen list;
    protected PixelmonSpawnerTileEntity ps;
    private int listTop;
    private int listLeft;
    private int listHeight;
    private int listWidth;
    private boolean page;
    private EditBox pokemonNameBox;
    private EditBox rarityBox;
    private EditBox spawnTickBox;
    private EditBox spawnRadiusBox;
    private EditBox maxSpawnsBox;
    private EditBox levelMinBox;
    private EditBox levelMaxBox;
    private EditBox bossRatioBox;
    private EditBox shinyRatioBox;
    private EditBox gmaxRatio;
    private CheckboxButton globalUncatchableBox;
    private CheckboxButton globalUnbreedable;
    private CheckboxButton globalUnbattleable;

    public PixelmonSpawnerScreen(int x, int y, int z) {
        super((Component)Component.m_237119_());
        this.ps = (PixelmonSpawnerTileEntity)Minecraft.m_91087_().f_91073_.m_7702_(new BlockPos(x, y, z));
        this.listTop = 58;
        this.listLeft = 15;
        this.listWidth = 100;
        this.page = true;
    }

    public void m_7856_() {
        super.m_7856_();
        PixelmonOverlayScreen.isVisible = false;
        Minecraft.m_91087_().f_91066_.f_92062_ = true;
        if (Minecraft.m_91087_().m_293199_().m_294516_()) {
            Minecraft.m_91087_().m_293199_().m_293034_();
        }
        this.list = new PokemonListScreen(this, 250, this.f_96544_ - 80, 25, 15);
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)new IndexedButton(0, this.listLeft + this.listWidth + 30, this.f_96544_ - 40, 30, 20, (Component)Component.m_237115_((String)"gui.trainereditor.add"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(5, this.listLeft + this.listWidth + 65, this.f_96544_ - 40, 70, 20, (Component)Component.m_237115_((String)"gui.trainereditor.deletepoke"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new ImageButton(1, this.f_96543_ - 30, 15, 15, 15, ResourceLocationHelper.of("pixelmon:textures/gui/uielements/tile006.png"), 255.0f, 0.0f, 0.0f, this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(6, this.f_96543_ - 115, this.f_96544_ - 40, 30, 20, "<", this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(7, this.f_96543_ - 45, this.f_96544_ - 40, 30, 20, ">", this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(3, this.f_96543_ - 115, 35, 100, 20, this.ps.aggression.getLocalizedName(), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(4, this.f_96543_ - 115, 60, 100, 20, this.ps.spawnLocation.getLocalizedName(), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(2, this.f_96543_ - 115, 85, 100, 20, (Component)(this.ps.fireOnTick ? Component.m_237115_((String)"gui.pixelmonspawner.fireontick") : Component.m_237115_((String)"gui.pixelmonspawner.fireonredstone")), this::actionPerformed));
        for (GuiEventListener indexedButton : this.f_96540_) {
            if (!(indexedButton instanceof IndexedButton) || ((IndexedButton)indexedButton).id < 2 || ((IndexedButton)indexedButton).id > 4) continue;
            ((IndexedButton)indexedButton).f_93624_ = !((IndexedButton)indexedButton).f_93624_;
        }
        this.pokemonNameBox = new TabCompleteTextField(5, Minecraft.m_91087_().f_91062_, this.listLeft, this.f_96544_ - 40, 80, 20).setCompletions(PixelmonSpecies.getFormattedEnglishNameSet());
        this.pokemonNameBox.m_94144_("Charizard");
        this.pokemonNameBox.m_94199_(1000);
        this.m_142416_((GuiEventListener)this.pokemonNameBox);
        this.rarityBox = new EditBox(Minecraft.m_91087_().f_91062_, this.listLeft + 85, this.f_96544_ - 40, 40, 20, (Component)Component.m_237119_());
        this.rarityBox.m_94144_("1");
        this.m_142416_((GuiEventListener)this.rarityBox);
        this.spawnTickBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ - 56, 35, 40, 10, (Component)Component.m_237119_());
        this.spawnTickBox.m_94144_("" + this.ps.spawnTick);
        this.m_142416_((GuiEventListener)this.spawnTickBox);
        this.spawnRadiusBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ - 56, 50, 40, 10, (Component)Component.m_237119_());
        this.spawnRadiusBox.m_94144_("" + this.ps.spawnRadius);
        this.m_142416_((GuiEventListener)this.spawnRadiusBox);
        this.maxSpawnsBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ - 56, 65, 40, 10, (Component)Component.m_237119_());
        this.maxSpawnsBox.m_94144_("" + this.ps.maxSpawns);
        this.m_142416_((GuiEventListener)this.maxSpawnsBox);
        this.levelMinBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ - 56, 80, 40, 10, (Component)Component.m_237119_());
        this.levelMinBox.m_94144_("" + this.ps.levelMin);
        this.m_142416_((GuiEventListener)this.levelMinBox);
        this.levelMaxBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ - 56, 95, 40, 10, (Component)Component.m_237119_());
        this.levelMaxBox.m_94144_("" + this.ps.levelMax);
        this.m_142416_((GuiEventListener)this.levelMaxBox);
        this.bossRatioBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ - 56, 110, 40, 10, (Component)Component.m_237119_());
        this.bossRatioBox.m_94144_("" + this.ps.bossRatio);
        this.m_142416_((GuiEventListener)this.bossRatioBox);
        this.shinyRatioBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ - 56, 125, 40, 10, (Component)Component.m_237119_());
        this.shinyRatioBox.m_94144_("" + this.ps.shinyRatio);
        this.m_142416_((GuiEventListener)this.shinyRatioBox);
        this.gmaxRatio = new EditBox(Minecraft.m_91087_().f_91062_, this.f_96543_ - 56, 140, 40, 10, (Component)Component.m_237119_());
        this.gmaxRatio.m_94144_("" + this.ps.gmaxRatio);
        this.m_142416_((GuiEventListener)this.gmaxRatio);
        this.globalUncatchableBox = new CheckboxButton(1, this.f_96543_ - 26, 155, 10, 10, this.ps.uncatchable, this::actionPerformed);
        this.m_142416_((GuiEventListener)this.globalUncatchableBox);
        this.globalUnbattleable = new CheckboxButton(1, this.f_96543_ - 26, 170, 10, 10, this.ps.unbattleable, this::actionPerformed);
        this.m_142416_((GuiEventListener)this.globalUnbattleable);
        this.globalUnbreedable = new CheckboxButton(1, this.f_96543_ - 26, 185, 10, 10, this.ps.unbreedable, this::actionPerformed);
        this.m_142416_((GuiEventListener)this.globalUnbreedable);
        this.m_142416_((GuiEventListener)this.list);
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        return this.m_7222_() != null && this.m_7222_().m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public boolean m_6375_(double par1, double par2, int par3) {
        boolean force = Minecraft.m_91087_().m_91390_();
        Minecraft.m_91087_().m_91336_(true);
        this.list.m_6375_(par1, par2, par3);
        boolean superCall = super.m_6375_(par1, par2, par3);
        Minecraft.m_91087_().m_91336_(force);
        return superCall;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean force = Minecraft.m_91087_().m_91390_();
        Minecraft.m_91087_().m_91336_(true);
        PoseStack matrix = graphics.m_280168_();
        ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, 10.0f, 10.0f, this.f_96543_ - 20, this.f_96544_ - 20, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        if (this.isFullScreen()) {
            ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, (float)((double)this.f_96543_ / 2.0 - 0.2 * (double)this.f_96543_), 10.0f, 0.4f * (float)this.f_96543_, this.f_96544_ - 20, 0.0f, 1.0f, 1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.25f, 0.0f);
            if (this.list.selectedElement != -1) {
                matrix.m_85836_();
                matrix.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)this.f_96544_ * 0.125, 300.0);
                float scalar = 1.0f;
                double referenceW = (float)this.f_96544_ / 18.0f;
                double referenceH = (float)this.f_96544_ / 18.0f;
                double dh = this.list.selectedPokemon.getForm().getDimensions().getHeight() - referenceH;
                double dw = this.list.selectedPokemon.getForm().getDimensions().getWidth() - referenceW;
                scalar = dh > dw ? (float)(referenceH / this.list.selectedPokemon.getForm().getDimensions().getHeight()) : (float)(referenceW / this.list.selectedPokemon.getForm().getDimensions().getWidth());
                matrix.m_85841_(scalar, scalar, scalar);
                matrix.m_85836_();
                matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
                PixelmonRendering.renderEntity(graphics, new PixelmonEntity((Level)this.f_96541_.f_91073_, this.list.selectedPokemon), true, partialTicks);
                matrix.m_85849_();
                matrix.m_85849_();
            }
        }
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.pokemonspec", (Object[])new Object[0]), 15, 15, 0, false);
        graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner", (Object[])new Object[0]), this.listLeft + 2, this.f_96544_ - 50, 0, false);
        graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.rarity", (Object[])new Object[0]), this.listLeft + 87, this.f_96544_ - 50, 0, false);
        if (this.page) {
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.spawntick", (Object[])new Object[0]), this.f_96543_ - 110, 35, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.radius", (Object[])new Object[0]), this.f_96543_ - 110, 50, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.maxspawns", (Object[])new Object[0]), this.f_96543_ - 110, 65, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.minlevel", (Object[])new Object[0]), this.f_96543_ - 110, 80, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.maxlevel", (Object[])new Object[0]), this.f_96543_ - 110, 95, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.bossratio", (Object[])new Object[0]), this.f_96543_ - 110, 110, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.shinyratio", (Object[])new Object[0]), this.f_96543_ - 110, 125, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.gmaxratio", (Object[])new Object[0]), this.f_96543_ - 110, 140, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.uncatchable", (Object[])new Object[0]), this.f_96543_ - 110, 155, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.unbattleable", (Object[])new Object[0]), this.f_96543_ - 110, 170, 0, false);
            graphics.m_280056_(font, I18n.m_118938_((String)"gui.pixelmonspawner.unbreedable", (Object[])new Object[0]), this.f_96543_ - 110, 185, 0, false);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.isFullScreen() && (this.list.selectedElement == -1 || this.list.selectedElement >= this.list.getSize())) {
            String text = I18n.m_118938_((String)"gui.pixelmonspawner.select", (Object[])new Object[0]);
            graphics.drawString(font, text, (float)this.f_96543_ / 2.0f - (float)font.m_92895_(text) / 2.0f, (float)this.f_96544_ / 2.0f, 0, false);
        }
        Minecraft.m_91087_().m_91336_(force);
    }

    public void m_86600_() {
    }

    protected void actionPerformed(Button button) {
        if (button.f_93623_ && button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 0) {
                int rarityString;
                PokemonSpecification pokemon = PokemonSpecificationProxy.create(this.pokemonNameBox.m_94155_()).get();
                try {
                    rarityString = Integer.parseInt(this.rarityBox.m_94155_());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (pokemon.getValue(SpeciesRequirement.class).isPresent() && rarityString > 0) {
                    int rarity = rarityString;
                    this.ps.pokemonList.add(new PokemonRarity(pokemon, rarity));
                    this.list.bindAmountScrolled();
                }
            } else if (id == 1) {
                this.saveFields();
            } else if (id == 2) {
                boolean bl = this.ps.fireOnTick = !this.ps.fireOnTick;
                if (this.ps.fireOnTick) {
                    button.m_93666_((Component)Component.m_237115_((String)"gui.pixelmonspawner.fireontick"));
                } else {
                    button.m_93666_((Component)Component.m_237115_((String)"gui.pixelmonspawner.fireonredstone"));
                }
            } else if (id == 3) {
                this.ps.aggression = Aggression.nextAggression(this.ps.aggression);
                button.m_93666_((Component)Component.m_237113_((String)this.ps.aggression.getLocalizedName()));
            } else if (id == 4) {
                this.ps.spawnLocation = SpawnLocationType.nextLocation(this.ps.spawnLocation);
                button.m_93666_((Component)Component.m_237113_((String)this.ps.spawnLocation.getLocalizedName()));
            } else if (id == 5) {
                if (this.list.selectedElement == -1 || this.list.selectedElement >= this.list.getSize()) {
                    return;
                }
                this.list.gui.removeFromList(this.list.selectedElement);
                this.list.bindAmountScrolled();
            } else if (id == 6 || id == 7) {
                this.page = !this.page;
                for (GuiEventListener child : this.f_96540_) {
                    if (child instanceof EditBox && ((EditBox)child).f_93620_ > this.f_96543_ - 150) {
                        boolean bl = ((EditBox)child).f_93624_ = !((EditBox)child).f_93624_;
                    }
                    if (child instanceof CheckboxButton) {
                        boolean bl = ((CheckboxButton)child).f_93624_ = !((CheckboxButton)child).f_93624_;
                    }
                    if (!(child instanceof IndexedButton)) continue;
                    IndexedButton indexedButton = (IndexedButton)child;
                    if (indexedButton.id < 2 || indexedButton.id > 4) continue;
                    indexedButton.f_93624_ = !indexedButton.f_93624_;
                }
            }
        }
    }

    private void saveFields() {
        if (this.checkFields()) {
            ScreenHelper.closeScreen();
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.saveFields();
        PixelmonOverlayScreen.isVisible = true;
        Minecraft.m_91087_().f_91066_.f_92062_ = false;
    }

    private boolean checkFields() {
        int spawnTicks = NumberHelper.parseInt(this.spawnTickBox.m_94155_()).orElse(0);
        int spawnRadius = NumberHelper.parseInt(this.spawnRadiusBox.m_94155_()).orElse(0);
        int maxSpawns = NumberHelper.parseInt(this.maxSpawnsBox.m_94155_()).orElse(0);
        int levelMin = NumberHelper.parseInt(this.levelMinBox.m_94155_()).orElse(0);
        int levelMax = NumberHelper.parseInt(this.levelMaxBox.m_94155_()).orElse(0);
        float bossRatio = (float)NumberHelper.parseDouble(this.bossRatioBox.m_94155_()).orElse(0.0);
        float gmaxRatio = (float)NumberHelper.parseDouble(this.gmaxRatio.m_94155_()).orElse(0.0);
        float shinyRatio = (float)NumberHelper.parseDouble(this.shinyRatioBox.m_94155_()).orElse(0.0);
        boolean uncatchable = this.globalUncatchableBox.m_93840_();
        boolean unbattleable = this.globalUnbattleable.m_93840_();
        boolean unbreedable = this.globalUnbreedable.m_93840_();
        if (spawnTicks > 0 && spawnTicks < 1000 && spawnRadius > 0 && spawnRadius < 50 && maxSpawns > 0 && maxSpawns < 50 && levelMin > 0 && levelMin <= PixelmonServerConfig.maxLevel && levelMax >= levelMin && levelMax <= PixelmonServerConfig.maxLevel) {
            this.ps.spawnTick = spawnTicks;
            this.ps.spawnRadius = spawnRadius;
            this.ps.maxSpawns = maxSpawns;
            this.ps.levelMin = levelMin;
            this.ps.levelMax = levelMax;
            this.ps.bossRatio = bossRatio;
            this.ps.gmaxRatio = gmaxRatio;
            this.ps.shinyRatio = shinyRatio;
            this.ps.unbattleable = unbattleable;
            this.ps.uncatchable = uncatchable;
            this.ps.unbreedable = unbreedable;
            CompoundTag nbt = new CompoundTag();
            this.ps.m_183515_(nbt);
            PixelmonSpawnerData p = new PixelmonSpawnerData(this.ps.m_58899_(), nbt, this.ps.pokemonList);
            NetworkHelper.sendToServer(new UpdateSpawnerPacket(p));
            return true;
        }
        return false;
    }

    public PokemonRarity getPokemonListEntry(int ind) {
        if (ind < this.ps.pokemonList.size() && ind >= 0) {
            return this.ps.pokemonList.get(ind);
        }
        return null;
    }

    public int getBiggestRarity() {
        int largest = Integer.MIN_VALUE;
        for (PokemonRarity pokemonRarity : this.ps.pokemonList) {
            if (pokemonRarity.rarity <= largest) continue;
            largest = pokemonRarity.rarity;
        }
        return largest;
    }

    public int getBiggestSpec(int maxSize) {
        int largest = Integer.MIN_VALUE;
        String largestText = null;
        for (PokemonRarity pokemonRarity : this.ps.pokemonList) {
            int length = Minecraft.m_91087_().f_91062_.m_92895_(pokemonRarity.pokemon.toString());
            if (length <= largest) continue;
            largestText = pokemonRarity.pokemon.toString();
            largest = length;
        }
        if (largestText == null) {
            return 0;
        }
        if (largestText.length() > maxSize) {
            largestText = largestText.substring(0, maxSize + 1);
            return Minecraft.m_91087_().f_91062_.m_92895_(largestText);
        }
        return largest;
    }

    public String getPercentage(int index) {
        PokemonRarity pokemonListEntry = this.getPokemonListEntry(index);
        double total = 0.0;
        for (PokemonRarity pokemonRarity : this.ps.pokemonList) {
            total += (double)pokemonRarity.rarity;
        }
        return String.format("%.2f", (double)pokemonListEntry.rarity / total * 100.0);
    }

    public boolean isFullScreen() {
        return Minecraft.m_91087_().m_91268_().m_85441_() > 900;
    }

    public int getPokemonListCount() {
        return this.ps.pokemonList.size();
    }

    public void removeFromList(int var1) {
        this.ps.pokemonList.remove(var1);
    }
}

