/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.raids;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenParticleEngine;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.raids.RaidButton;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.RaidActionPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.items.ItemData;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class RaidCatchScreen
extends Screen {
    private static final ResourceLocation WATERMARK = ResourceLocationHelper.of("pixelmon", "textures/gui/raids/watermark.png");
    private static final ResourceLocation STAR = ResourceLocationHelper.of("pixelmon", "textures/gui/raids/star.png");
    private static final ResourceLocation SHINY = ResourceLocationHelper.of("pixelmon", "textures/gui/battle/shiny.png");
    private final List<RaidButton> buttons = Lists.newArrayList();
    private RaidData raid;
    private PixelmonEntity pixelmon;
    private boolean shiny;
    private ItemStack[] drops;
    private List<ItemData> balls;
    private boolean canCatch;
    private boolean sentToPC;
    private boolean catchSuccess = false;
    private boolean pcFull = false;
    private boolean inCatchAnimation = false;
    private int shakes = 0;
    private int ticker = 0;
    private int delay = -1;
    private boolean shakeSound = false;
    private boolean shouldRefresh = false;
    private int ballIndex = 0;
    private int scrollIndex = 0;
    private boolean closing = false;
    protected ScreenParticleEngine particleEngine = new ScreenParticleEngine();
    private boolean scrolling = false;
    private boolean click = false;
    private long lastTime = -1L;

    public RaidCatchScreen(RaidData raid, boolean shiny, ItemStack[] drops, List<ItemData> pokeballs, boolean canCatch) {
        super((Component)Component.m_237119_());
        this.f_96541_ = Minecraft.m_91087_();
        SoundHelper.playSound(SoundEvents.f_12496_, 0.5f, 1.0f);
        this.drops = drops;
        this.canCatch = canCatch;
        this.balls = this.canCatch ? pokeballs : Lists.newArrayList();
        this.shiny = shiny;
        this.setRaid(raid);
    }

    public void setRaid(RaidData raid) {
        this.setRaid(raid, null);
    }

    public void setRaid(RaidData raid, RaidCatchScreen old) {
        this.raid = raid;
        if (old != null) {
            this.pixelmon = old.pixelmon;
        } else {
            Pokemon pokemon = PokemonFactory.create(raid.getSpecies());
            if (raid.getForm() != null) {
                pokemon.setForm(raid.getForm());
            }
            pokemon.setGrowth(EnumGrowth.Ordinary);
            pokemon.setShiny(this.shiny);
            this.pixelmon = new PixelmonEntity((Level)this.f_96541_.f_91073_, pokemon);
            this.pixelmon.setAnimation(AnimationType.IDLE);
            this.pixelmon.checkAnimation();
            this.pixelmon.initAnimation();
        }
        this.shouldRefresh = true;
    }

    public void setShakes(int shakes, boolean sentToPC) {
        if (!this.inCatchAnimation && this.canCatch) {
            if (shakes < 0) {
                this.pcFull = true;
            } else {
                SoundHelper.playSound((SoundEvent)SoundRegistration.POKEBALL_CAPTURE.get(), 0.4f, 1.0f);
                this.inCatchAnimation = true;
                this.ticker = -500;
                this.shakes = Mth.m_14045_((int)shakes, (int)1, (int)3);
                this.catchSuccess = shakes >= 4;
                this.canCatch = false;
                this.sentToPC = sentToPC;
            }
            this.shouldRefresh = true;
        }
    }

    private void initButtons() {
        this.buttons.clear();
        if (this.canCatch) {
            this.buttons.add(new RaidButton((double)this.f_96543_ * 0.5, (double)this.f_96544_ / 1.06 - (double)((int)((double)this.f_96544_ * 0.08 * 2.0)), 1.0, 0.0, (float)this.f_96544_ / 17.0f, "<", this.raid, button -> {
                boolean prev = this.canUseCurrentBall();
                --this.ballIndex;
                if (this.ballIndex < 0) {
                    this.ballIndex = this.balls.size() - 1;
                }
                if (this.canUseCurrentBall() != prev) {
                    this.shouldRefresh = true;
                }
            }).setEnabled(this.balls.size() > 1).setVisible(this.canCatch));
            this.buttons.add(new RaidButton((double)this.f_96543_ * 0.6, (double)this.f_96544_ / 1.06 - (double)((int)((double)this.f_96544_ * 0.08 * 2.0)), 1.0, 0.0, (float)this.f_96544_ / 17.0f, ">", this.raid, button -> {
                boolean prev = this.canUseCurrentBall();
                ++this.ballIndex;
                if (this.ballIndex >= this.balls.size()) {
                    this.ballIndex = 0;
                }
                if (this.canUseCurrentBall() != prev) {
                    this.shouldRefresh = true;
                }
            }).setEnabled(this.balls.size() > 1).setVisible(this.canCatch));
            this.buttons.add(new RaidButton((double)this.f_96543_ * 0.643, (double)this.f_96544_ / 1.06 - (double)((int)((double)this.f_96544_ * 0.08 * 2.0)), 1.0, (float)this.f_96543_ / 7.0f, (float)this.f_96544_ / 17.0f, this.pcFull ? I18n.m_118938_((String)"raid.button.pcfull", (Object[])new Object[0]) : (this.balls.isEmpty() ? I18n.m_118938_((String)"raid.button.noballs", (Object[])new Object[0]) : (this.canUseCurrentBall() ? I18n.m_118938_((String)"raid.button.catch", (Object[])new Object[0]) : I18n.m_118938_((String)"raid.button.cantuse", (Object[])new Object[0]))), this.raid, button -> NetworkHelper.sendToServer(new RaidActionPacket(this.raid.getDen(), 10, this.ballIndex, this.balls.get(this.ballIndex).getItemStack()))).setEnabled(this.canCatch && !this.balls.isEmpty() && !this.pcFull && this.canUseCurrentBall()).setVisible(this.canCatch));
            this.buttons.add(new RaidButton((double)this.f_96543_ * 0.83, (double)this.f_96544_ / 1.06 - (double)((int)((double)this.f_96544_ * 0.08 * 2.0)), 1.0, (float)this.f_96543_ / 7.0f, (float)this.f_96544_ / 17.0f, I18n.m_118938_((String)"raid.button.dontcatch", (Object[])new Object[0]), this.raid, button -> {
                this.closing = true;
                BattleScreen.restoreSettingsAndCloseStatic(ClientProxy.battleManager);
            }).setEnabled(this.canCatch).setVisible(this.canCatch));
        } else {
            this.buttons.add(new RaidButton((double)this.f_96543_ * 0.55, (double)this.f_96544_ / 1.06 - (double)((int)((double)this.f_96544_ * 0.08 * 2.0)), 1.0, (float)this.f_96543_ / 2.365f, (float)this.f_96544_ / 17.0f, I18n.m_118938_((String)"raid.button.done", (Object[])new Object[0]), this.raid, button -> {
                this.closing = true;
                BattleScreen.restoreSettingsAndCloseStatic(ClientProxy.battleManager);
            }).setEnabled(!this.inCatchAnimation && !this.canCatch).setVisible(!this.canCatch));
        }
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        float scale;
        if (this.buttons.isEmpty() || this.shouldRefresh) {
            this.shouldRefresh = false;
            this.initButtons();
        }
        this.m_280273_(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        for (RaidButton button : this.buttons) {
            button.draw(matrix, mouseX, mouseY, partialTicks);
        }
        int starSize = (int)((double)this.f_96543_ * 0.05);
        double sw = this.raid.getStars() * starSize;
        for (int i = 0; i < this.raid.getStars(); ++i) {
            ScreenHelper.drawImage(matrix, STAR, (float)((double)((float)this.f_96543_ * 0.75f + (float)(starSize * i)) - sw / 2.0), (float)this.f_96544_ * 0.185f, (float)starSize, (float)starSize, 1.0f);
        }
        float fs = (float)this.f_96543_ * 0.045f;
        ScreenHelper.drawScaledCenteredString(matrix, I18n.m_118938_((String)(this.catchSuccess && !this.inCatchAnimation ? "raid.caught" : "raid.defeated"), (Object[])new Object[]{this.raid.getSpecies().getName()}), (float)this.f_96543_ * 0.755f, (float)this.f_96544_ * 0.125f - fs / 4.0f, -1, fs);
        this.drawDrops(matrix, mouseX, mouseY);
        if (!this.balls.isEmpty() && this.canCatch) {
            scale = (float)this.f_96543_ / 960.0f * 3.0f;
            matrix.m_280168_().m_85836_();
            matrix.m_280168_().m_85837_((double)((float)this.f_96543_ * 0.525f), (double)this.f_96544_ * 0.7675, 0.0);
            matrix.m_280168_().m_85841_(scale, scale, scale);
            this.drawItem(matrix, this.balls.get(this.ballIndex).getItemStack(), 0.0f, 0.0f, 770, 771);
            matrix.m_280168_().m_85849_();
        }
        if (this.canCatch || this.ticker < 0 || !this.raid.canAllCatch && !this.raid.isOwner(this.f_96541_.f_91074_.m_20148_())) {
            matrix.m_280168_().m_85836_();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            matrix.m_280168_().m_252880_((float)this.f_96543_ / 4.0f, (float)this.f_96544_ / 4.0f * 3.0f, 300.0f);
            double referenceW = (float)this.f_96544_ / 3.0f;
            double referenceH = (float)this.f_96544_ / 4.0f;
            double dh = this.pixelmon.getForm().getDimensions().getHeight() - referenceH;
            double dw = this.pixelmon.getForm().getDimensions().getWidth() - referenceW;
            float scalar = 1.0f;
            scalar = dh > dw ? (float)(referenceH / this.pixelmon.getForm().getDimensions().getHeight()) : (float)(referenceW / this.pixelmon.getForm().getDimensions().getWidth());
            matrix.m_280168_().m_85841_(scalar, scalar, scalar);
            if (this.ticker < 0) {
                float shrink = (float)Math.max(0, -this.ticker) / 500.0f;
                matrix.m_280168_().m_85841_(shrink, shrink, shrink);
            }
            matrix.m_280168_().m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
            try {
                EntityRenderDispatcher renderManager = this.f_96541_.m_91290_();
                EntityRenderer entityClassRenderObject = renderManager.m_114382_((Entity)this.pixelmon);
                PixelmonRenderer rp = (PixelmonRenderer)entityClassRenderObject;
                rp.render(this.pixelmon, 0.0f, partialTicks, matrix.m_280168_(), (MultiBufferSource)matrix.m_280091_(), 0xF000F0);
                matrix.m_280091_().m_109911_();
                renderManager.m_252923_(Axis.f_252436_.m_252961_(180.0f));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            matrix.m_280168_().m_85849_();
        }
        if (this.shiny && RandomHelper.getRandom().nextInt(80) == 0) {
            double dx = (RandomHelper.getRandom().nextDouble() - 0.5) * (double)this.f_96544_ * 0.5;
            double dy = (RandomHelper.getRandom().nextDouble() - 0.5) * (double)this.f_96544_ * 0.5;
            int size = 15 + RandomHelper.getRandom().nextInt(15);
            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle(SHINY, (double)this.f_96543_ * 0.225 + dx, (double)this.f_96544_ * 0.5 + dy, 1000.0, 0.0, 0.0, 0.0, 1.0f, 0.8f, 0.3f, 0.0f, size, size, 120, (particle, PoseStack2) -> {
                int x = particle.age;
                int m = particle.maxAge;
                int h = m / 2;
                particle.a = (float)(x <= h ? x : h - (x - h)) / (float)h;
            }));
        }
        this.particleEngine.draw(matrix);
        if (!this.canCatch) {
            matrix.m_280168_().m_85836_();
            scale = (float)this.f_96543_ / 960.0f * 6.0f;
            matrix.m_280168_().m_85837_((double)((float)this.f_96543_ * 0.201f), (double)this.f_96544_ * 0.58, 200.0);
            matrix.m_280168_().m_85841_(scale, scale, scale);
            if (this.inCatchAnimation) {
                long ms = this.getMillis();
                if (this.shakes > 0) {
                    boolean tick = true;
                    float scalar = 0.5f;
                    float speed = 1.0f;
                    float angle = 0.0f;
                    float shrink = 1.0f;
                    if (this.ticker >= 0) {
                        if (this.delay == -1) {
                            this.delay = 500;
                        }
                        if (this.delay > 0) {
                            this.delay = (int)((long)this.delay - ms);
                            tick = false;
                        }
                        if ((float)this.ticker < 100.0f * speed) {
                            angle = (float)(-this.ticker) * scalar;
                        } else if ((float)this.ticker < 300.0f * speed) {
                            angle = ((float)this.ticker - 200.0f * speed) * scalar;
                            if ((float)this.ticker < 200.0f * speed && !this.shakeSound) {
                                SoundHelper.playSound((SoundEvent)SoundEvents.f_12208_.get(), 1.0f, 1.0f);
                                this.shakeSound = true;
                            }
                        } else if ((float)this.ticker < 400.0f * speed) {
                            angle = (400.0f * speed - (float)this.ticker) * scalar;
                        } else if ((float)this.ticker > 500.0f * speed) {
                            this.ticker = 0;
                            --this.shakes;
                            this.shakeSound = false;
                        }
                    } else {
                        shrink = 1.0f - (float)Math.max(0, -this.ticker) / 500.0f;
                    }
                    matrix.m_280168_().m_252880_(8.0f, 16.0f, 0.0f);
                    matrix.m_280168_().m_85841_(shrink, shrink, shrink);
                    matrix.m_280168_().m_252781_(QuaternionHelper.fromEuler(angle, 0.0f, 0.0f, 1.0f));
                    matrix.m_280168_().m_252880_(-8.0f, -16.0f, 0.0f);
                    if (tick) {
                        this.ticker = (int)((double)this.ticker + (double)ms / 2.5);
                    }
                } else {
                    this.inCatchAnimation = false;
                    this.shouldRefresh = true;
                    if (this.catchSuccess) {
                        SoundHelper.playSound((SoundEvent)SoundRegistration.POKEBALL_CAPTURE_SUCCESS.get(), 0.2f, 1.0f);
                        for (int i = 0; i < 15; ++i) {
                            int r = RandomHelper.getRandom().nextInt(360);
                            double dx = (RandomHelper.getRandom().nextDouble() * 2.0 - 1.0) * (double)this.f_96543_ * 0.05;
                            double dy = (RandomHelper.getRandom().nextDouble() * 2.0 - 1.0) * (double)this.f_96543_ * 0.05;
                            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle(STAR, (double)((float)this.f_96543_ * 0.251f) + dx, (double)this.f_96544_ * 0.675 + dy, 10.0, 0.0, 0.0, 0.0, 0.96f, 0.78f, 0.0f, 0.0f, 0.0f, 0.0f, RandomHelper.getRandom().nextInt(100) + 100, (particle, PoseStack2) -> {
                                int x = particle.age;
                                int m = particle.maxAge;
                                int h = m / 2;
                                float s = (float)(x <= h ? x : h - (x - h)) / (float)h;
                                PoseStack2.m_85837_(particle.x, particle.y, 0.0);
                                PoseStack2.m_252781_(QuaternionHelper.fromOld(0.0f, 0.0f, r + x, true));
                                PoseStack2.m_85837_(-particle.x, -particle.y, 0.0);
                                PoseStack2.m_252880_(-particle.w / 2.0f, -particle.h / 2.0f, 0.0f);
                                particle.a = s;
                                particle.w = s * (float)this.f_96543_ * 0.0525f;
                                particle.h = s * (float)this.f_96543_ * 0.0525f;
                            }));
                        }
                    } else {
                        ArrayList stacks;
                        SoundHelper.playSound(SoundEvents.f_12018_, 0.8f, 0.8f + RandomHelper.getRandom().nextFloat() * 0.4f);
                        ItemData data = this.balls.get(this.ballIndex);
                        ItemStack pokeballStack = data.getItemStack();
                        if (pokeballStack.m_41720_().equals(PixelmonItems.poke_ball)) {
                            PokeBall ball = PokeBallPart.getPokeBall(pokeballStack).get();
                            stacks = Lists.newArrayList((Object[])new ItemStack[]{ball.getLidItem(), new ItemStack((ItemLike)ball.getRandomBaseAsItem()), new ItemStack((ItemLike)Blocks.f_50124_)});
                        } else {
                            stacks = Lists.newArrayList((Object[])new ItemStack[]{pokeballStack});
                        }
                        for (ItemStack stack : stacks) {
                            double mY = 0.1 + (RandomHelper.getRandom().nextDouble() * 0.1 - 0.05);
                            this.particleEngine.addParticle(new ScreenParticleEngine.GuiParticle(null, (float)this.f_96543_ * 0.201f, (double)this.f_96544_ * 0.58, 0.0, RandomHelper.getRandom().nextDouble() * 2.0 - 1.0, -2.0, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 300, (particle, matrixStack) -> {
                                matrixStack.m_85836_();
                                matrixStack.m_85837_(particle.x, particle.y, 200.0);
                                matrixStack.m_85841_(scale, scale, scale);
                                this.drawItem(matrix, stack, 0.0f, 0.0f, 770, 771);
                                matrixStack.m_85849_();
                                particle.mY += mY;
                            }));
                        }
                    }
                }
            }
            if (this.shakes > 0 || this.catchSuccess) {
                this.drawItem(matrix, this.balls.get(this.ballIndex).getItemStack(), 0.0f, 0.0f, 770, 771, this.shakes == 0);
            }
            matrix.m_280168_().m_85849_();
        }
    }

    private void drawDrops(GuiGraphics matrix, int mouseX, int mouseY) {
        int index;
        matrix.m_280168_().m_85836_();
        float fs = (float)this.f_96543_ * 0.045f;
        for (int i = 0; i < 6 && (index = this.scrollIndex + i) < this.drops.length; ++i) {
            ItemStack stack = this.drops[index];
            float h = (float)this.f_96544_ * (0.3f + 0.076f * (float)i);
            float scale = (float)this.f_96543_ / 960.0f * 2.0f;
            matrix.m_280168_().m_85836_();
            matrix.m_280168_().m_85837_((double)((float)this.f_96543_ * 0.55f), (double)h - (double)this.f_96544_ * 0.015, 0.0);
            matrix.m_280168_().m_85841_(scale, scale, scale);
            this.drawItem(matrix, stack, 0.0f, 0.0f, 770, 771);
            matrix.m_280168_().m_85849_();
            ScreenHelper.drawScaledSquashedString(matrix, stack.m_41786_().getString(), (float)this.f_96543_ * 0.595f, h, -1, fs, 100.0);
            ScreenHelper.drawScaledString(matrix, "x " + stack.m_41613_(), (float)this.f_96543_ * 0.89f, h - (float)this.f_96544_ * 0.005f, -1, fs);
        }
        if (this.drops.length > 6) {
            boolean mouseOver;
            int top = (int)((double)this.f_96544_ * 0.29);
            int bottom = (int)((double)this.f_96544_ * 0.735);
            int diff = bottom - top;
            int div = this.drops.length - 5;
            float dy = (float)diff / (float)div;
            matrix.m_280509_((int)((double)this.f_96543_ * 0.972), top, (int)((double)this.f_96543_ * 0.9825), bottom, -298897617);
            int bX1 = (int)((double)this.f_96543_ * 0.972);
            int bY1 = (int)((float)top + dy * (float)this.scrollIndex);
            int bX2 = (int)((double)this.f_96543_ * 0.9825);
            int bY2 = (int)((float)top + dy * (float)(this.scrollIndex + 1));
            boolean bl = mouseOver = mouseX >= bX1 && mouseY >= bY1 && mouseX <= bX2 && mouseY <= bY2;
            if (this.click && mouseOver) {
                this.scrolling = true;
            }
            if (!this.f_96541_.f_91067_.m_91560_()) {
                this.scrolling = false;
            }
            if (this.scrolling) {
                if (mouseY > bY2) {
                    ++this.scrollIndex;
                    if (this.scrollIndex > this.drops.length - 6) {
                        this.scrollIndex = Math.max(0, this.drops.length - 6);
                    }
                } else if (mouseY < bY1) {
                    --this.scrollIndex;
                    if (this.scrollIndex < 0) {
                        this.scrollIndex = 0;
                    }
                }
            }
            matrix.m_280509_(bX1, bY1, bX2, bY2, mouseOver || this.scrolling ? -289686597 : -292318317);
        }
        this.click = false;
        matrix.m_280168_().m_85849_();
    }

    private void drawItem(GuiGraphics matrix, ItemStack stack, float x, float y, int srcFactor, int destFactor) {
        this.drawItem(matrix, stack, x, y, srcFactor, destFactor, false);
    }

    private void drawItem(GuiGraphics matrix, ItemStack stack, float x, float y, int srcFactor, int destFactor, boolean darken) {
        matrix.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)srcFactor, (int)destFactor);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        matrix.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        matrix.m_280168_().m_252880_(x, y, 100.0f);
        MultiBufferSource.BufferSource MultiBufferSource$impl = Minecraft.m_91087_().m_91269_().m_110104_();
        matrix.m_280480_(stack, 0, 0);
        MultiBufferSource$impl.m_109911_();
        RenderSystem.enableDepthTest();
        matrix.m_280168_().m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (mouseX >= (double)this.f_96543_ * 0.525 && mouseY >= (double)this.f_96544_ * 0.25 && mouseY <= (double)this.f_96544_ * 0.75) {
            if (deltaY < 0.0) {
                ++this.scrollIndex;
                if (this.scrollIndex > this.drops.length - 6) {
                    this.scrollIndex = Math.max(0, this.drops.length - 6);
                }
            } else if (deltaY > 0.0) {
                --this.scrollIndex;
                if (this.scrollIndex < 0) {
                    this.scrollIndex = 0;
                }
            }
        }
        return super.m_6050_(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        for (RaidButton button : this.buttons) {
            button.onClick(mouseX, mouseY, mouseButton);
        }
        this.click = true;
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_280273_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawGradientRect(matrix, 0, 0, 0.0f, this.f_96543_, this.f_96544_, -1596523265, -1866285374);
        int bgBar = (int)((double)this.f_96544_ * 0.125);
        matrix.m_280168_().m_85836_();
        matrix.m_280168_().m_252880_((float)this.f_96543_, 0.0f, 0.0f);
        matrix.m_280168_().m_252781_(QuaternionHelper.fromEuler(90.0f, 0.0f, 0.0f, 1.0f));
        float[] color = this.raid.getDenEntity((Level)this.f_96541_.f_91073_).map(den -> {
            ScreenHelper.drawGradientRect(matrix, bgBar, 0, 0.0f, this.f_96544_ - bgBar, this.f_96543_, den.getColorUIA().getRGB(), den.getColorUIB().getRGB());
            Color c3 = den.getColorUIC();
            return new float[]{(float)c3.getRed() / 255.0f, (float)c3.getGreen() / 255.0f, (float)c3.getBlue() / 255.0f, 0.4f};
        }).orElseGet(() -> {
            ScreenHelper.drawGradientRect(matrix, bgBar, 0, 0.0f, this.f_96544_ - bgBar, this.f_96543_, -37796, -5752007);
            return new float[]{0.8f, 0.0f, 0.0f, 0.4f};
        });
        matrix.m_280168_().m_85849_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrix.m_280168_().m_85836_();
        matrix.m_280168_().m_252781_(QuaternionHelper.fromEuler(-35.0f, 0.0f, 0.0f, 1.0f));
        ScreenHelper.drawImage(matrix, WATERMARK, (float)this.f_96543_ / 2.8f, (float)this.f_96544_ / 1.2f, (float)this.f_96543_ / 3.75f, (float)((double)((float)this.f_96543_ / 3.75f) * 1.65591398), color[0], color[1], color[2], color[3], 0.0f);
        matrix.m_280168_().m_85849_();
        matrix.m_280168_().m_85836_();
        ScreenHelper.drawQuad(matrix, this.f_96543_, (float)bgBar * 0.5f, 0.0f, (float)this.f_96543_ - (float)this.f_96543_ * 0.475f, (float)bgBar * 0.5f, 0.0f, (float)this.f_96543_ - (float)this.f_96543_ * 0.5f, (float)bgBar * 1.5f, 0.0f, this.f_96543_, (float)bgBar * 1.5f, 0.0f, Color.BLACK);
        matrix.m_280168_().m_85849_();
    }

    public void m_86600_() {
        this.pixelmon.getAnimationVariables().tick();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.initButtons();
    }

    public void m_7861_() {
        super.m_7861_();
        if (!this.closing) {
            this.f_96541_.execute(() -> this.f_96541_.m_91152_((Screen)this));
        } else if (this.sentToPC) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237110_((String)"pixelmon.storage.partyfull", (Object[])new Object[]{this.pixelmon.m_5446_()}));
        }
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public long getMillis() {
        if (this.lastTime < 0L) {
            this.lastTime = System.currentTimeMillis();
            return 0L;
        }
        long time = System.currentTimeMillis();
        long diff = time - this.lastTime;
        this.lastTime = time;
        return diff;
    }

    private boolean canUseCurrentBall() {
        if (this.balls.isEmpty()) {
            return false;
        }
        Optional<PokeBall> ball = PokeBallPart.getPokeBall(this.balls.get(this.ballIndex).getItemStack());
        return this.raid.canUseMaster || !ball.isPresent() || !ball.get().isGuaranteedCatch();
    }
}

