/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.raids;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PokemonSlot {
    private RaidData raid;
    private Pokemon pokemon;
    private int index = -1;
    private RaidData.RaidPlayer player;
    private PlayerInfo npi;
    private final Consumer<Integer> onClick;
    private final double x;
    private final double y;
    private final double z;
    private double w;
    private double h;
    private boolean visible = true;
    private boolean enabled = true;

    public PokemonSlot(RaidData raid, double x, double y, double z, RaidData.RaidPlayer player, Consumer<Integer> onClick) {
        this(raid, x, y, z, onClick);
        this.pokemon = null;
        this.player = player;
        this.npi = this.player != null && this.player.player != null ? Minecraft.m_91087_().f_91074_.f_108617_.m_104949_(this.player.player) : null;
    }

    public PokemonSlot(RaidData raid, double x, double y, double z, Pokemon pokemon, Consumer<Integer> onClick) {
        this(raid, x, y, z, onClick);
        this.pokemon = pokemon;
        this.player = null;
        this.npi = null;
    }

    private PokemonSlot(RaidData raid, double x, double y, double z, Consumer<Integer> onClick) {
        this.raid = raid;
        this.x = x;
        this.y = y;
        this.z = z;
        this.onClick = onClick;
    }

    public void draw(GuiGraphics matrix, double mouseX, double mouseY, double width, double height, boolean selected, float partialTicks) {
        Color color;
        this.w = width / 20.0;
        this.h = height / 40.0;
        boolean disabled = this.isInteractable() && (this.pokemon == null || !this.pokemon.canBattle());
        boolean hover = this.isWithin(mouseX, mouseY);
        if (disabled) {
            color = new Color(100, 100, 100);
        } else {
            Optional<DenEntity> den = this.raid.getDenEntity((Level)Minecraft.m_91087_().f_91073_);
            color = selected && !hover ? (den.isPresent() ? den.get().getColorUIA() : new Color(255, 108, 92)) : (den.isPresent() ? den.get().getColorUIB() : new Color(168, 59, 57));
        }
        ScreenHelper.drawEllipse(matrix, this.x, this.y, this.z - 1.0, this.w, height / 40.0, 40, disabled ? color : (hover || selected ? color : Color.WHITE));
        if (this.player != null || this.pokemon != null) {
            ResourceLocation rl = this.player != null ? ScreenHelper.getPokemonSprite(this.player.species, this.player.form.getName(), this.player.gender, this.player.palette, 0, Minecraft.m_91087_()) : this.pokemon.getSprite();
            float c = disabled ? 0.4f : 1.0f;
            ScreenHelper.drawImage(matrix, rl, (float)(this.x + width * (double)0.005f), (float)(this.y - height * (double)0.06f), (float)(width / 24.0), (float)(width / 24.0), c, c, c, 1.0f, (float)this.z);
            if (this.npi != null) {
                ScreenHelper.drawImageQuadUV(this.npi.m_293823_().f_290339_(), matrix, (float)(this.x + width * 0.04), (float)(this.y + height * 0.01), (float)(width / 64.0), (float)(width / 64.0), 8.0f, 8.0f, 8.0f, 8.0f, 1.0f, 1.0f, 1.0f, 1.0f, (float)this.z);
            }
        }
    }

    public boolean isWithin(double x, double y) {
        return this.enabled && this.pokemon != null && x >= this.x && y >= this.y - this.w + this.h && x <= this.x + this.w && y <= this.y + this.h;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (this.isInteractable() && this.isWithin(mouseX, mouseY)) {
            this.onClick.accept(button);
        }
    }

    public boolean isInteractable() {
        return this.enabled && this.visible;
    }

    public PokemonSlot setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public PokemonSlot setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PokemonSlot setPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
        return this;
    }

    public PokemonSlot setIndex(int index) {
        this.index = index;
        return this;
    }

    public PokemonSlot setPlayer(PlayerInfo npi) {
        this.npi = npi;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isPlayer(UUID uuid) {
        return this.npi != null && this.npi.m_105312_() != null && this.npi.m_105312_().getId().equals(uuid);
    }
}

