/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.PokePasteReader;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IImportableContainer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportRequestHandler;
import com.pixelmonmod.pixelmon.client.gui.widgets.text.EnhancedTextFieldWidget;
import com.pixelmonmod.pixelmon.comm.packetHandlers.editor.ImportRequestPacket;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class ReadPokePasteScreen
extends Screen
implements ImportRequestHandler {
    private static final Component NEED_URL = Component.m_237115_((String)"pixelmon.pokepaste.error.need_url");
    private static final Component INVALID_URL = Component.m_237115_((String)"pixelmon.pokepaste.error.invalid_url");
    private static final Component DESCRIPTION = Component.m_237115_((String)"pixelmon.pokepaste.description");
    private static final Component BACK = Component.m_237115_((String)"gui.battle.back");
    private static final Component POKE_PASTE_LINK = Component.m_237115_((String)"pixelmon.pokepaste.link");
    private static final Component DOWNLOAD = Component.m_237115_((String)"pixelmon.download");
    protected final IImportableContainer previousScreen;
    protected final String titleText;
    protected EnhancedTextFieldWidget urlField;
    protected Component error;
    protected Component failedValue;
    private static final int URL_FIELD_MAX_LENGTH = 256;
    private static final int URL_FIELD_MAX_HEIGHT = 10;

    public ReadPokePasteScreen(IImportableContainer previousScreen, String titleText) {
        super((Component)Component.m_237119_());
        this.previousScreen = previousScreen;
        this.titleText = titleText;
    }

    public void m_7856_() {
        this.urlField = new EnhancedTextFieldWidget(this.f_96547_, this.f_96543_ / 2 - 128, this.f_96544_ / 2 - 5, 256, 10, (Component)Component.m_237119_());
        List lines = this.f_96547_.m_92865_().m_92414_((FormattedText)DESCRIPTION, 180, Style.f_131099_);
        this.urlField.m_94199_(256);
        this.urlField.setPlaceholder(POKE_PASTE_LINK);
        this.urlField.setTooltip((graphics, mouseX, mouseY) -> {
            int n = this.f_96544_ / 2 - 15;
            int n2 = lines.size();
            Objects.requireNonNull(this.f_96547_);
            int n3 = n - n2 * 9;
            int n4 = this.f_96544_ / 2 - 10;
            int n5 = lines.size();
            Objects.requireNonNull(this.f_96547_);
            int n6 = n4 - n5 * 9;
            int n7 = lines.size();
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280509_(mouseX, n3, mouseX + 190, n6 + n7 * 9, Color.BLACK.getRGB());
            for (int i = 0; i < lines.size(); ++i) {
                FormattedText iTextProperties = (FormattedText)lines.get(i);
                String string = iTextProperties.getString();
                int n8 = this.f_96544_ / 2 - 12;
                Objects.requireNonNull(this.f_96547_);
                graphics.m_280488_(this.f_96547_, string, mouseX + 5, n8 - 9 * (lines.size() - i), Color.WHITE.getRGB());
            }
        });
        this.m_142416_((GuiEventListener)this.urlField);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 190, this.f_96544_ / 2 - 110, 60, 20, BACK, event -> this.f_96541_.m_91152_(this.previousScreen.getScreen()), p_253695_ -> Component.m_237119_()));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 30, this.f_96544_ / 2 + 10, 60, 20, DOWNLOAD, event -> {
            if (this.urlField.m_94155_().isEmpty()) {
                this.urlField.setHighlightColor(Color.RED.getRGB());
                this.error = NEED_URL;
                return;
            }
            if (!this.urlField.m_94155_().trim().toLowerCase(Locale.ROOT).startsWith("https://pokepast.es")) {
                this.urlField.setHighlightColor(Color.RED.getRGB());
                this.error = INVALID_URL;
                return;
            }
            PokePasteReader from = PokePasteReader.from(this.urlField.m_94155_().trim());
            if (from == null) {
                this.urlField.setHighlightColor(Color.RED.getRGB());
                this.error = INVALID_URL;
                return;
            }
            NetworkHelper.sendToServer(new ImportRequestPacket(from.getLines()));
        }, p_253695_ -> Component.m_237119_()));
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.f_96543_ / 2.0f - 200.0f, (float)this.f_96544_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        if (this.error != null && !Objects.equals(this.error, Component.m_237119_()) && this.failedValue != null && !Objects.equals(this.failedValue, Component.m_237119_())) {
            FormattedCharSequence errorSequence = FormattedCharSequence.m_13696_((FormattedCharSequence)this.error.m_7532_(), (FormattedCharSequence)this.failedValue.m_7532_());
            matrix.drawString(this.f_96547_, errorSequence, (float)this.f_96543_ / 2.0f - 128.0f, (float)this.f_96544_ / 2.0f - 30.0f, Color.RED.getRGB(), true);
        }
        matrix.drawString(this.f_96547_, this.titleText, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(this.titleText) / 2.0f, (float)this.f_96544_ / 2.0f - 90.0f, 0, true);
        super.m_88315_(matrix, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.previousScreen.getScreen());
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public void handleResponse(Pokemon ... pokemon) {
        this.previousScreen.setPokemon(pokemon);
        this.f_96541_.m_91152_(this.previousScreen.getScreen());
    }

    @Override
    public void handleResponse(String error, String failedValue) {
        this.urlField.setHighlightColor(Color.RED.getRGB());
        this.error = Component.m_237115_((String)error);
        this.failedValue = Component.m_237115_((String)failedValue);
    }
}

