/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PartyEditorBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorIndividualScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.RandomizePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.RequestCloseEditedPlayerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdatePlayerPokemonPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PokemonEditorPartyScreen
extends PartyEditorBaseScreen {
    public static UUID editedPlayerUUID;
    public static String editedPlayerName;

    public PokemonEditorPartyScreen() {
        super(ServerStorageDisplay.editedPokemon);
    }

    @Override
    public Component m_96636_() {
        return Component.m_237115_((String)"gui.pokemoneditor.title");
    }

    @Override
    protected void exitScreen() {
        if (!Minecraft.m_91087_().f_91074_.m_20148_().equals(editedPlayerUUID)) {
            NetworkHelper.sendToServer(new RequestCloseEditedPlayerPacket(editedPlayerUUID));
        }
        this.f_96541_.f_91074_.m_6915_();
    }

    @Override
    protected void randomizeParty() {
        NetworkHelper.sendToServer(new RandomizePokemonPacket(editedPlayerUUID));
    }

    @Override
    protected void addPokemon(int partySlot) {
        NetworkHelper.sendToServer(new ChangePokemonPacket(UUID.randomUUID(), PixelmonSpecies.MAGIKARP.getValueUnsafe()));
    }

    @Override
    protected void editPokemon(int partySlot) {
        Pokemon pokemon = (Pokemon)this.pokemonList.get(partySlot);
        if (pokemon != null) {
            this.f_96541_.m_91152_((Screen)new PokemonEditorIndividualScreen(pokemon, this.m_96636_()));
        }
    }

    @Override
    public void m_88315_(GuiGraphics matrix, int i, int j, float f) {
        super.m_88315_(matrix, i, j, f);
        this.pokemonList = Lists.newArrayList(ServerStorageDisplay.editedPokemon);
    }

    @Override
    protected void updatePokemon(Pokemon pokemon) {
        NetworkHelper.sendToServer(new UpdatePlayerPokemonPacket(pokemon));
    }

    @Override
    protected void updatePokemon(Pokemon pokemon, int slot) {
        NetworkHelper.sendToServer(new UpdatePlayerPokemonPacket(pokemon, slot));
    }
}

