/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IndividualEditorBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTranslateableTextField;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.DeletePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdatePlayerPokemonPacket;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;

public class PokemonEditorIndividualScreen
extends IndividualEditorBaseScreen {
    private TabCompleteTranslateableTextField<PokeBall> pokeBallText;
    private EditBox cloneText;
    private EditBox lakeText;
    private EditBox smeltText;
    private ItemStack pokeBall;

    PokemonEditorIndividualScreen(Pokemon p, Component titleText) {
        super(p, titleText);
    }

    @Override
    public void m_7856_() {
        this.textFields.clear();
        this.cloneText = null;
        this.lakeText = null;
        this.smeltText = null;
        super.m_7856_();
        this.pokeBallText = new TabCompleteTranslateableTextField<PokeBall>(16, this.f_96541_.f_91062_, this.f_96543_ / 2 - 120, this.f_96544_ / 2 + 72, 90, 17).setCompletions(PokeBallRegistry.getAll());
        this.pokeBall = this.p.getBall().getBallItem();
        this.pokeBallText.setValue(this.p.getBall());
        this.pokeBallText.m_94151_(s -> {
            PokeBall ball = PokeBallRegistry.getPokeBall(s.toLowerCase(Locale.ROOT).replace(" ", "_").replace("\u00e9", "e")).orElse((Object)null);
            if (ball == null || this.pokeBallText.getTranslatableValue().is(ball)) {
                return;
            }
            this.pokeBallText.setValue(ball);
            this.updatePokeBall();
        });
        this.m_142416_((GuiEventListener)this.pokeBallText);
        int formOffset = 20;
        if (this.p.getSpecies().is(PixelmonSpecies.MEW)) {
            this.cloneText = this.createExtraTextField();
            this.cloneText.f_93621_ += formOffset;
            this.cloneText.m_94144_(Integer.toString(((MewStats)this.p.getExtraStats()).numCloned));
            this.m_142416_((GuiEventListener)this.cloneText);
        } else if (this.p.getSpecies().is(PixelmonSpecies.AZELF) || this.p.getSpecies().is(PixelmonSpecies.MESPRIT) || this.p.getSpecies().is(PixelmonSpecies.UXIE)) {
            this.lakeText = this.createExtraTextField();
            this.lakeText.f_93621_ += formOffset;
            this.lakeText.m_94144_(Integer.toString(((LakeTrioStats)this.p.getExtraStats()).numEnchanted));
            this.textFields.add(this.lakeText);
            this.m_142416_((GuiEventListener)this.lakeText);
        } else if (this.p.getSpecies().is(PixelmonSpecies.MELTAN)) {
            this.smeltText = this.createExtraTextField();
            this.smeltText.f_93621_ += formOffset;
            this.smeltText.m_94144_(Integer.toString(((MeltanStats)this.p.getExtraStats()).nuggetsFed));
            this.textFields.add(this.smeltText);
            this.m_142416_((GuiEventListener)this.smeltText);
        }
    }

    @Override
    public void setPokemon(Pokemon pokemon) {
        super.setPokemon(pokemon);
        if (!pokemon.getSpecies().is(PixelmonSpecies.MEW)) {
            this.cloneText = null;
        }
        if (!pokemon.getSpecies().is(PixelmonSpecies.MESPRIT, PixelmonSpecies.AZELF, PixelmonSpecies.UXIE)) {
            this.lakeText = null;
        }
        if (!pokemon.getSpecies().is(PixelmonSpecies.MELTAN)) {
            this.smeltText = null;
        }
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundUnderMenus(matrix, partialTicks, mouseX, mouseY);
        if (this.pokeBallText != null) {
            matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.pokemoneditor.pokeball", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f + 75.0f, 0, false);
            matrix.m_280480_(this.pokeBall, this.f_96543_ / 2 - 28, this.f_96544_ / 2 + 72);
        }
        this.drawExtraText(matrix, mouseX, mouseY, partialTicks, this.cloneText, "gui.pokemoneditor.clones");
        this.drawExtraText(matrix, mouseX, mouseY, partialTicks, this.lakeText, "gui.pokemoneditor.lake_enchants");
        this.drawExtraText(matrix, mouseX, mouseY, partialTicks, this.smeltText, "gui.pokemoneditor.smelts");
    }

    private void updatePokeBall() {
        this.pokeBall = this.pokeBallText.getTranslatableValue().getBallItem();
        this.p.setBall(this.pokeBallText.getTranslatableValue());
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        for (EditBox textField : new EditBox[]{this.pokeBallText, this.cloneText, this.lakeText}) {
            if (textField == null) continue;
            textField.m_6375_(x, y, mouseButton);
        }
        return super.mouseClickedUnderMenus(x, y, mouseButton);
    }

    @Override
    protected void changePokemon(Species newPokemon) {
        NetworkHelper.sendToServer(new ChangePokemonPacket(this.p.getUUID(), newPokemon));
    }

    @Override
    protected void deletePokemon() {
        NetworkHelper.sendToServer(new DeletePokemonPacket(this.p.getUUID()));
        this.f_96541_.m_91152_((Screen)new PokemonEditorPartyScreen());
    }

    @Override
    protected void saveAndClose() {
        NetworkHelper.sendToServer(new UpdatePlayerPokemonPacket(this.p));
        this.f_96541_.m_91152_((Screen)new PokemonEditorPartyScreen());
    }

    @Override
    public List<Pokemon> getPokemonList() {
        return ServerStorageDisplay.editedPokemon;
    }

    @Override
    protected boolean checkFields() {
        boolean valid = super.checkFields();
        if (this.cloneText != null) {
            try {
                int numClones = Integer.parseInt(this.cloneText.m_94155_());
                if (numClones < 0) {
                    this.cloneText.m_94144_("0");
                    valid = false;
                } else if (numClones > 3) {
                    this.cloneText.m_94144_(Integer.toString(3));
                    valid = false;
                } else {
                    ((MewStats)this.p.getExtraStats()).numCloned = numClones;
                }
            }
            catch (NumberFormatException e) {
                this.cloneText.m_94144_("");
                valid = false;
            }
        }
        if (this.lakeText != null) {
            try {
                int enchants = Integer.parseInt(this.lakeText.m_94155_());
                if (enchants < 0) {
                    this.lakeText.m_94144_("0");
                    valid = false;
                } else if (enchants > PixelmonConfigProxy.getGeneral().getLakeTrioMaxEnchants()) {
                    this.lakeText.m_94144_(Integer.toString(PixelmonConfigProxy.getGeneral().getLakeTrioMaxEnchants()));
                    valid = false;
                } else {
                    ((LakeTrioStats)this.p.getExtraStats()).numEnchanted = enchants;
                }
            }
            catch (NumberFormatException e) {
                this.lakeText.m_94144_("");
                valid = false;
            }
        }
        if (this.smeltText != null) {
            try {
                int smelts = Integer.parseInt(this.smeltText.m_94155_());
                if (smelts < 0) {
                    this.smeltText.m_94144_("0");
                    valid = false;
                } else {
                    ((MeltanStats)this.p.getExtraStats()).nuggetsFed = smelts;
                }
            }
            catch (NumberFormatException e) {
                this.smeltText.m_94144_("");
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public Pokemon[] getPokemon() {
        return new Pokemon[]{this.p};
    }

    @Override
    public void setPokemon(Pokemon ... pokemon) {
        if (pokemon.length < 1) {
            return;
        }
        Tuple<PokemonStorage, StoragePosition> storageAndPosition = this.p.getStorageAndPosition();
        this.p = pokemon[0];
        if (storageAndPosition == null || storageAndPosition.m_14418_() == null || storageAndPosition.m_14419_() == null) {
            return;
        }
        this.p.setStorage((PokemonStorage)storageAndPosition.m_14418_(), (StoragePosition)storageAndPosition.m_14419_());
        NetworkHelper.sendToServer(new UpdatePlayerPokemonPacket(this.p, ((StoragePosition)storageAndPosition.m_14419_()).order));
    }
}

