/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IndividualEditorBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PokemonEditorAdvancedScreen
extends DropDownScreen {
    private IndividualEditorBaseScreen previousScreen;
    private Pokemon data;
    private EditBox[] evText = new EditBox[6];
    private EditBox[] ivText = new EditBox[6];
    private BattleStatsType[] stats = new BattleStatsType[]{BattleStatsType.HP, BattleStatsType.ATTACK, BattleStatsType.DEFENSE, BattleStatsType.SPECIAL_ATTACK, BattleStatsType.SPECIAL_DEFENSE, BattleStatsType.SPEED};
    private EditBox heldText;
    private ItemStack heldItem = ItemStack.f_41583_;
    private EditBox natureText;
    private EditBox friendshipText;
    private DropDown<String> abilityDropDown;
    private EditBox[] allText;
    private static final int BUTTON_OKAY = 1;
    private static final int BUTTON_MAX_IVS = 3;
    private static final int BUTTON_MIN_IVS = 4;
    private static final int BUTTON_RANDOM_IVS = 5;
    private static final int BUTTON_RESET_EVS = 6;

    public PokemonEditorAdvancedScreen(IndividualEditorBaseScreen previousScreen) {
        super((Component)Component.m_237119_());
        this.previousScreen = previousScreen;
        this.data = this.previousScreen.p;
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        return this.m_7222_() != null && this.m_7222_().m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    @Override
    public void m_7856_() {
        if (this.abilityDropDown != null) {
            this.checkFields();
        }
        super.m_7856_();
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 30, 20, (Component)Component.m_237115_((String)"gui.guiItemDrops.ok"), this::actionPerformed));
        Ability[] allAbilities = this.data.getForm().getAbilities().getAll();
        List<String> abilityList = Arrays.stream(allAbilities).filter(Objects::nonNull).map(Ability::getName).collect(Collectors.toList());
        int abilityWidth = this.getLongestString(abilityList);
        this.abilityDropDown = new DropDown<String>(abilityList, this.data.getAbilityName(), this.f_96543_ / 2 - 130, this.f_96544_ / 2 - 40, 80, 50, Math.max(80, abilityWidth)).setGetOptionString(ability -> I18n.m_118938_((String)("ability." + ability), (Object[])new Object[0]));
        this.addDropDown(this.abilityDropDown);
        this.m_142416_((GuiEventListener)new IndexedButton(3, this.f_96543_ / 2 + 125, this.f_96544_ / 2 - 50, 60, 20, (Component)Component.m_237115_((String)"gui.trainereditor.maxivs"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(4, this.f_96543_ / 2 + 125, this.f_96544_ / 2 - 25, 60, 20, (Component)Component.m_237115_((String)"gui.trainereditor.minivs"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(5, this.f_96543_ / 2 + 125, this.f_96544_ / 2, 60, 20, (Component)Component.m_237115_((String)"gui.trainereditor.randomivs"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(6, this.f_96543_ / 2 + 125, this.f_96544_ / 2 + 35, 60, 20, (Component)Component.m_237115_((String)"gui.trainereditor.resetevs"), this::actionPerformed));
        this.allText = new EditBox[15];
        for (int i = 0; i < this.stats.length; ++i) {
            this.evText[i] = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 + 45, this.f_96544_ / 2 - 55 + i * 25, 30, 20, (Component)Component.m_237119_());
            this.evText[i].m_94144_(String.valueOf(this.data.getEVs().getArray()[i]));
            this.ivText[i] = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 + 85, this.f_96544_ / 2 - 55 + i * 25, 30, 20, (Component)Component.m_237119_());
            this.ivText[i].m_94144_(String.valueOf(this.data.getIVs().getArray()[i]));
            this.m_142416_((GuiEventListener)this.evText[i]);
            this.m_142416_((GuiEventListener)this.ivText[i]);
            this.allText[i] = this.evText[i];
            this.allText[i + this.evText.length] = this.ivText[i];
        }
        this.heldText = new TabCompleteTextField(13, this.f_96541_.f_91062_, this.f_96543_ / 2 - 130, this.f_96544_ / 2 - 4, 80, 20).setCompletions(ItemRegistration.getAllItems().stream().filter(item -> item instanceof HeldItem).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toSet()));
        this.m_142416_((GuiEventListener)this.heldText);
        if (!this.data.getHeldItem().m_41619_()) {
            this.heldText.m_94144_(ForgeRegistries.ITEMS.getKey((Object)this.data.getHeldItem().m_41720_()).toString());
            this.updateHeldItem();
        }
        this.natureText = new TabCompleteTextField(14, this.f_96541_.f_91062_, this.f_96543_ / 2 - 130, this.f_96544_ / 2 + 34, 80, 20).setCompletions(Arrays.stream(Nature.values()).map(ITranslatable::getLocalizedName).collect(Collectors.toSet()));
        this.natureText.m_94144_(this.data.getBaseNature().getLocalizedName());
        this.m_142416_((GuiEventListener)this.natureText);
        this.friendshipText = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 130, this.f_96544_ / 2 + 70, 80, 20, (Component)Component.m_237119_());
        this.friendshipText.m_94144_(String.valueOf(this.data.getFriendship()));
        this.m_142416_((GuiEventListener)this.friendshipText);
        this.allText[12] = this.heldText;
        this.allText[13] = this.natureText;
        this.allText[14] = this.friendshipText;
    }

    private int getLongestString(List<String> items) {
        return ScreenHelper.getLongestStringWidth(items.stream().map(s -> I18n.m_118938_((String)("ability." + s), (Object[])new Object[0])).collect(Collectors.toList())) + 2;
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.f_96543_ / 2.0f - 200.0f, (float)this.f_96544_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        ScreenHelper.drawCenteredString(matrix, this.previousScreen.titleText, (float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f - 90.0f, 0, false);
        for (int i = 0; i < this.stats.length; ++i) {
            ScreenHelper.drawStringRightAligned(matrix, this.stats[i].getLocalizedName(), (float)this.f_96543_ / 2.0f + 40.0f, (float)this.f_96544_ / 2.0f - 50.0f + (float)(i * 25), 0, false);
        }
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.evs", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f + 50.0f, (float)this.f_96544_ / 2.0f - 70.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.ivs", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f + 90.0f, (float)this.f_96544_ / 2.0f - 70.0f, 0, false);
        ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)"gui.screenpokechecker.ability", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 90.0f, (float)(this.abilityDropDown.getTop() - 10), 0, false);
        ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)"gui.trainereditor.helditem", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 90.0f, (float)(this.heldText.f_93621_ - 10), 0, false);
        ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)"gui.screenpokechecker.nature", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 90.0f, (float)(this.natureText.f_93621_ - 10), 0, false);
        ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)"gui.screenpokechecker.happiness", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 90.0f, (float)(this.friendshipText.f_93621_ - 10), 0, false);
        if (!this.heldItem.m_41619_()) {
            matrix.m_280480_(this.heldItem, this.f_96543_ / 2 - 150, this.heldText.f_93621_);
        }
        ScreenHelper.drawImageQuad(this.data.getSprite(), matrix, (float)this.f_96543_ / 2.0f - 157.0f, (float)this.f_96544_ / 2.0f - 73.0f, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean m_5534_(char key, int keyCode) {
        if (this.heldText.m_93696_()) {
            this.updateHeldItem();
        }
        if (keyCode == 256 || keyCode == 257) {
            this.saveFields();
        }
        return super.m_5534_(key, keyCode);
    }

    @Override
    public boolean mouseClickedUnderMenus(double mouseX, double mouseY, int clickedButton) {
        for (EditBox textField : this.allText) {
            textField.m_6375_(mouseX, mouseY, clickedButton);
        }
        return super.mouseClickedUnderMenus(mouseX, mouseY, clickedButton);
    }

    protected void actionPerformed(Button button) {
        block4: {
            int id;
            block8: {
                block7: {
                    block6: {
                        block5: {
                            if (!(button instanceof IndexedButton)) break block4;
                            id = ((IndexedButton)button).id;
                            if (id != 1) break block5;
                            this.saveFields();
                            Minecraft.m_91087_().m_91152_((Screen)this.previousScreen);
                            break block4;
                        }
                        if (id != 3) break block6;
                        for (EditBox iv : this.ivText) {
                            iv.m_94144_("31");
                        }
                        break block4;
                    }
                    if (id != 4) break block7;
                    for (EditBox iv : this.ivText) {
                        iv.m_94144_("0");
                    }
                    break block4;
                }
                if (id != 5) break block8;
                for (EditBox iv : this.ivText) {
                    iv.m_94144_(String.valueOf(RandomHelper.getRandomNumberBetween(0, 31)));
                }
                break block4;
            }
            if (id != 6) break block4;
            for (EditBox ev : this.evText) {
                ev.m_94144_("0");
            }
        }
    }

    private void saveFields() {
        if (this.checkFields()) {
            this.f_96541_.m_91152_((Screen)this.previousScreen);
        }
    }

    private void updateHeldItem() {
        try {
            Item newItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(this.heldText.m_94155_()));
            if (newItem instanceof HeldItem) {
                this.heldItem = new ItemStack((ItemLike)newItem);
            } else if (!"en_us".equals(Minecraft.m_91087_().m_91102_().m_264236_())) {
                for (Item item : ItemRegistration.getAllItems()) {
                    if (!(item instanceof HeldItem) || !new ItemStack((ItemLike)item).m_41786_().getString().equalsIgnoreCase(this.heldText.m_94155_())) continue;
                    this.heldItem = new ItemStack((ItemLike)item);
                    return;
                }
                this.heldItem = ItemStack.f_41583_;
            } else {
                this.heldItem = ItemStack.f_41583_;
            }
        }
        catch (Exception e) {
            Pixelmon.LOGGER.warn("Failed to update held item!");
            e.printStackTrace();
        }
    }

    private boolean checkFields() {
        boolean isValid = true;
        for (EditBox iv : this.ivText) {
            try {
                int ivNumber = Integer.parseInt(iv.m_94155_());
                if (ivNumber < 0) {
                    isValid = false;
                    iv.m_94144_("0");
                    continue;
                }
                if (ivNumber <= 31) continue;
                isValid = false;
                iv.m_94144_("31");
            }
            catch (NumberFormatException e) {
                isValid = false;
                iv.m_94144_("0");
            }
        }
        int evTotal = 0;
        for (EditBox ev : this.evText) {
            int evNumber;
            try {
                evNumber = Integer.parseInt(ev.m_94155_());
                if (evNumber < 0) {
                    isValid = false;
                    ev.m_94144_("0");
                    evNumber = 0;
                } else if (evNumber > 252) {
                    isValid = false;
                    ev.m_94144_("252");
                    evNumber = 252;
                }
            }
            catch (NumberFormatException e) {
                isValid = false;
                ev.m_94144_("0");
                evNumber = 0;
            }
            if ((evTotal += evNumber) <= 510) continue;
            isValid = false;
            ev.m_94144_(String.valueOf(evNumber - (evTotal - 510)));
            evTotal = 510;
        }
        Nature newNature = Nature.natureFromString(this.natureText.m_94155_());
        if (newNature == null) {
            isValid = false;
            this.natureText.m_94144_(this.data.getBaseNature().getLocalizedName());
        }
        this.updateHeldItem();
        if (this.heldItem.m_41619_() && !this.heldText.m_94155_().equals("")) {
            this.heldText.m_94144_("");
            isValid = false;
        }
        int newFriendship = this.data.getFriendship();
        try {
            newFriendship = Integer.parseInt(this.friendshipText.m_94155_());
            if (newFriendship > 255) {
                this.friendshipText.m_94144_(String.valueOf(255));
                isValid = false;
            } else if (newFriendship < 0) {
                this.friendshipText.m_94144_("0");
                isValid = false;
            }
        }
        catch (NumberFormatException iv) {
            // empty catch block
        }
        if (isValid) {
            try {
                for (int i = 0; i < this.stats.length; ++i) {
                    this.data.getEVs().setStat(this.stats[i], Integer.parseInt(this.evText[i].m_94155_()));
                    this.data.getIVs().setStat(this.stats[i], Integer.parseInt(this.ivText[i].m_94155_()));
                }
                this.data.setNature(newNature);
                this.data.setHeldItem(this.heldItem);
                this.data.setAbility(AbilityRegistry.getAbility(this.abilityDropDown.getSelected()));
                this.data.setFriendship(newFriendship);
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
        }
        return isValid;
    }
}

