/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.export.PokemonConverterFactory;
import com.pixelmonmod.pixelmon.api.util.helpers.CursorHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IImportableContainer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportExportScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IndividualEditorBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class PartyEditorBaseScreen
extends Screen
implements IImportableContainer {
    private static final int BUTTON_OKAY = 1;
    private static final int BUTTON_RANDOM = 10;
    private static final int BUTTON_IMPORT_EXPORT = 11;
    private int draggedSlot = -1;
    private long cursor = CursorHelper.DEFAULT_CURSOR.get();
    public List<Pokemon> pokemonList;
    private List<Button> pokemonButtons = new ArrayList<Button>();

    protected PartyEditorBaseScreen(List<Pokemon> pokemonList) {
        super((Component)Component.m_237119_());
        this.pokemonList = pokemonList;
    }

    public void m_7856_() {
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 30, 20, (Component)Component.m_237115_((String)"gui.guiItemDrops.ok"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(10, this.f_96543_ / 2 - 160, this.f_96544_ / 2 + 90, 100, 20, (Component)Component.m_237115_((String)"gui.trainereditor.randomise"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(11, this.f_96543_ / 2 + 20, this.f_96544_ / 2 + 90, 100, 20, (Component)Component.m_237115_((String)"gui.pokemoneditor.importexport"), this::actionPerformed));
        super.m_7856_();
        for (int i = 0; i < 6; ++i) {
            IndexedButton pokeButton = new IndexedButton(i + 2, this.f_96543_ / 2 + 40, this.f_96544_ / 2 - 50 + i * 20, 80, 20, (Component)Component.m_237115_((String)"gui.trainereditor.edit"), this::actionPerformed);
            this.m_142416_((GuiEventListener)pokeButton);
            this.pokemonButtons.add(pokeButton);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.countPokemon() > 1) {
            for (int k = 0; k < this.pokemonList.size(); ++k) {
                Pokemon p = this.pokemonList.get(k);
                if (p == null) continue;
                float x = (float)this.f_96543_ / 2.0f - 157.0f;
                float y = (float)this.f_96544_ / 2.0f - 53.0f + (float)(k * 20);
                if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 180.0f)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 20.0f))) continue;
                this.draggedSlot = k;
                break;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggedSlot != -1 && this.countPokemon() > 1) {
            Pokemon dragged = this.pokemonList.get(this.draggedSlot);
            if (dragged != null) {
                for (int k = 0; k < this.pokemonList.size(); ++k) {
                    Pokemon p;
                    if (k == this.draggedSlot || (p = this.pokemonList.get(k)) == null) continue;
                    float x = (float)this.f_96543_ / 2.0f - 157.0f;
                    float y = (float)this.f_96544_ / 2.0f - 53.0f + (float)(k * 20);
                    if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 180.0f)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 20.0f))) continue;
                    this.pokemonList.set(k, dragged);
                    this.updatePokemon(dragged, k);
                    this.pokemonList.set(this.draggedSlot, p);
                    this.updatePokemon(p, this.draggedSlot);
                    break;
                }
            }
            this.draggedSlot = -1;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.f_96543_ / 2.0f - 200.0f, (float)this.f_96544_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        String title = this.m_96636_().getString();
        matrix.drawString(this.f_96547_, title, (float)this.f_96543_ / 2.0f - (float)this.f_96541_.f_91062_.m_92895_(title) / 2.0f, (float)this.f_96544_ / 2.0f - 90.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 130.0f, (float)this.f_96544_ / 2.0f - 65.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.lvl", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 40.0f, (float)this.f_96544_ / 2.0f - 65.0f, 0, false);
        for (int k = 0; k < 6; ++k) {
            if (k % 2 != 1) continue;
            matrix.m_280509_(this.f_96543_ / 2 - 160, this.f_96544_ / 2 - 50 + k * 20, this.f_96543_ / 2 + 40, this.f_96544_ / 2 - 30 + k * 20, -1777215);
        }
        Supplier<Long> cursor = CursorHelper.DEFAULT_CURSOR;
        ResourceLocation drawLast = null;
        for (int k = 0; k < this.pokemonList.size(); ++k) {
            Pokemon p = this.pokemonList.get(k);
            if (p == null) continue;
            matrix.drawString(this.f_96547_, p.getDisplayName(), (float)this.f_96543_ / 2.0f - 130.0f, (float)this.f_96544_ / 2.0f - 44.0f + (float)(k * 20), 0, false);
            matrix.drawString(this.f_96547_, String.valueOf(p.getPokemonLevel()), (float)this.f_96543_ / 2.0f - 40.0f, (float)this.f_96544_ / 2.0f - 44.0f + (float)(k * 20), 0, false);
            float x = (float)this.f_96543_ / 2.0f - 157.0f;
            float y = (float)this.f_96544_ / 2.0f - 53.0f + (float)(k * 20);
            float alpha = 1.0f;
            if (this.draggedSlot == k) {
                alpha = 0.5f;
                drawLast = p.getSprite();
                cursor = CursorHelper.HAND_CURSOR;
            } else if (this.countPokemon() > 1 && this.draggedSlot == -1 && (float)mouseX > x && (float)mouseX < x + 180.0f && (float)mouseY > y && (float)mouseY < y + 20.0f) {
                cursor = CursorHelper.HAND_CURSOR;
            }
            ScreenHelper.drawImageQuad(p.getSprite(), matrix, x, y, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, alpha, 1.0f);
        }
        CursorHelper.setCursor(cursor);
        for (int z = 0; z < 6; ++z) {
            Button pokemonButton = this.pokemonButtons.get(z);
            if (z < this.pokemonList.size() && this.pokemonList.get(z) != null) {
                pokemonButton.m_93666_((Component)Component.m_237115_((String)"gui.trainereditor.edit"));
                continue;
            }
            pokemonButton.m_93666_((Component)Component.m_237115_((String)"gui.trainereditor.add"));
        }
        super.m_88315_(matrix, mouseX, mouseY, partialTicks);
        if (drawLast != null) {
            ScreenHelper.drawImageQuad(drawLast, matrix, mouseX, mouseY, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void m_280273_(GuiGraphics p_283688_, int p_299421_, int p_298679_, float p_297268_) {
    }

    public abstract Component m_96636_();

    public boolean m_5534_(char key, int par2) {
        if (par2 == 256 || par2 == 257) {
            this.exitScreen();
        }
        return super.m_5534_(key, par2);
    }

    protected void actionPerformed(Button button) {
        if (button.f_93623_ && button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 1) {
                this.exitScreen();
            } else if (id == 10) {
                this.randomizeParty();
            } else if (id >= 2 && id < 8) {
                int partySlot = id - 2;
                if (this.pokemonButtons.get(partySlot).m_6035_().getString().equalsIgnoreCase(I18n.m_118938_((String)"gui.trainereditor.add", (Object[])new Object[0]))) {
                    this.addPokemon(partySlot);
                } else {
                    this.editPokemon(partySlot);
                }
            } else if (id == 11) {
                this.f_96541_.m_91152_((Screen)new ImportExportScreen(this, this.m_96636_().getString()));
            }
        }
    }

    protected abstract void exitScreen();

    protected abstract void randomizeParty();

    protected abstract void addPokemon(int var1);

    protected abstract void editPokemon(int var1);

    public static void editPokemonPacket(int partySlot) {
        IndividualEditorBaseScreen individualEditor;
        Pokemon currentPokemon;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof PartyEditorBaseScreen) {
            PartyEditorBaseScreen partyEditor = (PartyEditorBaseScreen)mc.f_91080_;
            partyEditor.editPokemon(partySlot);
        } else if (mc.f_91080_ instanceof IndividualEditorBaseScreen && (currentPokemon = (individualEditor = (IndividualEditorBaseScreen)mc.f_91080_).getPokemonList().get(partySlot)) != null) {
            individualEditor.p = currentPokemon;
            individualEditor.m_7856_();
        }
    }

    @Override
    public String getExportText() {
        StringBuilder exportText = new StringBuilder();
        for (int i = 0; i < this.pokemonList.size(); ++i) {
            Pokemon data = this.pokemonList.get(i);
            if (data == null) continue;
            if (i > 0) {
                exportText.append('\n').append(" ").append('\n');
            }
            exportText.append(PokemonConverterFactory.getExportText(data));
        }
        return exportText.toString();
    }

    @Override
    public void setPokemon(Pokemon ... pokemon) {
        for (int i = 0; i < pokemon.length; ++i) {
            if (i >= this.pokemonList.size()) {
                this.pokemonList.add(pokemon[i]);
            } else {
                this.pokemonList.set(i, pokemon[i]);
            }
            this.updatePokemon(pokemon[i], i);
        }
    }

    @Override
    public Pokemon[] getPokemon() {
        return this.pokemonList.toArray(new Pokemon[0]);
    }

    @Override
    public String importText(String importText) {
        return null;
    }

    protected abstract void updatePokemon(Pokemon var1);

    protected abstract void updatePokemon(Pokemon var1, int var2);

    @Override
    public Screen getScreen() {
        return this;
    }

    public boolean m_7043_() {
        return false;
    }

    private int countPokemon() {
        int count = 0;
        for (Pokemon pokemon : this.pokemonList) {
            if (pokemon == null) continue;
            ++count;
        }
        return count;
    }

    public void m_7379_() {
        CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
        super.m_7379_();
    }
}

