/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.export.PokemonConverterFactory;
import com.pixelmonmod.pixelmon.api.pokemon.export.exception.PokemonImportException;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IImportableContainer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportExportScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorAdvancedScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTranslateableTextField;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public abstract class IndividualEditorBaseScreen
extends DropDownScreen
implements IImportableContainer {
    protected Pokemon p;
    protected String titleText;
    private TabCompleteTranslateableTextField<Species> tbName;
    private EditBox tbNickname;
    private EditBox tbLvl;
    private DropDown<Stats> formDropdown;
    private DropDown<PaletteProperties> paletteDropdown;
    private IndexedButton genderButton;
    private TabCompleteTextField[] tbMoves = new TabCompleteTextField[4];
    private Attack[] attacks = new Attack[4];
    private static final int BUTTON_OKAY = 1;
    private static final int BUTTON_GENDER = 3;
    private static final int BUTTON_CHANGE = 4;
    private static final int BUTTON_ADVANCED = 6;
    private static final int BUTTON_DELETE = 14;
    private static final int BUTTON_IMPORT_EXPORT = 15;
    protected List<EditBox> textFields = Lists.newArrayList();

    public IndividualEditorBaseScreen(Pokemon p, Component titleText) {
        super(titleText);
        this.p = p;
        this.titleText = titleText.getString();
    }

    @Override
    public void m_7856_() {
        int i;
        this.m_169413_();
        super.m_7856_();
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 30, 20, (Component)Component.m_237115_((String)"gui.guiItemDrops.ok"), this::actionPerformed));
        ArrayList shinyOptions = Lists.newArrayList((Object[])this.p.getForm().getGenderProperties(this.p.getGender()).getPalettes());
        Species species = this.p.getSpecies();
        PaletteProperties currentType = this.p.getPalette();
        shinyOptions.removeIf(paletteProperties -> paletteProperties.getName().equals("online") && !PlayerExtraDataStore.get((Player)this.f_96541_.f_91074_).canSeeTexture(species));
        this.paletteDropdown = this.addDropDown(new DropDown<PaletteProperties>(shinyOptions, currentType, this.f_96543_ / 2 - 120, this.f_96544_ / 2 + 14, 80, 80).setOnSelected(this::setTextureType).setGetOptionString(PaletteProperties::getName));
        this.genderButton = new IndexedButton(3, this.f_96543_ / 2 - 120, this.f_96544_ / 2 + 30, 80, 20, I18n.m_118938_((String)this.p.getGender().getTranslationKey(), (Object[])new Object[0]), this::actionPerformed);
        this.m_142416_((GuiEventListener)this.genderButton);
        this.addDropDown(new DropDown<EnumGrowth>(EnumGrowth.orderedList, this.p.getGrowth(), this.f_96543_ / 2 - 120, this.f_96544_ / 2 + 28, 80, 100).setOnSelected(growth -> this.p.setGrowth((EnumGrowth)growth)).setGetOptionString(ITranslatable::getLocalizedName).setInactiveTop(this.f_96544_ / 2 + 54));
        List<Stats> forms = species.getForms(true);
        int formWidth = this.getLongestString(forms);
        this.formDropdown = this.addDropDown(new DropDown<Stats>(forms, this.p.getForm(), this.f_96543_ / 2 - 120, this.f_96544_ / 2 + 92 + Math.max(-16, Math.min(6, forms.size()) - 1) * -10, 80, 80, Math.max(80, formWidth)).setOnSelected(enumForm -> this.p.setForm((Stats)enumForm)).setGetOptionString(ITranslatable::getLocalizedName).setInactiveTop(this.f_96544_ / 2 + 94));
        if (forms.size() < 2) {
            this.formDropdown.setVisible(false);
        }
        this.tbName = new TabCompleteTranslateableTextField<Species>(6, this.f_96541_.f_91062_, this.f_96543_ / 2 - 120, this.f_96544_ / 2 - 50, 90, 17).setCompletions(PixelmonSpecies.getAll());
        this.tbName.setValue(this.p.getSpecies());
        this.tbName.m_94151_(s -> {
            if (!PixelmonSpecies.get(s.replace("\u00e9", "e")).isPresent()) {
                return;
            }
            Species newSpecies = PixelmonSpecies.get(s.replace("\u00e9", "e")).get().getValueUnsafe();
            if (newSpecies == null || this.tbName.getTranslatableValue().is(newSpecies)) {
                return;
            }
            this.tbName.setValue(newSpecies);
            this.changePokemon(this.tbName.getTranslatableValue());
        });
        this.m_142416_((GuiEventListener)this.tbName);
        this.tbLvl = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 120, this.f_96544_ / 2 - 30, 60, 17, (Component)Component.m_237119_());
        this.tbLvl.m_94144_("" + this.p.getPokemonLevel());
        this.tbLvl.m_94151_(s -> {
            try {
                int lvl = Integer.parseInt(this.tbLvl.m_94155_());
                if (lvl > 0 && lvl <= PixelmonServerConfig.maxLevel) {
                    this.p.setLevel(lvl);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.m_142416_((GuiEventListener)this.tbLvl);
        this.tbNickname = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 120, this.f_96544_ / 2 - 10, 90, 17, (Component)Component.m_237119_());
        this.tbNickname.m_94199_(16);
        this.tbNickname.m_94144_(this.p.getNickname() == null ? "" : this.p.getNickname());
        this.m_142416_((GuiEventListener)this.tbNickname);
        this.m_142416_((GuiEventListener)new IndexedButton(4, this.f_96543_ / 2 - 20, this.f_96544_ / 2 - 52, 100, 20, (Component)Component.m_237115_((String)"gui.trainereditor.randomize"), this::actionPerformed));
        for (i = 0; i < this.tbMoves.length; ++i) {
            this.tbMoves[i] = new TabCompleteTextField(9 + i, this.f_96541_.f_91062_, this.f_96543_ / 2 + 60, this.f_96544_ / 2 + 20 * i, 120, 17).setCompletions(AttackRegistry.getAllAttacks().stream().map(ITranslatable::getLocalizedName).collect(Collectors.toSet()));
            this.m_142416_((GuiEventListener)this.tbMoves[i]);
        }
        for (i = 0; i < this.p.getMoveset().size(); ++i) {
            this.attacks[i] = this.p.getMoveset().get(i);
            this.tbMoves[i].m_94144_(this.attacks[i].getMove().getLocalizedName());
        }
        this.m_142416_((GuiEventListener)new IndexedButton(6, this.f_96543_ / 2 + 105, this.f_96544_ / 2 - 110, 80, 20, (Component)Component.m_237115_((String)"gui.trainereditor.advanced"), this::actionPerformed));
        this.textFields.clear();
        this.textFields.addAll(Arrays.asList(new EditBox[]{this.tbName, this.tbLvl, this.tbNickname, this.tbMoves[0], this.tbMoves[1], this.tbMoves[2], this.tbMoves[3]}));
        if (this.showDeleteButton()) {
            this.m_142416_((GuiEventListener)new IndexedButton(14, this.f_96543_ / 2 - 185, this.f_96544_ / 2 - 110, 90, 20, (Component)Component.m_237115_((String)"gui.trainereditor.deletepoke"), this::actionPerformed));
        }
        this.m_142416_((GuiEventListener)new IndexedButton(15, this.f_96543_ / 2 + 20, this.f_96544_ / 2 + 90, 100, 20, (Component)Component.m_237115_((String)"gui.pokemoneditor.importexport"), this::actionPerformed));
    }

    public Pokemon getPokemonSingle() {
        return this.p;
    }

    public void setPokemon(Pokemon pokemon) {
        this.p = pokemon;
        for (int i = 0; i < this.tbMoves.length; ++i) {
            TabCompleteTextField tbMove = this.tbMoves[i];
            Attack move = this.p.getMoveset().get(i);
            if (move != null) {
                tbMove.m_94144_(move.getActualMove().getLocalizedName());
                continue;
            }
            tbMove.m_94144_("");
        }
        this.tbLvl.m_94144_("" + this.p.getPokemonLevel());
        ArrayList shinyOptions = Lists.newArrayList((Object[])this.p.getForm().getGenderProperties(this.p.getGender()).getPalettes());
        shinyOptions.removeIf(paletteProperties -> paletteProperties.getName().equals("online") && !PlayerExtraDataStore.get((Player)this.f_96541_.f_91074_).canSeeTexture(pokemon.getSpecies()));
        this.paletteDropdown.setOptions((List<PaletteProperties>)shinyOptions, pokemon.getPalette());
        this.formDropdown.setOptions(pokemon.getSpecies().getForms(true), pokemon.getForm());
        this.formDropdown.setVisible(pokemon.getSpecies().getForms(true).size() >= 2);
        this.genderButton.m_93666_((Component)Component.m_237115_((String)this.p.getGender().getTranslationKey()));
    }

    private int getLongestString(List<? extends ITranslatable> items) {
        return ScreenHelper.getLongestStringWidth(items.stream().filter(Objects::nonNull).map(ITranslatable::getLocalizedName).collect(Collectors.toList())) + 2;
    }

    protected EditBox createExtraTextField() {
        return new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 120, this.f_96544_ / 2 + 72, 60, 17, (Component)Component.m_237119_());
    }

    private void setTextureType(PaletteProperties textureType) {
        this.p.setPalette(textureType);
    }

    protected boolean showDeleteButton() {
        return true;
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.tbName == null) {
            this.m_7856_();
        }
        Font font = Minecraft.m_91087_().f_91062_;
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.f_96543_ / 2.0f - 200.0f, (float)this.f_96544_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        matrix.drawString(font, this.titleText, (float)this.f_96543_ / 2.0f - (float)this.f_96541_.f_91062_.m_92895_(this.titleText) / 2.0f, (float)this.f_96544_ / 2.0f - 90.0f, 0, false);
        matrix.drawString(font, I18n.m_118938_((String)"gui.trainereditor", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f - 45.0f, 0, false);
        matrix.drawString(font, I18n.m_118938_((String)"gui.trainereditor.lvl", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f - 25.0f, 0, false);
        matrix.drawString(font, I18n.m_118938_((String)"gui.trainereditor.nickname", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f - 5.0f, 0, false);
        matrix.drawString(font, I18n.m_118938_((String)"gui.trainereditor.palettes", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f + 15.0f, 0, false);
        matrix.drawString(font, I18n.m_118938_((String)"gui.trainereditor.gender", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f + 35.0f, 0, false);
        matrix.drawString(font, I18n.m_118938_((String)"gui.trainereditor.growth", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f + 55.0f, 0, false);
        if (this.p.getSpecies().getForms(true).size() >= 2) {
            matrix.drawString(font, I18n.m_118938_((String)"gui.trainereditor.form", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f + 95.0f, 0, false);
        }
        ScreenHelper.drawImageQuad(this.p.getSprite(), matrix, (float)this.f_96543_ / 2.0f - 157.0f, (float)this.f_96544_ / 2.0f - 73.0f, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.drawString(font, I18n.m_118938_((String)"gui.screenpokechecker.moves", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f + 100.0f, (float)this.f_96544_ / 2.0f - 15.0f, 0, false);
        if (this.p.getForm().getGigantamax().canHaveFactor()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            float color = this.p.hasGigantamaxFactor() ? 1.0f : 0.3f;
            ScreenHelper.drawImageQuad(Resources.gmaxFactor, matrix, (float)this.f_96543_ / 2.0f - 28.0f, (float)this.f_96544_ / 2.0f + 92.0f, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, color, color, color, 1.0f, 1.0f);
        }
    }

    protected void drawExtraText(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks, EditBox textField, String langKey) {
        if (textField != null) {
            matrix.drawString(this.f_96547_, I18n.m_118938_((String)langKey, (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)(textField.f_93621_ + 3), 0, false);
        }
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        return this.m_7222_() != null && this.m_7222_().m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public boolean m_5534_(char key, int keyCode) {
        boolean b = super.m_5534_(key, keyCode);
        this.p.setNickname(this.tbNickname.m_94155_());
        if (keyCode == 256 || keyCode == 257) {
            this.saveFields();
        }
        return b;
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int button) {
        this.tbLvl.m_6375_(x, y, button);
        this.tbNickname.m_6375_(x, y, button);
        this.tbName.m_6375_(x, y, button);
        for (TabCompleteTextField tbMove : this.tbMoves) {
            tbMove.m_6375_(x, y, button);
        }
        if (this.p.getForm().getGigantamax().canHaveFactor()) {
            boolean flagA;
            int gX = this.f_96543_ / 2 - 28;
            int gY = this.f_96544_ / 2 + 92;
            boolean bl = flagA = x >= (double)gX && x < (double)(gX + 16) && y >= (double)gY && y < (double)(gY + 16);
            if (flagA) {
                this.p.setGigantamaxFactor(!this.p.hasGigantamaxFactor());
            }
        }
        return super.mouseClickedUnderMenus(x, y, button);
    }

    protected void actionPerformed(Button button) {
        if (button.f_93623_ && button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 1) {
                if (!this.saveFields()) {
                    this.m_7379_();
                }
            } else if (id == 4) {
                this.changePokemon(this.p.getSpecies());
            } else if (id == 3) {
                if (this.p.getGender() == Gender.NONE) {
                    return;
                }
                if (this.p.getGender() == Gender.MALE) {
                    this.p.setGender(Gender.FEMALE);
                } else {
                    this.p.setGender(Gender.MALE);
                }
                button.m_93666_((Component)(this.p.getGender() == Gender.MALE ? Component.m_237115_((String)"gui.trainereditor.male") : Component.m_237115_((String)"gui.trainereditor.female")));
            } else if (id == 6) {
                if (this.checkFields()) {
                    this.f_96541_.m_91152_((Screen)new PokemonEditorAdvancedScreen(this));
                }
            } else if (id == 14) {
                this.deletePokemon();
            } else if (id == 15 && this.checkFields()) {
                this.f_96541_.m_91152_((Screen)new ImportExportScreen(this, this.titleText));
            }
        }
    }

    protected abstract void changePokemon(Species var1);

    protected abstract void deletePokemon();

    private boolean saveFields() {
        if (this.checkFields()) {
            this.saveAndClose();
            return true;
        }
        return false;
    }

    protected abstract void saveAndClose();

    protected boolean checkFields() {
        int i;
        int numMoves = 0;
        HashMap<Integer, String> newMoves = new HashMap<Integer, String>();
        HashMap<Integer, Attack> oldMoves = new HashMap<Integer, Attack>();
        boolean invalid = false;
        for (i = 0; i < 4; ++i) {
            TabCompleteTextField tbMove = this.tbMoves[i];
            String moveText = tbMove.m_94155_();
            if (moveText.isEmpty()) continue;
            if (Attack.hasAttack(moveText)) {
                if (this.p.getMoveset().get(i) == null || !this.p.getMoveset().get(i).getMove().getAttackName().equals(moveText)) {
                    newMoves.put(i, moveText);
                    continue;
                }
                oldMoves.put(i, this.p.getMoveset().get(i));
                continue;
            }
            tbMove.m_94144_("");
            invalid = true;
        }
        this.p.getMoveset().clear();
        for (i = 0; i < 4; ++i) {
            if (newMoves.containsKey(i)) {
                this.p.getMoveset().add(new Attack((String)newMoves.get(i)));
                continue;
            }
            if (!oldMoves.containsKey(i)) continue;
            this.p.getMoveset().add((Attack)oldMoves.get(i));
        }
        if (invalid) {
            return false;
        }
        for (i = 0; i < 4; ++i) {
            if (this.p.getMoveset().get(i) == null) continue;
            ++numMoves;
        }
        return numMoves != 0;
    }

    public int getNextAvailablePosition() {
        int size = this.p.getMoveset().size();
        if (size == 4) {
            return -1;
        }
        return size;
    }

    public abstract List<Pokemon> getPokemonList();

    @Override
    public String getExportText() {
        return PokemonConverterFactory.getExportText(this.p);
    }

    @Override
    public String importText(String importText) {
        try {
            Pokemon importedPokemon = PokemonConverterFactory.importText(importText);
            if (importedPokemon != null) {
                importedPokemon.setUUID(this.p.getUUID());
                this.p = importedPokemon;
                return null;
            }
            return "Error";
        }
        catch (PokemonImportException e) {
            return e.getReason() + e.getFailedValue();
        }
    }

    @Override
    public Screen getScreen() {
        return this;
    }
}

