/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IImportableContainer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ImportRequestHandler;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.ReadPokePasteScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.editor.ExportRequestPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.editor.ImportRequestPacket;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class ImportExportScreen
extends Screen
implements ImportRequestHandler {
    private static final int BUTTON_SAVE = 1;
    private static final int BUTTON_RESET = 2;
    private static final int BUTTON_COPY = 3;
    private static final int BUTTON_PASTE = 4;
    private static final int BUTTON_CANCEL = 5;
    private String titleText;
    private IImportableContainer previousScreen;
    private MultiLineEditBox importText;
    private int errorTextTimer;
    private Component errorText = Component.m_237119_();
    private Component failedValue = Component.m_237119_();

    public ImportExportScreen(IImportableContainer previousScreen, String titleText) {
        super((Component)Component.m_237119_());
        this.previousScreen = previousScreen;
        this.titleText = titleText;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 150, this.f_96544_ / 2 + 90, 40, 20, (Component)Component.m_237115_((String)"gui.pokemoneditor.save"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(2, this.f_96543_ / 2 + 150, this.f_96544_ / 2 - 110, 40, 20, (Component)Component.m_237115_((String)"gui.pokemoneditor.reset"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(3, this.f_96543_ / 2 + 150, this.f_96544_ / 2 - 80, 40, 20, (Component)Component.m_237115_((String)"gui.pokemoneditor.copy"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(4, this.f_96543_ / 2 + 150, this.f_96544_ / 2 - 50, 40, 20, (Component)Component.m_237115_((String)"gui.pokemoneditor.paste"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(5, this.f_96543_ / 2 + 150, this.f_96544_ / 2 + 40, 40, 20, (Component)Component.m_237115_((String)"gui.pokemoneditor.cancel"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 150, this.f_96544_ / 2 - 20, 40, 20, (Component)Component.m_237115_((String)"pixelmon.download"), button -> this.f_96541_.m_91152_((Screen)new ReadPokePasteScreen(this.previousScreen, this.titleText)), p_253695_ -> Component.m_237119_()));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 150, this.f_96544_ / 2 + 10, 40, 20, (Component)Component.m_237115_((String)"pixelmon.upload"), button -> NetworkHelper.sendToServer(new ExportRequestPacket(this.previousScreen.getPokemon())), p_253695_ -> Component.m_237119_()));
        this.importText = (MultiLineEditBox)this.m_142416_((GuiEventListener)new MultiLineEditBox(this.f_96547_, this.f_96543_ / 2 - 195, this.f_96544_ / 2 - 65, 320, 180, (Component)Component.m_237119_(), (Component)Component.m_237119_()));
        this.resetText();
    }

    public void setExportText(String exportText) {
        this.importText.m_240159_(exportText);
    }

    private void resetText() {
        this.importText.m_240159_(this.previousScreen.getExportText());
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.f_96543_ / 2.0f - 200.0f, (float)this.f_96544_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        matrix.drawString(this.f_96547_, this.titleText, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(this.titleText) / 2.0f, (float)this.f_96544_ / 2.0f - 90.0f, 0, false);
        ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)"gui.pokemoneditor.importexport", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f - 75.0f, 0);
        for (GuiEventListener child : this.f_96540_) {
            if (!(child instanceof Renderable)) continue;
            ((Renderable)child).m_88315_(matrix, mouseX, mouseY, partialTicks);
        }
        if (this.errorTextTimer > 0) {
            --this.errorTextTimer;
            ScreenHelper.drawCenteredString(matrix, I18n.m_118938_((String)"gui.pokemoneditor.errorimport", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f + 145.0f, (float)this.f_96544_ / 2.0f + 65.0f, 0xFF0000, false);
            ScreenHelper.drawCenteredString(matrix, this.errorText.getString() + this.failedValue.getString(), (float)this.f_96543_ / 2.0f + 145.0f, (float)this.f_96544_ / 2.0f + 75.0f, 0xFF0000, false);
        }
    }

    public boolean m_5534_(char key, int keyCode) {
        if (keyCode == 256 || keyCode == 257 && !this.importText.m_93696_()) {
            this.saveAndClose();
        }
        return super.m_5534_(key, keyCode);
    }

    protected void actionPerformed(Button button) {
        if (button.f_93623_ && button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 1) {
                this.saveAndClose();
            } else if (id == 2) {
                this.resetText();
            } else if (id == 3) {
                this.f_96541_.f_91068_.m_90911_(this.importText.m_239249_());
            } else if (id == 4) {
                this.importText.m_240159_(this.f_96541_.f_91068_.m_90876_());
            } else if (id == 5) {
                this.m_7379_();
            }
        }
    }

    private void saveAndClose() {
        NetworkHelper.sendToServer(new ImportRequestPacket(List.of(this.importText.m_239249_())));
    }

    @Override
    public void handleResponse(String errorCode, String failedValue) {
        this.errorTextTimer = 60;
        this.errorText = Component.m_237115_((String)errorCode);
        this.failedValue = Component.m_237115_((String)failedValue);
    }

    @Override
    public void handleResponse(Pokemon ... pokemon) {
        this.previousScreen.setPokemon(pokemon);
        this.m_7379_();
    }

    protected boolean save() {
        this.errorText = Component.m_237115_((String)this.previousScreen.importText(this.importText.m_239249_()));
        return this.errorText == null;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.previousScreen.getScreen());
    }

    public boolean m_7043_() {
        return false;
    }
}

