/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokedex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexEntry;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokedex.AnimationHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;

public class PokedexScreen
extends Screen {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex.png"), ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex_blue.png"), ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex_gold.png"), ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex_green.png"), ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex_pink.png"), ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex_grey.png"), ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex_orange.png"), ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex_purple.png"), ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex_blue_gold.png"), ResourceLocationHelper.of("pixelmon:textures/gui/pokedex/pokedex_purple_gold.png")};
    private static final String[] NAMES = new String[]{"N", "RB", "GS", "RS", "DP", "BW", "XY", "SM", "SS", "SV"};
    private Map<String, AnimationHelper> animations = Maps.newConcurrentMap();
    private int centerW;
    private float scalar = 10900.0f;
    private Species currentPokemon;
    private List<Pokemon> forms = Lists.newArrayList();
    private int currentForm = 0;
    private int currentRow = 0;
    private int dexVersion = 0;
    private PixelmonEntity displayedPokemon;
    private List<Species> pokemon = Lists.newArrayList();
    private int currentInfoRow = 0;
    private int currentPage = 0;
    private EditBox searchBar;
    private IndexedButton upButton;
    private IndexedButton downButton;
    private IndexedButton dexOptionsMenu;
    private List<IndexedButton> dexTypeButtons;
    private boolean isDexMenuOpen = false;
    private int dexMenuFrame = 0;

    public PokedexScreen(int pos) {
        super((Component)Component.m_237119_());
        this.setCurrentPokemon(PixelmonSpecies.fromDex(pos).orElse(PixelmonSpecies.MISSINGNO.getValueUnsafe()));
    }

    public void m_7856_() {
        super.m_7856_();
        if (this.currentPokemon != null && ClientStorageManager.pokedex.get(this.currentPokemon.getDex()) == PokedexRegistrationStatus.UNKNOWN) {
            this.setCurrentPokemon(null);
        }
        this.animations.put("open", new AnimationHelper(90, -1, this::drawScreenBackground));
        this.centerW = this.f_96543_ / 2;
        this.searchBar = new TabCompleteTextField(0, this.f_96541_.f_91062_, this.centerW - 84, 141, 150, 10).setCompletions(PixelmonSpecies.getFormattedEnglishNameSet());
        this.searchBar.m_94182_(false);
        this.searchBar.m_94151_(s -> this.generatePokemonList());
        this.m_142416_((GuiEventListener)this.searchBar);
        int id = 0;
        this.upButton = (IndexedButton)this.m_142416_((GuiEventListener)new IndexedButton(++id, this.centerW + 69, 153, 10, 24, (Component)Component.m_237119_(), this::actionPerformed));
        this.downButton = (IndexedButton)this.m_142416_((GuiEventListener)new IndexedButton(++id, this.centerW + 69, 181, 10, 24, (Component)Component.m_237119_(), this::actionPerformed));
        this.dexOptionsMenu = (IndexedButton)this.m_142416_((GuiEventListener)new IndexedButton(++id, this.centerW - 120, 110, 15, 15, (Component)Component.m_237119_(), this::actionPerformed));
        this.dexTypeButtons = Lists.newArrayList();
        for (int i = 0; i <= 9; ++i) {
            int height = 13;
            this.dexTypeButtons.add((IndexedButton)this.m_142416_((GuiEventListener)new IndexedButton(++id, this.centerW - 120, 107 + i * height, 15, height + 1, (Component)Component.m_237113_((String)NAMES[i]), this::actionPerformed)));
        }
        this.generatePokemonList();
        this.currentRow = this.pokemon.indexOf(this.currentPokemon) / 7;
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        for (AnimationHelper value : this.animations.values()) {
            if (value.getPokemonLevel() >= 0) continue;
            value.update(matrix);
        }
        if (!this.animations.get("open").isComplete()) {
            return;
        }
        if (this.displayedPokemon == null && this.currentPokemon != null) {
            this.setupDisplayedPokemon();
        }
        if (!this.animations.containsKey("selection")) {
            this.beginSelectAnimation();
        }
        this.drawBottomPage(matrix, mouseX, mouseY, partialTicks);
        this.animations.values().stream().filter(anim -> anim.getPokemonLevel() >= 0).sorted(Comparator.comparingInt(AnimationHelper::getPokemonLevel)).forEach(ah -> ah.update(matrix));
        if (this.currentPage == 0) {
            this.drawFirstPage(matrix, mouseX, mouseY, partialTicks);
        } else if (this.currentPage == 1) {
            this.drawSecondPage(matrix, mouseX, mouseY, partialTicks);
        }
    }

    private void drawScreenBackground(GuiGraphics matrix, int frame) {
        double thing = frame >= 60 ? 46.0 : (frame++ < 20 ? 0.0 : 0.18143666666666666 * Math.pow(frame - 20, 1.5));
        ResourceLocation texture = TEXTURES[this.dexVersion];
        if (frame < 60) {
            ScreenHelper.simpleDrawImageQuad(texture, matrix, this.centerW - 119, (float)(59.0 + thing), 15.08118f, 134.0f, 0.4639588f, 0.42222223f, 0.49885583f, 0.9957672f, 1.0f);
        } else {
            int xPos;
            if (this.isDexMenuOpen) {
                if (this.dexMenuFrame <= 20) {
                    ++this.dexMenuFrame;
                }
            } else if (this.dexMenuFrame > 0) {
                --this.dexMenuFrame;
            }
            if (this.dexMenuFrame > 0) {
                matrix.m_280509_(this.centerW - 104 - this.dexMenuFrame, 106, this.centerW - 104, 239, -13421773);
            }
            this.dexOptionsMenu.f_93620_ = xPos = this.centerW - 119 - this.dexMenuFrame;
            for (int i = 0; i < this.dexTypeButtons.size(); ++i) {
                Button dexTypeButton = this.dexTypeButtons.get(i);
                dexTypeButton.f_93620_ = xPos + 15;
                dexTypeButton.m_93674_((int)((double)this.dexMenuFrame * 1.03));
                if (this.dexMenuFrame == 0) continue;
                matrix.m_280509_(dexTypeButton.f_93620_, dexTypeButton.f_93621_, dexTypeButton.f_93620_ + dexTypeButton.m_5711_(), dexTypeButton.f_93621_ + dexTypeButton.m_93694_(), -9341834);
                if (this.dexVersion != i) {
                    matrix.m_280509_(dexTypeButton.f_93620_ + 1, dexTypeButton.f_93621_ + 1, dexTypeButton.f_93620_ + dexTypeButton.m_5711_() - 1, dexTypeButton.f_93621_ + dexTypeButton.m_93694_() - 1, -11118503);
                }
                ScreenHelper.drawCenteredString(matrix, dexTypeButton.m_6035_().getString(), Math.max((float)this.centerW - 97.0f - (float)this.dexMenuFrame, (float)this.centerW - 113.5f), (float)dexTypeButton.f_93621_ + 3.5f, -1);
            }
            ScreenHelper.simpleDrawImageQuad(texture, matrix, xPos, 105.0f, 15.08118f, 134.0f, 0.4639588f, 0.42222223f, 0.49885583f, 0.9957672f, 1.0f);
        }
        ScreenHelper.simpleDrawImageQuad(texture, matrix, this.centerW - 104, (float)(59.0 + thing), 215.09225f, 134.0f, 0.5005721f, 0.42222223f, 0.99828374f, 0.9957672f, 0.0f);
        float start = this.currentPage != 0 ? 0.0f : 0.50476193f;
        ScreenHelper.simpleDrawImageQuad(texture, matrix, (float)this.centerW - 103.5f, (float)(59.0 - thing), 199.0f, 115.69193f, 0.0f, start, 0.46052632f, start + 0.4952381f, 0.0f);
    }

    private void drawFirstPage(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        String s;
        if (this.currentPokemon == null || !Pokedex.FULL_POKEDEX.containsKey(this.currentPokemon.getDex())) {
            return;
        }
        PokedexEntry entry = Pokedex.FULL_POKEDEX.get(this.currentPokemon.getDex());
        Object nameS = this.displayedPokemon.getLocalizedName();
        if (!this.displayedPokemon.getPokemon().getForm().isDefault()) {
            nameS = (String)nameS + " " + this.displayedPokemon.getPokemon().getForm().getLocalizedName();
        }
        matrix.m_280488_(this.f_96547_, (String)nameS + " #" + entry.getPokedexDisplayNumber(), this.centerW - 86, 25, 0xFFFFFF);
        for (int i = 0; i < this.displayedPokemon.getPokemon().getForm().getTypes().size(); ++i) {
            Element type = this.displayedPokemon.getPokemon().getForm().getTypes().get(i);
            float x = type.textureX;
            float y = type.textureY;
            ScreenHelper.drawImageQuadUV(Resources.types, matrix, this.centerW + 67 - 13 * i, 24.0f, 10.0f, 10.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
        ScreenHelper.drawScaledString(matrix, this.forms.get(this.currentForm).getForm().getDimensions().getHeight() + I18n.m_118938_((String)"gui.pokedex.meters", (Object[])new Object[0]), this.centerW - 85, 40.0f, 0xFFFFFF, 10.0f);
        ScreenHelper.drawScaledStringRightAligned(matrix, this.forms.get(this.currentForm).getForm().getWeight() + I18n.m_118938_((String)"gui.pokedex.kilograms", (Object[])new Object[0]), this.centerW - 29, 40.0f, 0xFFFFFF, false, 10.0f);
        ScreenHelper.drawScaledCenteredString(matrix, I18n.m_118938_((String)"gui.pokedex.description", (Object[])new Object[0]), this.centerW + 28, 40.0f, 0xFFFFFF, 14.0f);
        if (ClientStorageManager.pokedex.get(this.currentPokemon.getDex()) == PokedexRegistrationStatus.CAUGHT) {
            String key = this.forms.get(this.currentForm).getForm().getName() + ".description";
            s = I18n.m_118938_((String)key, (Object[])new Object[0]);
            if (s.equals(key)) {
                s = I18n.m_118938_((String)("pixelmon." + this.currentPokemon.getName().replace(" ", "").toLowerCase(Locale.ROOT) + ".description"), (Object[])new Object[0]);
            }
        } else {
            s = "???";
        }
        s = ScreenHelper.splitStringToFit(s, 10, 97);
        for (int i = 0; i < s.split("\n").length; ++i) {
            String s1 = s.split("\n")[i];
            float f = this.centerW - 22;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            ScreenHelper.drawScaledString(matrix, s1, f, 55.0f + 9.0f * 0.625f * (float)i, 0xFFFFFF, 8.0f);
        }
        if (ClientStorageManager.pokedex.get(this.currentPokemon.getDex()) == PokedexRegistrationStatus.CAUGHT) {
            if (this.currentForm > 0) {
                ScreenHelper.drawImageQuad(Resources.pokedexBack, matrix, this.centerW - 88, 102.0f, 15.0f, 15.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (this.currentForm + 1 < this.forms.size()) {
                ScreenHelper.drawImageQuad(Resources.pokedexForward, matrix, this.centerW - 44, 102.0f, 15.0f, 15.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        this.drawEntityToScreen(matrix, this.centerW - 58, 105, 50, this.displayedPokemon, mouseX, partialTicks);
    }

    private void drawSecondPage(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.currentPokemon == null) {
            return;
        }
        PokedexEntry entry = Pokedex.FULL_POKEDEX.get(this.currentPokemon.getDex());
        matrix.m_280488_(this.f_96547_, this.displayedPokemon.getLocalizedName() + " #" + entry.getPokedexDisplayNumber(), this.centerW - 86, 25, 0xFFFFFF);
        for (int i = 0; i < this.displayedPokemon.getPokemon().getForm().getTypes().size(); ++i) {
            Element type = this.displayedPokemon.getPokemon().getForm().getTypes().get(i);
            float x = type.textureX;
            float y = type.textureY;
            ScreenHelper.drawImageQuadUV(Resources.types, matrix, this.centerW + 67 - 13 * i, 24.0f, 10.0f, 10.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
        ScreenHelper.drawScaledCenteredString(matrix, I18n.m_118938_((String)"gui.pokedex.spawns", (Object[])new Object[0]), this.centerW, 40.0f, 0xFFFFFF, 14.0f);
        List<String> spawnInfo = this.getSpawnInfo();
        for (int i = this.currentInfoRow; i < Math.min(this.currentInfoRow + 5, spawnInfo.size()); ++i) {
            String s = ScreenHelper.splitStringToFit(spawnInfo.get(i), 9, 155);
            for (int j = 0; j < s.split("\n").length; ++j) {
                String s1 = s.split("\n")[j];
                float f = this.centerW - 86;
                Objects.requireNonNull(this.f_96541_.f_91062_);
                ScreenHelper.drawScaledString(matrix, s1, f, 55.0f + 9.0f * 0.5625f * (float)j + (float)((i - this.currentInfoRow) * 9), 0xFFFFFF, 9.0f);
            }
        }
    }

    private void drawBottomPage(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        this.searchBar.m_88315_(matrix, mouseX, mouseY, partialTicks);
        for (int i = this.currentRow * 7; 0 <= i && i < Math.min(this.pokemon.size(), this.currentRow * 7 + 21); ++i) {
            float color;
            int j = i - this.currentRow * 7;
            int x = (int)((double)this.centerW + (double)(j % 7) * 21.9 - 86.0);
            int y = j / 7 * 19 + 148;
            PokedexRegistrationStatus status = ClientStorageManager.pokedex.get(this.pokemon.get(i).getDex());
            float f = color = status == PokedexRegistrationStatus.UNKNOWN ? 0.0f : 1.0f;
            if (this.currentPokemon != this.pokemon.get(i)) {
                ScreenHelper.drawImageQuad(this.pokemon.get(i).getDefaultForms().get(0).getGenderProperties(Gender.MALE).getDefaultPalette().getSprite(), matrix, x, y, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, color, color, color, 1.0f, 1.0f);
            }
            float f2 = color = status == PokedexRegistrationStatus.SEEN ? 0.0f : 1.0f;
            if (status != PokedexRegistrationStatus.UNKNOWN) {
                ScreenHelper.drawImageQuad(Resources.pokedexCaught, matrix, x + 15, (float)y + 3.5f, 5.0f, 5.0f, 0.0f, 0.0f, 1.0f, 1.0f, color, color, color, 1.0f, 1.0f);
            }
            if (x > mouseX || mouseX > x + 20 || y + 4 > mouseY || mouseY > y + 16 || status == PokedexRegistrationStatus.UNKNOWN) continue;
            ScreenHelper.drawImageQuad(Resources.pixelmonCreativeInventory, matrix, x - 2, y + 2, 24.0f, 20.0f, 0.31640625f, 0.72265625f, 0.41015625f, 0.80078125f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        String s = I18n.m_118938_((String)"gui.pokedex.caught", (Object[])new Object[0]) + " " + ClientStorageManager.pokedex.countCaught(this.dexVersion);
        ScreenHelper.drawScaledString(matrix, s, this.centerW - 47, 211.0f, 0xFFFFFF, 8.0f);
        s = I18n.m_118938_((String)"gui.pokedex.seen", (Object[])new Object[0]) + " " + ClientStorageManager.pokedex.countSeen(this.dexVersion);
        ScreenHelper.drawScaledString(matrix, s, this.centerW - 5, 211.0f, 0xFFFFFF, 8.0f);
        s = I18n.m_118938_((String)"gui.pokedex.completion", (Object[])new Object[0]) + " " + (int)(((double)ClientStorageManager.pokedex.countCaught(this.dexVersion) + 0.0) / (double)Pokedex.pokedexSize * 100.0) + "%";
        ScreenHelper.drawScaledString(matrix, s, this.centerW + 40, 211.0f, 0xFFFFFF, 8.0f);
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            if (button == this.upButton) {
                this.currentRow = Math.max(0, this.currentRow - 1);
            } else if (button == this.downButton) {
                this.currentRow = Math.min((int)Math.ceil((double)this.pokemon.size() / 7.0) - 1, this.currentRow + 1);
            } else if (button == this.dexOptionsMenu) {
                this.isDexMenuOpen = !this.isDexMenuOpen;
            } else if (this.dexTypeButtons.contains(button)) {
                this.dexVersion = this.dexTypeButtons.indexOf(button);
                this.generatePokemonList();
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int i;
        if (!this.animations.get("open").isComplete()) {
            return false;
        }
        int truncatedMouseX = (int)mouseX;
        int truncatedMouseY = (int)mouseY;
        int centerX = this.f_96543_ / 2;
        double mouseCenterX = truncatedMouseX - centerX;
        if (mouseCenterX >= -86.0 && mouseCenterX <= 72.0 && mouseY >= 148.0 && mouseY <= 202.0 && (i = (int)((double)((this.currentRow + (truncatedMouseY - 148) / 19) * 7) + (double)(truncatedMouseX - (centerX - 86)) / 21.9)) >= 0 && i < this.pokemon.size() && ClientStorageManager.pokedex.get(this.pokemon.get(i).getDex()) != PokedexRegistrationStatus.UNKNOWN) {
            this.currentInfoRow = 0;
            this.setCurrentPokemon(this.pokemon.get(i));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.beginSelectAnimation();
        }
        if (this.currentPage == 0 && this.currentPokemon != null && this.displayedPokemon != null && this.displayedPokemon.getPokemon() != null) {
            if (ClientStorageManager.pokedex.get(this.currentPokemon.getDex()) == PokedexRegistrationStatus.CAUGHT) {
                if (this.currentForm - 1 >= 0 && mouseCenterX >= -88.0 && mouseCenterX <= -74.0 && mouseY >= 105.0 && mouseY <= 120.0) {
                    --this.currentForm;
                    this.setupDisplayedPokemon();
                } else if (this.currentForm + 1 < this.forms.size() && mouseCenterX >= -42.0 && mouseCenterX <= -26.0 && mouseY >= 105.0 && mouseY <= 120.0) {
                    ++this.currentForm;
                    this.setupDisplayedPokemon();
                }
            }
            if (mouseCenterX >= 54.0 && mouseCenterX <= 80.0 && mouseY >= 100.0 && mouseY <= 125.0) {
                ++this.currentPage;
            }
        } else if (mouseCenterX >= -81.0 && mouseCenterX <= -55.0 && mouseY >= 100.0 && mouseY <= 125.0) {
            --this.currentPage;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollX, double scrollY) {
        double mouseCenterX = mouseX - (double)(this.f_96543_ / 2);
        if (mouseCenterX >= -86.0 && mouseCenterX <= 72.0 && mouseY >= 148.0 && mouseY <= 202.0) {
            if (scrollY > 0.0) {
                this.currentRow = Math.max(0, this.currentRow - 1);
            } else if (scrollY < 0.0) {
                this.currentRow = Math.min((int)Math.ceil((double)this.pokemon.size() / 7.0) - 1, this.currentRow + 1);
            }
        } else if (this.currentPage == 0) {
            this.scalar = (float)((double)this.scalar + scrollY);
        } else if (this.currentPage == 1 && mouseCenterX >= -90.0 && mouseCenterX <= 88.0 && mouseY >= 40.0 && mouseY <= 85.0) {
            int temp = this.currentInfoRow;
            if (scrollY > 0.0) {
                this.currentInfoRow = Math.max(0, this.currentInfoRow - 1);
            } else if (scrollY < 0.0) {
                this.currentInfoRow = Math.min(Math.max(this.getSpawnInfo().size() - 5, 0), this.currentInfoRow + 1);
            }
        }
        return super.m_6050_(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean m_7043_() {
        return false;
    }

    public void setCurrentPokemon(Species species) {
        this.currentPokemon = species;
        this.currentForm = 0;
        this.forms = Lists.newArrayList();
        if (species != null) {
            for (Stats form : species.getForms(true)) {
                for (GenderProperties gender : form.getGenderProperties()) {
                    for (PaletteProperties palette : gender.getPalettes()) {
                        Pokemon pokemon = PokemonFactory.create(species);
                        pokemon.setForm(form);
                        pokemon.setPalette(palette);
                        this.forms.add(pokemon);
                    }
                }
            }
        }
        this.setupDisplayedPokemon();
    }

    public void beginSelectAnimation() {
        int i = this.pokemon.indexOf(this.currentPokemon);
        if (i != -1) {
            this.animations.put("selection", new AnimationHelper(4, (matrix, frame) -> {
                int row = i / 7;
                if (row > this.currentRow + 2 || row < this.currentRow) {
                    return;
                }
                int j = i - this.currentRow * 7;
                int x = (int)((double)(this.f_96543_ / 2) + (double)(j % 7) * 21.9 - 86.0);
                int y = j / 7 * 19 + 148;
                ScreenHelper.drawImageQuad(Resources.pixelmonCreativeInventory, matrix, x - 2, y + 2, 24.0f, 20.0f, 0.31640625f, 0.72265625f, 0.41015625f, 0.80078125f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                float offset = (float)frame.intValue() / 2.0f;
                ScreenHelper.drawImageQuad(this.currentPokemon.getDefaultForms().get(0).getGenderProperties(Gender.MALE).getDefaultPalette().getSprite(), matrix, (float)x - offset, (float)y - offset, 20.0f + offset * 2.0f, 20.0f + offset * 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }));
        }
    }

    public void generatePokemonList() {
        this.pokemon = this.getPokemonList();
        if (!this.pokemon.contains(this.currentPokemon)) {
            this.setCurrentPokemon(this.pokemon.stream().filter(species -> ClientStorageManager.pokedex.isRegistered((Species)species)).findFirst().orElse(null));
        }
        this.currentRow = this.currentPokemon != null ? this.pokemon.indexOf(this.currentPokemon) / 7 : 0;
        this.animations.remove("selection");
        this.displayedPokemon = null;
    }

    private List<Species> getPokemonList() {
        ArrayList species = Lists.newArrayList();
        for (Species actualPokedex : Pokedex.actualPokedex) {
            if (!actualPokedex.getName().toLowerCase(Locale.ROOT).startsWith(this.searchBar.m_94155_().toLowerCase(Locale.ROOT)) || this.dexVersion != 0 && this.dexVersion != actualPokedex.getGeneration()) continue;
            species.add(actualPokedex);
        }
        species.sort(Comparator.comparingInt(Species::getDex));
        return species;
    }

    private void setupDisplayedPokemon() {
        double dw;
        if (this.f_96541_ == null) {
            return;
        }
        if (this.forms.isEmpty()) {
            this.displayedPokemon = null;
            return;
        }
        IncrementingVariable variable = null;
        if (this.displayedPokemon != null && this.displayedPokemon.getSpecies() == this.currentPokemon) {
            variable = this.displayedPokemon.getAnimationVariables().getCounter(-1);
        }
        this.displayedPokemon = new PixelmonEntity((Level)this.f_96541_.f_91073_, this.forms.get(this.currentForm));
        this.displayedPokemon.getPokemon().setGrowth(EnumGrowth.Ordinary);
        this.displayedPokemon.checkAnimation();
        this.displayedPokemon.initAnimation();
        if (variable != null && this.displayedPokemon.getAnimationVariables().getCounter(-1) != null) {
            this.displayedPokemon.getAnimationVariables().getCounter((int)-1).value = variable.value;
        }
        double referenceW = 40.0;
        double referenceH = 40.0;
        double dh = (double)this.displayedPokemon.m_20206_() - referenceH;
        this.scalar = dh > (dw = (double)this.displayedPokemon.m_20205_() - referenceW) ? (float)(referenceH / (double)this.displayedPokemon.m_20206_()) : (float)(referenceW / (double)this.displayedPokemon.m_20205_());
        this.currentPage = 0;
    }

    private List<String> getSpawnInfo() {
        ArrayList data = Lists.newArrayList();
        for (PlayerPokedex.PokedexSpawnData spawnDatum : ClientStorageManager.pokedex.getSpawnData(this.currentPokemon.getDex())) {
            data.add(spawnDatum.toString());
        }
        return data;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.displayedPokemon != null && this.displayedPokemon.getAnimationVariables() != null) {
            this.displayedPokemon.getAnimationVariables().tick();
        }
    }

    private void drawEntityToScreen(GuiGraphics graphics, int x, int y, int l, PixelmonEntity entity, int mouseX, float partialTicks) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        matrix.m_252880_((float)x, (float)y, 100.0f);
        if (l != 0) {
            matrix.m_85841_(this.scalar, this.scalar, this.scalar);
        }
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler((float)(x - mouseX) / 2.0f, 0.0f, 1.0f, 0.0f));
        PixelmonRendering.renderEntity(graphics, entity, true, partialTicks);
        matrix.m_252781_(QuaternionHelper.fromEuler(360.0f - (float)(x - mouseX) / 2.0f, 0.0f, 1.0f, 0.0f));
        matrix.m_252781_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        if (l != 0) {
            matrix.m_85841_(1.0f / this.scalar, 1.0f / this.scalar, 1.0f / this.scalar);
        }
        matrix.m_85849_();
    }
}

