/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker.ribbon;

import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.ribbon.RibbonButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.ImageButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetDisplayRibbonPacket;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class PokeCheckerRibbonsScreen
extends PokeCheckerScreen {
    private int page = 0;

    public PokeCheckerRibbonsScreen(PokeCheckerScreen tab) {
        super(tab);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int dispC = 0;
        int imgSize = 25;
        int cols = 6;
        int pos = 0;
        for (Ribbon t : this.pokemon.getRibbons()) {
            if (pos / 24 == this.page) {
                int y = imgSize * (dispC / cols);
                int x = 62 + imgSize * (dispC % cols);
                this.m_142416_((GuiEventListener)new RibbonButton(this.guiLeft + x, this.guiTop + y, 16, 16, (Component)Component.m_237119_(), button -> {
                    if (Objects.equals(t, this.pokemon.getDisplayedRibbon())) {
                        NetworkHelper.sendToServer(new SetDisplayRibbonPacket(this.position, this.pokemon.getUUID(), null));
                    } else {
                        NetworkHelper.sendToServer(new SetDisplayRibbonPacket(this.position, this.pokemon.getUUID(), t));
                    }
                }, t, ribbon -> Objects.equals(ribbon, this.pokemon.getDisplayedRibbon())));
                if (++dispC / cols == 4) break;
            }
            ++pos;
        }
        if (this.page != 0) {
            this.m_142416_((GuiEventListener)new ImageButton(0, this.guiLeft + 62, this.guiTop - 24, 24, 24, Resources.LEFT, 1.0f, 1.0f, 1.0f, button -> {
                --this.page;
                this.m_7856_();
            }));
        }
        if (this.page != this.pokemon.getRibbons().size() / 24) {
            this.m_142416_((GuiEventListener)new ImageButton(0, this.guiLeft + this.xSize, this.guiTop - 24, 24, 24, Resources.RIGHT, 1.0f, 1.0f, 1.0f, button -> {
                ++this.page;
                this.m_7856_();
            }));
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        matrix.m_280218_(Resources.summaryRibbons, (this.f_96543_ - this.xSize) / 2 - 40, (this.f_96544_ - this.ySize) / 2 - 25, 0, 0, 256, 205);
        this.drawPokemonName(matrix);
        this.drawArrows(matrix, mouseX, mouseY);
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics matrix, int mouseX, int mouseY) {
        if (!this.pokemon.isEgg()) {
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getPokemonLevel(), 10, -14, 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + this.pokemon.getSpecies().getDex(), -30, -14, 0xFFFFFF);
            if (this.pokemon.getDisplayedRibbon() != null) {
                ScreenHelper.drawSquashedString(matrix, this.f_96541_.f_91062_, this.pokemon.getDisplayedRibbon().getRibbonData().getTitle(), false, 115.0f, -33.0f, 112.0f, 0xFFFFFF, true);
                Component title = this.pokemon.getDisplayNameWithRibbon();
                int strWidth = Math.min(115, this.f_96541_.f_91062_.m_92852_((FormattedText)title));
                ScreenHelper.drawSquashedString(matrix, this.f_96541_.f_91062_, title, false, 115.0f, (float)(207 - strWidth), 112.0f, 0xFFAA00, true);
                ScreenHelper.drawSplitString(matrix, this.pokemon.getDisplayedRibbon().getRibbonData().getDescription(), -30, 128, 235, 0xFFFFFF);
            }
        } else {
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???", 10, -14, 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???", -30, -14, 0xFFFFFF);
        }
        this.drawBasePokemonInfo(matrix);
    }
}

