/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.species.moves.Moves;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerScreen;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalRecords;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import org.apache.commons.lang3.tuple.Pair;

public class PokeCheckerTMsScreen
extends PokeCheckerScreen {
    private int selectedNumber = 0;
    private int scrollPos = 0;
    private int selectedMoveset = 0;
    private List<ImmutableAttack> eggMoves = Lists.newArrayList();

    public PokeCheckerTMsScreen(PokeCheckerScreen tab) {
        super(tab);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        matrix.m_280218_(Resources.summaryTMs, (this.f_96543_ - this.xSize) / 2 - 40, (this.f_96544_ - this.ySize) / 2 - 25, 0, 0, 256, 205);
        this.drawPokemonName(matrix);
        this.drawArrows(matrix, mouseX, mouseY);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.eggMoves = Lists.newArrayList(this.pokemon.getForm().getMoves().getEggMoves());
    }

    private void drawMoveInfo(GuiGraphics matrix, ImmutableAttack attack) {
        if (attack == null) {
            return;
        }
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.battle.power", (Object[])new Object[0]) + ":", -30, 128, 0xFFFFFF);
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.battle.accuracy", (Object[])new Object[0]) + ":", -30, 138, 0xFFFFFF);
        int bpExtra = 0;
        int acExtra = 0;
        if (attack.getBasePower() >= 100) {
            bpExtra = this.f_96541_.f_91062_.m_92895_("0");
        }
        if (attack.getAccuracy() >= 100) {
            acExtra = this.f_96541_.f_91062_.m_92895_("0");
        }
        if (attack.getBasePower() > 0) {
            matrix.m_280488_(this.f_96541_.f_91062_, "" + attack.getBasePower(), 30 - bpExtra, 128, 0xFFFFFF);
        } else {
            matrix.m_280488_(this.f_96541_.f_91062_, "--", 30 - bpExtra, 128, 0xFFFFFF);
        }
        if (attack.getAccuracy() <= 0) {
            matrix.m_280488_(this.f_96541_.f_91062_, "--", 30 - acExtra, 138, 0xFFFFFF);
        } else {
            matrix.m_280488_(this.f_96541_.f_91062_, "" + attack.getAccuracy(), 30 - acExtra, 138, 0xFFFFFF);
        }
        matrix.m_280488_(this.f_96541_.f_91062_, attack.getAttackCategory().getLocalizedName(), -30, 148, 0xFFFFFF);
        matrix.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)("attack." + attack.getAttackName().replace(" ", "_").toLowerCase(Locale.ROOT)), (Object[])new Object[0]), 137, 98, 0xFFFFFF);
        ScreenHelper.drawSplitString(matrix, I18n.m_118938_((String)("attack." + attack.getAttackName().replace(" ", "_").toLowerCase(Locale.ROOT) + ".description"), (Object[])new Object[0]), 60, 113, 145, 0xFFFFFF);
        float x = attack.getAttackType().textureX;
        float y = attack.getAttackType().textureY;
        ScreenHelper.drawImageQuadUV(Resources.types, matrix, 0.0f, 108.0f, 18.0f, 18.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics matrix, int mouseX, int mouseY) {
        if (!this.pokemon.isEgg()) {
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getPokemonLevel(), 10, -14, 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + this.pokemon.getSpecies().getDex(), -30, -14, 0xFFFFFF);
            matrix.m_280218_(Resources.summaryTMs, 70 + 12 * this.selectedMoveset, -20, 0, 240, 12, 16);
            ArrayList displayMoves = Lists.newArrayList(this.pokemon.getForm().getMoves().getGenerationMoves(this.selectedMoveset));
            int size = displayMoves.size();
            if (this.selectedMoveset == 0) {
                size = this.eggMoves.size();
            } else if (this.selectedMoveset == -1) {
                size = this.pokemon.getForm().getMoves().getFormatLevelMoves().size();
            }
            if (size > 6) {
                float height = 85.0f / (float)size;
                ScreenHelper.drawImageQuad(Resources.summaryTMs, matrix, 205.0f, -4.0f, 5.0f, 90.0f, 0.0f, 0.91796875f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                ScreenHelper.drawImageQuad(Resources.summaryTMs, matrix, 205.0f, -4.0f + height * (float)this.scrollPos, 5.0f, height * 6.0f, 0.0f, 0.87890625f, 0.0f, 0.8984375f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                ScreenHelper.drawImageQuad(Resources.summaryTMs, matrix, 205.0f, -4.0f + height * (float)this.scrollPos, 5.0f, 5.0f, 0.0f, 0.859375f, 0.0f, 0.87890625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                ScreenHelper.drawImageQuad(Resources.summaryTMs, matrix, 205.0f, -4.0f + height * (float)(this.scrollPos + 6), 5.0f, 5.0f, 0.0f, 0.8984375f, 0.0f, 0.91796875f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            for (int i = 0; i < 6; ++i) {
                Object move;
                boolean shadow;
                if (size <= i + this.scrollPos) continue;
                boolean bl = shadow = this.selectedNumber != i + this.scrollPos;
                if (this.selectedMoveset == 0) {
                    move = this.eggMoves.get(i + this.scrollPos);
                    matrix.m_280056_(this.f_96541_.f_91062_, move.getLocalizedName(), 62, i * 15, 0xFFFFFF, shadow);
                    continue;
                }
                if (this.selectedMoveset == -1) {
                    Pair<Integer, ImmutableAttack> p = this.pokemon.getForm().getMoves().getFormatLevelMoves().get(i + this.scrollPos);
                    matrix.m_280056_(this.f_96541_.f_91062_, ((ImmutableAttack)p.getRight()).getLocalizedName(), 100, i * 15, 0xFFFFFF, shadow);
                    matrix.m_280056_(this.f_96541_.f_91062_, "Lv " + p.getLeft(), 62, 15 * i, 0xFFFFFF, shadow);
                    continue;
                }
                if (displayMoves.get(i + this.scrollPos) instanceof Gen8TechnicalRecords) {
                    move = (ITechnicalMove)displayMoves.get(i + this.scrollPos);
                    matrix.m_280056_(this.f_96541_.f_91062_, move.getAttack().getLocalizedName(), 100, i * 15, 0xFFFFFF, shadow);
                    matrix.m_280056_(this.f_96541_.f_91062_, "TR " + move.getId(), 62, 15 * i, 0xFFFFFF, shadow);
                    continue;
                }
                if (!(displayMoves.get(i + this.scrollPos) instanceof ITechnicalMove)) continue;
                move = (ITechnicalMove)displayMoves.get(i + this.scrollPos);
                matrix.m_280056_(this.f_96541_.f_91062_, move.getAttack().getLocalizedName(), 100, i * 15, 0xFFFFFF, shadow);
                matrix.m_280056_(this.f_96541_.f_91062_, "TM " + move.getId(), 62, 15 * i, 0xFFFFFF, shadow);
            }
            if (size > this.selectedNumber) {
                if (this.selectedMoveset == 0) {
                    this.drawMoveInfo(matrix, this.eggMoves.get(this.selectedNumber));
                } else if (this.selectedMoveset == -1) {
                    this.drawMoveInfo(matrix, (ImmutableAttack)this.pokemon.getForm().getMoves().getFormatLevelMoves().get(this.selectedNumber).getRight());
                } else if (displayMoves.get(this.selectedNumber) instanceof ITechnicalMove) {
                    this.drawMoveInfo(matrix, ((ITechnicalMove)displayMoves.get(this.selectedNumber)).getAttack());
                }
            }
            ScreenHelper.drawScaledImage(matrix, Resources.rareCandy, 0.705f, 58.5f, -17.25f, 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            ScreenHelper.drawScaledImage(matrix, Resources.egg, 1.5f, 64.0f, -27.5f, 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            Moves moves = this.pokemon.getForm().getMoves();
            matrix.m_280488_(this.f_96541_.f_91062_, "1", 85, -16, moves.getTMMoves1().isEmpty() ? 0x989898 : 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, "2", 97, -16, moves.getTMMoves2().isEmpty() ? 0x989898 : 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, "3", 109, -16, moves.getTMMoves3().isEmpty() ? 0x989898 : 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, "4", 121, -16, moves.getTMMoves4().isEmpty() ? 0x989898 : 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, "5", 133, -16, moves.getTMMoves5().isEmpty() ? 0x989898 : 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, "6", 145, -16, moves.getTMMoves6().isEmpty() ? 0x989898 : 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, "7", 157, -16, moves.getTMMoves7().isEmpty() ? 0x989898 : 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, "8", 169, -16, moves.getTMMoves8().isEmpty() ? 0x989898 : 0xFFFFFF);
        } else {
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???", 10, -14, 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???", -30, -14, 0xFFFFFF);
        }
        this.drawBasePokemonInfo(matrix);
    }

    public boolean m_6050_(double mX, double mY, double iX, double iY) {
        if (this.selectedMoveset == -1) {
            List<Pair<Integer, ImmutableAttack>> displayMoves = this.pokemon.getForm().getMoves().getFormatLevelMoves();
            if (displayMoves != null && displayMoves.size() > 7) {
                if (iY > 0.0) {
                    if (this.scrollPos - 1 != -1) {
                        --this.scrollPos;
                    }
                } else if (iY < 0.0 && this.scrollPos + 1 != displayMoves.size() - 5) {
                    ++this.scrollPos;
                }
            }
        } else if (this.selectedMoveset == 0) {
            List<ImmutableAttack> displayMoves = this.eggMoves;
            if (displayMoves != null && displayMoves.size() > 7) {
                if (iY > 0.0) {
                    if (this.scrollPos - 1 != -1) {
                        --this.scrollPos;
                    }
                } else if (iY < 0.0 && this.scrollPos + 1 != displayMoves.size() - 5) {
                    ++this.scrollPos;
                }
            }
        } else {
            Set<ITechnicalMove> displayMoves = this.pokemon.getForm().getMoves().getGenerationMoves(this.selectedMoveset);
            if (displayMoves != null && displayMoves.size() > 7) {
                if (iY > 0.0) {
                    if (this.scrollPos - 1 != -1) {
                        --this.scrollPos;
                    }
                } else if (iY < 0.0 && this.scrollPos + 1 != displayMoves.size() - 5) {
                    ++this.scrollPos;
                }
            }
        }
        return super.m_6050_(mX, mY, iX, iY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        double x = (double)((float)this.f_96543_ / 2.0f) - mouseX;
        double y = (double)((float)this.f_96544_ / 2.0f) - mouseY;
        if (x < 30.0 && x > -121.0 && y < 102.0) {
            if (y > 88.0) {
                if (x > 18.0) {
                    if (!this.pokemon.getForm().getMoves().getFormatLevelMoves().isEmpty()) {
                        this.selectedMoveset = -1;
                        this.scrollPos = 0;
                        this.selectedNumber = 0;
                    }
                } else if (x > 6.0) {
                    if (!this.eggMoves.isEmpty()) {
                        this.selectedMoveset = 0;
                        this.scrollPos = 0;
                        this.selectedNumber = 0;
                    }
                } else if (x > -6.0) {
                    if (!this.pokemon.getForm().getMoves().getGenerationMoves(1).isEmpty()) {
                        this.selectedMoveset = 1;
                        this.scrollPos = 0;
                        this.selectedNumber = 0;
                    }
                } else if (x > -18.0) {
                    if (!this.pokemon.getForm().getMoves().getGenerationMoves(2).isEmpty()) {
                        this.selectedMoveset = 2;
                        this.scrollPos = 0;
                        this.selectedNumber = 0;
                    }
                } else if (x > -30.0) {
                    if (!this.pokemon.getForm().getMoves().getGenerationMoves(3).isEmpty()) {
                        this.selectedMoveset = 3;
                        this.scrollPos = 0;
                        this.selectedNumber = 0;
                    }
                } else if (x > -42.0) {
                    if (!this.pokemon.getForm().getMoves().getGenerationMoves(4).isEmpty()) {
                        this.selectedMoveset = 4;
                        this.scrollPos = 0;
                        this.selectedNumber = 0;
                    }
                } else if (x > -54.0) {
                    if (!this.pokemon.getForm().getMoves().getGenerationMoves(5).isEmpty()) {
                        this.selectedMoveset = 5;
                        this.scrollPos = 0;
                        this.selectedNumber = 0;
                    }
                } else if (x > -66.0) {
                    if (!this.pokemon.getForm().getMoves().getGenerationMoves(6).isEmpty()) {
                        this.selectedMoveset = 6;
                        this.scrollPos = 0;
                        this.selectedNumber = 0;
                    }
                } else if (x > -78.0) {
                    if (!this.pokemon.getForm().getMoves().getGenerationMoves(7).isEmpty()) {
                        this.selectedMoveset = 7;
                        this.scrollPos = 0;
                        this.selectedNumber = 0;
                    }
                } else if (x > -90.0 && !this.pokemon.getForm().getMoves().getGenerationMoves(8).isEmpty()) {
                    this.selectedMoveset = 8;
                    this.scrollPos = 0;
                    this.selectedNumber = 0;
                }
            } else if (y > 73.0) {
                this.selectedNumber = this.scrollPos;
            } else if (y > 58.0) {
                this.selectedNumber = this.scrollPos + 1;
            } else if (y > 43.0) {
                this.selectedNumber = this.scrollPos + 2;
            } else if (y > 28.0) {
                this.selectedNumber = this.scrollPos + 3;
            } else if (y > 13.0) {
                this.selectedNumber = this.scrollPos + 4;
            } else if (y > -2.0) {
                this.selectedNumber = this.scrollPos + 5;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }
}

