/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerScreen;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;

public class PokeCheckerStatsScreen
extends PokeCheckerScreen {
    private static final int HEX_WHITE = 0xFFFFFF;
    private static final int HEX_DECREASE = 0xFF3030;
    private static final int HEX_INCREASE = 65280;

    PokeCheckerStatsScreen(PokeCheckerScreen tab) {
        super(tab);
    }

    public PokeCheckerStatsScreen(PokemonStorage storage, StoragePosition position, @Nullable Screen parent) {
        super(storage, position, parent);
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics matrix, int mouseX, int mouseY) {
        int hexColor = 0xFFFFFF;
        if (!this.pokemon.isEgg()) {
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getPokemonLevel(), 10, -14, hexColor);
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + this.pokemon.getSpecies().getDex(), -30, -14, hexColor);
            if (this.pokemon.getOriginalTrainer() != null) {
                matrix.m_280137_(this.f_96541_.f_91062_, this.pokemon.getOriginalTrainer(), 8, 126, hexColor);
            }
        } else {
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???", 10, -14, hexColor);
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???", -30, -14, hexColor);
            matrix.m_280137_(this.f_96541_.f_91062_, "???", 8, 126, hexColor);
        }
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.ot", (Object[])new Object[0]), -32, 111, hexColor);
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"nbt.hp", (Object[])new Object[0]), 60, -12, hexColor);
        String strHP = String.valueOf(this.pokemon.getMaxHealth());
        if (this.pokemon.isEgg()) {
            strHP = "???";
        }
        matrix.m_280488_(this.f_96541_.f_91062_, strHP, 200 - strHP.length() * 3, -12, hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.ATTACK && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.ATTACK && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strATK = String.valueOf(this.pokemon.getStat(BattleStatsType.ATTACK));
        if (this.pokemon.isEgg()) {
            strATK = "???";
        }
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"nbt.attack", (Object[])new Object[0]), 60, 9, hexColor);
        matrix.m_280488_(this.f_96541_.f_91062_, strATK, 200 - strATK.length() * 3, 9, hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.DEFENSE && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.DEFENSE && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strDEF = String.valueOf(this.pokemon.getStat(BattleStatsType.DEFENSE));
        if (this.pokemon.isEgg()) {
            strDEF = "???";
        }
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"nbt.defense", (Object[])new Object[0]), 60, 28, hexColor);
        matrix.m_280488_(this.f_96541_.f_91062_, strDEF, 200 - strDEF.length() * 3, 28, hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.SPECIAL_ATTACK && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.SPECIAL_ATTACK && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strSATK = String.valueOf(this.pokemon.getStat(BattleStatsType.SPECIAL_ATTACK));
        if (this.pokemon.isEgg()) {
            strSATK = "???";
        }
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"nbt.spattack", (Object[])new Object[0]), 60, 48, hexColor);
        matrix.m_280488_(this.f_96541_.f_91062_, strSATK, 200 - strSATK.length() * 3, 48, hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.SPECIAL_DEFENSE && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.SPECIAL_DEFENSE && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strSDEF = String.valueOf(this.pokemon.getStat(BattleStatsType.SPECIAL_DEFENSE));
        if (this.pokemon.isEgg()) {
            strSDEF = "???";
        }
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"nbt.spdefense", (Object[])new Object[0]), 60, 69, hexColor);
        matrix.m_280488_(this.f_96541_.f_91062_, strSDEF, 200 - strSDEF.length() * 3, 69, hexColor);
        hexColor = this.pokemon.getNature().getIncreasedStat() == BattleStatsType.SPEED && !this.pokemon.isEgg() ? 65280 : (this.pokemon.getNature().getDecreasedStat() == BattleStatsType.SPEED && !this.pokemon.isEgg() ? 0xFF3030 : 0xFFFFFF);
        String strSPD = String.valueOf(this.pokemon.getStat(BattleStatsType.SPEED));
        if (this.pokemon.isEgg()) {
            strSPD = "???";
        }
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"nbt.speed", (Object[])new Object[0]), 60, 88, hexColor);
        matrix.m_280488_(this.f_96541_.f_91062_, strSPD, 200 - strSPD.length() * 3, 88, hexColor);
        hexColor = 0xFFFFFF;
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.happiness", (Object[])new Object[0]), 70, 113, hexColor);
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.nature", (Object[])new Object[0]), 157, 113, hexColor);
        matrix.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.growth", (Object[])new Object[0]), 8, 137, hexColor);
        if (!this.pokemon.isEgg()) {
            boolean hasMintNature;
            matrix.m_280137_(this.f_96541_.f_91062_, String.valueOf(this.pokemon.getFriendship()), 95, 132, hexColor);
            Nature nature = this.pokemon.getBaseNature();
            Nature mintNature = this.pokemon.getMintNature();
            boolean bl = hasMintNature = mintNature != null && mintNature != nature;
            if (hasMintNature) {
                matrix.m_280137_(this.f_96541_.f_91062_, mintNature.getLocalizedName(), 174, 145, 11927491);
            }
            matrix.m_280137_(this.f_96541_.f_91062_, nature.getLocalizedName(), 174, 132, -1);
            matrix.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)this.pokemon.getGrowth().getTranslationKey(), (Object[])new Object[0]), 8, 150, -1);
        } else {
            matrix.m_280137_(this.f_96541_.f_91062_, "???", 95, 132, hexColor);
            matrix.m_280137_(this.f_96541_.f_91062_, "???", 174, 132, -1);
            matrix.m_280137_(this.f_96541_.f_91062_, "???", 8, 150, -1);
        }
        this.drawBasePokemonInfo(matrix);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        matrix.m_280218_(Resources.summaryStats, (this.f_96543_ - this.xSize) / 2 - 40, (this.f_96544_ - this.ySize) / 2 - 25, 0, 0, 256, 205);
        this.drawPokemonName(matrix);
        this.drawArrows(matrix, mouseX, mouseY);
    }

    @Override
    public void drawHealthBar(GuiGraphics graphics, int x, int y, int width, int height, Pokemon pokemon) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        int barWidth = width - 6;
        VertexConsumer buffer = graphics.m_280091_().m_6299_(RenderType.m_285907_());
        graphics.m_280091_().m_6299_(RenderType.m_285907_()).m_5483_((double)x, (double)y, 0.0).m_85950_(1.0f, 0.2f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_85950_(1.0f, 0.2f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)(y + height), 0.0).m_85950_(1.0f, 0.2f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)y, 0.0).m_85950_(1.0f, 0.2f, 0.2f, 1.0f).m_5752_();
        barWidth = (int)((float)pokemon.getHealth() / (float)pokemon.getMaxHealth() * ((float)width - 6.0f));
        buffer.m_5483_((double)x, (double)y, 0.0).m_85950_(0.2f, 1.0f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_85950_(0.2f, 1.0f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)(y + height), 0.0).m_85950_(0.2f, 1.0f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)y, 0.0).m_85950_(0.2f, 1.0f, 0.2f, 1.0f).m_5752_();
        graphics.m_280091_().m_109911_();
        matrix.m_85849_();
    }
}

