/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.NuggetCondition;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerMovesScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerStatsScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerTMsScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerTabsScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerWarningLevelScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.RenamePokemonScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.ribbon.PokeCheckerRibbonsScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import java.awt.Color;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PokeCheckerScreen
extends Screen {
    private static final Color[] DYNAMAX_LEVELS = new Color[]{new Color(3601150), new Color(6941951), new Color(7984383), new Color(6142719), new Color(11375103), new Color(13274879), new Color(15948030), new Color(16662225), new Color(16721836), new Color(16654730)};
    protected int xSize = 176;
    protected int ySize = 166;
    protected int guiLeft;
    protected int guiTop;
    protected PokemonStorage storage;
    protected StoragePosition position;
    protected Pokemon pokemon;
    @Nullable
    protected Screen parent;
    private Button renameButton;

    public PokeCheckerScreen(PokemonStorage storage, StoragePosition position, @Nullable Screen parent) {
        super((Component)Component.m_237119_());
        this.storage = (PokemonStorage)Preconditions.checkNotNull((Object)storage);
        this.position = (StoragePosition)Preconditions.checkNotNull((Object)position);
        this.pokemon = (Pokemon)Preconditions.checkNotNull((Object)storage.get(position));
        this.parent = parent;
        this.renameButton = new IndexedButton(4, 0, 0, 50, 20, (Component)Component.m_237115_((String)"gui.screenpokechecker.rename"), this::actionPerformed);
        this.renameButton.f_93624_ = false;
    }

    protected PokeCheckerScreen(PokeCheckerScreen tab) {
        this(tab.storage, tab.position, tab.parent);
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.m_169413_();
        this.m_142416_((GuiEventListener)new PokeCheckerTabsScreen(3, 0, this.f_96543_ / 2 + 107, this.f_96544_ / 2 + 80, 17, 15, "", this::actionPerformed));
        this.m_142416_((GuiEventListener)new PokeCheckerTabsScreen(0, 1, this.f_96543_ / 2 - 34 - 89 - 4, this.f_96544_ / 2 + 80, 89, 15, I18n.m_118938_((String)"gui.screenpokechecker.summary", (Object[])new Object[0]), this::actionPerformed));
        this.m_142416_((GuiEventListener)new PokeCheckerTabsScreen(1, 2, this.f_96543_ / 2 - 34, this.f_96544_ / 2 + 80, 69, 15, I18n.m_118938_((String)"gui.screenpokechecker.moves", (Object[])new Object[0]), this::actionPerformed));
        this.m_142416_((GuiEventListener)new PokeCheckerTabsScreen(2, 3, this.f_96543_ / 2 + 36, this.f_96544_ / 2 + 80, 69, 15, I18n.m_118938_((String)"gui.screenpokechecker.stats", (Object[])new Object[0]), this::actionPerformed));
        this.m_142416_((GuiEventListener)new PokeCheckerTabsScreen(4, 5, this.f_96543_ / 2 - 44, this.f_96544_ / 2 - 107, 9, 9, "", this.pokemon, this::actionPerformed));
        this.m_142416_((GuiEventListener)new PokeCheckerTabsScreen(7, 6, this.f_96543_ / 2 - 44, this.f_96544_ / 2 - 1, 9, 8, "", this.pokemon, this::actionPerformed));
        this.m_142416_((GuiEventListener)this.renameButton);
        this.m_142416_((GuiEventListener)new PokeCheckerTabsScreen(8, 7, this.f_96543_ / 2 - 120, this.f_96544_ / 2 - 80, 14, 14, "", this::actionPerformed));
        this.m_142416_((GuiEventListener)new PokeCheckerTabsScreen(9, 8, this.f_96543_ / 2 - 56, this.f_96544_ / 2 - 80, 16, 14, "", this::actionPerformed));
    }

    public void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            switch (((IndexedButton)button).id) {
                case 0: {
                    this.m_7379_();
                    break;
                }
                case 1: {
                    this.f_96541_.m_91152_((Screen)new PokeCheckerScreen(this));
                    break;
                }
                case 2: {
                    this.f_96541_.m_91152_((Screen)new PokeCheckerMovesScreen(this));
                    break;
                }
                case 3: {
                    this.f_96541_.m_91152_((Screen)new PokeCheckerStatsScreen(this));
                    break;
                }
                case 4: {
                    if (!PixelmonConfigProxy.getGeneral().isAllowPokemonNicknames() || this.pokemon.isEgg()) break;
                    this.f_96541_.m_91152_((Screen)new RenamePokemonScreen(this));
                    break;
                }
                case 5: {
                    this.f_96541_.m_91152_((Screen)new PokeCheckerWarningLevelScreen(this));
                    break;
                }
                case 6: {
                    if (!PixelmonConfigProxy.getGeneral().isAllowPokemonNicknames() || this.pokemon.isEgg()) break;
                    this.f_96541_.m_91152_((Screen)new RenamePokemonScreen(this));
                    break;
                }
                case 7: {
                    this.f_96541_.m_91152_((Screen)new PokeCheckerTMsScreen(this));
                    break;
                }
                case 8: {
                    this.f_96541_.m_91152_((Screen)new PokeCheckerRibbonsScreen(this));
                }
            }
        }
    }

    public void m_280273_(GuiGraphics p_283688_, int p_299421_, int p_298679_, float p_297268_) {
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (keyCode == 256) {
            this.m_7379_();
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public void m_7379_() {
        if (this.parent == null) {
            this.f_96541_.f_91074_.m_6915_();
        } else {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseX > (double)((float)this.f_96543_ / 2.0f - 125.0f) && mouseX < (double)((float)this.f_96543_ / 2.0f - 40.0f) && mouseY > (double)((float)this.f_96544_ / 2.0f - 15.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f + 5.0f)) {
            if (mouseButton == 1) {
                this.renameButton.f_93624_ = true;
                this.renameButton.f_93620_ = (int)mouseX;
                this.renameButton.f_93621_ = (int)mouseY;
            } else {
                this.renameButton.f_93624_ = false;
            }
        }
        this.arrowsMouseClicked(mouseX, mouseY);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int i = this.guiLeft;
        int j = this.guiTop;
        this.drawGuiContainerBackgroundLayer(graphics, partialTicks, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        PoseStack matrix = graphics.m_280168_();
        graphics.m_280168_().m_85836_();
        matrix.m_252880_((float)i, (float)j, 0.0f);
        this.drawGuiContainerForegroundLayer(graphics, mouseX, mouseY);
        matrix.m_85849_();
    }

    public void drawGuiContainerForegroundLayer(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.pokemon.isEgg()) {
            graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getPokemonLevel(), 10, -14, 0xFFFFFF);
            graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + this.pokemon.getSpecies().getDex(), -30, -14, 0xFFFFFF);
            if (this.pokemon.isFainted()) {
                graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.fainted", (Object[])new Object[0]), 117, -13, 0xFFFFFF);
            } else {
                graphics.m_280137_(this.f_96541_.f_91062_, this.pokemon.getHealth() + "/" + this.pokemon.getMaxHealth(), 140, -14, 0xDDDDDD);
            }
        } else {
            graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???", 10, -14, 0xFFFFFF);
            graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???", -30, -14, 0xFFFFFF);
            graphics.m_280137_(this.f_96541_.f_91062_, "???/???", 140, -13, 0xDDDDDD);
        }
        graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.status", (Object[])new Object[0]), -9, 111, 0xFFFFFF);
        graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.texp", (Object[])new Object[0]), 107, 32, 0xFFFFFF);
        graphics.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.levelup", (Object[])new Object[0]), 134, 56, 0xFFFFFF);
        graphics.m_280137_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.dynamaxlevel", (Object[])new Object[0]), 134, 80, 0xFFFFFF);
        if (!this.pokemon.isEgg()) {
            String xp = String.valueOf(this.pokemon.getExperience());
            String xptl = String.valueOf(this.pokemon.getExperienceToLevelUp());
            graphics.drawString(this.f_96547_, xp, 135.0f - (float)this.f_96541_.f_91062_.m_92895_(xp) / 2.0f, 44.0f, 0xFFFFFF, true);
            graphics.drawString(this.f_96547_, xptl, 135.0f - (float)this.f_96541_.f_91062_.m_92895_(xptl) / 2.0f, 68.0f, 0xFFFFFF, true);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            for (int i = 0; i < 10; ++i) {
                float[] rgb;
                if (this.pokemon.getDynamaxLevel() > i) {
                    Color c = DYNAMAX_LEVELS[i];
                    rgb = new float[]{(float)c.getRed() / 256.0f, (float)c.getGreen() / 256.0f, (float)c.getBlue() / 256.0f};
                } else {
                    rgb = new float[]{0.5f, 0.5f, 0.5f};
                }
                ScreenHelper.drawImageQuad(Resources.parallelogram, graphics, 82 + i * 10, 91.0f, 13.0f, 13.0f, 0.0f, 0.0f, 1.0f, 1.0f, rgb[0], rgb[1], rgb[2], 1.0f, 0.0f);
            }
            RenderSystem.disableBlend();
        } else {
            graphics.m_280137_(this.f_96541_.f_91062_, "???", 135, 44, 0xFFFFFF);
            graphics.m_280137_(this.f_96541_.f_91062_, "???", 135, 68, 0xFFFFFF);
        }
        graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.ability", (Object[])new Object[0]), 75, 116, 0xFFFFFF);
        if (!this.pokemon.isEgg()) {
            try {
                graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)("ability." + this.pokemon.getAbility().getName()), (Object[])new Object[0]), 130, 116, 0xFFFFFF);
                ScreenHelper.drawSplitString(graphics, I18n.m_118938_((String)("ability." + this.pokemon.getAbility().getName() + ".description"), (Object[])new Object[0]), 62, 131, 145, 0xFFFFFF);
            }
            catch (Exception e) {
                graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"ability.ComingSoon", (Object[])new Object[0]), 130, 117, 0xFFFFFF);
                ScreenHelper.drawSplitString(graphics, I18n.m_118938_((String)"ability.ComingSoon.description", (Object[])new Object[0]), 62, 131, 145, 0xFFFFFF);
            }
        } else {
            graphics.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"ability.Egg", (Object[])new Object[0]), 130, 116, 0xFFFFFF);
            ScreenHelper.drawSplitString(graphics, I18n.m_118938_((String)this.pokemon.getEggDescription(), (Object[])new Object[0]), 62, 131, 145, 0xFFFFFF);
        }
        this.drawBasePokemonInfo(graphics);
    }

    protected void drawBasePokemonInfo(GuiGraphics graphics) {
        ScreenHelper.drawImageQuad(this.pokemon.getSprite(), graphics, -27.0f, 14.0f, 68.0f, 68.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (!this.pokemon.isEgg()) {
            Element type1 = this.pokemon.getForm().getTypes().get(0);
            Element type2 = this.pokemon.getForm().getTypes().size() > 1 ? this.pokemon.getForm().getTypes().get(1) : null;
            float x = type1.textureX;
            float y = type1.textureY;
            float x1 = 0.0f;
            float y1 = 0.0f;
            if (type2 != null) {
                x1 = type2.textureX;
                y1 = type2.textureY;
            }
            if (type2 != Element.MYSTERY && type2 != null) {
                ScreenHelper.drawImageQuadUV(Resources.types, graphics, 8.0f, 0.0f, 21.0f, 21.0f, x1, y1, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                ScreenHelper.drawImageQuadUV(Resources.types, graphics, -14.0f, 0.0f, 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else {
                ScreenHelper.drawImageQuadUV(Resources.types, graphics, -2.0f, 0.0f, 21.0f, 21.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            this.pokemon.getExtraStats(MeltanStats.class).ifPresent(stats -> this.pokemon.getForm().getFirstEvolutionConditionOfType(NuggetCondition.class).ifPresent(condition -> {
                ScreenHelper.drawItem(graphics, new ItemStack((ItemLike)Items.f_42749_), -33.0f, 16.0f, 770, 771);
                ScreenHelper.drawCenteredString(graphics, this.f_96547_, String.valueOf(stats.nuggetsFed), -24.5f, 31.0f, stats.nuggetsFed >= condition.nuggets ? 65280 : 0xFFFFFF, true);
            }));
        }
        if (this.pokemon.isShiny()) {
            ScreenHelper.drawImageQuad(Resources.shiny, graphics, -35.0f, 73.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
        if (this.pokemon.getPokerus() != null && !Objects.equals((Object)this.pokemon.getPokerus().type, (Object)PokerusStrain.UNINFECTED)) {
            ScreenHelper.drawImageQuad(this.pokemon.getPokerus().canInfect() ? Resources.pokerusInfectious : Resources.pokerusCured, graphics, 40.0f, 72.0f, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        RenderSystem.disableBlend();
    }

    public void drawGuiContainerBackgroundLayer(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        graphics.m_280218_(Resources.summarySummary, (this.f_96543_ - this.xSize) / 2 - 40, (this.f_96544_ - this.ySize) / 2 - 25, 0, 0, 256, 205);
        this.drawHealthBar(graphics, (this.f_96543_ - this.xSize) / 2 + 59, (this.f_96544_ - this.ySize) / 2 - 18, 154, 14, this.pokemon);
        graphics.m_280218_(Resources.summarySummary, (this.f_96543_ - this.xSize) / 2 + 59, (this.f_96544_ - this.ySize) / 2 - 18, 103, 222, 150, 16);
        this.drawExpBar(graphics, (this.f_96543_ - this.xSize) / 2 + 86, (this.f_96544_ - this.ySize) / 2, 122, 14, this.pokemon);
        graphics.m_280218_(Resources.summarySummary, (this.f_96543_ - this.xSize) / 2 + 59, (this.f_96544_ - this.ySize) / 2, 104, 239, 150, 16);
        float[] texturePair = StatusType.getTexturePos(this.pokemon.getStatus().type);
        float textureX1 = texturePair[0];
        float textureY1 = texturePair[1];
        if (textureX1 != -1.0f) {
            ScreenHelper.simpleDrawImageQuad(Resources.status, graphics, (float)(this.f_96543_ - this.xSize) / 2.0f - 6.0f, (float)(this.f_96544_ - this.ySize) / 2.0f + 130.0f, 24.0f, 24.0f, textureX1 / 768.0f, textureY1 / 768.0f, (textureX1 + 240.0f) / 768.0f, (textureY1 + 240.0f) / 768.0f, 0.0f);
        } else {
            ScreenHelper.simpleDrawImageQuad(Resources.status, graphics, (float)(this.f_96543_ - this.xSize) / 2.0f - 6.0f, (float)(this.f_96544_ - this.ySize) / 2.0f + 130.0f, 24.0f, 24.0f, 0.34375f, 0.34375f, 0.65625f, 0.65625f, 0.0f);
        }
        this.drawPokemonName(graphics);
        this.drawArrows(graphics, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected void drawPokemonName(GuiGraphics graphics) {
        if (this.pokemon.isEgg()) {
            this.drawCenteredStringWithoutShadow(graphics, "Egg", (this.f_96543_ - this.xSize) / 2 + 7, (this.f_96544_ - this.ySize) / 2 + 89, 0xFFFFFF);
        } else {
            int offset;
            int textSize = 0;
            int n = offset = this.pokemon.hasGigantamaxFactor() ? 9 : 0;
            if (this.pokemon.getFormattedNickname() != null) {
                String ogName = "(" + this.pokemon.getSpecies().getLocalizedName() + ")";
                this.drawCenteredStringWithoutShadow(graphics, ogName, (this.f_96543_ - this.xSize) / 2 + 7 + offset, (this.f_96544_ - this.ySize) / 2 + 93, 0xFFFFFF);
                this.drawCenteredStringWithoutShadow(graphics, this.pokemon.getFormattedNickname(), (this.f_96543_ - this.xSize) / 2 + 7 + offset, (this.f_96544_ - this.ySize) / 2 + 84, 0xFFFFFF);
                textSize = Math.max(this.f_96547_.m_92852_((FormattedText)this.pokemon.getFormattedNickname()), this.f_96547_.m_92895_(ogName));
            } else {
                this.drawCenteredStringWithoutShadow(graphics, this.pokemon.getFormattedDisplayName(), (this.f_96543_ - this.xSize) / 2 + 7 + offset, (this.f_96544_ - this.ySize) / 2 + 89, 0xFFFFFF);
                textSize = this.f_96547_.m_92852_((FormattedText)this.pokemon.getFormattedDisplayName());
            }
            if (this.pokemon.hasGigantamaxFactor()) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                ScreenHelper.drawImageQuad(Resources.gmaxFactor, graphics, (float)(this.f_96543_ - this.xSize) / 2.0f - (float)textSize / 2.0f - 3.0f, (float)(this.f_96544_ - this.ySize) / 2.0f + 84.0f, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }

    public void arrowsMouseClicked(double mouseX, double mouseY) {
        int l1 = (this.f_96543_ - this.xSize) / 2 + 220;
        int l2 = (this.f_96543_ - this.xSize) / 2 - 62;
        int w = 16;
        int t = (this.f_96544_ - this.ySize) / 2;
        int h = 21;
        if (mouseY > (double)t && mouseY < (double)(t + h)) {
            if (mouseX > (double)l1 && mouseX < (double)(l1 + w)) {
                SoundHelper.playButtonPressSound();
                this.setNextPokemon();
            }
            if (mouseX > (double)l2 && mouseX < (double)(l2 + w)) {
                SoundHelper.playButtonPressSound();
                this.setPrevPokemon();
            }
        }
    }

    private void setPrevPokemon() {
        Tuple<Pokemon, StoragePosition> previous = ClientStorageManager.getPrevious(this.storage, this.position);
        if (previous != null && previous.m_14418_() != null) {
            this.pokemon = (Pokemon)previous.m_14418_();
            this.position = (StoragePosition)previous.m_14419_();
        }
    }

    private void setNextPokemon() {
        Tuple<Pokemon, StoragePosition> previous = ClientStorageManager.getNext(this.storage, this.position);
        if (previous != null && previous.m_14418_() != null) {
            this.pokemon = (Pokemon)previous.m_14418_();
            this.position = (StoragePosition)previous.m_14419_();
        }
    }

    public void drawArrows(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.position.box != -1) {
            return;
        }
        int l1 = (this.f_96543_ - this.xSize) / 2 + 220;
        int l2 = (this.f_96543_ - this.xSize) / 2 - 62;
        int w = 16;
        int t = (this.f_96544_ - this.ySize) / 2;
        int h = 21;
        graphics.m_280218_(Resources.summaryMoves, l1, t, 24, 207, w, h);
        graphics.m_280218_(Resources.summaryMoves, l2, t, 42, 207, w, h);
        if (mouseY > t && mouseY < t + h) {
            if (mouseX > l1 && mouseX < l1 + w) {
                graphics.m_280218_(Resources.summaryMoves, l1, t, 60, 207, w, h);
            }
            if (mouseX > l2 && mouseX < l2 + w) {
                graphics.m_280218_(Resources.summaryMoves, l2, t, 78, 207, w, h);
            }
        }
    }

    private void drawExpBar(GuiGraphics graphics, int x, int y, int width, int height, Pokemon pokemon) {
        PoseStack matrix = graphics.m_280168_();
        matrix.m_85836_();
        int barWidth = !pokemon.isEgg() ? (int)(pokemon.getExperienceFraction() * ((float)width - 6.0f)) : (int)(0.0f * ((float)width - 6.0f));
        if (pokemon.getPokemonLevel() == PixelmonServerConfig.maxLevel) {
            barWidth = 0;
        }
        VertexConsumer buffer = graphics.m_280091_().m_6299_(RenderType.m_285907_());
        buffer.m_5483_((double)x, (double)y, 0.0).m_85950_(0.0f, 0.0f, 0.4f, 1.0f).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_85950_(0.0f, 0.0f, 0.4f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_85950_(0.0f, 0.0f, 0.4f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_85950_(0.0f, 0.0f, 0.4f, 1.0f).m_5752_();
        buffer.m_5483_((double)x, (double)y, 0.0).m_85950_(0.3f, 1.0f, 1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_85950_(0.3f, 1.0f, 1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)(y + height), 0.0).m_85950_(0.3f, 1.0f, 1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)y, 0.0).m_85950_(0.3f, 1.0f, 1.0f, 1.0f).m_5752_();
        graphics.m_280091_().m_109911_();
        matrix.m_85849_();
    }

    public void drawHealthBar(GuiGraphics matrix, int x, int y, int width, int height, Pokemon pokemon) {
        matrix.m_280168_().m_85836_();
        int barWidth = width - 6;
        VertexConsumer buffer = matrix.m_280091_().m_6299_(RenderType.m_285907_());
        buffer.m_5483_((double)x, (double)y, 0.0).m_85950_(1.0f, 0.2f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_85950_(1.0f, 0.2f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)(y + height), 0.0).m_85950_(1.0f, 0.2f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)y, 0.0).m_85950_(1.0f, 0.2f, 0.2f, 1.0f).m_5752_();
        float healthFraction = pokemon.isEgg() ? 1.0f : (float)pokemon.getHealth() / (float)pokemon.getMaxHealth();
        barWidth = (int)(healthFraction * ((float)width - 24.0f)) + 18;
        buffer.m_5483_((double)x, (double)y, 0.0).m_85950_(0.2f, 1.0f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_85950_(0.2f, 1.0f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)(y + height), 0.0).m_85950_(0.2f, 1.0f, 0.2f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + barWidth), (double)y, 0.0).m_85950_(0.2f, 1.0f, 0.2f, 1.0f).m_5752_();
        matrix.m_280091_().m_109911_();
        matrix.m_280168_().m_85849_();
    }

    public void drawCenteredStringWithoutShadow(GuiGraphics graphics, String text, int x, int y, int color) {
        graphics.drawString(this.f_96547_, text, (float)x - (float)this.f_96541_.f_91062_.m_92895_(text) / 2.0f, (float)y, color, true);
    }

    public void drawCenteredStringWithoutShadow(GuiGraphics graphics, Component text, int x, int y, int color) {
        graphics.drawString(this.f_96547_, text.m_7532_(), (float)x - (float)this.f_96541_.f_91062_.m_92852_((FormattedText)text) / 2.0f, (float)y, color, false);
    }

    public boolean m_7043_() {
        return false;
    }
}

