/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerScreen;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.PokeCheckerWarningDeleteMoveScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SwapMovePacket;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;

public class PokeCheckerMovesScreen
extends PokeCheckerScreen {
    private int selectedNumber = -1;
    private boolean move1 = true;
    private boolean move2 = false;
    private boolean move3 = false;
    private boolean move4 = false;

    PokeCheckerMovesScreen(PokeCheckerScreen tab) {
        super(tab);
    }

    public PokeCheckerMovesScreen(PokemonStorage storage, StoragePosition position, @Nullable Screen parent) {
        super(storage, position, parent);
    }

    public void resetAll() {
        this.move1 = false;
        this.move2 = false;
        this.move3 = false;
        this.move4 = false;
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics matrix, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (!this.pokemon.isEgg()) {
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getPokemonLevel(), 10, -14, 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + this.pokemon.getSpecies().getDex(), -30, -14, 0xFFFFFF);
            Moveset moveset = this.pokemon.getMoveset();
            for (int i2 = 0; i2 < moveset.size(); ++i2) {
                if (this.pokemon.getMoveset().get(i2) == null) continue;
                matrix.m_280137_(this.f_96541_.f_91062_, moveset.get(i2).getActualMove().getLocalizedName(), 130, -7 + i2 * 22, 0xFFFFFF);
                matrix.m_280137_(this.f_96541_.f_91062_, this.pokemon.getMoveset().get((int)i2).pp + "/" + this.pokemon.getMoveset().get(i2).getMaxPP(), 193, -5 + i2 * 22, 0xFFFFFF);
                float x = moveset.get((int)i2).getActualMove().getAttackType().textureX;
                float y = moveset.get((int)i2).getActualMove().getAttackType().textureY;
                ScreenHelper.drawImageQuadUV(Resources.types, matrix, 62.0f, 22 * i2 - 13, 18.0f, 18.0f, x, y, 240.0f, 240.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        } else {
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???", 10, -14, 0xFFFFFF);
            matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???", -30, -14, 0xFFFFFF);
        }
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.screenpokechecker.effects", (Object[])new Object[0]), -10, 111, 0xFFFFFF);
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.battle.description", (Object[])new Object[0]), 107, 98, 0xFFFFFF);
        this.drawSelection(matrix, mouseX, mouseY);
        this.drawSelectedRectBin(matrix, mouseX, mouseY);
        this.drawMoveDescription(matrix);
        this.drawBasePokemonInfo(matrix);
        RenderSystem.disableBlend();
    }

    public void drawMoveDescription(GuiGraphics matrix) {
        if (!this.pokemon.isEgg()) {
            if (this.move1 && this.pokemon.getMoveset().size() > 0) {
                this.drawMoveInfo(matrix, this.pokemon.getMoveset().get(0));
            }
            if (this.move2 && this.pokemon.getMoveset().size() > 1) {
                this.drawMoveInfo(matrix, this.pokemon.getMoveset().get(1));
            }
            if (this.move3 && this.pokemon.getMoveset().size() > 2) {
                this.drawMoveInfo(matrix, this.pokemon.getMoveset().get(2));
            }
            if (this.move4 && this.pokemon.getMoveset().size() > 3) {
                this.drawMoveInfo(matrix, this.pokemon.getMoveset().get(3));
            }
        }
    }

    public void switchMoves(int moveToChange2) {
        NetworkHelper.sendToServer(new SwapMovePacket(this.position, this.pokemon.getUUID(), this.selectedNumber, moveToChange2));
        this.selectedNumber = -1;
    }

    private void drawMoveInfo(GuiGraphics matrix, Attack attack) {
        if (attack == null) {
            return;
        }
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.battle.power", (Object[])new Object[0]) + ":", -30, 128, 0xFFFFFF);
        matrix.m_280488_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.battle.accuracy", (Object[])new Object[0]) + ":", -30, 138, 0xFFFFFF);
        int bpExtra = 0;
        int acExtra = 0;
        if (attack.getActualMove().getBasePower() >= 100) {
            bpExtra = this.f_96541_.f_91062_.m_92895_("0");
        }
        if (attack.getActualMove().getAccuracy() >= 100) {
            acExtra = this.f_96541_.f_91062_.m_92895_("0");
        }
        if (attack.getActualMove().getBasePower() > 0) {
            matrix.m_280488_(this.f_96541_.f_91062_, "" + attack.getActualMove().getBasePower(), 30 - bpExtra, 128, 0xFFFFFF);
        } else {
            matrix.m_280488_(this.f_96541_.f_91062_, "--", 30 - bpExtra, 128, 0xFFFFFF);
        }
        if (attack.getActualMove().getAccuracy() <= 0) {
            matrix.m_280488_(this.f_96541_.f_91062_, "--", 30 - acExtra, 138, 0xFFFFFF);
        } else {
            matrix.m_280488_(this.f_96541_.f_91062_, "" + attack.getActualMove().getAccuracy(), 30 - acExtra, 138, 0xFFFFFF);
        }
        matrix.m_280488_(this.f_96541_.f_91062_, attack.getActualMove().getAttackCategory().getLocalizedName(), -30, 148, 0xFFFFFF);
        ScreenHelper.drawSplitString(matrix, I18n.m_118938_((String)("attack." + attack.getActualMove().getAttackName().replace(" ", "_").toLowerCase(Locale.ROOT) + ".description"), (Object[])new Object[0]), 60, 113, 145, 0xFFFFFF);
    }

    public void drawSelection(GuiGraphics matrix, int i, int i1) {
        if (this.pokemon.getMoveset().size() > 0 && i > this.f_96543_ / 2 - 31 && i < this.f_96543_ / 2 + 123 && i1 > this.f_96544_ / 2 - 100 && i1 < this.f_96544_ / 2 - 76 || this.move1) {
            matrix.m_280218_(Resources.summaryMoves, 58, -17, 1, 231, 153, 24);
            this.resetAll();
            this.move1 = true;
        }
        if (this.pokemon.getMoveset().size() > 1 && i > this.f_96543_ / 2 - 31 && i < this.f_96543_ / 2 + 123 && i1 > this.f_96544_ / 2 - 77 && i1 < this.f_96544_ / 2 - 53 || this.move2) {
            matrix.m_280218_(Resources.summaryMoves, 58, 6, 1, 231, 153, 24);
            this.resetAll();
            this.move2 = true;
        }
        if (this.pokemon.getMoveset().size() > 2 && i > this.f_96543_ / 2 - 31 && i < this.f_96543_ / 2 + 123 && i1 > this.f_96544_ / 2 - 54 && i1 < this.f_96544_ / 2 - 31 || this.move3) {
            matrix.m_280218_(Resources.summaryMoves, 58, 28, 1, 231, 153, 24);
            this.resetAll();
            this.move3 = true;
        }
        if (this.pokemon.getMoveset().size() > 3 && i > this.f_96543_ / 2 - 31 && i < this.f_96543_ / 2 + 123 && i1 > this.f_96544_ / 2 - 32 && i1 < this.f_96544_ / 2 - 9 || this.move4) {
            matrix.m_280218_(Resources.summaryMoves, 58, 50, 1, 231, 153, 24);
            this.resetAll();
            this.move4 = true;
        }
        this.drawSelectedRect(matrix);
    }

    protected void drawSelectedRect(GuiGraphics matrix) {
        matrix.m_280246_(0.0f, 1.0f, 0.0f, 1.0f);
        if (this.selectedNumber == 0) {
            matrix.m_280218_(Resources.summaryMoves, 58, -17, 1, 231, 153, 24);
        } else if (this.selectedNumber == 1) {
            matrix.m_280218_(Resources.summaryMoves, 58, 6, 1, 231, 153, 24);
        } else if (this.selectedNumber == 2) {
            matrix.m_280218_(Resources.summaryMoves, 58, 28, 1, 231, 153, 24);
        } else if (this.selectedNumber == 3) {
            matrix.m_280218_(Resources.summaryMoves, 58, 50, 1, 231, 153, 24);
        }
        matrix.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void drawSelectedRectBin(GuiGraphics matrix, int i, int i1) {
        matrix.m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
        if (this.selectedNumber >= this.pokemon.getMoveset().size() && i > this.f_96543_ / 2 + 130 && i < this.f_96543_ / 2 + 158 && i1 > this.f_96544_ / 2 - 25 && i1 < this.f_96544_ / 2 + 9) {
            matrix.m_280218_(Resources.summaryMoves, 220, 60, 230, 225, 26, 31);
        }
        matrix.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected int moveClicked(double i, double i1) {
        if (this.pokemon.isEgg()) {
            return -1;
        }
        if (this.pokemon.getMoveset().size() > 0 && i > (double)((float)this.f_96543_ / 2.0f - 31.0f) && i < (double)((float)this.f_96543_ / 2.0f + 123.0f) && i1 > (double)((float)this.f_96544_ / 2.0f - 100.0f) && i1 < (double)((float)this.f_96544_ / 2.0f - 76.0f)) {
            return 0;
        }
        if (this.pokemon.getMoveset().size() > 1 && i > (double)((float)this.f_96543_ / 2.0f - 31.0f) && i < (double)((float)this.f_96543_ / 2.0f + 123.0f) && i1 > (double)((float)this.f_96544_ / 2.0f - 77.0f) && i1 < (double)((float)this.f_96544_ / 2.0f - 53.0f)) {
            return 1;
        }
        if (this.pokemon.getMoveset().size() > 2 && i > (double)((float)this.f_96543_ / 2.0f - 31.0f) && i < (double)((float)this.f_96543_ / 2.0f + 123.0f) && i1 > (double)((float)this.f_96544_ / 2.0f - 54.0f) && i1 < (double)((float)this.f_96544_ / 2.0f - 31.0f)) {
            return 2;
        }
        if (this.pokemon.getMoveset().size() > 3 && i > (double)((float)this.f_96543_ / 2.0f - 31.0f) && i < (double)((float)this.f_96543_ / 2.0f + 123.0f) && i1 > (double)((float)this.f_96544_ / 2.0f - 32.0f) && i1 < (double)((float)this.f_96544_ / 2.0f - 9.0f)) {
            return 3;
        }
        return -1;
    }

    protected void attackClicked(double i, double i1) {
    }

    protected void selectMove(double i, double i1) {
        if (i > (double)(this.f_96543_ / 2 - 31) && i < (double)(this.f_96543_ / 2 + 123) && i1 > (double)(this.f_96544_ / 2 - 100) && i1 < (double)(this.f_96544_ / 2 - 9) && this.selectedNumber != this.moveClicked(i, i1)) {
            if (this.selectedNumber == -1) {
                this.selectedNumber = this.moveClicked(i, i1);
            } else if (this.moveClicked(i, i1) != -1) {
                this.switchMoves(this.moveClicked(i, i1));
            }
        } else {
            this.selectedNumber = -1;
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.canDeleteMove() && this.selectedNumber >= 0 && mouseX > (double)((float)this.f_96543_ / 2.0f + 130.0f) && mouseX < (double)((float)this.f_96543_ / 2.0f + 158.0f) && mouseY > (double)((float)this.f_96544_ / 2.0f - 25.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f + 9.0f)) {
            this.f_96541_.m_91152_((Screen)new PokeCheckerWarningDeleteMoveScreen(this, this.pokemon, this.selectedNumber));
        }
        if (!this.pokemon.isEgg()) {
            this.attackClicked(mouseX, mouseY);
            this.selectMove(mouseX, mouseY);
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    private boolean canDeleteMove() {
        return this.pokemon.getMoveset().size() > 1;
    }

    @Override
    public void drawGuiContainerBackgroundLayer(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        matrix.m_280218_(Resources.summaryMoves, (this.f_96543_ - this.xSize) / 2 - 40, (this.f_96544_ - this.ySize) / 2 - 25, 0, 0, 256, 205);
        if (this.selectedNumber >= 0 && this.canDeleteMove()) {
            matrix.m_280218_(Resources.summaryMoves, (this.f_96543_ - this.xSize) / 2 + 220, (this.f_96544_ - this.ySize) / 2 + 60, 203, 225, 26, 31);
        }
        this.drawPokemonName(matrix);
        this.drawArrows(matrix, mouseX, mouseY);
    }
}

