/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.HideMouse;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.PokeCheckerButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ServerSwapPacket;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class PokemonScreen
extends Screen
implements HideMouse {
    protected static final int SLOT_WIDTH = 30;
    protected static final int SLOT_HEIGHT = 28;
    protected static final int PC_NUM_WIDTH = 6;
    protected static final int PC_NUM_HEIGHT = 5;
    protected int pcLeft;
    protected int pcRight;
    protected int pcTop;
    protected int pcBottom;
    protected PCStorage storage;
    protected int boxNumber;
    protected StoragePosition selected;
    protected Pokemon selectedPokemon = null;
    protected int footerLeft;
    protected int footerRight;
    protected int footerTop;
    protected int footerBottom;
    private PokeCheckerButton pokeChecker = new PokeCheckerButton(this);

    public PokemonScreen(@Nullable StoragePosition selected) {
        super((Component)Component.m_237119_());
        this.updateStorage(ClientStorageManager.openPC, selected);
    }

    protected void updateSelected(StoragePosition selected) {
        this.selected = selected;
        this.selectedPokemon = this.getPokemon(selected);
    }

    protected void updateStorage(PCStorage storage, @Nullable StoragePosition selected) {
        this.storage = storage;
        this.updateSelected(selected);
        this.boxNumber = this.selected == null ? storage.getLastBox() : this.selected.box;
    }

    protected PokemonStorage getStorage(StoragePosition position) {
        if (position == null) {
            return null;
        }
        if (position.box == -1) {
            return ClientStorageManager.party;
        }
        return this.storage;
    }

    protected Pokemon getPokemon(StoragePosition position) {
        if (position == null) {
            return null;
        }
        if (position.box == -1) {
            return ClientStorageManager.party.get(position);
        }
        return this.storage.get(position);
    }

    public void m_7856_() {
        super.m_7856_();
        this.pcLeft = this.f_96543_ / 2 - 90;
        this.pcRight = this.pcLeft + 180;
        this.pcTop = this.f_96544_ / 6 - 5;
        this.pcBottom = this.pcTop + 140;
        this.footerLeft = this.f_96543_ / 2 - 90;
        this.footerRight = this.footerLeft + this.getFooterNumWidth() * 30;
        this.footerTop = this.f_96544_ / 6 + 157;
        this.footerBottom = this.footerTop + 28;
    }

    protected int getFooterNumWidth() {
        return 6;
    }

    public Pokemon getSlotAt(int x, int y) {
        Pokemon pokemon = this.getPCAt(x, y);
        return pokemon == null ? this.getFooterAt(x, y) : pokemon;
    }

    public StoragePosition getPosAt(double x, double y) {
        StoragePosition pos = this.getPCPosAt(x, y);
        return pos == null ? this.getFooterPosAt(x, y) : pos;
    }

    protected StoragePosition getFooterPosAt(double x, double y) {
        if (x >= (double)this.footerLeft && x < (double)this.footerRight && y >= (double)(this.footerTop + 3) && y <= (double)(this.footerBottom + 3)) {
            double xInd = (x - (double)this.footerLeft) / 30.0;
            return new StoragePosition(-1, Math.min((int)Math.floor(xInd), 5));
        }
        return null;
    }

    protected StoragePosition getPCPosAt(double x, double y) {
        if (x >= (double)this.pcLeft && x < (double)this.pcRight && y >= (double)(this.pcTop + 5) && y <= (double)(this.pcBottom + 5)) {
            double xInd = (x - (double)this.pcLeft) / 30.0;
            double yInd = (y - ((double)this.pcTop + 5.0)) / 28.0;
            int ind = (int)Math.floor(yInd) * 6 + (int)Math.floor(xInd);
            return new StoragePosition(this.boxNumber, ind > 29 ? 29 : ind);
        }
        return null;
    }

    protected Pokemon getFooterAt(double x, double y) {
        if (x >= (double)this.footerLeft && x < (double)this.footerRight && y >= (double)(this.footerTop + 3) && y <= (double)(this.footerBottom + 3)) {
            double xInd = (x - (double)this.footerLeft) / 30.0;
            return this.getFooterAt((int)Math.floor(xInd));
        }
        return null;
    }

    protected Pokemon getFooterAt(int index) {
        return ClientStorageManager.party.get(index);
    }

    protected Pokemon getPCAt(int x, int y) {
        if (x >= this.pcLeft && x < this.pcRight && y >= this.pcTop + 5 && y <= this.pcBottom + 5) {
            double xInd = ((double)x - (double)this.pcLeft) / 30.0;
            double yInd = ((double)y - ((double)this.pcTop + 5.0)) / 28.0;
            int ind = (int)Math.floor(yInd) * 6 + (int)Math.floor(xInd);
            if (ind > 29) {
                return null;
            }
            return this.storage.get(this.boxNumber, ind);
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        StoragePosition position = this.getPosAt(mouseX, mouseY);
        Pokemon pokemon = this.getPokemon(position);
        if (this.pokeChecker.m_5953_(mouseX, mouseY)) {
            if (mouseButton == 0) {
                this.pokeChecker.m_6375_(mouseX, mouseY, mouseButton);
            }
            return false;
        }
        if (this.selected == null) {
            if (mouseButton == 1) {
                this.pokeChecker.setPokemon(this.getStorage(position), position, pokemon, mouseX, mouseY);
            } else {
                this.pokeChecker.setPokemon(null, null, null, mouseX, mouseY);
            }
        }
        if (mouseButton == 0 && position != null && !ClientStorageManager.party.inTemporaryMode()) {
            if (pokemon != null && position.equals(this.selected)) {
                this.updateSelected(null);
            } else if (pokemon != null && this.selected == null) {
                if (Screen.m_96638_()) {
                    if (position.box != -1 || pokemon.isEgg() || ClientStorageManager.party.countPokemon() > 1) {
                        PokemonStorage destination = position.box == -1 ? ClientStorageManager.openPC : ClientStorageManager.party;
                        StoragePosition slot = (position.box == -1 ? this.storage.getBox(this.boxNumber) : ClientStorageManager.party).getFirstEmptyPosition();
                        if (slot != null) {
                            this.tryToSwap(this.getStorage(position), position, destination, slot);
                        }
                    }
                } else {
                    this.updateSelected(position);
                }
            } else if (this.selected != null && this.selectedPokemon == null) {
                this.updateSelected(this.selected);
                if (this.selectedPokemon == null) {
                    this.updateSelected(null);
                }
            } else if (this.selected != null) {
                if (this.selected.box == -1 && position.box != -1 || this.selected.box != -1 && position.box == -1) {
                    boolean targetIsEggOrBlank;
                    boolean selectedIsEgg = this.selectedPokemon.isEgg();
                    boolean bl = targetIsEggOrBlank = this.getPokemon(position) == null || this.getPokemon(position).isEgg();
                    if (selectedIsEgg != targetIsEggOrBlank && (selectedIsEgg && position.box == -1 || targetIsEggOrBlank && this.selected.box == -1) && ClientStorageManager.party.countPokemon() <= 1) {
                        return false;
                    }
                }
                if (this.tryToSwap(this.getStorage(this.selected), this.selected, this.getStorage(position), position)) {
                    this.updateSelected(null);
                }
            }
        }
        return true;
    }

    protected boolean tryToSwap(PokemonStorage from, StoragePosition fromPosition, PokemonStorage to, StoragePosition toPosition) {
        StoragePosition toOriginalPosition;
        Pokemon fromPokemon = from.get(fromPosition);
        Pokemon toPokemon = to.get(toPosition);
        StoragePosition fromOriginalPosition = fromPokemon == null ? fromPosition : fromPokemon.getPosition();
        StoragePosition storagePosition = toOriginalPosition = toPokemon == null ? toPosition : toPokemon.getPosition();
        if (to.transfer(from, fromPosition, toPosition)) {
            NetworkHelper.sendToServer(new ServerSwapPacket(fromOriginalPosition, fromPokemon, toOriginalPosition, toPokemon));
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.getKey().m_84873_() == keyCode && this.f_96541_.f_91066_.f_92092_.m_90859_()) {
            this.f_96541_.m_91152_(null);
            if (this.f_96541_.f_91080_ == null) {
                this.f_96541_.m_7440_(true);
            }
        } else {
            super.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        PixelmonOverlayScreen.checkSelection();
    }

    protected void drawBox(GuiGraphics matrix) {
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 5; ++y) {
                int slot = y * 6 + x;
                Pokemon pokemon = this.storage.get(this.boxNumber, slot);
                if (pokemon == null || this.selected != null && this.selected.box == this.boxNumber && this.selected.order == slot) continue;
                int xPos = this.pcLeft + x * 30;
                int yPos = this.pcTop + y * 28;
                ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, xPos + 2, yPos + 6, 26.0f, 26.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                if (!pokemon.getHeldItem().m_41619_()) {
                    ScreenHelper.drawImageQuad(Resources.heldItem, matrix, xPos + 21, yPos + 25, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (!ClientStorageManager.party.inTemporaryMode()) continue;
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, xPos, yPos + 25, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 1.0f);
            }
        }
    }

    protected void drawFooter(GuiGraphics matrix) {
        this.drawFooterBackground(matrix);
        for (int x = 0; x < this.getFooterNumWidth(); ++x) {
            Pokemon pokemon = this.getFooterAt(x);
            if (pokemon == null || this.selected != null && this.selected.box == -1 && this.selected.order == x) continue;
            int xPos = this.footerLeft + x * 30;
            int yPos = this.footerTop;
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, xPos + 2, yPos + 3, 26.0f, 26.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!pokemon.getHeldItem().m_41619_()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, xPos + 18, yPos + 22, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (!ClientStorageManager.party.inTemporaryMode()) continue;
            Color color = ClientStorageManager.party.getTempPartyColor();
            ScreenHelper.drawImageQuad(Resources.padlock, matrix, xPos, yPos + 23, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 1.0f);
        }
    }

    protected void drawFooterBackground(GuiGraphics matrix) {
        matrix.m_280218_(Resources.pcResources, this.f_96543_ / 2 - 91, this.f_96544_ / 6 + 160, 0, 0, 182, 29);
    }

    protected void drawPokeChecker(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        this.pokeChecker.m_88315_(matrix, mouseX, mouseY, partialTicks);
    }

    protected void drawHover(GuiGraphics matrix, int mouseX, int mouseY) {
        Pokemon pokemon;
        if (!this.pokeChecker.m_5953_(mouseX, mouseY) && (pokemon = this.getSlotAt(mouseX, mouseY)) != null && !pokemon.equals(this.selectedPokemon)) {
            ScreenHelper.drawPokemonHoverInfo(matrix, pokemon, mouseX, mouseY);
        }
    }

    protected void drawCursor(GuiGraphics matrix, int mouseX, int mouseY) {
        if (this.selectedPokemon == null) {
            ScreenHelper.drawImageQuad(Resources.pcPointer, matrix, mouseX, mouseY - 19, 19.0f, 21.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 100.0f);
        } else {
            ScreenHelper.drawImageQuad(this.selectedPokemon.getSprite(), matrix, mouseX - 13, mouseY - 13 - (this.selectedPokemon.getSpecies().getGeneration() == 6 ? -3 : 0), 26.0f, 26.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            if (!this.selectedPokemon.getHeldItem().m_41619_()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, mouseX + 6, mouseY + 6, 8.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            ScreenHelper.drawImageQuad(Resources.pcPointerGrabbed, matrix, mouseX, mouseY - 18, 17.0f, 18.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

