/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PCStorageSearch;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.pc.PokemonScreen;
import com.pixelmonmod.pixelmon.client.gui.pc.ReleaseWarningScreen;
import com.pixelmonmod.pixelmon.client.gui.pc.TrashCanButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.ArrowButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.ImageClickableButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.KeybindIcon;
import com.pixelmonmod.pixelmon.client.listener.WallpapersListener;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ServerSetLastOpenBoxPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class PCScreen
extends PokemonScreen {
    public static PCStorageSearch search;
    protected ImageClickableButton leftArrow;
    protected ImageClickableButton rightArrow;
    protected ImageClickableButton boxButton;
    protected ArrowButton leftArrowWallpaper;
    protected ArrowButton rightArrowWallpaper;
    protected EditBox nameField;
    protected EditBox searchField;
    protected List<KeybindIcon> icons = new ArrayList<KeybindIcon>();
    protected KeybindIcon searchIcon;
    protected KeybindIcon renameIcon;
    protected KeybindIcon wallpaperIcon = new KeybindIcon(ClientProxy.pcWallpaperKeyBind, Resources.pcWallpaperIcon);
    protected ResourceLocation boxWallpaper;
    private int normalBoxCount;
    private boolean blockTyping = false;

    public PCScreen(@Nullable StoragePosition selected) {
        super(selected);
        this.icons.add(this.wallpaperIcon);
        this.renameIcon = new KeybindIcon(ClientProxy.pcRenameKeyBind, Resources.pcRenameIcon);
        this.icons.add(this.renameIcon);
        this.searchIcon = new KeybindIcon(ClientProxy.pcSearchKeyBind, Resources.pcSearchIcon);
        this.icons.add(this.searchIcon);
        this.leftArrow = new ImageClickableButton(0, 0, 0, 0, 186, 17, 23, this::actionPerformed);
        this.rightArrow = new ImageClickableButton(1, 0, 0, 143, 186, 17, 23, this::actionPerformed);
        this.boxButton = new ImageClickableButton(2, 0, 0, 22, 186, 116, 23, this::actionPerformed);
        this.boxButton.f_93623_ = false;
        this.leftArrowWallpaper = new ArrowButton(4, 0, 0, ArrowButton.Direction.LEFT, this::actionPerformed);
        this.leftArrowWallpaper.f_93623_ = false;
        this.leftArrowWallpaper.f_93624_ = false;
        this.rightArrowWallpaper = new ArrowButton(5, 0, 0, ArrowButton.Direction.RIGHT, this::actionPerformed);
        this.rightArrowWallpaper.f_93623_ = false;
        this.rightArrowWallpaper.f_93624_ = false;
        this.nameField = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 116, 23, (Component)Component.m_237119_());
        this.nameField.m_94202_(0xFFFFFF);
        this.nameField.m_94199_(17);
        this.nameField.m_94182_(false);
        this.nameField.m_94190_(false);
        this.nameField.m_94194_(false);
        this.searchField = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 114, 23, (Component)Component.m_237119_());
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94199_(35);
        this.searchField.m_94194_(false);
        this.updateBox(this.boxNumber);
    }

    public PCScreen() {
        this(null);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.m_142416_((GuiEventListener)this.leftArrow.updatePosition(this.f_96543_ / 2 - 80, this.f_96544_ / 6 - 21));
        this.m_142416_((GuiEventListener)this.rightArrow.updatePosition(this.f_96543_ / 2 + 63, this.f_96544_ / 6 - 21));
        this.m_142416_((GuiEventListener)this.boxButton.updatePosition(this.f_96543_ / 2 - 58, this.f_96544_ / 6 - 21));
        this.m_142416_((GuiEventListener)new TrashCanButton(this, 3, this.f_96543_ / 2 + 111, this.f_96544_ / 6 + 110, this::actionPerformed));
        this.m_142416_((GuiEventListener)this.leftArrowWallpaper.updatePosition(this.f_96543_ / 2 - 125, this.f_96544_ / 6 + 58));
        this.m_142416_((GuiEventListener)this.rightArrowWallpaper.updatePosition(this.f_96543_ / 2 + 108, this.f_96544_ / 6 + 58));
        this.nameField.f_93620_ = this.f_96543_ / 2 - 51;
        this.nameField.f_93621_ = this.f_96544_ / 6 - 14;
        this.m_142416_((GuiEventListener)this.nameField);
        this.searchField.f_93620_ = this.f_96543_ / 2 - 57;
        this.searchField.f_93621_ = this.f_96544_ / 6 - 20;
        this.searchField.m_94151_(s -> {
            if (s.isEmpty()) {
                return;
            }
            if (this.boxNumber != 0) {
                this.updateBox(0);
            }
            search.query((String)s);
        });
        this.m_142416_((GuiEventListener)this.searchField);
        PixelmonOverlayScreen.ICONS.forEach(icon -> icon.setEnabled(false));
    }

    private void updateBox(int boxNumber) {
        int oldBox = this.boxNumber;
        this.boxNumber = boxNumber;
        if (this.boxNumber < 0) {
            this.boxNumber = this.storage.getBoxCount() - 1;
        } else if (this.boxNumber >= this.storage.getBoxCount()) {
            this.boxNumber = 0;
        }
        this.storage.setLastBox(this.boxNumber);
        PCBox data = this.storage.getBox(this.boxNumber);
        this.updateName(data);
        this.updateWallpaper(data);
        if (oldBox != boxNumber) {
            this.leftArrowWallpaper.f_93623_ = false;
            this.leftArrowWallpaper.f_93624_ = false;
            this.rightArrowWallpaper.f_93623_ = false;
            this.rightArrowWallpaper.f_93624_ = false;
        }
    }

    protected void updateName(PCBox data) {
        this.boxButton.m_93666_((Component)(data.getName() == null ? Component.m_237110_((String)"gui.pc.box", (Object[])new Object[]{this.boxNumber + 1}) : Component.m_237113_((String)data.getName())));
    }

    protected void updateWallpaper(PCBox data) {
        if (!WallpapersListener.hasWallpaper(data.getWallpaper())) {
            data.setWallpaper(null);
        }
        this.boxWallpaper = WallpapersListener.getWallpaper(data.getWallpaper());
        this.leftArrow.setImage(this.boxWallpaper);
        this.rightArrow.setImage(this.boxWallpaper);
        this.boxButton.setImage(this.boxWallpaper);
    }

    protected void switchWallpaper(boolean forward) {
        PCBox data = this.storage.getBox(this.boxNumber);
        int index = (data.getWallpaper() == null ? 0 : WallpapersListener.getWallpapers().indexOf(data.getWallpaper())) + (forward ? 1 : -1);
        if (index < 0) {
            index = WallpapersListener.getWallpapers().size() - 1;
        } else if (index >= WallpapersListener.getWallpapers().size()) {
            index = 0;
        }
        data.setWallpaper(WallpapersListener.getWallpapers().get(index));
        this.updateWallpaper(data);
    }

    public boolean m_7043_() {
        return false;
    }

    public void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            switch (((IndexedButton)button).id) {
                case 0: {
                    this.updateBox(this.boxNumber - 1);
                    break;
                }
                case 1: {
                    this.updateBox(this.boxNumber + 1);
                    break;
                }
                case 3: {
                    this.f_96541_.m_91152_((Screen)new ReleaseWarningScreen(this));
                    break;
                }
                case 4: {
                    this.switchWallpaper(false);
                    break;
                }
                case 5: {
                    this.switchWallpaper(true);
                }
            }
        }
    }

    private void closeSearch() {
        search = null;
        this.searchField.m_93692_(false);
        this.searchField.m_94194_(false);
        this.updateStorage(ClientStorageManager.openPC, this.selectedPokemon == null ? null : this.selectedPokemon.getPosition());
        this.updateBox(this.normalBoxCount);
    }

    private void closeName(boolean save) {
        if (save) {
            this.leftArrow.f_93623_ = true;
            this.rightArrow.f_93623_ = true;
            PCBox data = this.storage.getBox(this.boxNumber);
            data.setName(this.nameField.m_94155_().equals(I18n.m_118938_((String)"gui.pc.box", (Object[])new Object[]{this.boxNumber + 1})) ? null : this.nameField.m_94155_());
            this.updateName(data);
            this.nameField.m_94194_(false);
            this.searchField.m_93692_(false);
        } else {
            this.leftArrow.f_93623_ = true;
            this.rightArrow.f_93623_ = true;
            this.updateName(this.storage.getBox(this.boxNumber));
            this.nameField.m_94194_(false);
            this.searchField.m_93692_(false);
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchField.m_94213_()) {
            if (keyCode == 256) {
                this.closeSearch();
                return false;
            }
            if (keyCode == 257) {
                this.searchField.m_93692_(false);
                return false;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.nameField.m_94213_()) {
            if (keyCode == 256) {
                this.closeName(false);
                return false;
            }
            if (keyCode == 257) {
                this.closeName(true);
                return false;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        if (keyCode == ClientProxy.pcSearchKeyBind.getKey().m_84873_()) {
            if (!this.searchField.m_94213_()) {
                this.searchField.m_94194_(true);
                this.searchField.m_94144_("");
                this.searchField.m_93692_(true);
                this.boxButton.m_93666_((Component)Component.m_237119_());
                this.m_7522_((GuiEventListener)this.searchField);
                this.updateSelected(null);
                search = new PCStorageSearch(6, 5);
                this.updateStorage(search, this.selected);
                this.normalBoxCount = this.boxNumber;
                this.updateBox(this.boxNumber);
                this.boxButton.m_93666_((Component)Component.m_237119_());
                this.blockTyping = true;
                return true;
            }
        } else if (keyCode == ClientProxy.pcRenameKeyBind.getKey().m_84873_()) {
            if (!this.nameField.m_94213_()) {
                this.leftArrow.f_93623_ = false;
                this.rightArrow.f_93623_ = false;
                this.nameField.m_94194_(true);
                this.nameField.m_94144_(this.boxButton.m_6035_().getString());
                this.boxButton.m_93666_((Component)Component.m_237119_());
                this.nameField.m_93692_(true);
                this.m_7522_((GuiEventListener)this.nameField);
                this.blockTyping = true;
            }
        } else if (keyCode == ClientProxy.pcWallpaperKeyBind.getKey().m_84873_()) {
            boolean state;
            this.leftArrowWallpaper.f_93623_ = state = !this.leftArrowWallpaper.f_93623_;
            this.leftArrowWallpaper.f_93624_ = state;
            this.rightArrowWallpaper.f_93623_ = state;
            this.rightArrowWallpaper.f_93624_ = state;
            if (!state) {
                Arrays.stream(ClientStorageManager.openPC.getBoxes()).forEach(PCBox::sendChangesToServer);
            }
        } else if (keyCode == 263) {
            this.switchOrSound(this.leftArrowWallpaper.f_93623_ ? this.leftArrowWallpaper : this.leftArrow);
        } else if (keyCode == 262) {
            this.switchOrSound(this.rightArrowWallpaper.f_93623_ ? this.rightArrowWallpaper : this.rightArrow);
        } else {
            if (keyCode == 256) {
                this.f_96541_.m_91152_(null);
                return true;
            }
            super.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private void press(Button button) {
        if (button.f_93623_) {
            this.actionPerformed(button);
            button.m_7435_(this.f_96541_.m_91106_());
        }
    }

    private void switchOrSound(Button button) {
        if (this.storage.getBoxCount() > 1) {
            this.press(button);
        } else {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.nameField.m_6375_(mouseX, mouseY, mouseButton);
        this.searchField.m_6375_(mouseX, mouseY, mouseButton);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    public void m_7861_() {
        if (this.searchField.m_94213_()) {
            this.closeSearch();
        }
        if (this.nameField.m_94213_()) {
            this.closeName(true);
        }
        Arrays.stream(ClientStorageManager.openPC.getBoxes()).forEach(PCBox::sendChangesToServer);
        NetworkHelper.sendToServer(new ServerSetLastOpenBoxPacket(this.boxNumber));
        super.m_7861_();
        PixelmonOverlayScreen.ICONS.forEach(icon -> icon.setEnabled(true));
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.enableBlend();
        matrix.m_280218_(this.boxWallpaper, this.f_96543_ / 2 - 103, this.f_96544_ / 6 - 30, 0, 0, 206, 186);
        for (GuiEventListener child : this.f_96540_) {
            if (!(child instanceof Renderable)) continue;
            ((Renderable)child).m_88315_(matrix, mouseX, mouseY, partialTicks);
        }
        for (int i = 0; i < this.icons.size(); ++i) {
            this.icons.get(i).draw(matrix, this.f_96543_ - 30 - i * 25, this.f_96544_ - 30, partialTicks);
        }
        RenderSystem.enableBlend();
        this.drawBox(matrix);
        this.drawFooter(matrix);
        this.drawPokeChecker(matrix, mouseX, mouseY, partialTicks);
        this.drawHover(matrix, mouseX, mouseY);
        this.drawCursor(matrix, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    public boolean m_5534_(char p_231042_1_, int p_231042_2_) {
        if (this.blockTyping) {
            this.blockTyping = false;
            return false;
        }
        return super.m_5534_(p_231042_1_, p_231042_2_);
    }
}

