/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.override.servers.screen;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.override.servers.list.ExtendedServerData;
import com.pixelmonmod.pixelmon.client.gui.override.servers.list.ExtendedServerList;
import com.pixelmonmod.pixelmon.client.gui.override.servers.screen.CustomMultiplayerScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.DiscordButton;
import java.awt.Color;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

public class CustomServerSelectionList
extends ObjectSelectionList<Entry> {
    static final ResourceLocation INCOMPATIBLE_SPRITE = new ResourceLocation("server_list/incompatible");
    static final ResourceLocation UNREACHABLE_SPRITE = new ResourceLocation("server_list/unreachable");
    static final ResourceLocation PING_1_SPRITE = new ResourceLocation("server_list/ping_1");
    static final ResourceLocation PING_2_SPRITE = new ResourceLocation("server_list/ping_2");
    static final ResourceLocation PING_3_SPRITE = new ResourceLocation("server_list/ping_3");
    static final ResourceLocation PING_4_SPRITE = new ResourceLocation("server_list/ping_4");
    static final ResourceLocation PING_5_SPRITE = new ResourceLocation("server_list/ping_5");
    static final ResourceLocation PINGING_1_SPRITE = new ResourceLocation("server_list/pinging_1");
    static final ResourceLocation PINGING_2_SPRITE = new ResourceLocation("server_list/pinging_2");
    static final ResourceLocation PINGING_3_SPRITE = new ResourceLocation("server_list/pinging_3");
    static final ResourceLocation PINGING_4_SPRITE = new ResourceLocation("server_list/pinging_4");
    static final ResourceLocation PINGING_5_SPRITE = new ResourceLocation("server_list/pinging_5");
    static final ResourceLocation JOIN_HIGHLIGHTED_SPRITE = new ResourceLocation("server_list/join_highlighted");
    static final ResourceLocation JOIN_SPRITE = new ResourceLocation("server_list/join");
    static final ResourceLocation MOVE_UP_HIGHLIGHTED_SPRITE = new ResourceLocation("server_list/move_up_highlighted");
    static final ResourceLocation MOVE_UP_SPRITE = new ResourceLocation("server_list/move_up");
    static final ResourceLocation MOVE_DOWN_HIGHLIGHTED_SPRITE = new ResourceLocation("server_list/move_down_highlighted");
    static final ResourceLocation MOVE_DOWN_SPRITE = new ResourceLocation("server_list/move_down");
    static final Logger LOGGER = LogUtils.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    static final Component SCANNING_LABEL = Component.m_237115_((String)"lanServer.scanning");
    static final Component CANT_RESOLVE_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_resolve").m_130938_(p_264689_ -> p_264689_.m_178520_(-65536));
    static final Component CANT_CONNECT_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130938_(p_264688_ -> p_264688_.m_178520_(-65536));
    static final Component INCOMPATIBLE_STATUS = Component.m_237115_((String)"multiplayer.status.incompatible");
    static final Component NO_CONNECTION_STATUS = Component.m_237115_((String)"multiplayer.status.no_connection");
    static final Component PINGING_STATUS = Component.m_237115_((String)"multiplayer.status.pinging");
    static final Component ONLINE_STATUS = Component.m_237115_((String)"multiplayer.status.online");
    private final CustomMultiplayerScreen screen;
    private final List<OnlineServerEntry> onlineServers = Lists.newArrayList();
    private final Entry lanHeader = new LANHeader();
    private final List<NetworkServerEntry> networkServers = Lists.newArrayList();

    public CustomServerSelectionList(CustomMultiplayerScreen parent, Minecraft minecraft, int p_99773_, int p_99774_, int p_99775_, int p_99776_, int p_99777_) {
        super(minecraft, p_99773_, p_99774_, p_99775_, p_99776_, p_99777_);
        this.screen = parent;
    }

    private void refreshEntries() {
        this.m_93516_();
        this.onlineServers.forEach(p_169979_ -> this.m_7085_((AbstractSelectionList.Entry)p_169979_));
        this.m_7085_((AbstractSelectionList.Entry)this.lanHeader);
        this.networkServers.forEach(p_169976_ -> this.m_7085_((AbstractSelectionList.Entry)p_169976_));
    }

    public void setSelected(@Nullable Entry p_99790_) {
        super.m_6987_((AbstractSelectionList.Entry)p_99790_);
        this.screen.m_99730_();
    }

    public boolean m_7933_(int p_99782_, int p_99783_, int p_99784_) {
        Entry serverselectionlist$entry = (Entry)this.m_93511_();
        return serverselectionlist$entry != null && serverselectionlist$entry.m_7933_(p_99782_, p_99783_, p_99784_) || super.m_7933_(p_99782_, p_99783_, p_99784_);
    }

    public void updateOnlineServers(ExtendedServerList serverList) {
        this.onlineServers.clear();
        for (int i = 0; i < serverList.m_105445_(); ++i) {
            this.onlineServers.add(new OnlineServerEntry(this.screen, serverList.getServer(i)));
        }
        this.refreshEntries();
    }

    public void updateNetworkServers(List<LanServer> p_99800_) {
        int i = p_99800_.size() - this.networkServers.size();
        this.networkServers.clear();
        for (LanServer lanserver : p_99800_) {
            this.networkServers.add(new NetworkServerEntry(this.screen, lanserver));
        }
        this.refreshEntries();
        for (int i1 = this.networkServers.size() - i; i1 < this.networkServers.size(); ++i1) {
            NetworkServerEntry serverselectionlist$networkserverentry = this.networkServers.get(i1);
            int j = i1 - this.networkServers.size() + this.m_6702_().size();
            int k = this.m_7610_(j);
            int l = this.m_93485_(j);
            if (l < this.f_93390_ || k > this.f_93391_) continue;
            this.f_93386_.m_240477_().m_263195_((Component)Component.m_237110_((String)"multiplayer.lan.server_found", (Object[])new Object[]{serverselectionlist$networkserverentry.getServerNarration()}));
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 30;
    }

    public int m_5759_() {
        return super.m_5759_() + 85;
    }

    public void removed() {
    }

    @Nullable
    protected Entry getEntryAtPosition(double p_93413_, double p_93414_) {
        int i = this.m_5759_() / 2;
        int j = this.f_93393_ + this.f_93388_ / 2;
        int k = j - (i + 64);
        int l = j + (i + 32);
        int i1 = Mth.m_14107_((double)(p_93414_ - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        int j1 = i1 / this.f_93387_;
        return p_93413_ >= (double)k && p_93413_ <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.m_5773_() ? (Entry)this.m_6702_().get(j1) : null;
    }

    public boolean m_5953_(double p_93479_, double p_93480_) {
        return p_93480_ >= (double)this.f_93390_ && p_93480_ <= (double)this.f_93391_ && p_93479_ >= (double)(this.f_93393_ - 32) && p_93479_ <= (double)this.f_93392_ + 32.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LANHeader
    extends Entry {
        private final Minecraft minecraft = Minecraft.m_91087_();

        public void m_6311_(GuiGraphics p_281475_, int p_282477_, int p_282819_, int p_282001_, int p_281911_, int p_283126_, int p_282303_, int p_281998_, boolean p_282625_, float p_281811_) {
            int i = p_282819_ + p_283126_ / 2 - 4;
            p_281475_.m_280614_(this.minecraft.f_91062_, SCANNING_LABEL, this.minecraft.f_91080_.f_96543_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)SCANNING_LABEL) / 2, i, 0xFFFFFF, false);
            String s = LoadingDotsText.m_232744_((long)Util.m_137550_());
            p_281475_.m_280056_(this.minecraft.f_91062_, s, this.minecraft.f_91080_.f_96543_ / 2 - this.minecraft.f_91062_.m_92895_(s) / 2, i + 9, -8355712, false);
        }

        public Component m_142172_() {
            return SCANNING_LABEL;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class OnlineServerEntry
    extends Entry {
        private final CustomMultiplayerScreen screen;
        private final Minecraft minecraft;
        private final ExtendedServerData serverData;
        private final FaviconTexture icon;
        @Nullable
        private byte[] lastIconBytes;
        private long lastClickTime;

        protected OnlineServerEntry(CustomMultiplayerScreen p_99864_, ExtendedServerData p_99865_) {
            this.screen = p_99864_;
            this.serverData = p_99865_;
            this.minecraft = Minecraft.m_91087_();
            this.icon = FaviconTexture.m_289187_((TextureManager)this.minecraft.m_91097_(), (String)p_99865_.ip);
        }

        public void m_6311_(GuiGraphics guiGraphics, int p_281506_, int p_282921_, int p_281363_, int p_283596_, int p_281630_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            List list1;
            Component component;
            ResourceLocation resourcelocation;
            if (!this.serverData.f_105369_) {
                this.serverData.f_105369_ = true;
                this.serverData.f_105366_ = -2L;
                this.serverData.f_105365_ = CommonComponents.f_237098_;
                this.serverData.f_105364_ = CommonComponents.f_237098_;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.m_99731_().m_105459_((ServerData)this.serverData, () -> this.minecraft.execute(this::updateServerList));
                    }
                    catch (UnknownHostException unknownhostexception) {
                        this.serverData.f_105366_ = -1L;
                        this.serverData.f_105365_ = CANT_RESOLVE_TEXT;
                    }
                    catch (Exception exception) {
                        this.serverData.f_105366_ = -1L;
                        this.serverData.f_105365_ = CANT_CONNECT_TEXT;
                    }
                });
            }
            if (mouseX > p_281363_ - 32 && mouseX < p_281363_ && mouseY < p_282921_ + 48 && mouseY > p_282921_ + 8 || this.screen.getServers().isFavourite(this.serverData)) {
                ScreenHelper.drawStar(guiGraphics, this.f_93521_.m_5747_() - 18, p_282921_ + 16, 0.0, 7.143, 2.858, 5, false, 0.95f, 0.85f, 0.35f, 1.0f);
            } else {
                ScreenHelper.drawStar(guiGraphics, this.f_93521_.m_5747_() - 18, p_282921_ + 16, 0.0, 7.143, 2.858, 5, true, 0.95f, 0.85f, 0.35f, 1.0f);
            }
            guiGraphics.m_280509_(p_281363_, p_282921_, p_281363_ + 32, p_282921_ + 32, -1601138544);
            if (this.serverData.goldBorder && !Objects.equals(this, this.f_93521_.m_93511_())) {
                int p_240144_ = this.f_93521_.f_93387_;
                int i = this.f_93521_.m_5747_() - 1;
                int j = this.f_93521_.m_5747_() + this.f_93521_.m_5759_() - 2;
                guiGraphics.m_280509_(i, p_282921_ - 2, j, p_282921_ + p_240144_ + 2, new Color(0.8314f, 0.6863f, 0.2157f, 1.0f).getRGB());
                guiGraphics.m_280509_(i + 1, p_282921_ - 1, j - 1, p_282921_ + p_240144_ + 1, -16777216);
            }
            if (this.serverData.discordInvite != null) {
                ScreenHelper.drawImage(guiGraphics, DiscordButton.ICON, (float)(this.f_93521_.m_93520_() + 16), (float)(p_282921_ + 4), 16.0f, 16.0f, 0.0f);
                if (mouseX >= this.f_93521_.m_93520_() + 12 && mouseX <= this.f_93521_.m_93520_() + 32) {
                    String text = this.serverData.discordInvite.replace("https://", "").replace("http://", "");
                    int length = this.minecraft.f_91062_.m_92895_(text);
                    guiGraphics.m_280488_(this.minecraft.f_91062_, text, mouseX - length / 2, mouseY, Color.WHITE.getRGB());
                }
            }
            boolean flag = !this.isCompatible();
            guiGraphics.m_280056_(this.minecraft.f_91062_, this.serverData.name, p_281363_ + 32 + 3, p_282921_ + 1, 0xFFFFFF, false);
            List list = this.minecraft.f_91062_.m_92923_((FormattedText)this.serverData.f_105365_, p_283596_ - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                guiGraphics.m_280649_(this.minecraft.f_91062_, (FormattedCharSequence)list.get(i), p_281363_ + 32 + 3, p_282921_ + 12 + 9 * i, -8355712, false);
            }
            Component component1 = flag ? this.serverData.f_105368_.m_6881_().m_130940_(ChatFormatting.RED) : this.serverData.f_105364_;
            int j = this.minecraft.f_91062_.m_92852_((FormattedText)component1);
            guiGraphics.m_280614_(this.minecraft.f_91062_, component1, p_281363_ + p_283596_ - j - 15 - 2, p_282921_ + 1, -8355712, false);
            if (flag) {
                resourcelocation = INCOMPATIBLE_SPRITE;
                component = INCOMPATIBLE_STATUS;
                list1 = this.serverData.f_105370_;
            } else if (this.pingCompleted()) {
                resourcelocation = this.serverData.f_105366_ < 0L ? UNREACHABLE_SPRITE : (this.serverData.f_105366_ < 150L ? PING_5_SPRITE : (this.serverData.f_105366_ < 300L ? PING_4_SPRITE : (this.serverData.f_105366_ < 600L ? PING_3_SPRITE : (this.serverData.f_105366_ < 1000L ? PING_2_SPRITE : PING_1_SPRITE))));
                if (this.serverData.f_105366_ < 0L) {
                    component = NO_CONNECTION_STATUS;
                    list1 = Collections.emptyList();
                } else {
                    component = Component.m_237110_((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.f_105366_});
                    list1 = this.serverData.f_105370_;
                }
            } else {
                int k = (int)(Util.m_137550_() / 100L + (long)(p_281506_ * 2) & 7L);
                if (k > 4) {
                    k = 8 - k;
                }
                resourcelocation = switch (k) {
                    case 1 -> PINGING_2_SPRITE;
                    case 2 -> PINGING_3_SPRITE;
                    case 3 -> PINGING_4_SPRITE;
                    case 4 -> PINGING_5_SPRITE;
                    default -> PINGING_1_SPRITE;
                };
                component = PINGING_STATUS;
                list1 = Collections.emptyList();
            }
            guiGraphics.m_292816_(resourcelocation, p_281363_ + p_283596_ - 15, p_282921_, 10, 8);
            byte[] abyte = this.serverData.m_271916_();
            if (!Arrays.equals(abyte, this.lastIconBytes)) {
                if (this.uploadServerIcon(abyte)) {
                    this.lastIconBytes = abyte;
                } else {
                    this.serverData.m_271813_(null);
                    this.updateServerList();
                }
            }
            this.drawIcon(guiGraphics, p_281363_, p_282921_, this.icon.m_289196_());
            int l = mouseX - p_281363_;
            int i1 = mouseY - p_282921_;
            if (l >= p_283596_ - 15 && l <= p_283596_ - 5 && i1 >= 0 && i1 <= 8) {
                this.screen.m_99707_(Collections.singletonList(component));
            } else if (l >= p_283596_ - j - 15 - 2 && l <= p_283596_ - 15 - 2 && i1 >= 0 && i1 <= 8) {
                this.screen.m_99707_(list1);
            }
            ForgeHooksClient.drawForgePingInfo((JoinMultiplayerScreen)this.screen, (ServerData)this.serverData, (GuiGraphics)guiGraphics, (int)p_281363_, (int)p_282921_, (int)p_283596_, (int)l, (int)i1);
            if (((Boolean)this.minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || selected) {
                guiGraphics.m_280509_(p_281363_, p_282921_, p_281363_ + 32, p_282921_ + 32, -1601138544);
                int j1 = mouseX - p_281363_;
                int k1 = mouseY - p_282921_;
                if (this.canJoin()) {
                    if (j1 < 32 && j1 > 16) {
                        guiGraphics.m_292816_(JOIN_HIGHLIGHTED_SPRITE, p_281363_, p_282921_, 32, 32);
                    } else {
                        guiGraphics.m_292816_(JOIN_SPRITE, p_281363_, p_282921_, 32, 32);
                    }
                }
                if (p_281506_ > 0) {
                    if (j1 < 16 && k1 < 16) {
                        guiGraphics.m_292816_(MOVE_UP_HIGHLIGHTED_SPRITE, p_281363_, p_282921_, 32, 32);
                    } else {
                        guiGraphics.m_292816_(MOVE_UP_SPRITE, p_281363_, p_282921_, 32, 32);
                    }
                }
                if (p_281506_ < this.screen.getServers().m_105445_() - 1) {
                    if (j1 < 16 && k1 > 16) {
                        guiGraphics.m_292816_(MOVE_DOWN_HIGHLIGHTED_SPRITE, p_281363_, p_282921_, 32, 32);
                    } else {
                        guiGraphics.m_292816_(MOVE_DOWN_SPRITE, p_281363_, p_282921_, 32, 32);
                    }
                }
            }
        }

        private boolean pingCompleted() {
            return this.serverData.f_105369_ && this.serverData.f_105366_ != -2L;
        }

        private boolean isCompatible() {
            return this.serverData.f_105367_ == SharedConstants.m_183709_().m_132495_();
        }

        public void updateServerList() {
            this.screen.getServers().m_105442_();
        }

        protected void drawIcon(GuiGraphics p_281338_, int p_283001_, int p_282834_, ResourceLocation p_282534_) {
            RenderSystem.enableBlend();
            p_281338_.m_280163_(p_282534_, p_283001_, p_282834_, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        private boolean canJoin() {
            return true;
        }

        private boolean uploadServerIcon(@Nullable byte[] p_273176_) {
            if (p_273176_ == null) {
                this.icon.m_289218_();
            } else {
                try {
                    this.icon.m_289201_(NativeImage.m_271751_((byte[])p_273176_));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.name, this.serverData.ip, throwable});
                    return false;
                }
            }
            return true;
        }

        public boolean m_7933_(int p_99875_, int p_99876_, int p_99877_) {
            if (Screen.m_96638_()) {
                CustomServerSelectionList serverselectionlist = this.screen.serverSelectionList;
                int i = CustomServerSelectionList.this.m_6702_().indexOf(this);
                if (i == -1) {
                    return true;
                }
                if (p_99875_ == 264 && i < this.screen.getServers().m_105445_() - 1 || p_99875_ == 265 && i > 0) {
                    this.swap(i, p_99875_ == 264 ? i + 1 : i - 1);
                    return true;
                }
            }
            return super.m_7933_(p_99875_, p_99876_, p_99877_);
        }

        private void swap(int p_99872_, int p_99873_) {
            this.screen.getServers().m_105434_(p_99872_, p_99873_);
            this.screen.serverSelectionList.updateOnlineServers(this.screen.getServers());
            Entry serverselectionlist$entry = (Entry)this.screen.serverSelectionList.m_6702_().get(p_99873_);
            this.screen.serverSelectionList.setSelected(serverselectionlist$entry);
            CustomServerSelectionList.this.m_93498_((AbstractSelectionList.Entry)serverselectionlist$entry);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (mouseX >= (double)(this.f_93521_.m_5747_() - 32) && mouseX <= (double)this.f_93521_.m_5747_()) {
                this.screen.getServers().toggleFavourite(this.serverData);
                this.screen.serverSelectionList.updateOnlineServers(this.screen.getServers());
                this.screen.getServers().m_105442_();
                return true;
            }
            if (mouseX >= (double)(this.f_93521_.m_93520_() + 8) && mouseX <= (double)(this.f_93521_.m_93520_() + 32)) {
                if (this.serverData.discordInvite != null) {
                    Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(p_213064_1_ -> {
                        if (p_213064_1_) {
                            Util.m_137581_().m_137646_(this.serverData.discordInvite);
                        }
                        Minecraft.m_91087_().m_91152_((Screen)this.screen);
                    }, this.serverData.discordInvite, true));
                }
                return true;
            }
            double d0 = mouseX - (double)CustomServerSelectionList.this.m_5747_();
            double d1 = mouseY - (double)CustomServerSelectionList.this.m_7610_(CustomServerSelectionList.this.m_6702_().indexOf(this));
            if (d0 <= 32.0) {
                if (d0 < 32.0 && d0 > 16.0 && this.canJoin()) {
                    this.screen.setSelected(this);
                    this.screen.m_99729_();
                    return true;
                }
                int i = this.screen.m_6702_().indexOf(this);
                if (d0 < 16.0 && d1 < 16.0 && i > 0) {
                    this.swap(i, i - 1);
                    return true;
                }
                if (d0 < 16.0 && d1 > 16.0 && i < this.screen.getServers().m_105445_() - 1) {
                    this.swap(i, i + 1);
                    return true;
                }
            }
            this.screen.setSelected(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.screen.m_99729_();
            }
            this.lastClickTime = Util.m_137550_();
            return true;
        }

        public ExtendedServerData getServerData() {
            return this.serverData;
        }

        public Component m_142172_() {
            MutableComponent mutablecomponent = Component.m_237119_();
            mutablecomponent.m_7220_((Component)Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.serverData.name}));
            mutablecomponent.m_7220_(CommonComponents.f_178389_);
            if (!this.isCompatible()) {
                mutablecomponent.m_7220_(INCOMPATIBLE_STATUS);
                mutablecomponent.m_7220_(CommonComponents.f_178389_);
                mutablecomponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.version.narration", (Object[])new Object[]{this.serverData.f_105368_}));
                mutablecomponent.m_7220_(CommonComponents.f_178389_);
                mutablecomponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.serverData.f_105365_}));
            } else if (this.serverData.f_105366_ < 0L) {
                mutablecomponent.m_7220_(NO_CONNECTION_STATUS);
            } else if (!this.pingCompleted()) {
                mutablecomponent.m_7220_(PINGING_STATUS);
            } else {
                mutablecomponent.m_7220_(ONLINE_STATUS);
                mutablecomponent.m_7220_(CommonComponents.f_178389_);
                mutablecomponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.ping.narration", (Object[])new Object[]{this.serverData.f_105366_}));
                mutablecomponent.m_7220_(CommonComponents.f_178389_);
                mutablecomponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.serverData.f_105365_}));
                if (this.serverData.f_263840_ != null) {
                    mutablecomponent.m_7220_(CommonComponents.f_178389_);
                    mutablecomponent.m_7220_((Component)Component.m_237110_((String)"multiplayer.status.player_count.narration", (Object[])new Object[]{this.serverData.f_263840_.f_271178_(), this.serverData.f_263840_.f_271503_()}));
                    mutablecomponent.m_7220_(CommonComponents.f_178389_);
                    mutablecomponent.m_7220_(ComponentUtils.m_178433_((Collection)this.serverData.f_105370_, (Component)Component.m_237113_((String)", ")));
                }
            }
            return mutablecomponent;
        }

        @Override
        public void close() {
            this.icon.close();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NetworkServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final Component LAN_SERVER_HEADER = Component.m_237115_((String)"lanServer.title");
        private static final Component HIDDEN_ADDRESS_TEXT = Component.m_237115_((String)"selectServer.hiddenAddress");
        private final CustomMultiplayerScreen screen;
        protected final Minecraft minecraft;
        protected final LanServer serverData;
        private long lastClickTime;

        protected NetworkServerEntry(CustomMultiplayerScreen p_99836_, LanServer p_99837_) {
            this.screen = p_99836_;
            this.serverData = p_99837_;
            this.minecraft = Minecraft.m_91087_();
        }

        public void m_6311_(GuiGraphics p_282600_, int p_282649_, int p_283641_, int p_282277_, int p_283034_, int p_281533_, int p_282746_, int p_281454_, boolean p_283673_, float p_282694_) {
            p_282600_.m_280614_(this.minecraft.f_91062_, LAN_SERVER_HEADER, p_282277_ + 32 + 3, p_283641_ + 1, 0xFFFFFF, false);
            p_282600_.m_280056_(this.minecraft.f_91062_, this.serverData.m_120078_(), p_282277_ + 32 + 3, p_283641_ + 12, -8355712, false);
            if (this.minecraft.f_91066_.f_92124_) {
                p_282600_.m_280614_(this.minecraft.f_91062_, HIDDEN_ADDRESS_TEXT, p_282277_ + 32 + 3, p_283641_ + 12 + 11, 0x303030, false);
            } else {
                p_282600_.m_280056_(this.minecraft.f_91062_, this.serverData.m_120079_(), p_282277_ + 32 + 3, p_283641_ + 12 + 11, 0x303030, false);
            }
        }

        public boolean m_6375_(double p_99840_, double p_99841_, int p_99842_) {
            this.screen.setSelected(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.screen.m_99729_();
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public LanServer getServerData() {
            return this.serverData;
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.getServerNarration()});
        }

        public Component getServerNarration() {
            return Component.m_237119_().m_7220_(LAN_SERVER_HEADER).m_7220_(CommonComponents.f_263701_).m_130946_(this.serverData.m_120078_());
        }
    }
}

