/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.override.servers.list;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.override.servers.list.ExtendedServerData;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.util.thread.StrictQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ExtendedServerList
extends ServerList {
    private static final Logger LOGGER;
    private final Minecraft minecraft;
    private final List<ExtendedServerData> favouritedServers = Lists.newArrayList();
    private final List<ExtendedServerData> serverList = Lists.newArrayList();
    private final List<ExtendedServerData> hiddenServerList = Lists.newArrayList();

    public ExtendedServerList(Minecraft minecraft) {
        super(minecraft);
        this.minecraft = minecraft;
        if (ClientProxy.getRichPresence() != null) {
            ClientProxy.getRichPresence().setAcknowledgedServer(false);
        }
        this.m_105431_();
    }

    public void m_105431_() {
        if (this.serverList == null) {
            return;
        }
        try {
            this.serverList.clear();
            this.favouritedServers.clear();
            this.hiddenServerList.clear();
            CompoundTag compoundnbt = NbtIo.m_128953_((File)new File(this.minecraft.f_91069_, "servers.dat"));
            if (compoundnbt == null) {
                return;
            }
            ListTag listnbt = compoundnbt.m_128437_("servers", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compound = listnbt.m_128728_(i);
                if (compoundnbt.m_128441_("hidden") && compound.m_128471_("hidden")) {
                    this.hiddenServerList.add(ExtendedServerData.read(compound));
                    continue;
                }
                this.serverList.add(ExtendedServerData.read(compound));
            }
            if (compoundnbt.m_128441_("favourites")) {
                ListTag favourites = compoundnbt.m_128437_("favourites", 10);
                for (int i = 0; i < favourites.size(); ++i) {
                    this.favouritedServers.add(ExtendedServerData.read(favourites.m_128728_(i)));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load server list", (Throwable)exception);
        }
    }

    public void m_105442_() {
        try {
            ListTag listnbt = new ListTag();
            for (ExtendedServerData extendedServerData : this.serverList) {
                listnbt.add((Object)extendedServerData.m_105378_());
            }
            for (ServerData serverData : this.hiddenServerList) {
                CompoundTag compoundtag2 = serverData.m_105378_();
                compoundtag2.m_128379_("hidden", true);
                listnbt.add((Object)compoundtag2);
            }
            ListTag favourites = new ListTag();
            for (ExtendedServerData serverdata : this.favouritedServers) {
                favourites.add((Object)serverdata.m_105378_());
            }
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("servers", (Tag)listnbt);
            compoundTag.m_128365_("favourites", (Tag)favourites);
            File file3 = File.createTempFile("servers", ".dat", this.minecraft.f_91069_);
            NbtIo.m_128955_((CompoundTag)compoundTag, (File)file3);
            File file1 = new File(this.minecraft.f_91069_, "servers.dat_old");
            File file2 = new File(this.minecraft.f_91069_, "servers.dat");
            Util.m_137462_((File)file2, (File)file3, (File)file1);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't save server list", (Throwable)exception);
        }
    }

    public void m_105440_(ServerData serverData) {
        this.serverList.remove(serverData);
        this.favouritedServers.remove(serverData);
        this.hiddenServerList.remove(serverData);
    }

    public void add(ExtendedServerData p_78849_1_) {
        this.serverList.add(p_78849_1_);
    }

    public int m_105445_() {
        return this.serverList.size() + this.favouritedServers.size();
    }

    public void m_105434_(int index, int secondIndex) {
        if (index < this.favouritedServers.size() || secondIndex < this.favouritedServers.size()) {
            return;
        }
        ExtendedServerData serverdata = this.getServer(index);
        this.serverList.set(index - this.favouritedServers.size(), this.getServer(secondIndex));
        this.serverList.set(secondIndex - this.favouritedServers.size(), serverdata);
        this.m_105442_();
    }

    public void replace(int index, ExtendedServerData data) {
        this.serverList.set(index - this.favouritedServers.size(), data);
    }

    public void toggleFavourite(ExtendedServerData serverData) {
        if (this.favouritedServers.contains((Object)serverData)) {
            this.favouritedServers.remove((Object)serverData);
            this.serverList.add(serverData);
        } else {
            this.favouritedServers.add(serverData);
            this.serverList.remove((Object)serverData);
        }
    }

    public boolean isFavourite(ServerData serverData) {
        return this.favouritedServers.contains(serverData);
    }

    public void randomize() {
        Collections.shuffle(this.serverList);
        this.m_105442_();
    }

    public ExtendedServerData getServer(int index) {
        if (index < this.favouritedServers.size()) {
            return this.favouritedServers.get(index);
        }
        return this.serverList.get(index - this.favouritedServers.size());
    }

    @Deprecated
    public ServerData m_105432_(int p_78850_1_) {
        return this.serverList.get(p_78850_1_);
    }

    @Nullable
    public ServerData m_233845_(String p_233846_) {
        for (ServerData serverData : this.favouritedServers) {
            if (!serverData.f_105363_.equals(p_233846_)) continue;
            return serverData;
        }
        for (ServerData serverData : this.serverList) {
            if (!serverData.f_105363_.equals(p_233846_)) continue;
            return serverData;
        }
        for (ServerData serverData : this.hiddenServerList) {
            if (!serverData.f_105363_.equals(p_233846_)) continue;
            return serverData;
        }
        return null;
    }

    public void m_233842_(ServerData serverData, boolean hidden) {
        if (hidden) {
            this.hiddenServerList.add(0, new ExtendedServerData(serverData.f_105362_, serverData.f_105363_, ServerData.Type.OTHER));
            while (this.hiddenServerList.size() > 16) {
                this.hiddenServerList.remove(this.hiddenServerList.size() - 1);
            }
        } else {
            this.serverList.add(new ExtendedServerData(serverData.f_105362_, serverData.f_105363_, ServerData.Type.OTHER));
        }
    }

    static {
        ServerList.f_233836_ = new ProcessorMailbox((StrictQueue)new StrictQueue.QueueStrictQueue(new ConcurrentLinkedQueue()), command -> {}, "Server List IO");
        LOGGER = LogManager.getLogger();
    }
}

