/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.override.load;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.WeightedSet;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.override.ScreenModifier;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ScreenEvent;

public abstract class LoadingPokemonModifier
implements ScreenModifier {
    private static final List<WeightedSet<ResourceLocation>> SPRITES = Lists.newArrayList((Object[])new WeightedSet[]{WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/001_bulbasaur/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/004_charmander/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/007_squirtle/all/base/none/sprite.png"), 3, ResourceLocationHelper.of("pixelmon:textures/pokemon/025_pikachu/all/base/none/sprite.png"), 3, ResourceLocationHelper.of("pixelmon:textures/pokemon/133_eevee/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/001_bulbasaur/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/004_charmander/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/007_squirtle/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/152_chikorita/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/155_cyndaquil/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/158_totodile/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/152_chikorita/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/155_cyndaquil/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/158_totodile/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/252_treecko/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/255_torchic/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/258_mudkip/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/252_treecko/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/255_torchic/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/258_mudkip/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/387_turtwig/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/390_chimchar/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/393_piplup/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/387_turtwig/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/390_chimchar/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/393_piplup/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/495_snivy/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/498_tepig/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/501_oshawott/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/495_snivy/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/498_tepig/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/501_oshawott/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/650_chespin/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/653_fennekin/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/656_froakie/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/650_chespin/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/653_fennekin/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/656_froakie/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/722_rowlet/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/725_litten/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/728_popplio/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/722_rowlet/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/725_litten/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/728_popplio/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/810_grookey/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/813_scorbunny/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/816_sobble/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/810_grookey/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/813_scorbunny/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/816_sobble/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/025_pikachu/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/133_eevee/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/025_pikachu/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/133_eevee/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/722_rowlet/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/155_cyndaquil/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/501_oshawott/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/722_rowlet/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/155_cyndaquil/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/501_oshawott/all/base/shiny/sprite.png")), WeightedSet.newWeightedSet(10, ResourceLocationHelper.of("pixelmon:textures/pokemon/906_sprigatito/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/909_fuecoco/all/base/none/sprite.png"), 10, ResourceLocationHelper.of("pixelmon:textures/pokemon/912_quaxly/all/base/none/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/906_sprigatito/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/909_fuecoco/all/base/shiny/sprite.png"), 1, ResourceLocationHelper.of("pixelmon:textures/pokemon/912_quaxly/all/base/shiny/sprite.png"))});
    private final List<AnimatedSprite> sprites = Lists.newArrayList();
    private int nextSpriteIn = 0;
    private static final int gameStarterIndexToRender = RandomHelper.getRandomNumberBetween(0, SPRITES.size() - 1);

    @Override
    public void onPreRender(ScreenEvent.Init.Post event) {
        this.sprites.clear();
    }

    @Override
    public void onBackgroundDraw(ScreenEvent.BackgroundRendered event) {
        event.getGuiGraphics().m_280168_().m_85836_();
        this.sprites.removeIf(sprite -> sprite.tick(event.getGuiGraphics()));
        --this.nextSpriteIn;
        if (this.nextSpriteIn <= 0 && this.sprites.size() < 29) {
            this.nextSpriteIn = 10;
            this.sprites.add(new AnimatedSprite(SPRITES.get(gameStarterIndexToRender).get(), event.getScreen().f_96543_ + 50, 20, 40));
        }
        event.getGuiGraphics().m_280168_().m_85849_();
    }

    public static ResourceLocation getSprite() {
        return SPRITES.get(gameStarterIndexToRender).get();
    }

    private static class AnimatedSprite {
        private final ResourceLocation rl;
        private int x;
        private int y;
        private int w;
        private int jump = 0;
        private boolean up = true;

        public AnimatedSprite(ResourceLocation rl, int x, int y, int w) {
            this.rl = rl;
            this.x = x;
            this.y = y;
            this.w = w;
        }

        public boolean tick(GuiGraphics graphics) {
            if (this.x < -100) {
                return true;
            }
            int dy = 0;
            if (this.jump >= 0) {
                dy = this.jump++;
                if (this.up) {
                    if (this.jump >= 5) {
                        this.up = false;
                    }
                } else {
                    --this.jump;
                    if (this.jump <= 0) {
                        this.up = true;
                        this.jump = -RandomHelper.getRandom().nextInt(5);
                    }
                }
            } else {
                ++this.jump;
            }
            ScreenHelper.drawImageQuad(this.rl, graphics, this.x, this.y - dy, this.w, this.w, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 10.0f);
            if ((double)this.x > 0.75 * (double)Minecraft.m_91087_().f_91080_.f_96543_ && (double)this.y > 0.1 * (double)Minecraft.m_91087_().f_91080_.f_96544_) {
                this.y -= 3;
            } else if ((double)this.y > 0.8 * (double)Minecraft.m_91087_().f_91080_.f_96544_) {
                this.x += 3;
            } else if ((double)this.x < 0.15 * (double)Minecraft.m_91087_().f_91080_.f_96543_) {
                this.y += 3;
            } else if ((double)this.y < 0.3 * (double)Minecraft.m_91087_().f_91080_.f_96544_) {
                this.x -= 3;
            }
            return false;
        }
    }
}

