/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.override;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.client.gui.override.ScreenModifier;
import com.pixelmonmod.pixelmon.client.gui.override.escape.cosmetic.EscapeMenuCosmeticModifier;
import com.pixelmonmod.pixelmon.client.gui.override.load.ServerConnectModifier;
import com.pixelmonmod.pixelmon.client.gui.override.load.WorldLoadModifier;
import com.pixelmonmod.pixelmon.client.gui.override.main.MainMenuModifier;
import com.pixelmonmod.pixelmon.client.gui.override.main.SelectResourcePackModifier;
import com.pixelmonmod.pixelmon.client.gui.override.servers.MultiplayerScreenModifier;
import com.pixelmonmod.pixelmon.client.gui.override.warning.ConfirmScreenModifier;
import com.pixelmonmod.pixelmon.client.gui.override.warning.ExperimentalWarningScreenModifier;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pixelmon", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MenuOverrideFactory {
    private static Map<Class<? extends Screen>, List<ScreenModifier>> REGISTERED_MODIFIERS = Maps.newConcurrentMap();

    private static void registerModifier(ScreenModifier modifier) {
        REGISTERED_MODIFIERS.computeIfAbsent(modifier.getScreenClass(), ___ -> Lists.newArrayList()).add(modifier);
    }

    @SubscribeEvent
    public static void onGuiOpen(ScreenEvent.Init.Post event) {
        List<ScreenModifier> screenModifiers = REGISTERED_MODIFIERS.get(event.getScreen().getClass());
        if (screenModifiers == null) {
            return;
        }
        for (ScreenModifier screenModifier : screenModifiers) {
            screenModifier.onPreRender(event);
        }
    }

    @SubscribeEvent
    public static void onBackgroundDraw(ScreenEvent.BackgroundRendered event) {
        List<ScreenModifier> screenModifiers = REGISTERED_MODIFIERS.get(event.getScreen().getClass());
        if (screenModifiers == null) {
            return;
        }
        for (ScreenModifier screenModifier : screenModifiers) {
            screenModifier.onBackgroundDraw(event);
        }
    }

    static {
        MenuOverrideFactory.registerModifier(new EscapeMenuCosmeticModifier());
        MenuOverrideFactory.registerModifier(new WorldLoadModifier());
        MenuOverrideFactory.registerModifier(new ServerConnectModifier());
        MenuOverrideFactory.registerModifier(new MainMenuModifier());
        MenuOverrideFactory.registerModifier(new ExperimentalWarningScreenModifier());
        MenuOverrideFactory.registerModifier(new ConfirmScreenModifier());
        MenuOverrideFactory.registerModifier(new MultiplayerScreenModifier());
        MenuOverrideFactory.registerModifier(new SelectResourcePackModifier());
    }
}

