/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.ClickableElement;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.TutorListScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.TutorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteTrainerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTutorDataPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class TutorEditorScreen
extends DropDownScreen
implements ClickableElement<NPCTutor.LearnableMove> {
    public static EnumSet<BaseStatsLearnType> learnTypes = EnumSet.noneOf(BaseStatsLearnType.class);
    private final Map<String, Item> itemMap = new HashMap<String, Item>();
    private final Map<String, Item> idMap = new HashMap<String, Item>();
    private final Map<String, Item> modAndIdMap = new HashMap<String, Item>();
    NPCTutor tutor;
    List<ItemStack> cost;
    int listTop;
    int listLeft;
    int listHeight;
    int listWidth;
    TutorListScreen guiMoveList;
    int selectedMove = -1;
    EditBox newMove;
    EditBox newItem;
    EditBox newItemAmount;
    EditBox newItemDamage;
    Button okayButton;
    Button addMove;
    Button deleteMove;
    Button addItem;
    Button[] deleteCost = new Button[4];
    Button[] learnTypeButtons = new Button[BaseStatsLearnType.GEN8_DEFAULT.length];
    Button deleteTutor;
    private TextureEditorNPC textureEditor;

    public TutorEditorScreen(int tutorID) {
        super((Component)Component.m_237119_());
        Optional<NPCTutor> entityNPCOptional = NPCEntity.locateNPCClient((Level)Minecraft.m_91087_().f_91073_, tutorID, NPCTutor.class);
        if (!entityNPCOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.tutor = entityNPCOptional.get();
        this.listHeight = 150;
        this.listWidth = 90;
        ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).forEach(itemStack -> {
            Item item = itemStack.m_41720_();
            this.itemMap.put(itemStack.m_41786_().getString(), item);
            ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
            this.idMap.put(location.m_135815_().toLowerCase(Locale.ROOT), item);
            this.modAndIdMap.put((location.m_135827_() + ":" + location.m_135815_()).toLowerCase(Locale.ROOT), item);
        });
    }

    @Override
    public void m_7856_() {
        int i;
        super.m_7856_();
        PixelmonOverlayScreen.isVisible = false;
        Minecraft.m_91087_().f_91066_.f_92062_ = true;
        if (Minecraft.m_91087_().m_293199_().m_294516_()) {
            Minecraft.m_91087_().m_293199_().m_293034_();
        }
        this.listTop = this.f_96544_ / 2 - 62;
        this.listLeft = this.f_96543_ / 2 - 68;
        this.guiMoveList = new TutorListScreen(this, TutorScreen.moveList, this.listWidth, this.listHeight, this.listTop, this.listLeft, this.f_96541_);
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 50, 20, (Component)Component.m_237115_((String)"gui.pokemoneditor.save"), this::actionPerformed));
        this.okayButton = new IndexedButton(10, this.f_96543_ / 2 + 20, this.f_96544_ / 2 + 90, 50, 20, (Component)Component.m_237115_((String)"gui.guiItemDrops.ok"), this::actionPerformed);
        this.newMove = new TabCompleteTextField(1, this.f_96547_, this.f_96543_ / 2 + 54, this.f_96544_ / 2 - 100, 90, 16).setCompletions(AttackRegistry.getAllAttacks().stream().map(ITranslatable::getLocalizedName).collect(Collectors.toSet()));
        this.newItem = new TabCompleteTextField(2, this.f_96547_, this.f_96543_ / 2 + 80, this.f_96544_ / 2 + 30, 70, 16).setCompletions(this.itemMap.keySet());
        this.newItemAmount = new EditBox(this.f_96547_, this.f_96543_ / 2 + 80, this.f_96544_ / 2 + 50, 70, 16, (Component)Component.m_237119_());
        this.newItemDamage = new EditBox(this.f_96547_, this.f_96543_ / 2 + 80, this.f_96544_ / 2 + 70, 70, 16, (Component)Component.m_237119_());
        this.addMove = new IndexedButton(2, this.f_96543_ / 2 + 69, this.f_96544_ / 2 - 80, 60, 20, (Component)Component.m_237115_((String)"gui.tutor.addmove"), this::actionPerformed);
        this.deleteMove = new IndexedButton(3, this.f_96543_ / 2 + 64, this.f_96544_ / 2 - 45, 70, 20, (Component)Component.m_237115_((String)"gui.tutor.deletemove"), this::actionPerformed);
        this.addItem = new IndexedButton(4, this.f_96543_ / 2 + 80, this.f_96544_ / 2 + 90, 60, 20, (Component)Component.m_237115_((String)"gui.tutor.addcost"), this::actionPerformed);
        this.m_142416_(this.guiMoveList);
        this.m_142416_((GuiEventListener)this.newMove);
        if (this.selectedMove > -1) {
            this.m_142416_((GuiEventListener)this.newItemAmount);
            this.m_142416_((GuiEventListener)this.newItemDamage);
            this.m_142416_((GuiEventListener)this.newItem);
            this.m_142416_((GuiEventListener)this.addItem);
            this.m_142416_((GuiEventListener)this.deleteMove);
            this.m_142416_((GuiEventListener)this.okayButton);
        } else {
            i = 0;
            for (BaseStatsLearnType type : BaseStatsLearnType.GEN8_DEFAULT) {
                this.learnTypeButtons[i] = new IndexedButton(11 + i, this.f_96543_ / 2 + 150, this.f_96544_ / 2 - 34 + 16 * i, 20, 16, (Component)Component.m_237113_((String)(learnTypes.contains((Object)type) ? "O" : "X")), this::actionPerformed);
                this.m_142416_((GuiEventListener)this.learnTypeButtons[i]);
                ++i;
            }
        }
        for (i = 0; i < this.deleteCost.length; ++i) {
            this.deleteCost[i] = new IndexedButton(5 + i, this.f_96543_ / 2 + 80 + 20 * i, this.f_96544_ / 2 + 8, 20, 20, (Component)Component.m_237113_((String)"X"), this::actionPerformed);
        }
        this.deleteTutor = new IndexedButton(9, this.f_96543_ / 2 - 173, this.f_96544_ / 2 - 100, 80, 20, (Component)Component.m_237115_((String)"gui.tutor.deletetutor"), this::actionPerformed);
        this.textureEditor = new TextureEditorNPC(this, this.tutor, this.f_96543_ / 2 - 190, this.f_96544_ / 2 + 55, 100, -28);
        this.m_142416_((GuiEventListener)this.textureEditor.customTextureBox);
        this.m_142416_((GuiEventListener)this.addMove);
    }

    public void m_7379_() {
        super.m_7379_();
        this.saveFields();
        PixelmonOverlayScreen.isVisible = true;
        Minecraft.m_91087_().f_91066_.f_92062_ = false;
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        float sixteenthWidth = 40.0f;
        float sixteenthHeight = 20.0f;
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, 0.0f + sixteenthWidth, 0.0f + sixteenthHeight, (float)this.f_96543_ - sixteenthWidth * 2.0f, (float)this.f_96544_ - sixteenthHeight * 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.9f, 0.75f, 0.0f);
        ScreenHelper.drawInUnicode(() -> {
            String text1 = I18n.m_118938_((String)"pixelmon.npc.tutorname", (Object[])new Object[0]);
            matrix.drawString(this.f_96547_, text1, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(text1) / 2.0f, (float)this.f_96544_ / 2.0f - 100.0f, 0, false);
        });
        ScreenHelper.drawInUnicode(() -> {
            String text1 = I18n.m_118938_((String)"gui.choosemoveset.choosemove", (Object[])new Object[0]);
            matrix.drawString(this.f_96547_, text1, (float)this.f_96543_ / 2.0f - 33.0f - (float)this.f_96547_.m_92895_(text1) / 2.0f, (float)this.f_96544_ / 2.0f - 76.0f, 0, false);
        });
        ScreenHelper.drawEntity(matrix, (LivingEntity)this.tutor, this.f_96543_ / 2 - 133, this.f_96544_ / 2 + 50, 50.0f, 360.0f, 0.0f);
        if (this.selectedMove >= 0) {
            text = TutorScreen.moveList.get(this.selectedMove).attack().getLocalizedName();
            matrix.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 99.0f - (float)this.f_96547_.m_92895_(text) / 2.0f, (float)this.f_96544_ / 2.0f - 20.0f, 0, false);
            text = I18n.m_118938_((String)"gui.choosemoveset.cost", (Object[])new Object[0]);
            matrix.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 74.0f - (float)this.f_96547_.m_92895_(text), (float)this.f_96544_ / 2.0f - 5.0f, 0, false);
            if (this.cost.size() < 4) {
                text = I18n.m_118938_((String)"gui.tutor.itemname", (Object[])new Object[0]);
                matrix.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 75.0f - (float)this.f_96547_.m_92895_(text), (float)this.f_96544_ / 2.0f + 35.0f, 0, false);
                text = I18n.m_118938_((String)"gui.tutor.itemamount", (Object[])new Object[0]);
                matrix.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 75.0f - (float)this.f_96547_.m_92895_(text), (float)this.f_96544_ / 2.0f + 55.0f, 0, false);
                text = I18n.m_118938_((String)"gui.tutor.itemdamage", (Object[])new Object[0]);
                matrix.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 75.0f - (float)this.f_96547_.m_92895_(text), (float)this.f_96544_ / 2.0f + 75.0f, 0, false);
            }
        } else {
            text = I18n.m_118938_((String)"gui.tutor.learntypes", (Object[])new Object[0]);
            matrix.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 160.0f - (float)this.f_96547_.m_92895_(text), (float)this.f_96544_ / 2.0f - 45.0f, 0, false);
            int count = 0;
            for (BaseStatsLearnType type : BaseStatsLearnType.GEN8_DEFAULT) {
                text = I18n.m_118938_((String)("gui.tutor.learntype." + type.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
                matrix.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 140.0f - (float)this.f_96547_.m_92895_(text), (float)this.f_96544_ / 2.0f - 30.0f + (float)(16 * count), 0, false);
                ++count;
            }
        }
        this.textureEditor.drawCustomTextBox(matrix, mouseX, mouseY, partialTicks);
        if (this.cost != null && !this.cost.isEmpty()) {
            int i = 0;
            for (ItemStack item : this.cost) {
                matrix.m_280480_(item, this.f_96543_ / 2 + 80 + i * 21, this.f_96544_ / 2 - 10);
                matrix.m_280302_(this.f_96541_.f_91062_, item, this.f_96543_ / 2 + 80 + i * 21, this.f_96544_ / 2 - 10, null);
                if (i < this.deleteCost.length && !this.f_96540_.contains(this.deleteCost[i])) {
                    this.m_142416_((GuiEventListener)this.deleteCost[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public void elementClicked(List<NPCTutor.LearnableMove> list, int index) {
        if (!TutorScreen.moveList.isEmpty() && index < TutorScreen.moveList.size()) {
            this.selectedMove = index;
            this.cost = TutorScreen.moveList.get(index).costs();
            if (!this.f_169369_.contains(this.deleteMove)) {
                this.m_142416_((GuiEventListener)this.deleteMove);
            }
            if (!this.f_169369_.contains(this.addItem) && this.cost.size() < 4) {
                this.m_142416_((GuiEventListener)this.addItem);
            }
            for (Button deleteCostButton : this.deleteCost) {
                this.m_169411_((GuiEventListener)deleteCostButton);
            }
            for (Button learnTypeButton : this.learnTypeButtons) {
                this.m_169411_((GuiEventListener)learnTypeButton);
            }
            this.m_142416_((GuiEventListener)this.okayButton);
            this.m_142416_((GuiEventListener)this.newItem);
            this.m_142416_((GuiEventListener)this.newItemDamage);
            this.m_142416_((GuiEventListener)this.newItemAmount);
        }
    }

    public boolean m_5534_(char key, int keyCode) {
        if (keyCode == 256 || keyCode == 257) {
            this.saveFields();
        }
        return super.m_5534_(key, keyCode);
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 1) {
                this.saveFields();
            } else if (id == 2) {
                Optional<ImmutableAttack> optional = AttackRegistry.getAttackBase(this.newMove.m_94155_());
                if (optional.isPresent()) {
                    ImmutableAttack move = optional.get();
                    if (TutorScreen.moveList.stream().noneMatch(it -> it.attack() == move)) {
                        TutorScreen.moveList.add(new NPCTutor.LearnableMove(move, Lists.newArrayList(), true));
                    }
                }
            } else if (id == 3) {
                if (this.selectedMove >= 0 && this.selectedMove < TutorScreen.moveList.size()) {
                    TutorScreen.moveList.remove(this.selectedMove);
                    this.cost = Lists.newArrayList();
                    this.selectedMove = -1;
                    this.m_169411_((GuiEventListener)this.addItem);
                    this.m_169411_((GuiEventListener)this.deleteMove);
                    this.m_169411_((GuiEventListener)this.newItem);
                    this.m_169411_((GuiEventListener)this.newItemDamage);
                    this.m_169411_((GuiEventListener)this.newItemAmount);
                    this.m_169411_((GuiEventListener)this.okayButton);
                    for (Button deleteCostButton : this.deleteCost) {
                        this.m_169411_((GuiEventListener)deleteCostButton);
                    }
                    for (Button learnTypeButton : this.learnTypeButtons) {
                        this.m_142416_((GuiEventListener)learnTypeButton);
                    }
                }
            } else if (id == 4) {
                if (this.cost.size() < 4) {
                    String itemString = this.newItem.m_94155_();
                    Item item = null;
                    if (this.itemMap.containsKey(itemString)) {
                        item = this.itemMap.get(itemString);
                    } else if (this.idMap.containsKey(itemString.toLowerCase(Locale.ROOT))) {
                        item = this.idMap.get(itemString.toLowerCase(Locale.ROOT));
                    } else if (this.modAndIdMap.containsKey(itemString.toLowerCase(Locale.ROOT))) {
                        item = this.modAndIdMap.get(itemString.toLowerCase(Locale.ROOT));
                    } else {
                        try {
                            item = Item.m_41445_((int)Integer.parseInt(itemString));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (item != null) {
                        int amount = 1;
                        int damage = 0;
                        try {
                            amount = Math.max(amount, Integer.parseInt(this.newItemAmount.m_94155_()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            damage = Math.max(damage, Integer.parseInt(this.newItemDamage.m_94155_()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        ItemStack newItem = new ItemStack((ItemLike)item, amount);
                        if (amount > newItem.m_41741_()) {
                            newItem.m_41764_(newItem.m_41741_());
                        }
                        if (damage != 0) {
                            newItem.m_41721_(damage);
                        }
                        this.cost.add(newItem);
                        if (this.cost.size() >= 4) {
                            this.m_169411_((GuiEventListener)this.addItem);
                        }
                    }
                }
            } else if (id >= 5 && id <= 8) {
                int deleteButtonIndex = id - 5;
                if (this.cost.size() > deleteButtonIndex) {
                    this.cost.remove(deleteButtonIndex);
                    for (Button deleteCostButton : this.deleteCost) {
                        this.m_169411_((GuiEventListener)deleteCostButton);
                    }
                    if (!this.f_169369_.contains(this.addItem)) {
                        this.m_169411_((GuiEventListener)this.addItem);
                    }
                }
            } else if (id == 9) {
                NetworkHelper.sendToServer(new DeleteTrainerPacket(this.tutor.getNPCID()));
                ScreenHelper.closeScreen();
            } else if (id == 10) {
                this.cost = null;
                this.selectedMove = -1;
                this.m_169411_((GuiEventListener)this.addItem);
                this.m_169411_((GuiEventListener)this.okayButton);
                this.m_169411_((GuiEventListener)this.deleteMove);
                this.m_169411_((GuiEventListener)this.newItem);
                this.m_169411_((GuiEventListener)this.newItemDamage);
                this.m_169411_((GuiEventListener)this.newItemAmount);
                for (Button deleteCostButton : this.deleteCost) {
                    this.m_169411_((GuiEventListener)deleteCostButton);
                }
                for (Button learnTypeButton : this.learnTypeButtons) {
                    this.m_142416_((GuiEventListener)learnTypeButton);
                }
            } else if (id >= 11 && id <= 11 + this.learnTypeButtons.length) {
                int index = id - 11;
                if (this.learnTypeButtons[index].m_6035_().getString().equals("X")) {
                    this.learnTypeButtons[index].m_93666_((Component)Component.m_237113_((String)"0"));
                    learnTypes.add(BaseStatsLearnType.GEN8_DEFAULT[index]);
                } else {
                    this.learnTypeButtons[index].m_93666_((Component)Component.m_237113_((String)"X"));
                    learnTypes.remove((Object)BaseStatsLearnType.GEN8_DEFAULT[index]);
                }
            }
        }
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    private void saveFields() {
        if (!TutorScreen.moveList.isEmpty()) {
            if (this.tutor != null) {
                NetworkHelper.sendToServer(new StoreTutorDataPacket(this.tutor.m_19879_(), TutorScreen.moveList, learnTypes));
                this.textureEditor.saveCustomTexture();
            }
            ScreenHelper.closeScreen();
        }
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (p_231046_1_ == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        return this.m_7222_() != null && this.m_7222_().m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
    }
}

