/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerDropListSlotScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerDataPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class TrainerEditorMoreScreen
extends Screen {
    private Map<String, ItemStack> itemMap = new HashMap<String, ItemStack>();
    private Map<String, ItemStack> idMap = new HashMap<String, ItemStack>();
    private Map<String, ItemStack> modAndIdMap = new HashMap<String, ItemStack>();
    EditBox tfGreeting;
    EditBox tfWin;
    EditBox tfLose;
    EditBox tfDrop;
    EditBox tfWinMoney;
    protected int listTop;
    protected int listLeft;
    protected int listHeight;
    protected int listWidth;
    ArrayList<ItemStack> dropList = new ArrayList();
    TrainerDropListSlotScreen list;
    int lastWidth;
    int lastHeight;

    public TrainerEditorMoreScreen() {
        super((Component)Component.m_237119_());
        if (TrainerEditorScreen.trainerData == null) {
            TrainerEditorScreen.trainerData = new SetTrainerData("", "", "", "", 0, new ItemStack[0], new BattleRules());
        }
        Collections.addAll(this.dropList, TrainerEditorScreen.trainerData.winnings);
        ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).forEach(itemStack -> {
            NonNullList list = NonNullList.m_122779_();
            list.add(itemStack);
            list.forEach(stack -> {
                this.itemMap.put(stack.m_41786_().getString(), (ItemStack)stack);
                ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                this.idMap.put(location.m_135815_().toLowerCase(Locale.ROOT), (ItemStack)stack);
                this.modAndIdMap.put((location.m_135827_() + ":" + location.m_135815_()).toLowerCase(Locale.ROOT), (ItemStack)stack);
            });
        });
    }

    private void initList() {
        this.lastWidth = this.f_96543_;
        this.lastHeight = this.f_96544_;
        this.listTop = this.f_96544_ / 2 + 30;
        this.listLeft = this.f_96543_ / 2 - 160;
        this.listHeight = 80;
        this.listWidth = 100;
        this.list = new TrainerDropListSlotScreen(this);
        this.m_142416_((GuiEventListener)this.list);
    }

    public void m_7856_() {
        super.m_7856_();
        this.initList();
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 30, 20, (Component)Component.m_237115_((String)"gui.guiItemDrops.ok"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(2, this.f_96543_ / 2 - 30, this.f_96544_ / 2 + 70, 80, 20, (Component)Component.m_237115_((String)"gui.trainereditor.additem"), this::actionPerformed));
        this.tfGreeting = new EditBox(this.f_96547_, this.f_96543_ / 2 - 120, this.f_96544_ / 2 - 70, 280, 17, (Component)Component.m_237119_());
        this.tfGreeting.m_94199_(2000);
        this.tfGreeting.m_94144_(TrainerEditorScreen.trainerData.greeting);
        this.m_142416_((GuiEventListener)this.tfGreeting);
        this.tfWin = new EditBox(this.f_96547_, this.f_96543_ / 2 - 120, this.f_96544_ / 2 - 50, 280, 17, (Component)Component.m_237119_());
        this.tfWin.m_94199_(2000);
        this.tfWin.m_94144_(TrainerEditorScreen.trainerData.win);
        this.m_142416_((GuiEventListener)this.tfWin);
        this.tfLose = new EditBox(this.f_96547_, this.f_96543_ / 2 - 120, this.f_96544_ / 2 - 30, 280, 17, (Component)Component.m_237119_());
        this.tfLose.m_94199_(2000);
        this.tfLose.m_94144_(TrainerEditorScreen.trainerData.lose);
        this.m_142416_((GuiEventListener)this.tfLose);
        this.tfDrop = new TabCompleteTextField(7, this.f_96547_, this.f_96543_ / 2 - 30, this.f_96544_ / 2 + 50, 120, 17).setCompletions(this.itemMap.keySet());
        this.m_142416_((GuiEventListener)this.tfDrop);
        this.tfWinMoney = new EditBox(this.f_96547_, this.f_96543_ / 2 + 110, this.f_96544_ / 2 + 50, 80, 20, (Component)Component.m_237119_());
        this.tfWinMoney.m_94199_(2000);
        this.tfWinMoney.m_94144_(String.valueOf(TrainerEditorScreen.trainerData.winMoney));
        this.m_142416_((GuiEventListener)this.tfWinMoney);
    }

    public void m_88315_(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.f_96543_ / 2.0f - 200.0f, (float)this.f_96544_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.moreinfo", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - (float)this.f_96541_.f_91062_.m_92895_(I18n.m_118938_((String)"gui.trainereditor.moreinfo", (Object[])new Object[0])) / 2.0f, (float)this.f_96544_ / 2.0f - 90.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.greeting", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f - 65.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.win", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f - 45.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.lose", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f - 25.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.winningdrops", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 157.0f, (float)this.f_96544_ / 2.0f + 15.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.adddrops", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 30.0f, (float)this.f_96544_ / 2.0f + 15.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.enteritemname", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 30.0f, (float)this.f_96544_ / 2.0f + 30.0f, 0, false);
        matrix.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.winmoney", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f + 110.0f, (float)this.f_96544_ / 2.0f + 30.0f, 0, false);
        for (GuiEventListener child : this.f_96540_) {
            if (!(child instanceof Renderable)) continue;
            ((Renderable)child).m_88315_(matrix, mouseX, mouseY, partialTicks);
        }
        super.m_88315_(matrix, mouseX, mouseY, partialTicks);
    }

    public boolean m_5534_(char key, int par2) {
        if (par2 == 256 || par2 == 257) {
            this.saveFields();
        }
        return super.m_5534_(key, par2);
    }

    public boolean m_6375_(double x, double y, int z) {
        return super.m_6375_(x, y, z);
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 1) {
                this.saveFields();
            } else if (id == 2) {
                String itemString = this.tfDrop.m_94155_();
                if (this.itemMap.containsKey(itemString)) {
                    this.dropList.add(this.itemMap.get(itemString).m_41777_());
                } else if (this.idMap.containsKey(itemString.toLowerCase(Locale.ROOT))) {
                    this.dropList.add(this.idMap.get(itemString.toLowerCase(Locale.ROOT)).m_41777_());
                } else if (this.modAndIdMap.containsKey(itemString.toLowerCase(Locale.ROOT))) {
                    this.dropList.add(this.modAndIdMap.get(itemString.toLowerCase(Locale.ROOT)).m_41777_());
                } else {
                    try {
                        String[] split = itemString.split(":", 2);
                        int id2 = Integer.parseInt(split[0]);
                        if (Item.m_41445_((int)id2) != null) {
                            this.dropList.add(new ItemStack((ItemLike)Item.m_41445_((int)id2)));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void saveFields() {
        ItemStack[] drops = new ItemStack[this.dropList.size()];
        for (int i = 0; i < this.dropList.size(); ++i) {
            drops[i] = this.dropList.get(i);
        }
        int winMoneyValue = TrainerEditorScreen.trainerData.winMoney;
        try {
            winMoneyValue = Math.max(0, Integer.parseInt(this.tfWinMoney.m_94155_()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        SetTrainerData p = new SetTrainerData(TrainerEditorScreen.trainerData.name, this.tfGreeting.m_94155_(), this.tfWin.m_94155_(), this.tfLose.m_94155_(), winMoneyValue, drops);
        p.id = TrainerEditorScreen.currentTrainerID;
        if (!(this.tfGreeting.m_94155_().equals(TrainerEditorScreen.trainerData.greeting) && this.tfWin.m_94155_().equals(TrainerEditorScreen.trainerData.win) && this.tfLose.m_94155_().equals(TrainerEditorScreen.trainerData.lose) && winMoneyValue == TrainerEditorScreen.trainerData.winMoney)) {
            NetworkHelper.sendToServer(new StoreTrainerDataPacket(TrainerEditorScreen.currentTrainerID, p));
        }
        NetworkHelper.sendToServer(new StoreTrainerDataPacket(TrainerEditorScreen.currentTrainerID, drops));
        TrainerEditorScreen.trainerData = p;
        this.f_96541_.m_91152_((Screen)new TrainerEditorScreen(TrainerEditorScreen.currentTrainerID));
    }

    public int getDropListCount() {
        return this.dropList.size();
    }

    public void removeFromList(int ind) {
        this.dropList.remove(ind);
    }

    public ItemStack getDropListEntry(int ind) {
        if (ind < this.dropList.size() && ind >= 0) {
            return this.dropList.get(ind);
        }
        return null;
    }
}

