/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.ShinyRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteTrainerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class TradeEditorScreen
extends DropDownScreen {
    public int top;
    public int left;
    EditBox offerName;
    EditBox exchangeName;
    EditBox descriptionTextBox;
    NPCTrader trader;
    PokemonSpecification offer;
    boolean offerChanged = false;
    PokemonSpecification exchange;
    boolean exchangeChanged = false;
    String description;
    private TextureEditorNPC textureEditor;

    public TradeEditorScreen(int traderId) {
        super((Component)Component.m_237119_());
        this.xSize = 256;
        this.ySize = 226;
        Optional<NPCTrader> entityNPCOptional = NPCEntity.locateNPCClient((Level)Minecraft.m_91087_().f_91073_, traderId, NPCTrader.class);
        if (!entityNPCOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.trader = entityNPCOptional.get();
        this.offer = ClientProxy.currentTradePair.offer;
        this.exchange = ClientProxy.currentTradePair.exchange;
        this.description = ClientProxy.currentTradePair.description;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.trader == null) {
            ScreenHelper.closeScreen();
            return;
        }
        if (ClientProxy.currentTradePair == null) {
            ClientProxy.currentTradePair = new TradePair(PokemonSpecificationProxy.create("random").get(), PokemonSpecificationProxy.create("random").get());
        }
        this.left = (this.f_96543_ - this.xSize) / 2;
        this.top = (this.f_96544_ - this.ySize) / 2;
        this.offerName = new TabCompleteTextField(6, this.f_96541_.f_91062_, this.f_96543_ / 2 - 45, this.f_96544_ / 2 + 10, 90, 17).setCompletions(PixelmonSpecies.getFormattedEnglishNameSet());
        this.offerName.m_94199_(150);
        this.offerName.m_94144_(this.offer.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.MISSINGNO).getValueUnsafe().getName());
        this.m_142416_((GuiEventListener)this.offerName);
        this.exchangeName = new TabCompleteTextField(7, this.f_96541_.f_91062_, this.f_96543_ / 2 + 100, this.f_96544_ / 2 + 10, 90, 17).setCompletions(PixelmonSpecies.getFormattedEnglishNameSet());
        this.exchangeName.m_94199_(150);
        this.exchangeName.m_94144_(this.exchange.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.MISSINGNO).getValueUnsafe().getName());
        this.m_142416_((GuiEventListener)this.exchangeName);
        this.descriptionTextBox = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 45, this.f_96544_ / 2 + 50, 235, 15, (Component)Component.m_237119_());
        this.descriptionTextBox.m_94199_(150);
        if (this.description != null) {
            this.descriptionTextBox.m_94144_(this.description);
        }
        this.m_142416_((GuiEventListener)this.descriptionTextBox);
        this.m_142416_((GuiEventListener)new IndexedButton(0, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 30, 20, (Component)Component.m_237115_((String)"gui.guiItemDrops.ok"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 100, this.f_96544_ / 2 - 110, 80, 20, (Component)Component.m_237115_((String)"gui.tradereditor.delete"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(2, this.f_96543_ / 2 - 40, this.f_96544_ / 2 - 110, 80, 20, (Component)Component.m_237115_((String)"gui.tradereditor.random"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(3, this.f_96543_ / 2 + 58, this.f_96544_ / 2 + 9, 30, 20, (Component)Component.m_237113_((String)"<->"), this::actionPerformed));
        this.textureEditor = new TextureEditorNPC(this, this.trader, this.f_96543_ / 2 - 190, this.f_96544_ / 2 + 50, 130, -23);
        this.m_142416_((GuiEventListener)this.textureEditor.customTextureBox);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, (float)this.f_96543_ / 2.0f - 200.0f, (float)this.f_96544_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        ScreenHelper.drawEntity(graphics, (LivingEntity)this.trader, this.f_96543_ / 2 - 125, this.f_96544_ / 2 + 40, 50.0f, 360.0f, 0.0f);
        if (ClientProxy.currentTradePair.offer.getValue(ShinyRequirement.class).orElse(false).booleanValue()) {
            this.offerName.m_94202_(0xFFFF33);
        } else {
            this.offerName.m_94202_(0xFFFFFF);
        }
        if (ClientProxy.currentTradePair.offer.getValue(ShinyRequirement.class).orElse(false).booleanValue()) {
            this.exchangeName.m_94202_(0xFFFF33);
        } else {
            this.exchangeName.m_94202_(0xFFFFFF);
        }
        graphics.m_280056_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.tradereditor.offer", (Object[])new Object[0]), this.left + 85, this.top + 110, 0, false);
        graphics.m_280056_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.tradereditor.exchange", (Object[])new Object[0]), this.left + 225, this.top + 110, 0, false);
        graphics.m_280056_(this.f_96541_.f_91062_, I18n.m_118938_((String)"gui.tradereditor.description", (Object[])new Object[0]), this.left + 85, this.top + 150, 0, false);
        this.textureEditor.drawCustomTextBox(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_5534_(char key, int keyCode) {
        if (keyCode == 256 || keyCode == 257) {
            this.saveFields();
        }
        if (this.m_7222_() == this.offerName) {
            this.offerChanged = true;
        }
        if (this.m_7222_() == this.exchangeName) {
            this.exchangeChanged = true;
        }
        return super.m_5534_(key, keyCode);
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        if (ClientStorageManager.party.inTemporaryMode()) {
            return true;
        }
        this.offerName.m_6375_(x, y, mouseButton);
        this.exchangeName.m_6375_(x, y, mouseButton);
        this.descriptionTextBox.m_6375_(x, y, mouseButton);
        this.textureEditor.mouseClicked(x, y, mouseButton);
        return super.mouseClickedUnderMenus(x, y, mouseButton);
    }

    protected void actionPerformed(Button button) {
        if (button.f_93623_ && button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 0) {
                this.saveFields();
            } else if (id == 1) {
                ScreenHelper.closeScreen();
                Minecraft.m_91087_().m_91118_((Entity)Minecraft.m_91087_().f_91074_);
                NetworkHelper.sendToServer(new DeleteTrainerPacket(this.trader.getNPCID()));
            } else if (id == 2) {
                List<Species> list = PixelmonSpecies.getAll();
                String poke1 = RandomHelper.getRandomElementFromCollection(list).getName();
                String poke2 = RandomHelper.getRandomElementFromCollection(list).getName();
                if (poke2.equalsIgnoreCase(poke1)) {
                    poke2 = RandomHelper.getRandomElementFromCollection(list).getName();
                }
                this.offerName.m_94144_(poke1);
                this.exchangeName.m_94144_(poke2);
                this.exchangeChanged = true;
                this.offerChanged = true;
            } else if (id == 3) {
                String text = this.offerName.m_94155_();
                this.offerName.m_94144_(this.exchangeName.m_94155_());
                this.exchangeName.m_94144_(text);
                this.exchangeChanged = true;
                this.offerChanged = true;
            }
        }
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    private void saveFields() {
        String offerText = this.offerName.m_94155_();
        String exchangeText = this.exchangeName.m_94155_();
        this.description = this.descriptionTextBox.m_94155_();
        PokemonSpecification offer = PokemonSpecificationProxy.create(offerText.split(" ")).get();
        PokemonSpecification exchange = PokemonSpecificationProxy.create(exchangeText.split(" ")).get();
        if (exchange.getValue(SpeciesRequirement.class).isPresent() && offer.getValue(SpeciesRequirement.class).isPresent()) {
            this.setNewTradePokemon(this.offerChanged ? offer : this.offer, this.exchangeChanged ? exchange : this.exchange);
            this.exchangeChanged = false;
            this.offerChanged = false;
            ScreenHelper.closeScreen();
            Minecraft.m_91087_().m_91118_((Entity)Minecraft.m_91087_().f_91074_);
        }
        this.textureEditor.saveCustomTexture();
    }

    private void setNewTradePokemon(PokemonSpecification offer, PokemonSpecification exchange) {
        ClientProxy.currentTradePair = new TradePair(offer, exchange, this.description);
        NetworkHelper.sendToServer(new NPCServerPacket(this.trader.getNPCID(), offer, exchange, this.description));
    }
}

