/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumNPCServerPacketType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

class TextureEditorNPC {
    private DropDownScreen gui;
    private NPCEntity npc;
    private BaseTrainer model;
    private int x;
    private int y;
    private int width;
    private int yOffset;
    public EditBox customTextureBox;
    private DropDown<String> modelTextureDropDown;
    private boolean customFocus = false;

    TextureEditorNPC(DropDownScreen gui, NPCEntity npc, int x, int y, int width) {
        this(gui, npc, x, y, width, 0);
    }

    TextureEditorNPC(DropDownScreen gui, NPCEntity npc, int x, int y, int width, int yOffset) {
        this.gui = gui;
        this.npc = npc;
        this.model = npc.getBaseTrainer();
        this.x = x;
        this.y = y;
        this.width = width;
        this.yOffset = yOffset;
        gui.addDropDown(new DropDown<BaseTrainer>(ServerNPCRegistry.trainers.getTypes(), this.model, x, y + yOffset, width, 92).setGetOptionString(trainer -> I18n.m_118938_((String)("trainer." + trainer.name), (Object[])new Object[0])).setOnSelected(this::selectTrainerType).setInactiveTop(y).setOrdered());
        if (this.model != null && this.model.textures.size() > 1) {
            this.displayTextureMenu();
        }
        this.customTextureBox = new EditBox(Minecraft.m_91087_().f_91062_, x, y + 38, width, 20, (Component)Component.m_237119_());
        String tex = this.npc.getCustomSteveTexture();
        this.customTextureBox.m_94144_(tex.contains(";") ? tex.split(";")[0] : tex);
    }

    private void displayTextureMenu() {
        int modelDistance = 16;
        this.modelTextureDropDown = new DropDown<int>((List<int>)this.model.textures, this.npc.getTextureIndex(), this.x, this.y + Math.max(this.yOffset, (this.model.textures.size() - 1) * -10) + modelDistance, this.width, 70).setGetOptionString(texture -> I18n.m_118938_((String)("trainer.model." + texture), (Object[])new Object[0])).setOnSelectedIndex(this::selectTexture).setInactiveTop(this.y + modelDistance);
        this.gui.addDropDown(this.modelTextureDropDown);
    }

    private void selectTrainerType(BaseTrainer model) {
        this.model = model;
        this.npc.setBaseTrainer(model);
        NetworkHelper.sendToServer(new NPCServerPacket(this.npc.getNPCID(), this.model.id));
        this.npc.setTextureIndex(0);
        this.gui.removeDropDown(this.modelTextureDropDown);
        if (this.model.textures.size() > 1) {
            this.npc.setNickName("Steve");
            this.displayTextureMenu();
        }
    }

    private void selectTexture(int textureIndex) {
        if (!this.model.textures.isEmpty()) {
            NetworkHelper.sendToServer(new NPCServerPacket(this.npc.getNPCID(), EnumNPCServerPacketType.TextureIndex, textureIndex));
        }
    }

    void drawCustomTextBox(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isCustomTexture()) {
            this.customTextureBox.m_87963_(graphics, mouseX, mouseY, partialTicks);
            this.customTextureBox.m_94194_(true);
        } else {
            this.customTextureBox.m_94194_(false);
        }
    }

    void keyTyped(char key, int keyCode, EditBox ... otherFields) {
        if (this.customFocus && !this.customTextureBox.m_93696_()) {
            this.saveCustomTexture();
        }
        this.customFocus = this.customTextureBox.m_93696_();
        this.customTextureBox.m_5534_(key, keyCode);
        if (this.customTextureBox.m_94213_()) {
            ArrayList<EditBox> fields = new ArrayList<EditBox>(Arrays.asList(otherFields));
            fields.add(this.customTextureBox);
            ScreenHelper.switchFocus(keyCode, fields);
        } else {
            ScreenHelper.switchFocus(keyCode, otherFields);
        }
        this.customTextureBox.m_7933_((int)key, keyCode, 0);
    }

    void mouseClicked(double x, double y, int mouseButton) {
        this.customTextureBox.m_93692_(this.customTextureBox.m_6375_(x, y, mouseButton));
        if (this.customFocus && !this.customTextureBox.m_93696_()) {
            this.saveCustomTexture();
        }
        this.customFocus = this.customTextureBox.m_93696_();
    }

    void saveCustomTexture() {
        if (this.isCustomTexture() && !this.customTextureBox.m_94155_().equals(this.npc.getCustomSteveTexture().split(";")[0])) {
            NetworkHelper.sendToServer(new NPCServerPacket(this.npc.getNPCID(), EnumNPCServerPacketType.CustomSteveTexture, this.customTextureBox.m_94155_()));
        }
    }

    private boolean isCustomTexture() {
        if (this.model != null && !this.model.textures.isEmpty() && (this.model == NPCRegistryTrainers.Steve || this.model.name.equals("Steve"))) {
            String texture = this.model.textures.get(this.npc.getTextureIndex());
            return texture.equals("Custom_RP") || texture.equals("Custom_PN");
        }
        return false;
    }
}

