/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteTrainerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumNPCServerPacketType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientShopkeeperData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ShopkeeperEditorScreen
extends DropDownScreen {
    public static int shopkeeperID;
    public static String json;
    public static String name;
    public static List<ClientShopkeeperData> shopkeeperData;
    NPCShopkeeper npc;
    private DropDown jsonDropDown;
    private DropDown nameDropDown;
    private DropDown textureDropDown;

    public ShopkeeperEditorScreen(int shopkeeperID) {
        super((Component)Component.m_237119_());
        Optional<NPCShopkeeper> npcShopkeeperOptional = NPCEntity.locateNPCClient((Level)Minecraft.m_91087_().f_91073_, shopkeeperID, NPCShopkeeper.class);
        if (!npcShopkeeperOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.npc = npcShopkeeperOptional.get();
        ShopkeeperEditorScreen.shopkeeperID = shopkeeperID;
        if (this.npc == null) {
            ScreenHelper.closeScreen();
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 30, 20, (Component)Component.m_237115_((String)"gui.guiItemDrops.ok"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(6, this.f_96543_ / 2 + 100, this.f_96544_ / 2 - 120, 80, 20, (Component)Component.m_237115_((String)"gui.npceditor.despawn"), this::actionPerformed));
        this.jsonDropDown = new DropDown<ClientShopkeeperData>(shopkeeperData, new ClientShopkeeperData(json), this.f_96543_ / 2 - 10, this.f_96544_ / 2 - 81, 140, 100).setGetOptionString(shopkeeper -> I18n.m_118938_((String)("npc.shopkeeper." + shopkeeper.getID()), (Object[])new Object[0])).setOnSelected(shopkeeper -> NetworkHelper.sendToServer(new NPCServerPacket(shopkeeperID, EnumNPCServerPacketType.CycleJson, shopkeeper.getID()))).setOrdered();
        this.addDropDown(this.jsonDropDown);
        ClientShopkeeperData currentShopkeeper = null;
        for (ClientShopkeeperData data : shopkeeperData) {
            if (!data.getID().equals(name)) continue;
            currentShopkeeper = data;
            break;
        }
        if (currentShopkeeper == null) {
            if (shopkeeperData.isEmpty()) {
                ScreenHelper.closeScreen();
                return;
            }
            currentShopkeeper = shopkeeperData.get(0);
        }
        this.resetDropDowns(currentShopkeeper, this.npc.getCustomSteveTexture());
        this.m_142416_((GuiEventListener)new IndexedButton(5, this.f_96543_ / 2 - 10, this.f_96544_ / 2 + 5, 140, 20, (Component)Component.m_237115_((String)"gui.shopkeepereditor.refreshItems"), this::actionPerformed));
    }

    public void updateShopkeeper(String texture) {
        int selectedIndex;
        if (this.jsonDropDown != null && (selectedIndex = this.jsonDropDown.getSelectedIndex()) >= 0) {
            this.resetDropDowns(shopkeeperData.get(selectedIndex), texture);
        }
    }

    private void resetDropDowns(ClientShopkeeperData currentShopkeeper, String newTexture) {
        this.removeDropDown(this.nameDropDown);
        this.nameDropDown = new DropDown<String>(currentShopkeeper.getNames(), name, this.f_96543_ / 2 - 10, this.f_96544_ / 2 - 51, 140, 100).setOnSelectedIndex(index -> NetworkHelper.sendToServer(new NPCServerPacket(shopkeeperID, EnumNPCServerPacketType.CycleName, (int)index)));
        this.addDropDown(this.nameDropDown);
        this.removeDropDown(this.textureDropDown);
        this.textureDropDown = new DropDown<String>(currentShopkeeper.getTextures(), newTexture, this.f_96543_ / 2 - 10, this.f_96544_ / 2 - 21, 140, 100).setGetOptionString(texture -> I18n.m_118938_((String)("npc.model." + texture.replace(".png", "")), (Object[])new Object[0])).setOnSelected(texture -> NetworkHelper.sendToServer(new NPCServerPacket(shopkeeperID, EnumNPCServerPacketType.CustomSteveTexture, (String)texture)));
        this.addDropDown(this.textureDropDown);
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, (float)this.f_96543_ / 2.0f - 200.0f, (float)this.f_96544_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        ScreenHelper.drawEntity(graphics, (LivingEntity)this.npc, this.f_96543_ / 2 - 140, this.f_96544_ / 2 + 50, 60.0f, 360.0f, 0.0f);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"gui.shopkeeper.json", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 60.0f, (float)this.f_96544_ / 2.0f - 80.0f, 0, false);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 60.0f, (float)this.f_96544_ / 2.0f - 50.0f, 0, false);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.model", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 60.0f, (float)this.f_96544_ / 2.0f - 20.0f, 0, false);
    }

    public boolean m_5534_(char key, int par2) {
        if (par2 == 256 || par2 == 257) {
            ScreenHelper.closeScreen();
        }
        return super.m_5534_(key, par2);
    }

    protected void actionPerformed(Button button) {
        if (button.f_93623_ && button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 1) {
                ScreenHelper.closeScreen();
            } else if (id == 5) {
                NetworkHelper.sendToServer(new NPCServerPacket(shopkeeperID, EnumNPCServerPacketType.RefreshItems));
            } else if (id == 6) {
                NetworkHelper.sendToServer(new DeleteTrainerPacket(shopkeeperID));
                ScreenHelper.closeScreen();
            }
        }
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    static {
        shopkeeperData = new ArrayList<ClientShopkeeperData>();
    }
}

