/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteTrainerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumNPCServerPacketType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientNPCData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ChattingNPCEditorScreen
extends DropDownScreen {
    public static int currentNPCID;
    public static ArrayList<String> chatPages;
    public static boolean chatChanged;
    public static String name;
    NPCChatting npc;
    EditBox nameBox;
    EditBox page1Box;
    EditBox page2Box;
    EditBox page3Box;
    EditBox page4Box;
    EditBox textureBox;
    public static List<ClientNPCData> npcData;

    public ChattingNPCEditorScreen(int npcID) {
        super((Component)Component.m_237119_());
        Optional<NPCChatting> npcChattingOptional = NPCEntity.locateNPCClient((Level)Minecraft.m_91087_().f_91073_, npcID, NPCChatting.class);
        if (!npcChattingOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.npc = npcChattingOptional.get();
        currentNPCID = npcID;
        if (this.npc == null) {
            ScreenHelper.closeScreen();
        }
    }

    @Override
    public void m_7856_() {
        String type;
        super.m_7856_();
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 30, 20, (Component)Component.m_237115_((String)"gui.guiItemDrops.ok"), this::actionPerformed));
        this.m_142416_((GuiEventListener)new IndexedButton(6, this.f_96543_ / 2 + 100, this.f_96544_ / 2 - 120, 80, 20, (Component)Component.m_237115_((String)"gui.npceditor.despawn"), this::actionPerformed));
        this.nameBox = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 20, this.f_96544_ / 2 - 96, 180, 20, (Component)Component.m_237119_());
        this.nameBox.m_94144_(name);
        this.m_142416_((GuiEventListener)this.nameBox);
        this.textureBox = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 189, this.f_96544_ / 2 + 100, 149, 10, (Component)Component.m_237119_());
        this.m_142416_((GuiEventListener)this.textureBox);
        String textureText = this.npc.getCustomSteveTexture();
        String string = type = !this.npc.getBaseTrainer().textures.isEmpty() ? this.npc.getBaseTrainer().textures.get(this.npc.getTextureIndex()) : "";
        if (type.startsWith("Custom")) {
            this.textureBox.m_94144_(textureText.replaceAll(";.+", ""));
            textureText = type;
        }
        ArrayList npcs = Lists.newArrayList(npcData);
        npcs.add(new ClientNPCData("Custom_RP", "Custom_RP"));
        npcs.add(new ClientNPCData("Custom_PN", "Custom_PN"));
        npcs.sort(Comparator.comparing(ClientNPCData::getID));
        this.addDropDown(new DropDown<ClientNPCData>(npcs, new ClientNPCData(textureText), this.f_96543_ / 2 - 190, this.f_96544_ / 2 - 85, 140, 200).setGetOptionString(npc -> {
            if (npc.getTexture().contains(".png")) {
                return I18n.m_118938_((String)("npc.model." + npc.getTexture().replace(".png", "")), (Object[])new Object[0]);
            }
            return I18n.m_118938_((String)("trainer.model." + npc.getTexture()), (Object[])new Object[0]);
        }).setOnSelected(npc -> {
            if (npc.getID().startsWith("Custom")) {
                NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, EnumNPCServerPacketType.TextureIndex, this.npc.getBaseTrainer().textures.indexOf(npc.getID())));
                this.textureBox.m_94144_("");
            } else {
                NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, (ClientNPCData)npc));
            }
        }).setInactiveTop(this.f_96544_ / 2 + 85).setOrdered());
        this.page1Box = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 80, this.f_96544_ / 2 - 50, 260, 20, (Component)Component.m_237119_());
        this.page1Box.m_94199_(128);
        this.page1Box.m_94144_(!chatPages.isEmpty() ? chatPages.get(0) : "");
        this.m_142416_((GuiEventListener)this.page1Box);
        this.page2Box = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 80, this.f_96544_ / 2 - 15, 260, 20, (Component)Component.m_237119_());
        this.page2Box.m_94199_(128);
        this.page2Box.m_94144_(chatPages.size() > 1 ? chatPages.get(1) : "");
        this.m_142416_((GuiEventListener)this.page2Box);
        this.page3Box = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 80, this.f_96544_ / 2 + 20, 260, 20, (Component)Component.m_237119_());
        this.page3Box.m_94199_(128);
        this.page3Box.m_94144_(chatPages.size() > 2 ? chatPages.get(2) : "");
        this.m_142416_((GuiEventListener)this.page3Box);
        this.page4Box = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 80, this.f_96544_ / 2 + 55, 260, 20, (Component)Component.m_237119_());
        this.page4Box.m_94199_(128);
        this.page4Box.m_94144_(chatPages.size() > 3 ? chatPages.get(3) : "");
        this.m_142416_((GuiEventListener)this.page4Box);
        chatChanged = false;
    }

    @Override
    protected void drawBackgroundUnderMenus(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, (float)this.f_96543_ / 2.0f - 200.0f, (float)this.f_96544_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        ScreenHelper.drawEntity(graphics, (LivingEntity)this.npc, this.f_96543_ / 2 - 140, this.f_96544_ / 2 + 50, 60.0f, 360.0f, 0.0f);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 60.0f, (float)this.f_96544_ / 2.0f - 90.0f, 0, false);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"gui.npceditor.page1", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 80.0f, (float)this.f_96544_ / 2.0f - 61.0f, 0, false);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"gui.npceditor.page2", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 80.0f, (float)this.f_96544_ / 2.0f - 26.0f, 0, false);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"gui.npceditor.page3", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 80.0f, (float)this.f_96544_ / 2.0f + 9.0f, 0, false);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"gui.npceditor.page4", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 80.0f, (float)this.f_96544_ / 2.0f + 44.0f, 0, false);
        graphics.drawString(this.f_96547_, I18n.m_118938_((String)"gui.trainereditor.model", (Object[])new Object[0]), (float)this.f_96543_ / 2.0f - 180.0f, (float)this.f_96544_ / 2.0f + 72.0f, 0, false);
    }

    public boolean m_5534_(char key, int par2) {
        ScreenHelper.switchFocus(par2, this.nameBox, this.page1Box, this.page2Box, this.page3Box, this.page4Box, this.textureBox);
        return super.m_5534_(key, par2);
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int button) {
        return false;
    }

    protected void actionPerformed(Button button) {
        if (button.f_93623_ && button instanceof IndexedButton) {
            if (((IndexedButton)button).id == 1) {
                this.saveFields();
            } else if (((IndexedButton)button).id == 6) {
                NetworkHelper.sendToServer(new DeleteTrainerPacket(currentNPCID));
                ScreenHelper.closeScreen();
            }
        }
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    private void saveFields() {
        if (this.checkFields()) {
            ScreenHelper.closeScreen();
        }
    }

    private boolean checkFields() {
        if (this.nameBox.m_94155_().equals("")) {
            return false;
        }
        if (currentNPCID <= 0) {
            currentNPCID = this.npc.getNPCID();
        }
        if (!this.nameBox.m_94155_().equals(name)) {
            NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, EnumNPCServerPacketType.Name, this.nameBox.m_94155_()));
        }
        ArrayList<String> pages = new ArrayList<String>();
        if (!this.page1Box.m_94155_().equals("")) {
            pages.add(this.page1Box.m_94155_());
        }
        if (!this.page2Box.m_94155_().equals("")) {
            pages.add(this.page2Box.m_94155_());
        }
        if (!this.page3Box.m_94155_().equals("")) {
            pages.add(this.page3Box.m_94155_());
        }
        if (!this.page4Box.m_94155_().equals("")) {
            pages.add(this.page4Box.m_94155_());
        }
        if (this.isCustomTexture()) {
            NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, EnumNPCServerPacketType.CustomSteveTexture, this.textureBox.m_94155_()));
        }
        if (!this.compareChat(pages)) {
            NetworkHelper.sendToServer(new NPCServerPacket(currentNPCID, pages));
        }
        return true;
    }

    private boolean compareChat(ArrayList<String> pages) {
        if (pages.size() != chatPages.size()) {
            return false;
        }
        for (int i = 0; i < chatPages.size(); ++i) {
            String oldPage;
            String page = pages.get(i);
            if (page.equals(oldPage = chatPages.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isCustomTexture() {
        return !this.npc.getBaseTrainer().textures.isEmpty() && this.npc.getBaseTrainer().textures.get(this.npc.getTextureIndex()).startsWith("Custom");
    }

    static {
        chatChanged = false;
        npcData = new ArrayList<ClientNPCData>();
    }
}

