/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.ClickableElement;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.TutorListScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.NPCTeachMovePacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TutorScreen
extends Screen
implements ClickableElement<NPCTutor.LearnableMove> {
    public static List<NPCTutor.LearnableMove> moveList;
    NPCTutor tutor;
    int listTop;
    int listLeft;
    int listHeight;
    int listWidth;
    TutorListScreen attackListGui;
    Pokemon pokemon;

    public TutorScreen(Pokemon data, int npcId) {
        super((Component)Component.m_237119_());
        Optional<NPCTutor> entityNPCOptional = NPCEntity.locateNPCClient((Level)Minecraft.m_91087_().f_91073_, npcId, NPCTutor.class);
        if (!entityNPCOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.tutor = entityNPCOptional.get();
        this.pokemon = data;
        this.listHeight = 150;
        this.listWidth = 90;
    }

    public void m_7856_() {
        super.m_7856_();
        if (moveList.isEmpty()) {
            this.f_96541_.f_91074_.m_6915_();
            return;
        }
        this.listTop = this.f_96544_ / 2 - 62;
        this.listLeft = this.f_96543_ / 2 - 40;
        moveList.sort(Comparator.comparing(NPCTutor.LearnableMove::learnable).reversed());
        this.attackListGui = new TutorListScreen(this, moveList, this.listWidth, this.listHeight, this.listTop, this.listLeft, this.f_96541_);
        this.m_142416_(this.attackListGui);
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 50, 20, (Component)Component.m_237115_((String)"gui.cancel.text"), this::actionPerformed));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float mFloat) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, (float)(0.05 * (double)this.f_96543_), (float)(0.05 * (double)this.f_96544_), (float)(0.9 * (double)this.f_96543_), (float)(0.9 * (double)this.f_96544_), 0.0f, 0.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.9f, 0.75f, 0.0f);
        boolean force = Minecraft.m_91087_().m_91390_();
        Minecraft.m_91087_().m_91336_(true);
        String text = I18n.m_118938_((String)(this.tutor.getTutorType() == EnumNPCTutorType.TRANSFER ? "pixelmon.npc.transfername" : "pixelmon.npc.tutorname"), (Object[])new Object[0]);
        graphics.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(text) / 2.0f, (float)this.f_96544_ / 2.0f - 110.0f, 0, false);
        text = I18n.m_118938_((String)"gui.choosemoveset.choosemove", (Object[])new Object[0]);
        graphics.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(text) / 2.0f, (float)this.f_96544_ / 2.0f - 92.0f, 0, false);
        ScreenHelper.drawImageQuad(this.pokemon.getSprite(), graphics, (float)this.f_96543_ / 2.0f - 211.0f, (float)this.f_96544_ / 2.0f - 98.0f, 84.0f, 84.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        this.attackListGui.m_88315_(graphics, mouseX, mouseY, mFloat);
        ScreenHelper.drawAttackInfoBox(graphics, 0.0f, this.f_96543_, this.f_96544_);
        text = I18n.m_118938_((String)"gui.choosemoveset.cost", (Object[])new Object[0]);
        int costTextWidth = this.f_96547_.m_92895_(text);
        graphics.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 125.0f - (float)costTextWidth, (float)this.f_96544_ / 2.0f + 60.0f, 0, false);
        for (int i = 0; i < moveList.size(); ++i) {
            NPCTutor.LearnableMove learnableMove = moveList.get(i);
            if (!this.attackListGui.isMouseOver(i, mouseX, mouseY)) continue;
            TutorScreen.drawAttackInfoList(graphics, learnableMove.attack(), this.f_96543_, this.f_96544_);
            List<ItemStack> costList = learnableMove.costs();
            if (costList != null && !costList.isEmpty()) {
                int j = 0;
                for (ItemStack item : costList) {
                    graphics.m_280480_(item, this.f_96543_ / 2 + 125 + j * 20, this.f_96544_ / 2 + 55);
                    graphics.m_280302_(this.f_96541_.f_91062_, item, this.f_96543_ / 2 + 125 + j * 20, this.f_96544_ / 2 + 55, null);
                    ++j;
                }
            }
            text = this.pokemon.getMoveset().hasAttack(learnableMove.attack()) ? I18n.m_118938_((String)"gui.tutor.already", (Object[])new Object[0]) : (learnableMove.learnable() ? I18n.m_118938_((String)"gui.tutor.canlearn", (Object[])new Object[0]) : I18n.m_118938_((String)"gui.tutor.cantlearn", (Object[])new Object[0]));
            graphics.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 125.0f - (float)costTextWidth, (float)this.f_96544_ / 2.0f + 75.0f, 0, false);
        }
        super.m_88315_(graphics, mouseX, mouseY, mFloat);
        Minecraft.m_91087_().m_91336_(force);
    }

    @Override
    public void elementClicked(List<NPCTutor.LearnableMove> list, int index) {
        NPCTutor.LearnableMove learnableMove = moveList.get(index);
        if (learnableMove.learnable() && !this.pokemon.getMoveset().hasAttack(learnableMove.attack())) {
            ScreenHelper.closeScreen();
            NetworkHelper.sendToServer(new NPCTeachMovePacket(this.pokemon.getUUID(), learnableMove.attack().getAttackName(), this.tutor.m_19879_()));
        }
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton && ((IndexedButton)button).id == 1) {
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public static void drawAttackInfoList(GuiGraphics graphics, ImmutableAttack a, int width, int height) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int y = height / 2 - 85;
        int x = width / 2 + 105;
        String powerString = I18n.m_118938_((String)"gui.choosemoveset.power", (Object[])new Object[0]) + ": ";
        powerString = a.getBasePower() > 0 ? powerString + a.getBasePower() : powerString + "--";
        graphics.m_280488_(fontRenderer, powerString, x, y + 3, 0);
        String accuracyString = I18n.m_118938_((String)"gui.battle.accuracy", (Object[])new Object[0]) + ": ";
        accuracyString = a.getAccuracy() > 0 ? accuracyString + a.getAccuracy() : accuracyString + "--";
        graphics.m_280488_(fontRenderer, accuracyString, x, y + 13, 0);
        graphics.m_280488_(fontRenderer, I18n.m_118938_((String)"nbt.pp", (Object[])new Object[0]) + " " + a.getPPBase() + "/" + a.getPPBase(), x, y + 23, 0);
        String typeString = I18n.m_118938_((String)"gui.battle.type", (Object[])new Object[0]) + " ";
        graphics.m_280488_(fontRenderer, typeString, x, y + 33, 0);
        graphics.m_280488_(fontRenderer, a.getAttackType().getLocalizedName(), x + fontRenderer.m_92895_(typeString), y + 33, a.getAttackType().getColor());
        String category = a.getAttackCategory().getLocalizedName();
        graphics.m_280488_(fontRenderer, category, x, y + 43, 0);
        ScreenHelper.drawSplitString(graphics, I18n.m_118938_((String)a.getDescriptionKey(), (Object[])new Object[0]), x, y + 58, 95, 0);
    }
}

