/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npc;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.battles.BattleScreen;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.InvisibleButton;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SelectPokemonResponsePacket;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class SelectPartyPokemonScreen
extends Screen {
    String mainText;
    String backText;
    boolean faintedOnly;
    private final List<PixelmonClientData> party = Lists.newArrayList();
    private final SelectPokemonResponsePacket.Mode mode;
    private final int npcId;

    public SelectPartyPokemonScreen(int mode, int npcId) {
        super((Component)Component.m_237119_());
        this.mode = SelectPokemonResponsePacket.Mode.fromOrdinal(mode);
        this.npcId = npcId;
        if (this.mode == SelectPokemonResponsePacket.Mode.Revive) {
            this.mainText = "gui.selectpokemon.message";
            this.backText = "gui.battle.back";
            this.faintedOnly = true;
        } else {
            this.mainText = "gui.selectpokemon.message";
            this.backText = "gui.battle.back";
            this.faintedOnly = false;
        }
    }

    public SelectPartyPokemonScreen(String mainText, String backText, boolean faintedOnly, int mode, int npcId) {
        super((Component)Component.m_237119_());
        this.mainText = mainText;
        this.backText = backText;
        this.faintedOnly = faintedOnly;
        this.mode = SelectPokemonResponsePacket.Mode.fromOrdinal(mode);
        this.npcId = npcId;
    }

    public void m_7856_() {
        super.m_7856_();
        List<Pokemon> team = ClientStorageManager.party.getTeam();
        if (team.isEmpty()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.party.clear();
        for (Pokemon pokemon : team) {
            if (pokemon.isFainted() ? !this.faintedOnly : this.faintedOnly) continue;
            this.party.add(new PixelmonClientData(pokemon));
        }
        if (this.party.isEmpty()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.m_142416_((GuiEventListener)new InvisibleButton(0, this, this::actionPerformed).setPosition(this.f_96543_ / 2 - 119, this.f_96544_ - 179, 88, 66));
        int pos = 1;
        this.m_142416_((GuiEventListener)new InvisibleButton(1, this, this::actionPerformed).setPosition(this.f_96543_ / 2 - 29, this.f_96544_ - 223 + pos * 30, 148, 29));
        pos = 2;
        this.m_142416_((GuiEventListener)new InvisibleButton(2, this, this::actionPerformed).setPosition(this.f_96543_ / 2 - 29, this.f_96544_ - 223 + pos * 30, 148, 29));
        pos = 3;
        this.m_142416_((GuiEventListener)new InvisibleButton(3, this, this::actionPerformed).setPosition(this.f_96543_ / 2 - 29, this.f_96544_ - 223 + pos * 30, 148, 29));
        pos = 4;
        this.m_142416_((GuiEventListener)new InvisibleButton(4, this, this::actionPerformed).setPosition(this.f_96543_ / 2 - 29, this.f_96544_ - 223 + pos * 30, 148, 29));
        pos = 5;
        this.m_142416_((GuiEventListener)new InvisibleButton(5, this, this::actionPerformed).setPosition(this.f_96543_ / 2 - 29, this.f_96544_ - 223 + pos * 30, 148, 29));
        this.m_142416_((GuiEventListener)new InvisibleButton(-1, this, this::actionPerformed).setPosition(this.f_96543_ / 2 + 63, this.f_96544_ - 27, 48, 17));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PixelmonClientData mainPokemon;
        int width = this.f_96543_;
        int height = this.f_96544_;
        ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f - 128.0f, height - 203, 256.0f, 203.0f, 0.0f, 0.0f, 1.0f, 0.79296875f, 0.0f);
        if (this.mainText != null && !this.mainText.isEmpty()) {
            graphics.m_280137_(this.f_96547_, I18n.m_118938_((String)this.mainText, (Object[])new Object[0]), width / 2 - 40, height - 23, 0xFFFFFF);
        }
        if (this.backText != null && !this.backText.isEmpty()) {
            if (mouseX > width / 2 + 63 && mouseX < width / 2 + 63 + 48 && mouseY > height - 27 && mouseY < height - 27 + 17) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f + 63.0f, height - 27, 48.0f, 17.0f, 0.7734375f, 0.8203125f, 0.9609375f, 0.88671875f, 0.0f);
            }
            graphics.m_280137_(this.f_96547_, I18n.m_118938_((String)this.backText, (Object[])new Object[0]), width / 2 + 87, height - 22, 0xFFFFFF);
        }
        if ((mainPokemon = this.party.get(0)) != null) {
            ScreenHelper.drawImageQuad(ScreenHelper.getPokemonSprite(mainPokemon, this.f_96541_), graphics, (float)width / 2.0f - 121.0f, height - 179, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            BattleScreen.drawHealthBar(graphics, width / 2 - 85, height - 135, 56, 9, (float)mainPokemon.health.get(), mainPokemon.maxHealth);
            ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f - 95.0f, height - 135, 61.0f, 9.0f, 0.3359375f, 0.9375f, 0.57421875f, 0.97265625f, 0.0f);
            graphics.m_280137_(this.f_96547_, (int)mainPokemon.health.get() + "/" + mainPokemon.maxHealth, width / 2 - 59, height - 123, 0xFFFFFF);
            String name = mainPokemon.getDisplayName();
            graphics.m_280488_(this.f_96547_, name, width / 2 - 90, height - 161, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + mainPokemon.level, width / 2 - 90, height - 148, 0xFFFFFF);
            float[] texturePair = mainPokemon.getStatusTexturePos();
            if (texturePair[0] != -1.0f) {
                ScreenHelper.simpleDrawImageQuad(Resources.status, graphics, (float)width / 2.0f - 117.0f, height - 145, 20.0f, 20.0f, texturePair[0] / 768.0f, texturePair[1] / 768.0f, (texturePair[0] + 240.0f) / 768.0f, (texturePair[1] + 240.0f) / 768.0f, 0.0f);
            }
            if (mainPokemon.getGender() == Gender.MALE) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f - 90.0f + (float)this.f_96547_.m_92895_(name), height - 161, 6.0f, 9.0f, 0.125f, 0.8125f, 0.1484375f, 0.84765625f, 0.0f);
            } else if (mainPokemon.getGender() == Gender.FEMALE) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f - 90.0f + (float)this.f_96547_.m_92895_(name), height - 161, 6.0f, 9.0f, 0.125f, 0.8515625f, 0.1484375f, 0.88671875f, 0.0f);
            }
            if (mouseX > width / 2 - 119 && mouseX < width / 2 - 31 && mouseY > height - 165 && mouseY < height - 113) {
                ScreenHelper.drawImageQuad(Resources.selectCurrentPokemon, graphics, (float)width / 2.0f - 120.0f, height - 165, 89.0f, 52.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            }
        }
        for (int i = 1; i < this.party.size(); ++i) {
            PixelmonClientData pig = this.party.get(i);
            int pos = i - 1;
            if (pig == null) continue;
            ScreenHelper.drawImageQuad(ScreenHelper.getPokemonSprite(pig, this.f_96541_), graphics, (float)width / 2.0f - 23.0f, height - 192 + pos * 30, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            BattleScreen.drawHealthBar(graphics, width / 2 + 65, height - 192 + pos * 30, 56, 9, (float)pig.health.get(), pig.maxHealth);
            ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f + 55.0f, height - 192 + pos * 30, 61.0f, 9.0f, 0.3359375f, 0.9375f, 0.57421875f, 0.97265625f, 0.0f);
            graphics.m_280488_(this.f_96547_, (int)pig.health.get() + "/" + pig.maxHealth, width / 2 + 75, height - 180 + pos * 30, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, pig.getDisplayName(), width / 2 + 5, height - 190 + pos * 30, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + pig.level, width / 2 + 5, height - 176 + pos * 30, 0xFFFFFF);
            float[] texturePair = pig.getStatusTexturePos();
            if (texturePair[0] != -1.0f) {
                ScreenHelper.simpleDrawImageQuad(Resources.status, graphics, (float)width / 2.0f + 50.0f, height - 177 + pos * 26, 14.0f, 14.0f, texturePair[0] / 768.0f, texturePair[1] / 768.0f, (texturePair[0] + 240.0f) / 768.0f, (texturePair[1] + 240.0f) / 768.0f, 0.0f);
            }
            if (pig.getGender() == Gender.MALE) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f + 40.0f, height - 176 + pos * 30, 6.0f, 9.0f, 0.125f, 0.8125f, 0.1484375f, 0.84765625f, 0.0f);
            } else if (pig.getGender() == Gender.FEMALE) {
                ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, (float)width / 2.0f + 40.0f, height - 176 + pos * 30, 6.0f, 9.0f, 0.125f, 0.8515625f, 0.1484375f, 0.88671875f, 0.0f);
            }
            int xPos = width / 2 - 30;
            int yPos = height - 195 + pos * 30;
            if (mouseX <= xPos || mouseX >= xPos + 150 || mouseY <= yPos + 1 || mouseY >= yPos + 31) continue;
            ScreenHelper.drawImageQuad(Resources.choosePokemon, graphics, xPos, yPos, 150.0f, 32.0f, 0.16796875f, 0.80078125f, 0.7578125f, 0.92578125f, 0.0f);
        }
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == -1) {
                ScreenHelper.closeScreen();
            } else {
                if (id >= this.party.size()) {
                    return;
                }
                PixelmonClientData pokemon = this.party.get(id);
                if (pokemon != null) {
                    NetworkHelper.sendToServer(new SelectPokemonResponsePacket(this.mode, this.npcId, pokemon.pokemonUUID));
                }
            }
        }
    }
}

