/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npc;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.ClickableElement;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.MoveListScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.NPCTeachMovePacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RelearnerScreen
extends Screen
implements ClickableElement<Attack> {
    Pokemon pokemon;
    NPCRelearner relearner;
    ItemStack cost;
    public static List<Attack> attackList;
    int listTop;
    int listLeft;
    int listHeight;
    int listWidth;
    MoveListScreen attackListGui;

    public RelearnerScreen(Pokemon pokemon) {
        super((Component)Component.m_237119_());
        Optional<NPCRelearner> entityNPCOptional = NPCEntity.locateNPCClient((Level)Minecraft.m_91087_().f_91073_, ServerStorageDisplay.npcInteractID, NPCRelearner.class);
        if (!entityNPCOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.relearner = entityNPCOptional.get();
        this.cost = this.relearner.getCost();
        this.pokemon = pokemon;
        attackList = Lists.newArrayList();
        for (ImmutableAttack attack : NPCRelearner.getRelearnableMoves(pokemon)) {
            attackList.add(attack.ofMutable());
        }
        this.listHeight = 150;
        this.listWidth = 90;
        this.f_96541_ = Minecraft.m_91087_();
    }

    public void m_7856_() {
        super.m_7856_();
        this.listTop = this.f_96544_ / 2 - 62;
        this.listLeft = this.f_96543_ / 2 - 40;
        this.attackListGui = new MoveListScreen(this, attackList, this.listWidth, this.listHeight, this.listTop, this.listLeft, this.f_96541_);
        this.m_142416_(this.attackListGui);
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.f_96543_ / 2 + 155, this.f_96544_ / 2 + 90, 50, 20, (Component)Component.m_237115_((String)"gui.cancel.text"), this::actionPerformed));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float mFloat) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, graphics, 2.0f, 2.0f, (float)this.f_96543_ - 6.0f, (float)this.f_96544_ - 6.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        String text = I18n.m_118938_((String)"gui.choosemoveset.relearnmove", (Object[])new Object[0]);
        graphics.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92895_(text) / 2.0f, (float)this.f_96544_ / 2.0f - 110.0f, 0, false);
        text = I18n.m_118938_((String)"gui.choosemoveset.choosemove", (Object[])new Object[0]);
        graphics.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f - 15.0f - (float)this.f_96547_.m_92895_(text) / 2.0f, (float)this.f_96544_ / 2.0f - 92.0f, 0, false);
        this.attackListGui.m_88315_(graphics, mouseX, mouseY, mFloat);
        ScreenHelper.drawImageQuad(this.pokemon.getSprite(), graphics, (float)this.f_96543_ / 2.0f - 211.0f, (float)this.f_96544_ / 2.0f - 98.0f, 84.0f, 84.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        ScreenHelper.drawAttackInfoBox(graphics, 0.0f, this.f_96543_, this.f_96544_);
        for (int i = 0; i < attackList.size(); ++i) {
            if (!this.attackListGui.isMouseOver(i, mouseX, mouseY)) continue;
            ScreenHelper.drawAttackInfoList(graphics, attackList.get(i), this.f_96543_, this.f_96544_);
        }
        if (this.cost != null) {
            text = I18n.m_118938_((String)"gui.choosemoveset.cost", (Object[])new Object[0]);
            graphics.drawString(this.f_96547_, text, (float)this.f_96543_ / 2.0f + 130.0f - (float)this.f_96547_.m_92895_(text), (float)this.f_96544_ / 2.0f + 60.0f, 0, false);
            graphics.m_280480_(this.cost, this.f_96543_ / 2 + 130, this.f_96544_ / 2 + 55);
            graphics.m_280302_(this.f_96541_.f_91062_, this.cost, this.f_96543_ / 2 + 130, this.f_96544_ / 2 + 55, null);
        }
        super.m_88315_(graphics, mouseX, mouseY, mFloat);
    }

    @Override
    public void elementClicked(List<Attack> list, int index) {
        Attack a = attackList.get(index);
        this.f_96541_.f_91074_.m_6915_();
        NetworkHelper.sendToServer(new NPCTeachMovePacket(this.pokemon.getUUID(), a.getActualMove().getAttackName(), this.relearner.getNPCID()));
    }

    public boolean m_7043_() {
        return false;
    }

    protected void actionPerformed(Button button) {
        this.f_96541_.f_91074_.m_6915_();
    }
}

