/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npc;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.npc.ClientShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.EnumBuySell;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public abstract class AbstractShopScreen
extends Screen {
    public static ArrayList<ClientShopItem> buyItems;
    public static ArrayList<ClientShopItem> sellItems;
    protected int selectedItem = -1;
    protected int quantity = 1;
    protected float floatQuantity = 1.0f;
    private float incrementInterval = 8.0f;
    private static final float START_INTERVAL = 8.0f;
    protected int buyStartIndex = 0;
    protected int sellStartIndex = 0;
    protected boolean allowMultiple = true;
    EnumBuySell currentTab = EnumBuySell.Buy;

    public AbstractShopScreen() {
        super((Component)Component.m_237119_());
    }

    public void m_86600_() {
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY != 0.0) {
            if (deltaY > 0.0) {
                deltaY = 1.0;
            }
            if (deltaY < 0.0) {
                deltaY = -1.0;
            }
            if (this.currentTab == EnumBuySell.Buy) {
                this.buyStartIndex = (int)((double)this.buyStartIndex - deltaY);
                if (this.buyStartIndex + 6 >= buyItems.size()) {
                    this.buyStartIndex = buyItems.size() - 6;
                }
                if (this.buyStartIndex < 0) {
                    this.buyStartIndex = 0;
                }
            } else {
                this.sellStartIndex = (int)((double)this.sellStartIndex - deltaY);
                if (this.sellStartIndex + 6 >= sellItems.size()) {
                    this.sellStartIndex = sellItems.size() - 6;
                }
                if (this.sellStartIndex < 0) {
                    this.sellStartIndex = 0;
                }
            }
        }
        return false;
    }

    protected boolean isBuyMiniScreenVisible() {
        return this.selectedItem != -1;
    }

    public void m_280039_(GuiGraphics p_282281_) {
    }

    public void m_280273_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected void clickBuyScreen(double mouseX, double mouseY) {
        if (mouseX > (double)((float)this.f_96543_ / 2.0f + 51.0f) && mouseX < (double)((float)this.f_96543_ / 2.0f + 51.0f + 16.0f) && mouseY > (double)((float)this.f_96544_ / 2.0f - 61.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f - 61.0f + 10.0f)) {
            if (this.currentTab == EnumBuySell.Buy) {
                if (this.buyStartIndex > 0) {
                    --this.buyStartIndex;
                    return;
                }
            } else if (this.sellStartIndex > 0) {
                --this.sellStartIndex;
                return;
            }
        }
        if (mouseX > (double)((float)this.f_96543_ / 2.0f + 51.0f) && mouseX < (double)((float)this.f_96543_ / 2.0f + 51.0f + 16.0f) && mouseY > (double)((float)this.f_96544_ / 2.0f + 78.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f + 78.0f + 10.0f)) {
            if (this.currentTab == EnumBuySell.Buy) {
                if (this.buyStartIndex + 6 < buyItems.size()) {
                    ++this.buyStartIndex;
                    return;
                }
            } else if (this.sellStartIndex + 6 < sellItems.size()) {
                ++this.sellStartIndex;
                return;
            }
        }
        if (mouseX > (double)((float)this.f_96543_ / 2.0f + 139.0f) && mouseX < (double)((float)this.f_96543_ / 2.0f + 139.0f + 14.0f) && mouseY > (double)((float)this.f_96544_ / 2.0f + 79.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f + 79.0f + 17.0f)) {
            this.m_7379_();
            return;
        }
        int leftLimit = this.f_96543_ / 2 - 28;
        if (this.currentTab == EnumBuySell.Buy) {
            for (i = this.buyStartIndex; i < 6 + this.buyStartIndex; ++i) {
                if (i >= buyItems.size()) continue;
                float h = 21.0f;
                float topLimit = (float)this.f_96544_ / 2.0f - 49.0f + (float)(i - this.buyStartIndex) * h;
                int w = 174;
                if (!(mouseX > (double)leftLimit) || !(mouseX < (double)(leftLimit + w)) || !(mouseY > (double)topLimit) || !(mouseY < (double)(topLimit + h)) || this.selectedItem == i) continue;
                this.selectedItem = i;
                this.quantity = 1;
            }
        } else {
            for (i = this.sellStartIndex; i < 6 + this.sellStartIndex; ++i) {
                if (i >= sellItems.size()) continue;
                float h = 21.0f;
                float topLimit = (float)this.f_96544_ / 2.0f - 49.0f + (float)(i - this.sellStartIndex) * h;
                int w = 174;
                if (!(mouseX > (double)leftLimit) || !(mouseX < (double)(leftLimit + w)) || !(mouseY > (double)topLimit) || !(mouseY < (double)(topLimit + h)) || this.selectedItem == i) continue;
                this.selectedItem = i;
                this.quantity = 1;
            }
        }
        this.clickBuyMiniScreen(mouseX, mouseY, true);
        if (this.isBuyMiniScreenVisible() && mouseX > (double)((float)this.f_96543_ / 2.0f - 94.0f) && mouseX < (double)((float)this.f_96543_ / 2.0f - 94.0f + 49.0f) && mouseY > (double)((float)this.f_96544_ / 2.0f - 29.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f - 29.0f + 18.0f)) {
            if (this.currentTab == EnumBuySell.Buy) {
                int buyPrice;
                if (this.selectedItem < buyItems.size() && (double)(this.quantity * (buyPrice = buyItems.get(this.selectedItem).getBuy())) <= ClientData.playerMoney.doubleValue()) {
                    this.sendBuyPacket();
                    this.selectedItem = -1;
                }
            } else if (this.selectedItem < sellItems.size()) {
                ClientShopItem sellItem = sellItems.get(this.selectedItem);
                this.sendSellPacket();
                sellItem.amount -= this.quantity;
                this.selectedItem = -1;
            }
        }
    }

    private int checkRemainingSlots(ItemStack buying) {
        if (buying == null || buying == ItemStack.f_41583_ || buying.m_41720_() == Items.f_41852_) {
            return 0;
        }
        try {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            int available = 0;
            for (ItemStack curStack : new ArrayList(player.m_150109_().f_35974_)) {
                if (curStack != null && ItemStack.m_41656_((ItemStack)curStack, (ItemStack)buying)) {
                    available += buying.m_41741_() - curStack.m_41613_();
                    continue;
                }
                if (curStack != null && curStack != ItemStack.f_41583_ && curStack.m_41720_() != Items.f_41852_) continue;
                available += buying.m_41741_();
            }
            return Math.min(2304, available);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 2304;
        }
    }

    protected void clickBuyMiniScreen(double mouseX, double mouseY, boolean isInstant) {
        if (this.floatQuantity <= 0.0f || isInstant) {
            if (this.isBuyMiniScreenVisible() && this.allowMultiple) {
                ClientShopItem item;
                if (mouseX > (double)((float)this.f_96543_ / 2.0f - 71.0f) && mouseX < (double)((float)this.f_96543_ / 2.0f - 71.0f + 25.0f) && mouseY > (double)((float)this.f_96544_ / 2.0f - 58.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f - 58.0f + 6.0f)) {
                    this.quantity = this.currentTab == EnumBuySell.Buy ? ((double)((this.quantity + 1) * (item = buyItems.get(this.selectedItem)).getBuy()) <= ClientData.playerMoney.doubleValue() && this.quantity + 1 <= Math.min(this.checkRemainingSlots(item.getItemStack()), PixelmonConfigProxy.getGeneral().getShopMaxStackSize(item.getItemStack())) ? ++this.quantity : 1) : (this.quantity + 1 <= AbstractShopScreen.sellItems.get((int)this.selectedItem).amount ? ++this.quantity : 1);
                    this.floatQuantity = 2.0f;
                    this.decreaseIncrementInterval();
                }
                if (mouseX > (double)((float)this.f_96543_ / 2.0f - 71.0f) && mouseX < (double)((float)this.f_96543_ / 2.0f - 71.0f + 25.0f) && mouseY > (double)((float)this.f_96544_ / 2.0f - 42.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f - 42.0f + 7.0f)) {
                    --this.quantity;
                    this.floatQuantity = 2.0f;
                    if (this.quantity < 1) {
                        if (this.currentTab == EnumBuySell.Buy) {
                            item = buyItems.get(this.selectedItem);
                            this.quantity = Math.min(this.checkRemainingSlots(item.getItemStack()), PixelmonConfigProxy.getGeneral().getShopMaxStackSize(item.getItemStack()));
                        } else {
                            this.quantity = AbstractShopScreen.sellItems.get((int)this.selectedItem).amount;
                        }
                        if (this.quantity == 0) {
                            this.quantity = 1;
                        }
                        this.floatQuantity = 2.0f;
                    }
                    this.decreaseIncrementInterval();
                }
            }
        } else {
            this.floatQuantity -= 1.0f / this.incrementInterval;
        }
        if (isInstant) {
            this.incrementInterval = 8.0f;
        }
    }

    private void decreaseIncrementInterval() {
        this.incrementInterval = Math.max(0.5f, this.incrementInterval * 0.75f);
    }

    public void m_7379_() {
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    protected void sendBuyPacket() {
    }

    protected void sendSellPacket() {
    }

    protected void renderBuyScreen(GuiGraphics graphics, int mouseX, int mouseY) {
        ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f - 40.0f, (float)this.f_96544_ / 2.0f - 102.0f, 197.0f, 201.0f, 0.23046875f, 0.0f, 1.0f, 0.78515625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        if (this.isBuyMiniScreenVisible() && mouseX > this.f_96543_ / 2 + 139 && mouseX < this.f_96543_ / 2 + 139 + 14 && mouseY > this.f_96544_ / 2 + 79 && mouseY < this.f_96544_ / 2 + 79 + 17) {
            ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f + 139.0f, (float)this.f_96544_ / 2.0f + 79.0f, 14.0f, 17.0f, 0.9296875f, 0.87890625f, 0.984375f, 0.9453125f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
        String moneyLabel = I18n.m_118938_((String)"gui.shopkeeper.money", (Object[])new Object[0]);
        graphics.m_280488_(this.f_96541_.f_91062_, moneyLabel, this.f_96543_ / 2 + 118 - this.f_96541_.f_91062_.m_92895_(moneyLabel) / 2, this.f_96544_ / 2 - 90, 0xFFFFFF);
        String playerMoneyLabel = "" + ClientData.playerMoney;
        ScreenHelper.drawImageQuad(Resources.pokedollar, graphics, (float)this.f_96543_ / 2.0f + 118.0f - (float)this.f_96541_.f_91062_.m_92895_(playerMoneyLabel + "8") / 2.0f, (float)this.f_96544_ / 2.0f - 78.0f, 6.0f, 9.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        graphics.m_280488_(this.f_96541_.f_91062_, playerMoneyLabel, this.f_96543_ / 2 + 118 - this.f_96541_.f_91062_.m_92895_(playerMoneyLabel + "8") / 2 + 8, this.f_96544_ / 2 - 77, 0xFFFFFF);
        if (this.currentTab == EnumBuySell.Buy) {
            ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f - 31.0f, (float)this.f_96544_ / 2.0f - 93.0f, 58.0f, 30.0f, 0.265625f, 0.8828125f, 0.4921875f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        } else {
            ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f + 28.0f, (float)this.f_96544_ / 2.0f - 93.0f, 58.0f, 30.0f, 0.265625f, 0.8828125f, 0.4921875f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
        this.renderMenu(graphics, mouseX, mouseY);
    }

    protected void renderMenu(GuiGraphics graphics, int mouseX, int mouseY) {
        ItemStack item;
        int i;
        int colour = 0xFFFFFF;
        int leftLimit = this.f_96543_ / 2 - 28;
        int startIndex = this.currentTab == EnumBuySell.Buy ? this.buyStartIndex : this.sellStartIndex;
        ArrayList<ClientShopItem> listItems = this.currentTab == EnumBuySell.Buy ? buyItems : sellItems;
        for (i = startIndex; i < 6 + startIndex; ++i) {
            if (i >= listItems.size()) continue;
            float h = 21.0f;
            float topLimit = (float)this.f_96544_ / 2.0f - 49.0f + (float)(i - startIndex) * h;
            int w = 174;
            if (mouseX > leftLimit && mouseX < leftLimit + w && (float)mouseY > topLimit && (float)mouseY < topLimit + h || this.selectedItem == i) {
                ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, leftLimit, topLimit, w, 20.0f, 0.27734375f, 0.79296875f, 0.95703125f, 0.87109375f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            int itemLeft = this.f_96543_ / 2;
            int itemRight = this.f_96543_ / 2 + 140;
            item = listItems.get(i).getItemStack();
            Object itemName = item.m_41786_().getString();
            if (this.currentTab == EnumBuySell.Sell) {
                itemName = (String)itemName + " x" + listItems.get((int)i).amount;
            }
            Object cost = "";
            cost = (String)cost + (this.currentTab == EnumBuySell.Buy ? listItems.get(i).getBuy() : listItems.get(i).getSell());
            int costWidth = Math.min(24, this.f_96541_.f_91062_.m_92895_((String)cost));
            ScreenHelper.drawImageQuad(Resources.pokedollar, graphics, itemRight - costWidth - 8, (int)(topLimit + 6.0f), 6.0f, 9.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawSquashedString(graphics, this.f_96541_.f_91062_, (String)itemName, false, (float)(140 - costWidth - 15), (float)itemLeft, (float)((int)(topLimit + 7.0f)), 0xFFFFFF, true);
            colour = 0xDDDDDD;
            if (this.currentTab == EnumBuySell.Buy && (double)listItems.get(i).getBuy() > ClientData.playerMoney.doubleValue()) {
                colour = 0xFF4444;
            }
            ScreenHelper.drawSquashedString(graphics, this.f_96541_.f_91062_, (String)cost, false, (float)costWidth, (float)(itemRight - costWidth), (float)((int)(topLimit + 7.0f)), colour, false);
        }
        if (startIndex > 0) {
            if (mouseX > this.f_96543_ / 2 + 51 && mouseX < this.f_96543_ / 2 + 51 + 16 && mouseY > this.f_96544_ / 2 - 61 && mouseY < this.f_96544_ / 2 - 61 + 10) {
                ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f + 51.0f, (float)this.f_96544_ / 2.0f - 61.0f, 17.0f, 10.0f, 0.58203125f, 0.8828125f, 0.6484375f, 0.921875f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else {
                ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f + 51.0f, (float)this.f_96544_ / 2.0f - 61.0f, 17.0f, 10.0f, 0.65625f, 0.8828125f, 0.72265625f, 0.921875f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
        if (startIndex + 6 < listItems.size()) {
            if (mouseX > this.f_96543_ / 2 + 51 && mouseX < this.f_96543_ / 2 + 51 + 16 && mouseY > this.f_96544_ / 2 + 78 && mouseY < this.f_96544_ / 2 + 78 + 10) {
                ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f + 51.0f, (float)this.f_96544_ / 2.0f + 78.0f, 17.0f, 10.0f, 0.58203125f, 0.9375f, 0.6484375f, 0.9765625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else {
                ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f + 51.0f, (float)this.f_96544_ / 2.0f + 78.0f, 17.0f, 10.0f, 0.65625f, 0.9375f, 0.72265625f, 0.9765625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
        if (this.isBuyMiniScreenVisible()) {
            ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f - 99.0f, (float)this.f_96544_ / 2.0f - 102.0f, 59.0f, 97.0f, 0.0f, 0.0f, 0.23046875f, 0.37890625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            String priceLabel = I18n.m_118938_((String)"gui.shopkeeper.price", (Object[])new Object[0]);
            graphics.m_280488_(this.f_96541_.f_91062_, priceLabel, this.f_96543_ / 2 - 69 - this.f_96541_.f_91062_.m_92895_(priceLabel) / 2, this.f_96544_ / 2 - 96, 0xFFFFFF);
            int price = this.currentTab == EnumBuySell.Buy ? listItems.get(this.selectedItem).getBuy() : listItems.get(this.selectedItem).getSell();
            String priceAmount = "" + this.quantity * price;
            ScreenHelper.drawImageQuad(Resources.pokedollar, graphics, (float)this.f_96543_ / 2.0f - 70.0f - (float)(this.f_96541_.f_91062_.m_92895_(priceAmount) + 8) / 2.0f - 4.0f, (float)this.f_96544_ / 2.0f - 84.0f, 6.0f, 9.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (this.currentTab == EnumBuySell.Buy && (double)(this.quantity * price) > ClientData.playerMoney.doubleValue()) {
                colour = 0xFF4444;
            }
            colour = 0xDDDDDD;
            graphics.drawString(this.f_96547_, priceAmount, (float)this.f_96543_ / 2.0f - 69.0f - (float)(this.f_96541_.f_91062_.m_92895_(priceAmount) + 8) / 2.0f + 4.0f, (float)this.f_96544_ / 2.0f - 84.0f, colour, true);
            String quantityLabel = I18n.m_118938_((String)"gui.shopkeeper.quantity", (Object[])new Object[0]);
            graphics.m_280488_(this.f_96541_.f_91062_, quantityLabel, this.f_96543_ / 2 - 69 - this.f_96541_.f_91062_.m_92895_(quantityLabel) / 2, this.f_96544_ / 2 - 69, 0xFFFFFF);
            String quantityAmount = "" + this.quantity;
            graphics.m_280488_(this.f_96541_.f_91062_, quantityAmount, this.f_96543_ / 2 - 58 - this.f_96541_.f_91062_.m_92895_(quantityAmount) / 2, this.f_96544_ / 2 - 51, 0xFFFFFF);
            if (mouseX > this.f_96543_ / 2 - 94 && mouseX < this.f_96543_ / 2 - 94 + 49 && mouseY > this.f_96544_ / 2 - 29 && mouseY < this.f_96544_ / 2 - 29 + 18) {
                boolean validTransaction;
                boolean bl = this.currentTab == EnumBuySell.Buy ? (double)(this.quantity * price) <= ClientData.playerMoney.doubleValue() : (validTransaction = this.quantity <= listItems.get((int)this.selectedItem).amount);
                if (validTransaction) {
                    ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f - 94.0f, (float)this.f_96544_ / 2.0f - 29.0f, 49.0f, 18.0f, 0.01953125f, 0.796875f, 0.2109375f, 0.8671875f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
            }
            colour = 0xFFFFFF;
            if (this.currentTab == EnumBuySell.Buy && (double)(this.quantity * price) > ClientData.playerMoney.doubleValue()) {
                colour = 0x777777;
            }
            String buyLabel = I18n.m_118938_((String)(this.currentTab == EnumBuySell.Buy ? "gui.shopkeeper.buy" : "gui.shopkeeper.sell"), (Object[])new Object[0]);
            graphics.drawString(this.f_96547_, buyLabel, (float)this.f_96543_ / 2.0f - 69.0f - (float)this.f_96541_.f_91062_.m_92895_(buyLabel) / 2.0f, (float)this.f_96544_ / 2.0f - 24.0f, colour, true);
            if (this.allowMultiple) {
                if (mouseX > this.f_96543_ / 2 - 72 && mouseX < this.f_96543_ / 2 - 72 + 25 && mouseY > this.f_96544_ / 2 - 58 && mouseY < this.f_96544_ / 2 - 58 + 6) {
                    ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f - 63.0f, (float)this.f_96544_ / 2.0f - 58.0f, 9.0f, 6.0f, 0.09765625f, 0.8828125f, 0.1328125f, 0.90625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                } else {
                    ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f - 63.0f, (float)this.f_96544_ / 2.0f - 58.0f, 9.0f, 6.0f, 0.140625f, 0.8828125f, 0.17578125f, 0.90625f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
                if (mouseX > this.f_96543_ / 2 - 72 && mouseX < this.f_96543_ / 2 - 72 + 25 && mouseY > this.f_96544_ / 2 - 42 && mouseY < this.f_96544_ / 2 - 42 + 7) {
                    ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f - 63.0f, (float)this.f_96544_ / 2.0f - 42.0f, 9.0f, 6.0f, 0.09765625f, 0.9140625f, 0.1328125f, 0.9375f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                } else {
                    ScreenHelper.drawImageQuad(Resources.shopkeeper, graphics, (float)this.f_96543_ / 2.0f - 63.0f, (float)this.f_96544_ / 2.0f - 42.0f, 9.0f, 6.0f, 0.140625f, 0.9140625f, 0.17578125f, 0.9375f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                }
            }
            item = listItems.get(this.selectedItem).getItemStack();
            graphics.m_280480_(item, this.f_96543_ / 2 - 91, this.f_96544_ / 2 - 55);
        }
        for (i = startIndex; i < 6 + startIndex; ++i) {
            float h = 21.0f;
            float topLimit = (float)this.f_96544_ / 2.0f - 49.0f + (float)(i - startIndex) * h;
            if (i >= listItems.size()) continue;
            ItemStack item2 = listItems.get(i).getItemStack();
            graphics.m_280480_(item2, leftLimit + 2, (int)(topLimit + 2.0f));
        }
    }
}

