/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.moveskills;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.PixelmonOverlayScreen;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class MoveSkillSelectScreen
extends Screen {
    int slot;
    Pokemon pokemon = null;
    ArrayList<MoveSkill> moveSkills = new ArrayList();
    int currentlySelectedIndex = -1;
    long mouseStationaryTime = System.currentTimeMillis();
    int lastMouseX = 0;
    int lastMouseY = 0;

    public MoveSkillSelectScreen(int slot) {
        super((Component)Component.m_237119_());
        this.slot = slot;
    }

    public void m_7856_() {
        MoveSkill selected;
        super.m_7856_();
        this.pokemon = ClientStorageManager.party.get(this.slot);
        if (this.pokemon == null) {
            this.f_96541_.f_91074_.m_6915_();
            return;
        }
        this.moveSkills = ClientProxy.getMoveSkills(this.pokemon);
        if (PixelmonOverlayScreen.selectedMoveSkill != null && (selected = CollectionHelper.find(this.moveSkills, moveSkill -> moveSkill.id.equals(PixelmonOverlayScreen.selectedMoveSkill))) != null) {
            this.currentlySelectedIndex = this.moveSkills.indexOf(selected);
        }
    }

    private int getIndexForPos(int mouseX, int mouseY) {
        mouseY = -1 * (mouseY - this.f_96544_ / 2);
        double quadrantAdjustment = (mouseX -= this.f_96543_ / 2) >= 0 && mouseY >= 0 ? 0.0 : (mouseX >= 0 && mouseY <= 0 ? Math.PI * 2 : Math.PI);
        double r = Math.sqrt(mouseX * mouseX + mouseY * mouseY);
        double theta = Math.atan(1.0 * (double)mouseY / (double)mouseX) + quadrantAdjustment;
        theta = ((theta - 1.5707963267948966) * 180.0 / Math.PI + 360.0) % 360.0;
        theta = 360.0 - theta;
        double wheelRadius = this.getWheelRadius();
        if (r < wheelRadius * 0.188 || r > wheelRadius * 0.9) {
            return -1;
        }
        if (this.moveSkills.isEmpty()) {
            return -1;
        }
        if (this.moveSkills.size() == 1) {
            return 0;
        }
        double radialWidth = 360.0 / (double)this.moveSkills.size();
        for (int i = 0; i < this.moveSkills.size(); ++i) {
            if (!(i == 0 ? theta > 360.0 - radialWidth / 2.0 || theta < 0.0 + radialWidth / 2.0 : theta > (double)i * radialWidth - radialWidth / 2.0 && theta < (double)i * radialWidth + radialWidth / 2.0)) continue;
            return i;
        }
        return -1;
    }

    public double getWheelRadius() {
        return 0.4 * (double)Math.min(this.f_96544_, this.f_96543_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int hovering = this.getIndexForPos(mouseX, mouseY);
        int focused = hovering;
        if (focused == -1) {
            focused = this.currentlySelectedIndex;
        }
        float wheelRadius = (float)this.getWheelRadius();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableDepthTest();
        ScreenHelper.drawImageQuad(Resources.moveSkillWheel, graphics, (float)this.f_96543_ / 2.0f - wheelRadius, (float)this.f_96544_ / 2.0f - wheelRadius, wheelRadius * 2.0f, wheelRadius * 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(Resources.moveSkillWheelCenter, graphics, (float)this.f_96543_ / 2.0f - wheelRadius * 0.2f, (float)this.f_96544_ / 2.0f - wheelRadius * 0.2f, wheelRadius * 0.4f, wheelRadius * 0.4f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawImageQuad(this.pokemon.getSprite(), graphics, (float)this.f_96543_ / 2.0f - wheelRadius * 0.2f, (float)this.f_96544_ / 2.0f - wheelRadius * 0.25f, wheelRadius * 0.4f, wheelRadius * 0.4f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        if (this.moveSkills.size() == 1) {
            this.drawMoveSkill(graphics, wheelRadius, 0.0f, this.moveSkills.get(0), true);
        } else {
            for (int i = 0; i < this.moveSkills.size(); ++i) {
                this.drawMoveSkill(graphics, wheelRadius, 360.0f - (float)i * 360.0f / (float)this.moveSkills.size(), this.moveSkills.get(i), focused == i);
            }
        }
        PoseStack matrix = graphics.m_280168_();
        if (focused != -1) {
            matrix.m_85836_();
            matrix.m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
            matrix.m_252781_(QuaternionHelper.fromEuler(360.0f / (float)this.moveSkills.size() * (float)focused, 0.0f, 0.0f, 1.0f));
            ScreenHelper.drawImageQuad(Resources.moveSkillPointer, graphics, -wheelRadius / 10.0f, -wheelRadius * 0.4f, wheelRadius / 5.0f, wheelRadius / 5.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            matrix.m_85849_();
        }
        if (this.moveSkills.size() > 1) {
            for (int i = 0; i < this.moveSkills.size(); ++i) {
                float angle = 360.0f / (float)this.moveSkills.size() * ((float)i + (this.moveSkills.size() % 2 == 0 ? 0.5f : 0.0f));
                matrix.m_85836_();
                matrix.m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
                matrix.m_252781_(QuaternionHelper.fromEuler(angle, 0.0f, 0.0f, 1.0f));
                ScreenHelper.simpleDrawImageQuad(Resources.pcPointerGrabbed, graphics, -wheelRadius / 250.0f, wheelRadius * 0.2f, wheelRadius / 125.0f, wheelRadius * 0.7f, 0.45f, 0.45f, 0.55f, 0.55f, 1.0f);
                matrix.m_85849_();
            }
        }
        if (mouseX == this.lastMouseX && mouseY == this.lastMouseY && System.currentTimeMillis() > this.mouseStationaryTime + 1250L && hovering != -1) {
            matrix.m_85836_();
            matrix.m_252880_(0.0f, 0.0f, 20.0f);
            MoveSkill moveSkill = this.moveSkills.get(focused);
            StringBuilder str = new StringBuilder("\u00a7n" + I18n.m_118938_((String)moveSkill.name, (Object[])new Object[0]) + "\u00a7r");
            for (String description : moveSkill.descriptions) {
                str.append("\n\n\u00a7r").append(I18n.m_118938_((String)description, (Object[])new Object[0]));
            }
            List<String> strings = ScreenHelper.splitString(str.toString(), this.f_96543_ - mouseX - 10);
            float maxWidth = 0.0f;
            for (String string : strings) {
                int width = this.f_96541_.f_91062_.m_92895_(string);
                if (!((float)width > maxWidth)) continue;
                maxWidth = width;
            }
            ScreenHelper.drawImageQuad(Resources.button, graphics, mouseX - 9, mouseY - 16, maxWidth + 20.0f, strings.size() * 9 + 17, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawSplitString(graphics, str.toString(), mouseX + 3, mouseY - 7, this.f_96543_ - mouseX - 10, 0xFFFFFF);
            matrix.m_85849_();
        } else if (mouseX != this.lastMouseX || mouseY != this.lastMouseY) {
            this.mouseStationaryTime = System.currentTimeMillis();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
        RenderSystem.disableBlend();
    }

    private void drawMoveSkill(GuiGraphics graphics, float wheelRadius, float rotation, MoveSkill moveSkill, boolean select) {
        float r = 0.6f * wheelRadius;
        int x = (int)((double)((float)this.f_96543_ / 2.0f) - (double)r * Math.cos((double)(rotation - 90.0f) * Math.PI / 180.0));
        int y = this.f_96544_ - (int)((double)((float)this.f_96544_ / 2.0f) - (double)r * Math.sin((double)(rotation - 90.0f) * Math.PI / 180.0));
        ScreenHelper.drawImageQuad(moveSkill.sprite, graphics, (float)x - wheelRadius / 6.0f, (float)y - wheelRadius / 6.0f, wheelRadius / 3.0f, wheelRadius / 3.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        if (select) {
            ScreenHelper.drawImageQuad(Resources.moveSkillSelect, graphics, (float)x - wheelRadius / 6.0f, (float)y - wheelRadius / 6.0f, wheelRadius / 3.0f, wheelRadius / 3.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int clickedSpot = this.getIndexForPos((int)mouseX, (int)mouseY);
        if (clickedSpot == -1) {
            this.f_96541_.f_91074_.m_6915_();
        } else {
            PixelmonOverlayScreen.selectedMoveSkill = this.moveSkills.get((int)clickedSpot).id;
            this.f_96541_.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 1.0f, 1.0f);
            this.f_96541_.f_91074_.m_6915_();
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }
}

